/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.NodeFactory;
import com.akiban.sql.parser.NodeFactoryImpl;
import com.akiban.sql.parser.ParameterNode;
import com.akiban.sql.parser.ParseException;
import com.akiban.sql.parser.SQLGrammar;
import com.akiban.sql.parser.SQLGrammarTokenManager;
import com.akiban.sql.parser.SQLParserContext;
import com.akiban.sql.parser.SQLParserException;
import com.akiban.sql.parser.SQLParserFeature;
import com.akiban.sql.parser.StatementNode;
import com.akiban.sql.parser.StringCharStream;
import com.akiban.sql.parser.Token;
import com.akiban.sql.parser.TokenMgrError;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SQLParser
implements SQLParserContext {
    private String sqlText;
    private List<ParameterNode> parameterList;
    private boolean returnParameterFlag;
    private Map printedObjectsMap;
    private int generatedColumnNameIndex;
    private StringCharStream charStream = null;
    private SQLGrammarTokenManager tokenManager = null;
    private SQLGrammar parser = null;
    private int maxStringLiteralLength = 65535;
    private int maxIdentifierLength = 128;
    private String messageLocale = null;
    private Set<SQLParserFeature> features = EnumSet.of(SQLParserFeature.GROUPING, new SQLParserFeature[]{SQLParserFeature.DIV_OPERATOR, SQLParserFeature.GEO_INDEX_DEF_FUNC, SQLParserFeature.MYSQL_HINTS, SQLParserFeature.MYSQL_INTERVAL, SQLParserFeature.MYSQL_LEFT_RIGHT_FUNC, SQLParserFeature.UNSIGNED, SQLParserFeature.INFIX_MOD});
    NodeFactory nodeFactory = new NodeFactoryImpl();

    public String getSQLText() {
        return this.sqlText;
    }

    public List<ParameterNode> getParameterList() {
        return this.parameterList;
    }

    public ParameterNode lookupUnnamedParameter(int paramNumber) {
        return this.parameterList.get(paramNumber);
    }

    public StatementNode parseStatement(String sqlText) throws StandardException {
        this.reinit(sqlText);
        try {
            return this.parser.parseStatement(sqlText, this.parameterList);
        }
        catch (ParseException ex) {
            throw new SQLParserException(SQLParser.standardizeEol(ex.getMessage()), ex, SQLParser.tokenErrorPosition(ex.currentToken, sqlText));
        }
        catch (TokenMgrError ex) {
            this.parser = null;
            if (ex.errorCode == 0) {
                throw new SQLParserException(ex.getMessage(), ex, SQLParser.lineColumnErrorPosition(ex.errorLine, ex.errorColumn, sqlText));
            }
            throw new StandardException(ex);
        }
    }

    public List<StatementNode> parseStatements(String sqlText) throws StandardException {
        this.reinit(sqlText);
        try {
            return this.parser.parseStatements(sqlText);
        }
        catch (ParseException ex) {
            throw new SQLParserException(SQLParser.standardizeEol(ex.getMessage()), ex, SQLParser.tokenErrorPosition(ex.currentToken, sqlText));
        }
        catch (TokenMgrError ex) {
            this.parser = null;
            if (ex.errorCode == 0) {
                throw new SQLParserException(ex.getMessage(), ex, SQLParser.lineColumnErrorPosition(ex.errorLine, ex.errorColumn, sqlText));
            }
            throw new StandardException(ex);
        }
    }

    private static String standardizeEol(String msg) {
        String eol = System.getProperty("line.separator", "\n");
        if (eol.equals("\n")) {
            return msg;
        }
        return msg.replaceAll(eol, "\n");
    }

    private static int tokenErrorPosition(Token token, String sql) {
        if (token == null) {
            return 0;
        }
        return SQLParser.lineColumnErrorPosition(token.next.beginLine, token.next.beginColumn, sql);
    }

    private static int lineColumnErrorPosition(int line, int column, String sql) {
        if (line <= 0) {
            return 0;
        }
        int position = 0;
        while (line-- > 1) {
            if ((position = sql.indexOf(10, position)) < 0) {
                return 0;
            }
            ++position;
        }
        return position += column;
    }

    protected void reinit(String sqlText) throws StandardException {
        this.sqlText = sqlText;
        if (this.charStream == null) {
            this.charStream = new StringCharStream(sqlText);
        } else {
            this.charStream.ReInit(sqlText);
        }
        if (this.tokenManager == null) {
            this.tokenManager = new SQLGrammarTokenManager(null, this.charStream);
        } else {
            this.tokenManager.ReInit(this.charStream);
        }
        if (this.parser == null) {
            this.parser = new SQLGrammar(this.tokenManager);
            this.parser.setParserContext(this);
        } else {
            this.parser.ReInit(this.tokenManager);
        }
        this.tokenManager.parser = this.parser;
        this.parameterList = new ArrayList<ParameterNode>();
        this.returnParameterFlag = false;
        this.printedObjectsMap = null;
        this.generatedColumnNameIndex = 1;
    }

    public int getMaxStringLiteralLength() {
        return this.maxStringLiteralLength;
    }

    public void setMaxStringLiteralLength(int maxLength) {
        this.maxStringLiteralLength = maxLength;
    }

    @Override
    public void checkStringLiteralLengthLimit(String image) throws StandardException {
        if (image.length() > this.maxStringLiteralLength) {
            throw new StandardException("String literal too long");
        }
    }

    public int getMaxIdentifierLength() {
        return this.maxIdentifierLength;
    }

    public void setMaxIdentifierLength(int maxLength) {
        this.maxIdentifierLength = maxLength;
    }

    @Override
    public void checkIdentifierLengthLimit(String identifier) throws StandardException {
        if (identifier.length() > this.maxIdentifierLength) {
            throw new StandardException("Identifier too long: '" + identifier + "'");
        }
    }

    @Override
    public void setReturnParameterFlag() {
        this.returnParameterFlag = true;
    }

    public String getMessageLocale() {
        return this.messageLocale;
    }

    @Override
    public void setMessageLocale(String locale) {
        this.messageLocale = locale;
    }

    @Override
    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    @Override
    public Map getPrintedObjectsMap() {
        if (this.printedObjectsMap == null) {
            this.printedObjectsMap = new HashMap();
        }
        return this.printedObjectsMap;
    }

    public String generateColumnName() {
        return "_SQL_COL_" + this.generatedColumnNameIndex++;
    }

    public Set<SQLParserFeature> getFeatures() {
        return this.features;
    }

    @Override
    public boolean hasFeature(SQLParserFeature feature) {
        return this.features.contains((Object)feature);
    }

    @Override
    public SQLParserContext.IdentifierCase getIdentifierCase() {
        return SQLParserContext.IdentifierCase.LOWER;
    }
}

