/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.RoutineDesignator;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.TablePrivilegesNode;

public class PrivilegeNode
extends QueryTreeNode {
    public static final String USAGE_PRIV = "USAGE";
    private ObjectType objectType;
    private TableName objectName;
    private TablePrivilegesNode specificPrivileges;
    private RoutineDesignator routineDesignator;
    private String privilege;
    private boolean restrict;

    @Override
    public void init(Object objectType, Object objectOfPrivilege, Object specificPrivileges) throws StandardException {
        this.objectType = (ObjectType)((Object)objectType);
        switch (this.objectType) {
            case TABLE_PRIVILEGES: {
                this.objectName = (TableName)objectOfPrivilege;
                this.specificPrivileges = (TablePrivilegesNode)specificPrivileges;
                break;
            }
            case ROUTINE_PRIVILEGES: {
                this.routineDesignator = (RoutineDesignator)objectOfPrivilege;
                this.objectName = this.routineDesignator.name;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    @Override
    public void init(Object objectType, Object objectName, Object privilege, Object restrict) {
        this.objectType = (ObjectType)((Object)objectType);
        this.objectName = (TableName)objectName;
        this.privilege = (String)privilege;
        this.restrict = (Boolean)restrict;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        PrivilegeNode other = (PrivilegeNode)node;
        this.objectType = other.objectType;
        this.objectName = (TableName)this.getNodeFactory().copyNode(other.objectName, this.getParserContext());
        this.specificPrivileges = (TablePrivilegesNode)this.getNodeFactory().copyNode(other.specificPrivileges, this.getParserContext());
        if (other.routineDesignator != null) {
            this.routineDesignator = new RoutineDesignator(other.routineDesignator.isSpecific, (TableName)this.getNodeFactory().copyNode(other.routineDesignator.name, this.getParserContext()), other.routineDesignator.isFunction, other.routineDesignator.paramTypeList);
        }
        this.privilege = other.privilege;
        this.restrict = other.restrict;
    }

    public static enum ObjectType {
        TABLE_PRIVILEGES,
        ROUTINE_PRIVILEGES,
        SEQUENCE_PRIVILEGES,
        UDT_PRIVILEGES;

    }
}

