/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.event;

import com.neeve.event.IEvent;
import com.neeve.event.IEventAcknowledger;
import com.neeve.event.IEventSource;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReferenceTracker;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Event
extends UtlListElement
implements IEvent,
UtlPool.Item<Event> {
    private static final AtomicLong instanceCount = new AtomicLong(0L);
    private final short type;
    private long instanceNumber;
    private IEventSource source;
    private IEventAcknowledger acknowledger;
    private boolean endOfBatch;
    private Object attachment;
    private boolean handled;
    private int delay;
    private long scheduledTime;
    private long dispatchTime;
    private UtlPool<Event> pool;
    private final UtlReferenceTracker refTracker;
    long offerTs;
    long pollTs;
    protected final AtomicInteger ownershipCount;

    protected Event(short type) {
        this.type = type;
        this.ownershipCount = new AtomicInteger(1);
        this.refTracker = UtlReferenceTracker.enabled(this.getClass()) ? new UtlReferenceTracker((Object)this) : null;
    }

    protected final void init(IEventSource source, IEventAcknowledger acknowledger) {
        this.source = source;
        this.acknowledger = acknowledger;
        this.delay = 0;
        this.ownershipCount.set(1);
        this.instanceNumber = instanceCount.incrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onInit(1);
        }
    }

    protected abstract void reset();

    @Override
    public final long getInstanceNumber() {
        return this.instanceNumber;
    }

    @Override
    public final short getType() {
        return this.type;
    }

    @Override
    public void setSource(IEventSource source) {
        this.source = source;
    }

    @Override
    public IEventSource getSource() {
        return this.source;
    }

    @Override
    public final void setAcknowledger(IEventAcknowledger acknowledger) {
        this.acknowledger = acknowledger;
    }

    @Override
    public final IEventAcknowledger getAcknowledger() {
        return this.acknowledger;
    }

    @Override
    public final Event setEndOfBatch(boolean val) {
        this.endOfBatch = val;
        return this;
    }

    @Override
    public final boolean isEndOfBatch() {
        return this.endOfBatch;
    }

    @Override
    public final Event setAttachment(Object attachment) {
        this.attachment = attachment;
        return this;
    }

    @Override
    public final Object getAttachment() {
        return this.attachment;
    }

    @Override
    public final Event setHandled() {
        this.handled = true;
        return this;
    }

    @Override
    public final boolean isHandled() {
        return this.handled;
    }

    @Override
    public final Event setDelay(int val) {
        this.delay = val;
        return this;
    }

    @Override
    public final int getDelay() {
        return this.delay;
    }

    public final Event setDispatchTime(long ts) {
        this.dispatchTime = ts;
        return this;
    }

    @Override
    public final long getDispatchTime() {
        return this.dispatchTime;
    }

    public final Event setScheduledTime(long ts) {
        this.scheduledTime = ts;
        return this;
    }

    @Override
    public final long getScheduledTime() {
        return this.scheduledTime;
    }

    @Override
    public final int getRemainingTime(long now) {
        return this.delay <= 0 ? this.delay : this.delay - (int)(now - this.scheduledTime);
    }

    public final long getOfferTs() {
        return this.offerTs;
    }

    public final long getPollTs() {
        return this.pollTs;
    }

    @Override
    public final Event acquire() {
        int val = this.ownershipCount.incrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onAcquire(val);
        }
        if (val <= 1 && this.pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed event (event='" + this.getClass().getName() + "')");
        }
        return this;
    }

    @Override
    public final int owners() {
        return this.ownershipCount.get();
    }

    @Override
    public final void dispose() {
        int val = this.ownershipCount.decrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onDispose(val);
        }
        if (val < 0 && this.pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed event (event='" + this.getClass().getName() + "')");
        }
        if (val == 0) {
            this.preDispose();
            if (this.acknowledger != null) {
                this.acknowledger.dispose();
            }
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            }
        }
    }

    protected void preDispose() {
    }

    public final UtlReferenceTracker referenceTracker() {
        return this.refTracker;
    }

    public final Event init() {
        this.source = null;
        this.acknowledger = null;
        this.endOfBatch = false;
        this.attachment = null;
        this.pollTs = 0L;
        this.offerTs = 0L;
        this.delay = 0;
        this.scheduledTime = 0L;
        this.dispatchTime = 0L;
        this.handled = false;
        this.reset();
        return this;
    }

    public final Event setPool(UtlPool<Event> pool) {
        this.pool = pool;
        return this;
    }

    public final UtlPool<Event> getPool() {
        return this.pool;
    }

    public String toString() {
        return "type=" + this.getType() + ", source=" + (this.getSource() == null ? "null" : this.getSource().getName() + ", owners=" + this.ownershipCount.get() + ", endOfBatch=" + this.isEndOfBatch() + ", delay=" + this.delay + ", scheduledTime=" + this.scheduledTime + ", dispatchTime=" + this.dispatchTime);
    }
}

