/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.config.Config;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIterator;
import com.neeve.lang.XString;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlPool;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class MessageTransportHeaders
implements UtlPool.Item<MessageTransportHeaders>,
XIterator<Header>,
Iterable<Header> {
    static final UtlPool<MessageTransportHeaders> headerPool = UtlPool.create((String)"sma_transport_headers", (String)"singleton", (UtlPool.Factory)new UtlPool.Factory<MessageTransportHeaders>(){

        public MessageTransportHeaders[] createItemArray(int size) {
            return new MessageTransportHeaders[size];
        }

        public MessageTransportHeaders createItem(Object object) {
            return new MessageTransportHeaders();
        }
    }, (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
    private static final byte VERSION = 1;
    private static final int OFFSET_VERSION = 0;
    private static final int OFFSET_LENGTH = 1;
    private static final int OFFSET_VARIABLE_PORTION = 5;
    private static final byte FLG_READ_ONLY = 1;
    private final Header header = new Header();
    private UtlPool<MessageTransportHeaders> pool;
    private IOBuffer buffer;
    private byte flags;
    private int nextHeader = 5;

    private MessageTransportHeaders() {
    }

    private final IOBuffer ensureCapacity(int bytesNeeded) {
        if (this.buffer == null) {
            this.buffer = IOBuffer.create((int)(5 + bytesNeeded));
            this.buffer.putByte(0, (byte)1);
        } else {
            this.buffer = IOBuffer.ensureCapacity((IOBuffer)this.buffer, (int)(this.buffer.getLength() + bytesNeeded), (boolean)true);
        }
        return this.buffer;
    }

    private final void checkReadOnly() {
        if (this.isReadOnly()) {
            throw new IllegalStateException("not modifiable");
        }
    }

    public static final short getLatestVersion() {
        return 1;
    }

    public static MessageTransportHeaders create() {
        return (MessageTransportHeaders)headerPool.get(null);
    }

    public boolean isReadOnly() {
        return (this.flags & 1) != 0;
    }

    public final int serializedLength() {
        if (this.buffer == null) {
            return 5;
        }
        return this.buffer.getLength();
    }

    public final int deserialize(IOElasticBuffer src, int offset) {
        return this.deserialize(src.getBackingBufferUnsafe(), offset + src.getOffset());
    }

    public final int deserialize(IOBuffer src, int offset) {
        byte version = src.getByte(offset + 0);
        if (version != 1) {
            throw new IllegalArgumentException("Invalid transport header version '" + version + "': " + UtlBuffer.dump((String)"BackingBuffer", (ByteBuffer)this.buffer.getBufferUnsafe(), (int)0, (int)this.buffer.getLength()));
        }
        if (this.buffer != null) {
            this.buffer.dispose();
            this.buffer = null;
        }
        int serializedLen = src.getInt(offset + 1);
        this.ensureCapacity(serializedLen - 5);
        src.getTo(offset, this.buffer, 0, serializedLen);
        return serializedLen;
    }

    public final int deserialize(ByteBuffer src) {
        byte version = src.get(0);
        if (version != 1) {
            throw new IllegalArgumentException("Invalid transport header version '" + version + "': " + UtlBuffer.dump((String)"BackingBuffer", (ByteBuffer)this.buffer.getBufferUnsafe(), (int)0, (int)this.buffer.getLength()));
        }
        if (this.buffer != null) {
            this.buffer.dispose();
            this.buffer = null;
        }
        int serializedLen = src.getInt(1);
        this.ensureCapacity(serializedLen - 5);
        this.buffer.putFrom(0, src, 0, serializedLen);
        return serializedLen;
    }

    public final int serialize(IOBuffer dest, int offset) {
        this.ensureCapacity(0);
        int len = this.buffer.getLength();
        this.buffer.putInt(1, len);
        dest.putFrom(offset, this.buffer, 0, len);
        return len;
    }

    public final int serialize(IOElasticBuffer dest, int offset) {
        this.ensureCapacity(0);
        int len = this.buffer.getLength();
        this.buffer.putInt(1, len);
        dest.putFrom(offset, this.buffer, 0, len);
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int serialize(ByteBuffer dest) {
        this.ensureCapacity(0);
        int len = this.buffer.getLength();
        this.buffer.putInt(1, len);
        ByteBuffer b = this.buffer.takeBuffer();
        try {
            dest.put(b);
        }
        finally {
            this.buffer.releaseBuffer();
        }
        return len;
    }

    public static final int getSerializedLength(IOElasticBuffer buffer, int offset) {
        return buffer.getInt(offset + 1);
    }

    public static final int getSerializedLength(IOBuffer buffer, int offset) {
        return buffer.getBufferUnsafe().getInt(1);
    }

    public final MessageTransportHeaders copy() {
        MessageTransportHeaders copy = MessageTransportHeaders.create();
        if (this.buffer != null) {
            copy.ensureCapacity(this.buffer.getLength() - 5);
            this.buffer.putInt(1, this.buffer.getLength());
            copy.buffer.putFrom(0, this.buffer, 0, this.buffer.getLength());
        }
        return copy;
    }

    public final boolean hasNext() {
        return this.buffer != null && this.nextHeader < this.buffer.getLength();
    }

    public final Header next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextHeader = this.header.wrap(this.nextHeader);
        return this.header;
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public final XIterator<Header> toFirst() {
        this.nextHeader = 5;
        return this;
    }

    @Override
    public final Iterator<Header> iterator() {
        return this.toFirst();
    }

    private final int serializeHeaderKey(CharSequence name, HeaderType type, int dataLen) {
        this.checkReadOnly();
        int nameLength = IOBuffer.calculateUTF8Length((CharSequence)name);
        if (nameLength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Header name exceeds maximum length: " + nameLength);
        }
        int len = this.buffer != null ? this.buffer.getLength() : 5;
        this.buffer = this.ensureCapacity(2 * (type.isLengthEncoded ? 2 : 1) + nameLength + 1 + dataLen);
        this.buffer.putShort(len, (short)nameLength);
        this.buffer.putUTF8CharSequence(len += 2, name);
        this.buffer.putByte(len += nameLength, type.wireCode);
        if (type.isLengthEncoded()) {
            this.buffer.putShort(++len, (short)dataLen);
            return len + 2;
        }
        return len + 1;
    }

    private final int serializeHeaderKey(XString name, HeaderType type, int dataLen) {
        this.checkReadOnly();
        int nameLength = name.serializedLength();
        if (nameLength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Header name exceeds maximum length: " + nameLength);
        }
        int len = this.buffer != null ? this.buffer.getLength() : 5;
        this.buffer = this.ensureCapacity(2 * (type.isLengthEncoded ? 2 : 1) + nameLength + 1 + dataLen);
        this.buffer.putShort(len, (short)nameLength);
        this.putXString(name, len += 2);
        this.buffer.putByte(len += nameLength, type.wireCode);
        if (type.isLengthEncoded()) {
            this.buffer.putShort(++len, (short)dataLen);
            return len + 2;
        }
        return len + 1;
    }

    private final void putXString(XString str, int offset) {
        str.getTo(this.buffer, offset);
    }

    public final void addHeader(CharSequence name, byte value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Byte, 1);
        this.buffer.putByte(offset, value);
    }

    public final void addHeader(CharSequence name, boolean value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Boolean, 1);
        this.buffer.putByte(offset, value ? (byte)1 : 0);
    }

    public final void addHeader(CharSequence name, char value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Char, 2);
        this.buffer.putChar(offset, value);
    }

    public final void addHeader(CharSequence name, short value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Short, 2);
        this.buffer.putShort(offset, value);
    }

    public final void addHeader(CharSequence name, int value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Int, 4);
        this.buffer.putInt(offset, value);
    }

    public final void addHeader(CharSequence name, float value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Float, 4);
        this.buffer.putFloat(offset, value);
    }

    public final void addHeader(CharSequence name, long value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Long, 8);
        this.buffer.putLong(offset, value);
    }

    public final void addHeader(CharSequence name, double value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Double, 8);
        this.buffer.putDouble(offset, value);
    }

    public final void addHeader(XString name, byte value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Byte, 1);
        this.buffer.putByte(offset, value);
    }

    public final void addHeader(XString name, boolean value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Boolean, 1);
        this.buffer.putByte(offset, value ? (byte)1 : 0);
    }

    public final void addHeader(XString name, char value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Char, 2);
        this.buffer.putChar(offset, value);
    }

    public final void addHeader(XString name, short value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Short, 2);
        this.buffer.putShort(offset, value);
    }

    public final void addHeader(XString name, int value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Int, 4);
        this.buffer.putInt(offset, value);
    }

    public final void addHeader(XString name, float value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Float, 4);
        this.buffer.putFloat(offset, value);
    }

    public final void addHeader(XString name, long value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Long, 8);
        this.buffer.putLong(offset, value);
    }

    public final void addHeader(XString name, double value) {
        int offset = this.serializeHeaderKey(name, HeaderType.Double, 8);
        this.buffer.putDouble(offset, value);
    }

    public final void addHeader(CharSequence name, CharSequence value) {
        int valueLength = IOBuffer.calculateUTF8Length((CharSequence)value);
        if (valueLength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Header value exceeds maximum length: " + valueLength);
        }
        int offset = this.serializeHeaderKey(name, HeaderType.String, valueLength);
        this.buffer.putUTF8CharSequence(offset, value);
    }

    public final void addHeader(CharSequence name, byte[] src, int srcOffset, int length) {
        int offset = this.serializeHeaderKey(name, HeaderType.Binary, length);
        this.buffer.putFrom(offset, src, srcOffset, length);
    }

    public final void addHeader(CharSequence name, IOBuffer src, int srcOffset, int length) {
        int offset = this.serializeHeaderKey(name, HeaderType.Binary, length);
        this.buffer.putFrom(offset, src, srcOffset, length);
    }

    public MessageTransportHeaders addHeader(CharSequence name, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof String) {
            this.addHeader(name, (CharSequence)((String)value));
        } else if (value instanceof Boolean) {
            this.addHeader(name, (boolean)((Boolean)value));
        } else if (value instanceof Byte) {
            this.addHeader(name, (byte)((Byte)value));
        } else if (value instanceof Character) {
            this.addHeader(name, ((Character)value).charValue());
        } else if (value instanceof Short) {
            this.addHeader(name, (short)((Short)value));
        } else if (value instanceof Integer) {
            this.addHeader(name, (int)((Integer)value));
        } else if (value instanceof Long) {
            this.addHeader(name, (long)((Long)value));
        } else if (value instanceof Float) {
            this.addHeader(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.addHeader(name, (double)((Double)value));
        } else if (value instanceof byte[]) {
            this.addHeader(name, (byte[])value, 0, ((byte[])value).length);
        } else if (value instanceof IOBuffer) {
            this.addHeader(name, (IOBuffer)value, 0, ((IOBuffer)value).getLength());
        } else {
            throw new IllegalArgumentException("Unssupported value type: " + value.getClass());
        }
        return this;
    }

    public MessageTransportHeaders addHeader(XString name, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof String) {
            this.addHeader(name, (String)value);
        } else if (value instanceof Boolean) {
            this.addHeader(name, (boolean)((Boolean)value));
        } else if (value instanceof Byte) {
            this.addHeader(name, (byte)((Byte)value));
        } else if (value instanceof Character) {
            this.addHeader(name, ((Character)value).charValue());
        } else if (value instanceof Short) {
            this.addHeader(name, (short)((Short)value));
        } else if (value instanceof Integer) {
            this.addHeader(name, (int)((Integer)value));
        } else if (value instanceof Long) {
            this.addHeader(name, (long)((Long)value));
        } else if (value instanceof Float) {
            this.addHeader(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.addHeader(name, (double)((Double)value));
        } else if (value instanceof byte[]) {
            this.addHeader(name, (byte[])value, 0, ((byte[])value).length);
        } else if (value instanceof IOBuffer) {
            this.addHeader(name, (IOBuffer)value, 0, ((IOBuffer)value).getLength());
        } else {
            throw new IllegalArgumentException("Unssupported value type: " + value.getClass());
        }
        return this;
    }

    public final void addHeader(XString name, XString value) {
        int valueLen = value.serializedLength();
        if (valueLen > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Header value exceeds maximum length: " + valueLen);
        }
        int offset = this.serializeHeaderKey(name, HeaderType.String, valueLen);
        this.putXString(value, offset);
    }

    public final void addHeader(XString name, String value) {
        int valueLen = IOBuffer.calculateUTF8Length((CharSequence)value);
        if (valueLen > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Header value exceeds maximum length: " + valueLen);
        }
        int offset = this.serializeHeaderKey(name, HeaderType.String, valueLen);
        this.buffer.putUTF8CharSequence(offset, (CharSequence)value);
    }

    public final void addHeader(XString name, IOBuffer src, int srcOffset, int length) {
        if (length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Binary header value cannot exceed length of 32767");
        }
        int offset = this.serializeHeaderKey(name, HeaderType.Binary, length);
        this.buffer.putFrom(offset, src, srcOffset, length);
    }

    public final void addHeader(XString name, byte[] src, int srcOffset, int length) {
        if (length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Binary header value cannot exceed length of 32767");
        }
        int offset = this.serializeHeaderKey(name, HeaderType.Binary, length);
        this.buffer.putFrom(offset, src, srcOffset, length);
    }

    public final void addHeader(XString name, long src, int srcOffset, int length) {
        if (length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Binary header value cannot exceed length of 32767");
        }
        int offset = this.serializeHeaderKey(name, HeaderType.Binary, length);
        this.buffer.putFrom(offset, src, srcOffset, length);
    }

    public Map<String, Object> toMap() {
        if (this.buffer == null || this.buffer.getLength() <= 5) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> rc = new HashMap<String, Object>();
        this.getAllTo(rc);
        return Collections.unmodifiableMap(rc);
    }

    public void getAllTo(Map<String, Object> to) {
        if (this.buffer == null || this.buffer.getLength() <= 5) {
            return;
        }
        for (Header h : this) {
            to.put(h.getName().toString(), h.getValue());
        }
    }

    public Object getValue(String key) {
        XIterator<Header> headers = this.toFirst();
        while (headers.hasNext()) {
            Header h = (Header)headers.next();
            if (!key.equals(h.getName())) continue;
            return h.getValue();
        }
        return null;
    }

    public final void dispose() {
        if (this.pool != null) {
            this.pool.put((UtlPool.Item)this);
        }
    }

    public final MessageTransportHeaders init() {
        if (this.buffer != null) {
            this.buffer.dispose();
            this.buffer = null;
        }
        this.flags = 0;
        this.nextHeader = 5;
        return this;
    }

    public final MessageTransportHeaders setPool(UtlPool<MessageTransportHeaders> pool) {
        this.pool = pool;
        return this;
    }

    public final UtlPool<MessageTransportHeaders> getPool() {
        return this.pool;
    }

    public String toString() {
        int len = this.buffer.getLength();
        if (this.buffer == null || len <= 5) {
            return "TransportHeaders[<empty>]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("TransportHeaders[len=").append(len).append("]{");
        Header header = new Header();
        int nextHeader = 5;
        while (nextHeader < len) {
            if (nextHeader > 5) {
                sb.append(", ");
            }
            nextHeader = header.wrap(nextHeader);
            sb.append((CharSequence)header.getNameUnsafe()).append("=");
            sb.append((CharSequence)header.getStringValueUnsafe());
        }
        sb.append("}");
        return sb.toString();
    }

    public void toJsonString(StringBuilder sb) {
        this.toJsonString(Config.getValue((String)"nv.indent.json", (boolean)false), 0, false, sb);
    }

    public void toJsonString(boolean indent, int indentDepth, boolean noSpaces, StringBuilder sb) {
        int i;
        int len = this.buffer.getLength();
        sb.append("{");
        ++indentDepth;
        if (this.buffer == null || len <= 5) {
            sb.append("}");
            return;
        }
        Header header = new Header();
        int nextHeader = 5;
        block12: while (nextHeader < len) {
            if (nextHeader > 5) {
                sb.append(",");
            }
            if (indent) {
                sb.append("\n");
                for (i = 0; i < indentDepth; ++i) {
                    sb.append("  ");
                }
            } else if (!noSpaces) {
                sb.append(" ");
            }
            nextHeader = header.wrap(nextHeader);
            sb.append("\"").append((CharSequence)header.getNameUnsafe()).append("\":").append(noSpaces ? "" : " ");
            switch (header.getType()) {
                case Binary: {
                    sb.append("[");
                    ++indentDepth;
                    for (i = 0; i < header.valueLen; ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        if (indent) {
                            sb.append("\n");
                            for (int j = 0; j < indentDepth; ++j) {
                                sb.append("  ");
                            }
                        } else if (!noSpaces) {
                            sb.append(" ");
                        }
                        sb.append(this.buffer.getByte(header.valueOffset + i));
                    }
                    --indentDepth;
                    if (indent) {
                        sb.append("\n");
                        for (i = 0; i < indentDepth; ++i) {
                            sb.append("  ");
                        }
                    }
                    sb.append("}");
                    continue block12;
                }
                case Boolean: {
                    sb.append(header.getBooleanValue());
                    continue block12;
                }
                case Byte: {
                    sb.append(header.getByteValue());
                    continue block12;
                }
                case Char: {
                    sb.append("\"").append((CharSequence)header.getStringValueUnsafe()).append("\"");
                    continue block12;
                }
                case Double: {
                    sb.append(header.getDoubleValue());
                    continue block12;
                }
                case Float: {
                    sb.append(header.getFloatValue());
                    continue block12;
                }
                case Int: {
                    sb.append(header.getIntValue());
                    continue block12;
                }
                case Long: {
                    sb.append(header.getLongValue());
                    continue block12;
                }
                case Short: {
                    sb.append(header.getShortValue());
                    continue block12;
                }
                case String: {
                    sb.append("\"").append((CharSequence)header.getStringValueUnsafe()).append("\"");
                    continue block12;
                }
            }
        }
        --indentDepth;
        if (indent) {
            sb.append("\n");
            for (i = 0; i < indentDepth; ++i) {
                sb.append("  ");
            }
        }
        sb.append("}");
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Expected buffer dump as input in the form: \"<01000000 1500056d 73676964 00000007 00000001 00>\"");
        }
        MessageTransportHeaders headers = MessageTransportHeaders.create();
        headers.deserialize(UtlBuffer.fromDump((String)args[0]));
        StringBuilder sb = new StringBuilder();
        sb.append("\"messageTransportHeaders\": ");
        headers.toJsonString(true, 0, false, sb);
        System.out.println(sb);
    }

    public final class Header {
        private final XString name = XString.create((int)32);
        private final XString value = XString.create((int)32);
        private HeaderType type;
        private int valueOffset;
        private int valueLen;

        public final XString getNameUnsafe() {
            return this.name;
        }

        public final String getName() {
            return this.name.toString();
        }

        public final HeaderType getType() {
            return this.type;
        }

        public final XString getStringValueUnsafe() {
            if (!this.value.hasValue()) {
                this.getStringValueTo(this.value);
            }
            return this.value;
        }

        public final void getStringValueTo(XString target) {
            switch (this.type) {
                case Binary: {
                    target.setValue(MessageTransportHeaders.this.buffer, this.valueOffset, this.valueLen);
                    break;
                }
                case Char: {
                    target.clear(false);
                    target.append(MessageTransportHeaders.this.buffer.getChar(this.valueOffset));
                    break;
                }
                case Boolean: {
                    target.clear(false);
                    target.append(this.getBooleanValue());
                    break;
                }
                case Byte: {
                    target.setValue((long)this.getByteValue());
                    break;
                }
                case Double: {
                    target.append((CharSequence)("" + this.getDoubleValue()));
                    break;
                }
                case Float: {
                    target.append((CharSequence)("" + this.getFloatValue()));
                    break;
                }
                case Int: {
                    target.setValue((long)this.getIntValue());
                    break;
                }
                case Long: {
                    target.setValue(this.getLongValue());
                    break;
                }
                case Short: {
                    target.setValue((long)this.getShortValue());
                    break;
                }
                case String: {
                    target.setValue(MessageTransportHeaders.this.buffer, this.valueOffset, this.valueLen);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown header type " + (Object)((Object)this.type));
                }
            }
        }

        public String getStringValue() {
            XString v = this.getStringValueUnsafe();
            if (v == null) {
                return null;
            }
            return v.getValue();
        }

        public long getLongValue() {
            switch (this.type) {
                case Binary: 
                case Char: 
                case Boolean: {
                    throw new NumberFormatException("Inconvertible header type " + (Object)((Object)this.type));
                }
                case Byte: {
                    return MessageTransportHeaders.this.buffer.getByte(this.valueOffset);
                }
                case Double: {
                    return (long)MessageTransportHeaders.this.buffer.getDouble(this.valueOffset);
                }
                case Float: {
                    return (long)MessageTransportHeaders.this.buffer.getFloat(this.valueOffset);
                }
                case Int: {
                    return MessageTransportHeaders.this.buffer.getInt(this.valueOffset);
                }
                case Long: {
                    return MessageTransportHeaders.this.buffer.getLong(this.valueOffset);
                }
                case Short: {
                    return MessageTransportHeaders.this.buffer.getShort(this.valueOffset);
                }
                case String: {
                    return this.getStringValueUnsafe().getValueAsLong();
                }
            }
            throw new NumberFormatException("Unknown header type " + (Object)((Object)this.type));
        }

        public int getIntValue() {
            return (int)this.getLongValue();
        }

        public short getShortValue() {
            return (short)this.getLongValue();
        }

        public short getByteValue() {
            return (byte)this.getLongValue();
        }

        public byte[] getBinaryValue() {
            if (this.type == HeaderType.Binary) {
                byte[] rc = new byte[this.valueLen];
                MessageTransportHeaders.this.buffer.getTo(this.valueOffset, rc, 0, this.valueLen);
                return rc;
            }
            throw new IllegalArgumentException("Incompatible header type " + (Object)((Object)this.type));
        }

        public IOBuffer getEncodedValueBackingBuffer() {
            return MessageTransportHeaders.this.buffer;
        }

        public int getEncodedValueOffset() {
            return this.valueOffset;
        }

        public int getEncodedValueLength() {
            return this.valueLen;
        }

        public int getBinaryValueTo(IOElasticBuffer target, int offset) {
            target.putFrom(offset, MessageTransportHeaders.this.buffer, this.valueOffset, this.valueLen);
            return this.valueLen;
        }

        public int getBinaryValueTo(IOBuffer target, int offset) {
            target.putFrom(offset, MessageTransportHeaders.this.buffer, this.valueOffset, this.valueLen);
            return this.valueLen;
        }

        public int getBinaryValueTo(ByteBuffer target) {
            if (target.remaining() < this.valueLen) {
                throw new BufferOverflowException();
            }
            int newPos = target.position() + this.valueLen;
            MessageTransportHeaders.this.buffer.getTo(this.valueOffset, target, target.position(), this.valueLen);
            target.position(newPos);
            return this.valueLen;
        }

        public int getBinaryValueTo(byte[] target) {
            if (target.length < this.valueLen) {
                throw new BufferOverflowException();
            }
            MessageTransportHeaders.this.buffer.getTo(this.valueOffset, target, 0, this.valueLen);
            return this.valueLen;
        }

        public boolean getBooleanValue() {
            XString v;
            if (this.type == HeaderType.Boolean) {
                return MessageTransportHeaders.this.buffer.getByte(this.valueOffset) == 1;
            }
            return this.type == HeaderType.String && ((v = this.getStringValueUnsafe()).compareTo((CharSequence)"true") == 0 || v.compareTo((CharSequence)"TRUE") == 0);
        }

        public char getCharValue() {
            if (this.type == HeaderType.Char) {
                return MessageTransportHeaders.this.buffer.getChar(this.valueOffset);
            }
            throw new IllegalArgumentException("Invalid header type: " + (Object)((Object)this.type));
        }

        public double getDoubleValue() {
            switch (this.type) {
                case Binary: 
                case Char: 
                case Boolean: {
                    throw new NumberFormatException("Inconvertible header type " + (Object)((Object)this.type));
                }
                case Byte: {
                    return MessageTransportHeaders.this.buffer.getByte(this.valueOffset);
                }
                case Double: {
                    return MessageTransportHeaders.this.buffer.getDouble(this.valueOffset);
                }
                case Float: {
                    return MessageTransportHeaders.this.buffer.getFloat(this.valueOffset);
                }
                case Int: {
                    return MessageTransportHeaders.this.buffer.getInt(this.valueOffset);
                }
                case Long: {
                    return MessageTransportHeaders.this.buffer.getLong(this.valueOffset);
                }
                case Short: {
                    return MessageTransportHeaders.this.buffer.getShort(this.valueOffset);
                }
                case String: {
                    return Double.valueOf(this.getStringValueUnsafe().getValue());
                }
            }
            throw new NumberFormatException("Unknown header type " + (Object)((Object)this.type));
        }

        public float getFloatValue() {
            return (float)this.getDoubleValue();
        }

        public final Object getValue() {
            switch (this.type) {
                case Binary: {
                    return this.getBinaryValue();
                }
                case Char: {
                    return Character.valueOf(MessageTransportHeaders.this.buffer.getChar(this.valueOffset));
                }
                case Boolean: {
                    return this.getBooleanValue();
                }
                case Byte: {
                    return MessageTransportHeaders.this.buffer.getByte(this.valueOffset);
                }
                case Double: {
                    return MessageTransportHeaders.this.buffer.getDouble(this.valueOffset);
                }
                case Float: {
                    return Float.valueOf(MessageTransportHeaders.this.buffer.getFloat(this.valueOffset));
                }
                case Int: {
                    return MessageTransportHeaders.this.buffer.getInt(this.valueOffset);
                }
                case Long: {
                    return MessageTransportHeaders.this.buffer.getLong(this.valueOffset);
                }
                case Short: {
                    return MessageTransportHeaders.this.buffer.getShort(this.valueOffset);
                }
                case String: {
                    return this.getStringValue();
                }
            }
            throw new NumberFormatException("Unknown header type " + (Object)((Object)this.type));
        }

        final int wrap(int offset) {
            this.value.clear(false);
            short len = MessageTransportHeaders.this.buffer.getShort(offset);
            this.name.setValue(MessageTransportHeaders.this.buffer, offset += 2, (int)len);
            try {
                this.type = HeaderType.from(MessageTransportHeaders.this.buffer.getByte(offset += this.name.serializedLength()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid tranport header type at position " + offset + ": " + e.getMessage() + " ... wire corruption? " + UtlBuffer.dump((String)"BackingBuffer", (ByteBuffer)MessageTransportHeaders.this.buffer.getBufferUnsafe(), (int)0, (int)MessageTransportHeaders.this.buffer.getLength()));
            }
            this.valueOffset = offset + 1;
            switch (this.type) {
                case Char: {
                    this.valueLen = 2;
                    break;
                }
                case Boolean: {
                    this.valueLen = 1;
                    break;
                }
                case Byte: {
                    this.valueLen = 1;
                    break;
                }
                case Double: {
                    this.valueLen = 8;
                    break;
                }
                case Float: {
                    this.valueLen = 4;
                    break;
                }
                case Int: {
                    this.valueLen = 4;
                    break;
                }
                case Long: {
                    this.valueLen = 8;
                    break;
                }
                case Short: {
                    this.valueLen = 2;
                    break;
                }
                case Binary: {
                    this.valueLen = MessageTransportHeaders.this.buffer.getShort(this.valueOffset);
                    this.valueOffset += 2;
                    break;
                }
                case String: {
                    this.valueLen = MessageTransportHeaders.this.buffer.getShort(this.valueOffset);
                    this.valueOffset += 2;
                }
            }
            return this.valueLen + this.valueOffset;
        }
    }

    public static enum HeaderType {
        Byte(1, false),
        Boolean(2, false),
        Char(3, false),
        Short(4, false),
        Int(5, false),
        Float(6, false),
        Long(7, false),
        Double(8, false),
        String(9, true),
        Binary(10, true);

        private final byte wireCode;
        private final boolean isLengthEncoded;

        private HeaderType(int wireCode, boolean isLengthEncoded) {
            this.wireCode = (byte)wireCode;
            this.isLengthEncoded = isLengthEncoded;
        }

        final boolean isLengthEncoded() {
            return this.isLengthEncoded;
        }

        public static HeaderType from(byte b) {
            if (b == HeaderType.String.wireCode) {
                return String;
            }
            if (b == HeaderType.Long.wireCode) {
                return Long;
            }
            if (b == HeaderType.Byte.wireCode) {
                return Byte;
            }
            if (b == HeaderType.Boolean.wireCode) {
                return Boolean;
            }
            if (b == HeaderType.Char.wireCode) {
                return Char;
            }
            if (b == HeaderType.Short.wireCode) {
                return Short;
            }
            if (b == HeaderType.Int.wireCode) {
                return Int;
            }
            if (b == HeaderType.Float.wireCode) {
                return Float;
            }
            if (b == HeaderType.Double.wireCode) {
                return Double;
            }
            if (b == HeaderType.Binary.wireCode) {
                return Binary;
            }
            throw new IllegalArgumentException("Invalid Transport Header Wire Type: " + b);
        }
    }
}

