/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.jms;

import com.neeve.event.IEventHandler;
import com.neeve.jms.JmsMessageChannel;
import com.neeve.lang.XString;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaPermanentException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlTime;
import com.neeve.util.UtlUnit;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;

public class JmsMessageBusBinding
extends MessageBusBindingBase
implements ExceptionListener {
    HashMap<MessageChannel, List<DurableSubscriptionInfo>> openDurableSubs = new HashMap();
    private int connectionPoolSize;
    private int connectionOpenRetries;
    private long connectionOpenRetryIntervalMillis;
    private int sessionsPerConnection;
    private String username;
    private String password;
    private String clientID;
    private boolean setClientID;
    protected boolean jndi;
    private String jndiContextFactory;
    private String jndiPrincipal;
    private String jndiCredentials;
    private String jndiTopicConnectionFactory;
    private int nextThreadConnection;
    protected List<ConnectionContext> connections;
    private ConcurrentHashMap<Thread, TopicSession> threadSessions;
    protected ConcurrentHashMap<String, TopicSubscriber> subscribers;
    protected ConcurrentHashMap<TopicSession, TopicPublisher> publishers;

    protected JmsMessageBusBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        super(null, userName, descriptor, eventHandler);
    }

    protected TopicConnectionFactory createTopicConnectionFactory(String address, Properties providerConfig) throws Exception {
        TopicConnectionFactory tcf;
        if (this.jndi) {
            if (this.jndiContextFactory == null) {
                throw new SmaPermanentException("Invalid provider configuration [missing 'jndi_contextfactory' property]");
            }
            if (this.jndiPrincipal == null) {
                throw new SmaPermanentException("Invalid provider configuration [missing 'jndi_principal' property]");
            }
            if (this.jndiCredentials == null) {
                throw new SmaPermanentException("Invalid provider configuration [missing 'jndi_credentials' property]");
            }
            if (this.jndiTopicConnectionFactory == null) {
                throw new SmaPermanentException("Invalid provider configuration [missing 'jndi_connectionfactory' property]");
            }
            Properties props = new Properties();
            props.put("java.naming.factory.initial", this.jndiContextFactory);
            props.put("java.naming.provider.url", address);
            props.put("java.naming.security.principal", this.jndiPrincipal);
            props.put("java.naming.security.credentials", this.jndiCredentials);
            InitialContext jndiContext = new InitialContext(props);
            if (this.tracer.debug) {
                this.tracer.log("...using JNDI (Context= " + jndiContext.toString() + ")...", Tracer.Level.DEBUG);
            }
            if ((tcf = (TopicConnectionFactory)jndiContext.lookup(this.jndiTopicConnectionFactory)) == null) {
                throw new SmaPermanentException("Connection factory '" + this.jndiTopicConnectionFactory + "' not found!");
            }
        } else {
            Class<?> tcfClass = Class.forName("com.tibco.tibjms.TibjmsTopicConnectionFactory");
            Constructor<?> constructor = null;
            Class[] parameterTypes = new Class[]{String.class};
            constructor = tcfClass.getConstructor(parameterTypes);
            Object[] parameters = new Object[]{address};
            tcf = (TopicConnectionFactory)constructor.newInstance(parameters);
        }
        return tcf;
    }

    private final TopicSession getOutSession() {
        Thread current = Thread.currentThread();
        TopicSession session = this.threadSessions.get(current);
        if (session == null) {
            int assignedConnectionIndex = this.nextThreadConnection++ % this.connections.size();
            ConnectionContext connection = this.connections.get(assignedConnectionIndex);
            int assignedSessionIndex = connection.nextThreadSession++ % connection.sessions.size();
            session = connection.sessions.get(assignedSessionIndex);
            this.threadSessions.put(current, session);
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Assigned session #" + assignedSessionIndex + " in connection #" + assignedConnectionIndex + " to thread '" + current + " for outbound traffic.", Tracer.Level.DEBUG);
            }
        }
        return session;
    }

    private final String channelName(MessageMetadata metadata) {
        return metadata != null ? metadata.getMessageChannelName() : null;
    }

    private final short channelId(MessageMetadata metadata) {
        return metadata != null ? metadata.getMessageChannelId() : (short)0;
    }

    final String extractDestinationName(Message message) {
        String destination;
        block3: {
            destination = null;
            try {
                Destination d = message.getJMSDestination();
                if (d != null) {
                    destination = d instanceof Topic ? ((Topic)d).getTopicName() : (d instanceof Queue ? ((Queue)d).getQueueName() : d.toString());
                }
            }
            catch (JMSException jmse) {
                if (!this.tracer.debug) break block3;
                this.tracer.log(this.tracePrefix + "Could not get destination from message: " + jmse.toString(), Tracer.Level.DEBUG);
            }
        }
        return destination;
    }

    final void onMessage(Message message, JmsMessageChannel ackChannel, MessageMetadata metadata, long originTs, long preWireTs, long postWireTs) throws SmaException {
        JmsMessageChannel channel = (JmsMessageChannel)(metadata != null ? this.findMessageChannelForInboundMessageDispatch(metadata.getMessageChannelNameAsRaw(), metadata.getMessageChannelId()) : this.getCatchAllChannel());
        if (channel != null) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Dispatching message sent on channel '" + this.channelName(metadata) + "' via channel '" + channel.getName() + "'.", Tracer.Level.DEBUG);
            }
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Channel (name=" + this.channelName(metadata) + ", id=" + this.channelId(metadata) + ") not found (or not joined) for inbound message.", Tracer.Level.DEBUG);
            }
            throw new RuntimeException(this.tracePrefix + "Channel (name=" + this.channelName(metadata) + ", id=" + this.channelId(metadata) + ") not found (or not joined) for inbound message.");
        }
        channel.onMessage(message, ackChannel, metadata, originTs, preWireTs, postWireTs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final void onMessage(JmsMessageChannel channel, Message message) {
        metadata = null;
        try {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Received a message on topic '" + message.getJMSDestination() + "'", Tracer.Level.DEBUG);
            }
            postWireTs = MessageLatencyManager.captureMsgLatencyStats != false ? UtlTime.now() : 0L;
            MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.r, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Inbound, (Object)message);
            if (!this.rawMode()) {
                if (message.getBooleanProperty("x-sma-metadata-present")) {
                    version = message.getStringProperty("x-sma-metadata-version") != null ? message.getByteProperty("x-sma-metadata-version") : 1;
                    encodingType = message.getByteProperty("x-sma-metadata-ec");
                    vfid = message.getShortProperty("x-sma-metadata-vfid");
                    vtype = version > 1 ? message.getShortProperty("x-sma-metadata-vtype") : 0;
                    sender = message.getIntProperty("x-sma-metadata-sender");
                    flow = message.getIntProperty("x-sma-metadata-flow");
                    sno = message.getLongProperty("x-sma-metadata-sno");
                    channelId = message.getShortProperty("x-sma-metadata-chid");
                    channelName = message.getStringProperty("x-sma-metadata-chname");
                    rawChannelName = channelName == null ? null : XString.create((String)channelName);
                    try {
                        metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
                        switch (version) {
                            case 1: {
                                metadata.serializeV1(encodingType, vfid, sender, flow, sno, channelId, rawChannelName);
                                ** break;
lbl25:
                                // 1 sources

                            }
                            case 2: {
                                metadata.serializeV2(encodingType, vfid, vtype, sender, flow, sno, channelId, rawChannelName);
                                ** break;
lbl29:
                                // 1 sources

                            }
                            default: {
                                throw new SmaException(this.tracePrefix + "Unsupported metadata version '" + version + "'");
                            }
                        }
                    }
                    finally {
                        if (rawChannelName != null) {
                            rawChannelName.close();
                        }
                    }
                } else {
                    throw new SmaException(this.tracePrefix + "Inbound message is corrupt [no SMA metadata in message]");
                }
            }
            this.onMessage(message, channel, metadata, message.propertyExists("x-sma-metadata-origin-ts") != false ? message.getLongProperty("x-sma-metadata-origin-ts") : 0L, message.propertyExists("x-sma-metadata-prewire-ts") != false ? message.getLongProperty("x-sma-metadata-prewire-ts") : 0L, postWireTs);
        }
        catch (Exception e) {
            messageId = null;
            try {
                messageId = message.getJMSMessageID();
            }
            catch (JMSException jmse) {
                this.tracer.log(this.tracePrefix + "Could not get message id from message with inbound handling fault: " + jmse.toString(), Tracer.Level.WARNING);
            }
            destination = this.extractDestinationName(message);
            serializedPayload = null;
            try {
                if (message instanceof BytesMessage) {
                    bytesMessage = (BytesMessage)message;
                    if (bytesMessage.getBodyLength() > 0L) {
                        serializedPayload = new byte[(int)bytesMessage.getBodyLength()];
                        ((BytesMessage)message).reset();
                        ((BytesMessage)message).readBytes(serializedPayload, serializedPayload.length);
                    }
                } else if (message instanceof TextMessage && (text = ((TextMessage)message).getText()) != null) {
                    serializedPayload = text.getBytes("utf-8");
                }
            }
            catch (Exception jmse) {
                this.tracer.log(this.tracePrefix + "Error extracting serialized payload from message with inbound handling fault: " + jmse.toString(), Tracer.Level.WARNING);
            }
            this.onInboundMessageHandlingFault(messageId, destination, metadata, message, null, serializedPayload, channel.getQos() == MessageChannel.Qos.Guaranteed ? this.createAcknowledger(channel, message) : null, e);
        }
    }

    final void unsubscribe(JmsMessageChannel channel, String destination) throws SmaException {
        try {
            TopicSubscriber subscriber;
            if (this.tracer.debug) {
                this.tracer.log("Unsubscribing from topic '" + destination + "' [channel=" + channel.getName() + "]", Tracer.Level.DEBUG);
            }
            if ((subscriber = this.subscribers.remove(destination)) != null) {
                subscriber.setMessageListener(null);
                subscriber.close();
            }
        }
        catch (JMSException e) {
            throw new SmaException((Throwable)e);
        }
    }

    final BytesMessage createBytesMessage() throws JMSException {
        return this.getOutSession().createBytesMessage();
    }

    final TextMessage createTextMessage() throws JMSException {
        return this.getOutSession().createTextMessage();
    }

    final JmsAcknowledger createAcknowledger(JmsMessageChannel channel, Message message) {
        return new JmsAcknowledger(channel, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void send(JmsMessageChannel sender, MessageView view, Message message, MessageMetadata metadata, String destination, MessageChannel.Qos qos, long originTs, int flags) throws SmaException {
        try {
            TopicSession session;
            if (metadata != null) {
                message.setBooleanProperty("x-sma-metadata-present", true);
                message.setByteProperty("x-sma-metadata-version", (byte)metadata.getVersion());
                message.setByteProperty("x-sma-metadata-ec", metadata.getMessageEncodingType());
                message.setShortProperty("x-sma-metadata-vfid", metadata.getMessageViewFactory());
                message.setShortProperty("x-sma-metadata-vtype", metadata.getMessageViewType());
                message.setIntProperty("x-sma-metadata-sender", metadata.getMessageSender());
                message.setIntProperty("x-sma-metadata-flow", metadata.getMessageFlow());
                message.setLongProperty("x-sma-metadata-sno", metadata.getMessageSno());
                message.setShortProperty("x-sma-metadata-chid", metadata.getMessageChannelId());
                message.setStringProperty("x-sma-metadata-chname", metadata.getMessageChannelName());
            }
            if (originTs > 0L) {
                message.setLongProperty("x-sma-metadata-origin-ts", originTs);
            }
            MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.w1, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)view);
            if (MessageLatencyManager.captureMsgLatencyStats) {
                long now = UtlTime.now();
                view.setPreWireTs(now);
                message.setLongProperty("x-sma-metadata-prewire-ts", now);
            }
            TopicSession topicSession = session = this.getOutSession();
            synchronized (topicSession) {
                TopicPublisher publisher = this.publishers.get(session);
                Topic topic = session.createTopic(destination);
                if (qos == MessageChannel.Qos.BestEffort) {
                    publisher.publish(topic, message);
                } else {
                    publisher.publish(topic, message, 2, 0, 0L);
                }
            }
            if (MessageLatencyManager.captureMsgLatencyStats) {
                view.setPostWireSendTs(UtlTime.now());
                if (this.latencyManager != null) {
                    this.latencyManager.update(view, MessageLatencyManager.MessagingDirection.Outbound);
                }
            }
            MessageWaypointListenerRegistry.dispatch((MessageWaypointListener.Waypoint)MessageWaypointListener.Waypoint.w2, (MessageWaypointListener.MessagingDirection)MessageWaypointListener.MessagingDirection.Outbound, (Object)view);
        }
        catch (JMSException e) {
            throw new SmaException((Throwable)e);
        }
    }

    final void onBindingFail(Exception e) {
        this.doClose();
        this.onFail(e);
    }

    protected void onChannelClose(JmsMessageChannel channel) throws SmaException {
        if (this.supportsGuaranteedQos()) {
            List<DurableSubscriptionInfo> subs = this.openDurableSubs.remove((Object)channel);
            if (subs == null || subs.isEmpty()) {
                return;
            }
            for (int i = 0; i < subs.size(); ++i) {
                DurableSubscriptionInfo info = subs.get(i);
                try {
                    info.subscriber.close();
                    continue;
                }
                catch (JMSException e) {
                    this.tracer.log(this.tracePrefix + "Error closing durable subscriber [" + info + "]: " + e.toString(), Tracer.Level.WARNING);
                }
            }
        }
    }

    protected void subscribe(JmsMessageChannel channel, String destination) throws SmaException {
        try {
            if (this.tracer.debug) {
                this.tracer.log("Subscribing to topic '" + destination + "' [channel=" + channel.getName() + "]", Tracer.Level.DEBUG);
            }
            Topic topic = this.connections.get((int)0).inSession.createTopic(destination);
            TopicSubscriber subscriber = this.connections.get((int)0).inSession.createSubscriber(topic);
            this.subscribers.put(destination, subscriber);
            subscriber.setMessageListener((MessageListener)channel);
        }
        catch (JMSException e) {
            throw new SmaException((Throwable)e);
        }
    }

    protected final void subscribeGuaranteed(JmsMessageChannel channel, String destination) throws SmaException {
        if (this.supportsGuaranteedQos()) {
            try {
                String durableSubscriptionName = this.durableSubscriptionName(channel, destination);
                if (this.tracer.debug) {
                    this.tracer.log("Subscribing to guaranteed (durable) topic '" + destination + "', subscription: '" + durableSubscriptionName + "' [channel=" + channel.getName() + "]", Tracer.Level.DEBUG);
                }
                Topic topic = this.connections.get((int)0).inGuarSession.createTopic(destination);
                TopicSubscriber subscriber = this.connections.get((int)0).inGuarSession.createDurableSubscriber(topic, durableSubscriptionName);
                this.subscribers.put(destination, subscriber);
                List<DurableSubscriptionInfo> dSubs = this.openDurableSubs.get((Object)channel);
                if (dSubs == null) {
                    dSubs = new ArrayList<DurableSubscriptionInfo>();
                    this.openDurableSubs.put((MessageChannel)channel, dSubs);
                }
                dSubs.add(new DurableSubscriptionInfo(durableSubscriptionName, channel.getName(), destination, subscriber));
                subscriber.setMessageListener((MessageListener)channel);
            }
            catch (JMSException e) {
                this.tracer.log(this.tracePrefix + "Failed to subscribe (durable) to '" + destination + "' [ " + e.toString() + "]", Tracer.Level.SEVERE);
                throw new SmaException((Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException("guaranteed QOS is not supported");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void unsubscribeGuaranteed(JmsMessageChannel channel, String destination) throws SmaException {
        if (!this.supportsGuaranteedQos()) throw new UnsupportedOperationException("guaranteed QOS is not supported");
        try {
            TopicSubscriber subscriber;
            String durableSubscriptionName = this.durableSubscriptionName(channel, destination);
            if (this.tracer.debug) {
                this.tracer.log("Closing durable durable topic '" + destination + "', subscription: '" + durableSubscriptionName + "' [channel=" + channel.getName() + "]", Tracer.Level.DEBUG);
            }
            if ((subscriber = this.subscribers.remove(destination)) == null) return;
            subscriber.close();
            List<DurableSubscriptionInfo> dSubs = this.openDurableSubs.get((Object)channel);
            for (int i = 0; i < dSubs.size(); ++i) {
                if (dSubs.get((int)i).subscriber != subscriber) continue;
                dSubs.remove(i);
                break;
            }
            if (this.tracer.debug) {
                this.tracer.log("Unsubscribing (durable) topic '" + destination + "', subscription: '" + durableSubscriptionName + "' [channel=" + channel.getName() + "]", Tracer.Level.DEBUG);
            }
            this.connections.get((int)0).inGuarSession.unsubscribe(this.durableSubscriptionName(channel, destination));
            return;
        }
        catch (JMSException e) {
            this.tracer.log(this.tracePrefix + "Failed to unsubsubscribe (durable) from '" + destination + "' [ " + e.toString() + "]", Tracer.Level.SEVERE);
            throw new SmaException((Throwable)e);
        }
    }

    private final String durableSubscriptionName(JmsMessageChannel channel, String destination) {
        return this.getUserName() + "-" + channel.getName() + "-" + destination.hashCode();
    }

    protected boolean supportsGuaranteedQos() {
        return false;
    }

    protected int getDeliveryMode(MessageChannel.Qos qos) {
        switch (qos) {
            case BestEffort: {
                return 1;
            }
            case Guaranteed: {
                return 2;
            }
        }
        return 1;
    }

    protected int getAcknowledgementMode(MessageChannel.Qos qos) {
        switch (qos) {
            case BestEffort: {
                return 1;
            }
            case Guaranteed: {
                return 2;
            }
        }
        return 1;
    }

    protected final void doOpen() throws SmaException {
        String address;
        this.connections = new ArrayList<ConnectionContext>();
        this.threadSessions = new ConcurrentHashMap();
        this.subscribers = new ConcurrentHashMap();
        this.publishers = new ConcurrentHashMap();
        Properties providerConfig = this.descriptor.getProviderConfig();
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Opening binding (props=" + providerConfig + ")...", Tracer.Level.DEBUG);
        }
        this.connectionPoolSize = Math.max(1, UtlProps.getValue((Properties)providerConfig, (String)"connection_pool_size", (int)1));
        this.connectionOpenRetries = Math.max(0, UtlProps.getValue((Properties)providerConfig, (String)"connection_open_retry_count", (int)10));
        this.connectionOpenRetryIntervalMillis = (long)Math.max(250.0, UtlUnit.parseDuration((String)UtlProps.getValue((Properties)providerConfig, (String)"connection_open_retry_interval", (String)"1"), (TimeUnit)TimeUnit.SECONDS, (TimeUnit)TimeUnit.MILLISECONDS));
        this.sessionsPerConnection = Math.max(1, UtlProps.getValue((Properties)providerConfig, (String)"sessions_per_connection", (int)1));
        this.username = UtlProps.getValue((Properties)providerConfig, (String)"username", null);
        this.password = UtlProps.getValue((Properties)providerConfig, (String)"password", null);
        this.jndi = UtlProps.getValue((Properties)providerConfig, (String)"jndi", (boolean)false);
        this.setClientID = UtlProps.getValue((Properties)providerConfig, (String)"set_client_id", (boolean)true);
        if (this.setClientID) {
            this.clientID = UtlProps.getValue((Properties)providerConfig, (String)"client_id", (String)(UtlProps.getValue((Properties)providerConfig, (String)"use_legacy_client_id", (boolean)false) ? super.getUserName() + "-" + super.getName() : "X-SMA-" + super.getName() + "-" + super.getUserName()));
        }
        if (this.jndi) {
            this.jndiContextFactory = UtlProps.getValue((Properties)providerConfig, (String)"jndi_contextfactory", null);
            this.jndiPrincipal = UtlProps.getValue((Properties)providerConfig, (String)"jndi_principal", null);
            this.jndiCredentials = UtlProps.getValue((Properties)providerConfig, (String)"jndi_credentials", null);
            this.jndiTopicConnectionFactory = UtlProps.getValue((Properties)providerConfig, (String)"jndi_connectionfactory", null);
        }
        boolean hasGuaranteedChannels = false;
        boolean hasBestEffortChannels = false;
        for (MessageChannelDescriptor channel : this.descriptor.getChannels()) {
            if (channel.getChannelQos() == MessageChannel.Qos.Guaranteed) {
                hasGuaranteedChannels = true;
                if (!hasBestEffortChannels) continue;
                break;
            }
            hasBestEffortChannels = true;
            if (!hasGuaranteedChannels) continue;
            break;
        }
        if ((address = UtlProps.getValue((Properties)providerConfig, (String)"Address", null)) == null) {
            throw new SmaPermanentException("Invalid provider configuration [missing 'Address' property]");
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Connecting using '" + address + "' (username=" + this.username + ", password=" + this.password + ", jndi=" + this.jndi + ", clientID=" + this.clientID + ")...", Tracer.Level.DEBUG);
        }
        TopicConnectionFactory tcf = null;
        try {
            tcf = this.createTopicConnectionFactory(address, providerConfig);
        }
        catch (SmaPermanentException smae) {
            throw smae;
        }
        catch (Exception e) {
            throw new SmaPermanentException((Throwable)e);
        }
        int sessionCount = 0;
        block9: for (int i = 0; i < this.connectionPoolSize; ++i) {
            String connectionClientID = null;
            if (this.setClientID) {
                connectionClientID = this.clientID;
                if (this.connectionPoolSize > 0) {
                    connectionClientID = connectionClientID + "-" + (i + 1);
                }
            }
            int connectionAttemptLimit = 1 + this.connectionOpenRetries;
            for (int c = 1; c <= connectionAttemptLimit + 1; ++c) {
                try {
                    ConnectionContext connection = new ConnectionContext(tcf, hasGuaranteedChannels, hasBestEffortChannels, connectionClientID);
                    this.connections.add(connection);
                    sessionCount += connection.sessions.size();
                    if (c <= 1) continue block9;
                    this.tracer.log(this.tracePrefix + " connection attempt " + c + " of " + connectionAttemptLimit + " succeeded", Tracer.Level.INFO);
                    continue block9;
                }
                catch (SmaPermanentException smae) {
                    this.doClose();
                    throw smae;
                }
                catch (SmaException smae) {
                    if (c == connectionAttemptLimit) {
                        this.tracer.log(this.tracePrefix + " connection attempt " + c + " of " + connectionAttemptLimit + " failed [" + smae.getMessage() + "]", Tracer.Level.WARNING);
                        this.doClose();
                        throw smae;
                    }
                    this.tracer.log(this.tracePrefix + " connection attempt " + c + " of " + connectionAttemptLimit + " failed [" + smae.getMessage() + "] will retry in " + this.connectionOpenRetryIntervalMillis + "ms...", Tracer.Level.WARNING);
                    try {
                        Thread.sleep(this.connectionOpenRetryIntervalMillis);
                        continue;
                    }
                    catch (InterruptedException e) {
                        this.tracer.log(this.tracePrefix + " connection attempt " + (c + 1) + " of " + connectionAttemptLimit + " interrupted.", Tracer.Level.WARNING);
                        this.doClose();
                        Thread.currentThread().interrupt();
                        throw new SmaException((Throwable)smae);
                    }
                }
            }
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + this.connections.size() + " connections established.", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + sessionCount + " sessions established.", Tracer.Level.DEBUG);
        }
    }

    protected MessageChannel doGetMessageChannel(MessageChannelDescriptor descriptor) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Creating new channel '" + descriptor.getName() + "'.", Tracer.Level.DEBUG);
        }
        return new JmsMessageChannel(descriptor, this);
    }

    protected final void doStart() throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Starting binding...", Tracer.Level.DEBUG);
        }
        try {
            for (ConnectionContext connection : this.connections) {
                connection.connection.start();
            }
        }
        catch (JMSException e) {
            throw new SmaException((Throwable)e);
        }
    }

    protected void doFlush() throws SmaException {
    }

    protected final boolean doCanFail() {
        return true;
    }

    protected boolean doAcksRequireFlush() {
        return false;
    }

    protected final void doClose() {
        block8: {
            if (this.supportsGuaranteedQos()) {
                try {
                    if (this.connections != null && this.connections.size() > 0) {
                        this.connections.get((int)0).connection.stop();
                    }
                    if (this.subscribers != null) {
                        for (TopicSubscriber subscriber : this.subscribers.values()) {
                            MessageListener listener = subscriber.getMessageListener();
                            if (listener == null || !(listener instanceof JmsMessageChannel)) continue;
                            ((JmsMessageChannel)listener).flushReceivedAcks();
                        }
                    }
                }
                catch (JMSException jmse) {
                    if (!this.tracer.debug) break block8;
                    this.tracer.log("Unable to flush guaranteed acks on close: " + jmse.toString(), Tracer.Level.WARNING);
                }
            }
        }
        if (this.connections != null) {
            for (ConnectionContext connection : this.connections) {
                connection.close();
            }
        }
    }

    public void onException(JMSException e) {
        this.tracer.log(this.tracePrefix + "Connection has failed [" + e.toString() + "]", Tracer.Level.WARNING);
        this.onFail((Exception)((Object)e));
    }

    protected final class ConnectionContext {
        public final TopicConnection connection;
        public final TopicSession inSession;
        public final List<TopicSession> sessions = new ArrayList<TopicSession>();
        public final TopicSession inGuarSession;
        public int nextThreadSession;

        ConnectionContext(TopicConnectionFactory tcf, boolean hasGuaranteedChannels, boolean hasBestEfforChannels, String clientID) throws SmaException, SmaPermanentException {
            try {
                this.connection = JmsMessageBusBinding.this.username == null || JmsMessageBusBinding.this.password == null ? tcf.createTopicConnection() : tcf.createTopicConnection(JmsMessageBusBinding.this.username, JmsMessageBusBinding.this.password);
                try {
                    if (clientID != null) {
                        this.connection.setClientID(clientID);
                    }
                    this.connection.setExceptionListener((ExceptionListener)JmsMessageBusBinding.this);
                    if (JmsMessageBusBinding.this.sessionsPerConnection <= 0) {
                        throw new IllegalArgumentException("sessionsPerConnection parameter must be greater than or equal to 1!");
                    }
                    TopicSession theInSession = null;
                    for (int i = 0; i < JmsMessageBusBinding.this.sessionsPerConnection; ++i) {
                        TopicSession session = this.connection.createTopicSession(false, JmsMessageBusBinding.this.getAcknowledgementMode(MessageChannel.Qos.BestEffort));
                        this.sessions.add(session);
                        if (i != 0) continue;
                        theInSession = session;
                    }
                    this.inSession = theInSession;
                    this.inGuarSession = JmsMessageBusBinding.this.supportsGuaranteedQos() && hasGuaranteedChannels ? this.connection.createTopicSession(false, JmsMessageBusBinding.this.getAcknowledgementMode(MessageChannel.Qos.Guaranteed)) : null;
                    for (TopicSession session : this.sessions) {
                        TopicPublisher publisher = session.createPublisher(null);
                        publisher.setDeliveryMode(1);
                        JmsMessageBusBinding.this.publishers.put(session, publisher);
                    }
                }
                catch (Throwable thrown) {
                    try {
                        this.closeInternal();
                    }
                    catch (Throwable t2) {
                        JmsMessageBusBinding.this.tracer.log("Error closing partially established connection " + t2.toString(), Tracer.Level.WARNING);
                    }
                    throw thrown;
                }
            }
            catch (SmaPermanentException smae) {
                throw smae;
            }
            catch (JMSSecurityException jmse) {
                throw new SmaPermanentException((Throwable)jmse);
            }
            catch (InvalidClientIDException e) {
                throw new SmaException((Throwable)e);
            }
            catch (Exception jmse) {
                throw new SmaException((Throwable)jmse);
            }
            catch (Throwable thrown) {
                throw new SmaPermanentException(thrown);
            }
        }

        private final void closeInternal() throws JMSException {
            try {
                this.connection.stop();
                for (Session session : this.sessions) {
                    session.close();
                }
                if (this.inGuarSession != null) {
                    this.inGuarSession.close();
                }
            }
            finally {
                this.connection.close();
            }
        }

        final void close() {
            try {
                this.closeInternal();
            }
            catch (JMSException e) {
                JmsMessageBusBinding.this.tracer.log(JmsMessageBusBinding.this.tracePrefix + "Failed to close JMS connection [ " + e.toString() + "]", Tracer.Level.WARNING);
            }
        }
    }

    private final class JmsAcknowledger
    extends MessageBusBindingBase.Acknowledger<JmsAcknowledger> {
        private Message message;
        private JmsMessageChannel channel;
        volatile int ackCount;

        JmsAcknowledger(JmsMessageChannel channel, Message message) {
            super((MessageBusBindingBase)JmsMessageBusBinding.this);
            this.ackCount = 0;
            this.message = message;
            this.channel = channel;
        }

        protected final void doAck() {
            try {
                if (((JmsMessageBusBinding)JmsMessageBusBinding.this).tracer.debug) {
                    JmsMessageBusBinding.this.tracer.log("Acknowledging message from: " + this.message.getJMSDestination().toString(), Tracer.Level.DEBUG);
                }
                if (++this.ackCount == 1) {
                    this.channel.acknowledgeMessage(this.message);
                } else {
                    JmsMessageBusBinding.this.tracer.log("Duplicate acknowledging message from: " + this.message.getJMSDestination().toString(), Tracer.Level.WARNING);
                }
            }
            catch (JMSException e) {
                JmsMessageBusBinding.this.tracer.log(JmsMessageBusBinding.this.tracePrefix + "Failed to acknowlege message [ " + e.toString() + "]", Tracer.Level.WARNING);
            }
        }

        protected final void doReset() {
            this.message = null;
            this.ackCount = 0;
        }
    }

    private static class DurableSubscriptionInfo {
        final String durableSubscriptionName;
        final String channelName;
        final String destination;
        final TopicSubscriber subscriber;

        DurableSubscriptionInfo(String durableSubscriptionName, String channelName, String destination, TopicSubscriber subscriber) {
            this.durableSubscriptionName = durableSubscriptionName;
            this.channelName = channelName;
            this.destination = destination;
            this.subscriber = subscriber;
        }

        public String toString() {
            return "name=" + this.durableSubscriptionName + "topic=" + this.destination + ",channel=" + this.channelName;
        }
    }
}

