/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.aep.messaging;

import com.neeve.aep.AepEngineDescriptor;
import com.neeve.config.Config;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageViewFactoryRegistry;
import java.util.Map;
import java.util.Properties;

final class Configurer {
    private static final String MESSAGES_CHANNEL_NAME = "messages";

    Configurer() {
    }

    private static final MessageBusDescriptor configureMessageBus(String busName) throws Exception {
        MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)"perf-aep");
        MessageChannelDescriptor channelDescriptor = MessageChannelDescriptor.create((String)MESSAGES_CHANNEL_NAME, (MessageBusDescriptor)busDescriptor);
        channelDescriptor.setChannelId((short)1);
        channelDescriptor.setChannelQos(MessageChannel.Qos.valueOf((String)Config.getValue((String)"perf.aep.channel.messages.qos", (String)MessageChannel.Qos.Guaranteed.toString())));
        channelDescriptor.setChannelKey(Config.getValue((String)"perf.aep.channel.messages.key", null));
        busDescriptor.addChannel(channelDescriptor);
        return busDescriptor;
    }

    static final MessageBusDescriptor configure(String appName, boolean receive, Map<String, AepEngineDescriptor.ChannelConfig> channelsConfig, Properties props) throws Exception {
        Config.initializeEnvironment();
        MessageBusDescriptor busDescriptor = Configurer.configureMessageBus(appName);
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory("com.neeve.perf.aep.messages.MessageFactory");
        AepEngineDescriptor.ChannelConfig channelConfig = new AepEngineDescriptor.ChannelConfig();
        channelConfig.setJoin(receive);
        channelConfig.setFilter(Config.getValue((String)("perf.aep.channel.messages." + appName + ".filter"), null));
        channelsConfig.put(MESSAGES_CHANNEL_NAME, channelConfig);
        props.setProperty("provider_descriptor", Config.getValue((String)("perf.aep.bus." + appName + ".descriptor"), (String)Config.getValue((String)"perf.aep.bus.descriptor", null)));
        props.setProperty("detachedCommit", "false");
        return busDescriptor;
    }
}

