/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.util.UtlJar;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;

public class UtlResource {
    public static void findClasspathResourcesIn(String path, Set<URL> results, URLFilter filter) throws IOException {
        Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(path);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if ("file".equals(url.getProtocol())) {
                try {
                    File file = new File(url.toURI());
                    if (!file.isDirectory()) continue;
                    for (File child : file.listFiles()) {
                        if (!child.isFile()) continue;
                        URL childUrl = child.toURI().toURL();
                        if (filter != null && filter.filter(childUrl)) continue;
                        results.add(childUrl);
                    }
                    continue;
                }
                catch (URISyntaxException e) {
                    throw new IOException("Invalid file url on classpath: " + e.getMessage(), e);
                }
            }
            if (!"jar".equals(url.getProtocol())) continue;
            UtlJar.listFiles(url, results, filter);
        }
    }

    public static interface URLFilter {
        public boolean filter(URL var1);
    }
}

