/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.config.Config;
import com.neeve.util.UtlTime;

public final class UtlGovernor {
    private final long nanosPerToken;
    private final long start;
    private long tokensAccumulated;
    private long tokensPickedUp;
    private WaitStrategy waitStrategy = Config.getValue((String)"nv.conservecpu", (boolean)false) ? WaitStrategy.Sleep : WaitStrategy.BusySpin;

    public UtlGovernor(int rate) {
        this.nanosPerToken = rate > 0 ? 1000000000L / (long)rate : 1L;
        this.start = UtlTime.now();
    }

    public final WaitStrategy getWaitStrategy() {
        return this.waitStrategy;
    }

    public final void setWaitStrategy(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    public final void blockToNext() {
        if (++this.tokensPickedUp > this.tokensAccumulated) {
            do {
                switch (this.waitStrategy) {
                    case BusySpin: {
                        break;
                    }
                    case Sleep: {
                        long timeUntilNextToken = this.tokensAccumulated * this.nanosPerToken - this.start + this.nanosPerToken - UtlTime.now();
                        if (timeUntilNextToken <= 0L) break;
                        long sleepMillis = 0L;
                        int sleepNanos = 0;
                        if (timeUntilNextToken > 1000000000L) {
                            sleepMillis = timeUntilNextToken / 1000000000L;
                            sleepNanos = (int)(sleepMillis * 1000000000L - timeUntilNextToken);
                        } else {
                            sleepNanos = (int)timeUntilNextToken;
                        }
                        try {
                            Thread.sleep(sleepMillis, sleepNanos);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        break;
                    }
                    case Yield: {
                        Thread.yield();
                    }
                }
                long current = UtlTime.now();
                this.tokensAccumulated = (current - this.start) / this.nanosPerToken;
            } while (this.tokensPickedUp > this.tokensAccumulated);
        }
    }

    public static final void run(int iterations, int rate, Runnable command) {
        UtlGovernor governor = new UtlGovernor(rate);
        int i = 0;
        while (iterations <= 0 || i++ < iterations) {
            governor.blockToNext();
            command.run();
        }
    }

    public static enum WaitStrategy {
        BusySpin,
        Yield,
        Sleep;

    }
}

