/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive;

import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.tools.interactive.commands.IndentingWriter;
import com.neeve.util.UtlTableFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

public class DocumentationGenerator {
    private final InteractiveTool tool;

    DocumentationGenerator(InteractiveTool tool) {
        this.tool = tool;
    }

    public final void generate(String name, Format format, File outputDir) throws IOException {
        switch (format) {
            case Html: {
                this.generateHtml(name, outputDir, this.tool.commands.values());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported format: " + (Object)((Object)format));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateHtml(String name, File outputDir, Collection<Command> commands) throws IOException {
        File file;
        if (name == null) {
            name = this.tool.getName();
        }
        if (!(file = new File(outputDir, name + ".html")).exists()) {
            file.getParentFile().mkdirs();
        }
        try (IndentingWriter out = new IndentingWriter(new BufferedWriter(new FileWriter(file)), "  ");){
            out.println("<html>").indent();
            out.println("<head>").indent();
            out.print("<title>").print(name).print(" Usage").print("</title>");
            out.println("</head>");
            out.println("");
            out.println("<body>").indent();
            out.println("");
            HashSet alreadyShown = new HashSet();
            if (!this.tool.configPropertyHandlers.isEmpty()) {
                out.print("<h1>Properties</h1>");
                UtlTableFormatter.Table table = UtlTableFormatter.createTable("Property Name", "Default Value", "Description");
                for (InteractiveTool.ConfigPropertyHandler property : this.tool.configPropertyHandlers.values()) {
                    try {
                        property.appendUsage(table);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                StringBuffer sb = new StringBuffer();
                table.write(sb, UtlTableFormatter.Format.HTML, true, -1);
                out.println(sb.toString());
            }
            if (!commands.isEmpty()) {
                out.print("<h1>Commands</h1>");
            }
            for (Command command : commands) {
                if (command.hidden() || !alreadyShown.add(command.getClass())) continue;
                out.println("<div class=\"command\">").indent();
                out.print("<h2>");
                if (command.keywords().length > 1) {
                    boolean first = true;
                    for (String keyword : command.keywords()) {
                        if (!first) {
                            out.print(" | ");
                        } else {
                            first = false;
                        }
                        out.print(keyword);
                    }
                } else {
                    out.print(command.keywords()[0]);
                }
                out.println("</h2>");
                if (command instanceof AnnotatedCommand) {
                    AnnotatedCommand acmd = (AnnotatedCommand)command;
                    acmd = (AnnotatedCommand)command;
                    acmd.helpHtml(out);
                } else {
                    out.println("<div class=\"preformatted panel\" style=\"border-width: 1px;\">)").indent();
                    out.println("<div class=\"preformattedContent panelContent\">").indent();
                    out.println("<pre>").indent();
                    out.println("Use 'help " + command.keywords()[0] + "' for usage");
                    out.deindent().println("</pre>");
                    out.deindent().println("</div>");
                    out.deindent().println("</div>");
                }
                out.print("</h2>");
                out.deindent().println("</div>");
            }
            out.deindent().println("<body>");
        }
    }

    public static enum Format {
        Html;

    }
}

