/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.stats;

import com.neeve.lang.XString;
import com.neeve.stats.AbstractGauge;
import com.neeve.stats.IStats;
import java.lang.reflect.Method;
import java.text.NumberFormat;

public class MethodReflectingGauge
extends AbstractGauge {
    private final Object target;
    private final Method accessor;
    private final XString stringHolder;

    public MethodReflectingGauge(String name, Object target, Method accessor) {
        super(name, MethodReflectingGauge.getType(accessor));
        if (!accessor.isAccessible()) {
            accessor.setAccessible(true);
        }
        this.target = target;
        this.accessor = accessor;
        this.stringHolder = this.type == IStats.Gauge.Type.String && !XString.class.isAssignableFrom(accessor.getReturnType()) ? XString.create(16, true) : null;
    }

    private static final IStats.Gauge.Type getType(Method accessor) {
        Class<?> javaType = accessor.getReturnType();
        if (javaType == null || javaType == Void.class) {
            throw new IllegalArgumentException("Return type for Gauge accessor method cannot be Void: ... " + accessor.toString());
        }
        if (accessor.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("Gauge accessor method must have 0 arguments: " + accessor.toString());
        }
        if (javaType.equals(Boolean.class) || javaType.equals(Boolean.TYPE)) {
            return IStats.Gauge.Type.Boolean;
        }
        if (javaType.equals(Byte.class) || javaType.equals(Byte.TYPE)) {
            return IStats.Gauge.Type.Byte;
        }
        if (javaType.equals(Short.class) || javaType.equals(Short.TYPE)) {
            return IStats.Gauge.Type.Short;
        }
        if (javaType.equals(Integer.class) || javaType.equals(Integer.TYPE)) {
            return IStats.Gauge.Type.Int;
        }
        if (javaType.equals(Long.class) || javaType.equals(Long.TYPE)) {
            return IStats.Gauge.Type.Long;
        }
        if (javaType.equals(Float.class) || javaType.equals(Float.TYPE)) {
            return IStats.Gauge.Type.Float;
        }
        if (javaType.equals(Double.class) || javaType.equals(Double.TYPE)) {
            return IStats.Gauge.Type.Double;
        }
        if (javaType.equals(Character.class) || javaType.equals(Character.TYPE)) {
            return IStats.Gauge.Type.Char;
        }
        if (javaType.equals(String.class) || XString.class.isAssignableFrom(javaType)) {
            return IStats.Gauge.Type.String;
        }
        throw new IllegalArgumentException("Gauge accessor return type is not a supported Gauge type: " + accessor.toString());
    }

    @Override
    public final boolean getBooleanValue() {
        if (this.type == IStats.Gauge.Type.Boolean) {
            try {
                Boolean value = (Boolean)this.accessor.invoke(this.target, new Object[0]);
                if (value == null) {
                    return false;
                }
                return value;
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getBooleanValue();
    }

    @Override
    public final byte getByteValue() {
        if (this.type == IStats.Gauge.Type.Byte) {
            try {
                Byte value = (Byte)this.accessor.invoke(this.target, new Object[0]);
                if (value == null) {
                    return 0;
                }
                return value;
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getByteValue();
    }

    @Override
    public final char getCharValue() {
        if (this.type == IStats.Gauge.Type.Char) {
            try {
                Character value = (Character)this.accessor.invoke(this.target, new Object[0]);
                if (value == null) {
                    return '\u0000';
                }
                return value.charValue();
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getCharValue();
    }

    @Override
    public final short getShortValue() {
        if (this.type == IStats.Gauge.Type.Short) {
            try {
                Short value = (Short)this.accessor.invoke(this.target, new Object[0]);
                if (value == null) {
                    return 0;
                }
                return value;
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getShortValue();
    }

    @Override
    public final int getIntValue() {
        if (this.type == IStats.Gauge.Type.Int) {
            try {
                Integer value = (Integer)this.accessor.invoke(this.target, new Object[0]);
                if (value == null) {
                    return 0;
                }
                return value;
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getIntValue();
    }

    @Override
    public final long getLongValue() {
        if (this.type == IStats.Gauge.Type.Long) {
            try {
                Long value = (Long)this.accessor.invoke(this.target, new Object[0]);
                if (value == null) {
                    return 0L;
                }
                return value;
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getLongValue();
    }

    @Override
    public final float getFloatValue() {
        if (this.type == IStats.Gauge.Type.Float) {
            try {
                Float value = (Float)this.accessor.invoke(this.target, new Object[0]);
                if (value == null) {
                    return 0.0f;
                }
                return value.floatValue();
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getFloatValue();
    }

    @Override
    public final double getDoubleValue() {
        if (this.type == IStats.Gauge.Type.Double) {
            try {
                Double value = (Double)this.accessor.invoke(this.target, new Object[0]);
                if (value == null) {
                    return 0.0;
                }
                return value;
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getDoubleValue();
    }

    @Override
    public final XString getStringValue() {
        if (this.type == IStats.Gauge.Type.String) {
            try {
                if (this.stringHolder != null) {
                    this.stringHolder.setValue((String)this.accessor.invoke(this.target, new Object[0]));
                    return this.stringHolder;
                }
                return (XString)this.accessor.invoke(this.target, new Object[0]);
            }
            catch (Throwable thrown) {
                throw new RuntimeException("Unable to get value for " + this.name + ": " + thrown.getMessage(), thrown);
            }
        }
        return super.getStringValue();
    }

    @Override
    public final void get(StringBuilder builder, NumberFormat format) {
        switch (this.type) {
            case Boolean: {
                builder.append(this.getBooleanValue());
                break;
            }
            case Byte: {
                builder.append(format.format(this.getByteValue()));
                break;
            }
            case Double: {
                builder.append(format.format(this.getDoubleValue()));
                break;
            }
            case Float: {
                builder.append(format.format(this.getFloatValue()));
                break;
            }
            case Int: {
                builder.append(format.format(this.getIntValue()));
                break;
            }
            case Long: {
                builder.append(format.format(this.getLongValue()));
                break;
            }
            case Short: {
                builder.append(format.format(this.getShortValue()));
                break;
            }
            case Char: {
                builder.append(this.getCharValue());
                break;
            }
            case String: {
                builder.append(this.getStringValue());
                break;
            }
        }
    }
}

