/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.IXStringFactory;
import com.neeve.lang.XString;

public final class XStringFactory
implements IXStringFactory<XString> {
    private final short initialCapacity;

    private XStringFactory(String name, short initialCapacity, boolean pooled, int preallocationCount, boolean threaded) {
        if (pooled) {
            throw new UnsupportedOperationException("XString does not support pooling, use XPooledString instead");
        }
        if (preallocationCount > 0) {
            throw new UnsupportedOperationException("XStringFactory does not currently support pool preallocation use XPooledString instead.");
        }
        this.initialCapacity = initialCapacity;
    }

    public static IXStringFactory<? extends XString> newFactory(String name, short initialCapacity) {
        return new XStringFactory(name, initialCapacity, false, 0, false);
    }

    public final short geInitialCapacity() {
        return this.initialCapacity;
    }

    @Override
    public final XString create() {
        return this.create(true);
    }

    public final XString[] createArray(int size) {
        XString[] rc = new XString[size];
        for (int i = 0; i < size; ++i) {
            rc[i] = this.create(true);
        }
        return rc;
    }

    @Override
    public final XString create(String value) {
        return this.create(value, false);
    }

    @Override
    public final XString create(boolean mutable) {
        return new XString(mutable, this.initialCapacity);
    }

    @Override
    public final XString create(String initialValue, boolean mutable) {
        XString rc = this.create(mutable);
        rc.initialize(initialValue);
        return rc;
    }

    @Override
    public final XString create(XString initialValue, boolean mutable) {
        XString rc = this.create(mutable);
        rc.initializeFrom(initialValue);
        return rc;
    }
}

