/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XByteCollection;
import com.neeve.lang.XByteCollectionBase;
import com.neeve.lang.XByteIterator;
import com.neeve.lang.XByteList;
import com.neeve.lang.XByteListIterator;
import com.neeve.lang.XCollection;
import java.util.NoSuchElementException;

public class XByteLinkedList
extends XByteCollectionBase
implements XByteList {
    private transient ByteNode _head = this.newNode();
    private transient ByteNode _tail = this.newNode();
    private transient int _size;

    public XByteLinkedList() {
        this(4);
    }

    public XByteLinkedList(int capacity) {
        this._head._next = this._tail;
        this._tail._previous = this._head;
        ByteNode previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            ByteNode newNode = this.newNode();
            newNode._previous = previous;
            previous._next = newNode;
            previous = newNode;
        }
    }

    public XByteLinkedList(XByteCollection values) {
        this(values.size());
        this.addAll(values);
    }

    public static XByteLinkedList newInstance() {
        return new XByteLinkedList();
    }

    @Override
    public final boolean add(byte value) {
        this.addLast(value);
        return true;
    }

    @Override
    public final byte get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return this.nodeAt(index)._value;
    }

    @Override
    public final byte set(int index, byte value) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        ByteNode node = this.nodeAt(index);
        byte previousValue = node._value;
        node._value = value;
        return previousValue;
    }

    @Override
    public final void add(int index, byte value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.addBefore(this.nodeAt(index), value);
    }

    @Override
    public final boolean addAll(int index, XByteCollection values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        ByteNode indexNode = this.nodeAt(index);
        XByteIterator i = values.iterator();
        while (i.hasNext()) {
            this.addBefore(indexNode, i.next());
        }
        return values.size() != 0;
    }

    @Override
    public final byte remove(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        ByteNode node = this.nodeAt(index);
        byte previousValue = node._value;
        this.delete(node);
        return previousValue;
    }

    @Override
    public final int indexOf(byte value) {
        int index = 0;
        ByteNode n = this._head;
        ByteNode end = this._tail;
        while ((n = n._next) != end) {
            if (value == n._value) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(byte value) {
        int index = this.size() - 1;
        ByteNode n = this._tail;
        ByteNode end = this._head;
        while ((n = n._previous) != end) {
            if (value == n._value) {
                return index;
            }
            --index;
        }
        return -1;
    }

    @Override
    public XByteIterator iterator() {
        return this.listIterator();
    }

    @Override
    public XByteListIterator listIterator() {
        return XByteLinkedListIterator.valueOf(this, this._head._next, 0, this._size);
    }

    @Override
    public XByteListIterator listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return XByteLinkedListIterator.valueOf(this, this.nodeAt(index), index, this._size);
    }

    @Override
    public final XByteList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubList.valueOf(this, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
    }

    public final byte getFirst() {
        ByteNode node = this._head._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final byte getLast() {
        ByteNode node = this._tail._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final void addFirst(byte value) {
        this.addBefore(this._head._next, value);
    }

    public void addLast(byte value) {
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        this._tail._value = value;
        this._tail = this._tail._next;
        ++this._size;
    }

    public final byte removeFirst() {
        ByteNode first = this._head._next;
        if (first == this._tail) {
            throw new NoSuchElementException();
        }
        byte previousValue = first._value;
        this.delete(first);
        return previousValue;
    }

    public final byte removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        ByteNode last = this._tail._previous;
        byte previousValue = last._value;
        this._tail = last;
        last._value = (byte)-1;
        return previousValue;
    }

    public final void addBefore(ByteNode next, byte value) {
        ByteNode newNode;
        ByteNode tailNext;
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        if ((tailNext = (this._tail._next = (newNode = this._tail._next)._next)) != null) {
            tailNext._previous = this._tail;
        }
        ByteNode previous = next._previous;
        previous._next = newNode;
        next._previous = newNode;
        newNode._next = next;
        newNode._previous = previous;
        newNode._value = value;
        ++this._size;
    }

    private final ByteNode nodeAt(int index) {
        ByteNode node = this._head;
        int i = index;
        while (i-- >= 0) {
            node = node._next;
        }
        return node;
    }

    @Override
    public final ByteNode head() {
        return this._head;
    }

    @Override
    public final ByteNode tail() {
        return this._tail;
    }

    @Override
    public final byte valueOf(XCollection.Record record) {
        return ((ByteNode)record)._value;
    }

    @Override
    public final void delete(XCollection.Record record) {
        ByteNode node = (ByteNode)record;
        --this._size;
        node._value = (byte)-1;
        node._previous._next = node._next;
        node._next._previous = node._previous;
        ByteNode next = this._tail._next;
        node._previous = this._tail;
        node._next = next;
        this._tail._next = node;
        if (next != null) {
            next._previous = node;
        }
    }

    @Override
    public final boolean contains(byte value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        this._size = 0;
        this._tail = this._head._next;
    }

    @Override
    public XByteList unmodifiable() {
        return (XByteList)super.unmodifiable();
    }

    protected ByteNode newNode() {
        return new ByteNode();
    }

    private void increaseCapacity() {
        ByteNode newNode0 = this.newNode();
        this._tail._next = newNode0;
        newNode0._previous = this._tail;
        ByteNode newNode1 = this.newNode();
        newNode0._next = newNode1;
        newNode1._previous = newNode0;
        ByteNode newNode2 = this.newNode();
        newNode1._next = newNode2;
        newNode2._previous = newNode1;
        ByteNode newNode3 = this.newNode();
        newNode2._next = newNode3;
        newNode3._previous = newNode2;
    }

    public void reset() {
        this.clear();
    }

    private static final class XByteLinkedListIterator
    implements XByteListIterator {
        private XByteLinkedList _list;
        private ByteNode _nextNode;
        private ByteNode _currentNode;
        private int _length;
        private int _nextIndex;

        private XByteLinkedListIterator() {
        }

        public static XByteLinkedListIterator valueOf(XByteLinkedList list, ByteNode nextNode, int nextIndex, int size) {
            XByteLinkedListIterator itr = new XByteLinkedListIterator();
            itr._list = list;
            itr._nextNode = nextNode;
            itr._nextIndex = nextIndex;
            itr._length = size;
            return itr;
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        @Override
        public byte next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._currentNode._value;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public byte previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = this._nextNode._previous;
            return this._currentNode._value;
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(byte o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("add not supported");
            }
            this._list.addBefore(this._nextNode, o);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        @Override
        public void set(byte o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("set not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode._value = o;
        }

        @Override
        public void remove() {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("remove not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            if (this._nextNode == this._currentNode) {
                this._nextNode = this._nextNode._next;
            } else {
                --this._nextIndex;
            }
            this._list.delete(this._currentNode);
            this._currentNode = null;
            --this._length;
        }

        @Override
        public final XByteLinkedListIterator toFirst() {
            this._nextNode = this._list._head._next;
            this._nextIndex = 0;
            this._length = this._list._size;
            return this;
        }
    }

    private static final class SubList
    extends XByteCollectionBase
    implements XByteList {
        private XByteLinkedList _list;
        private ByteNode _head;
        private ByteNode _tail;
        private int _size;

        private SubList() {
        }

        public static SubList valueOf(XByteLinkedList list, ByteNode head, ByteNode tail, int size) {
            SubList subList = new SubList();
            subList._list = list;
            subList._head = head;
            subList._tail = tail;
            subList._size = size;
            return subList;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public XCollection.Record head() {
            return this._head;
        }

        @Override
        public XCollection.Record tail() {
            return this._tail;
        }

        @Override
        public byte valueOf(XCollection.Record record) {
            return this._list.valueOf(record);
        }

        @Override
        public void delete(XCollection.Record record) {
            this._list.delete(record);
            if (record == this._head) {
                this._head = this._head.getNext();
            } else if (record == this._tail) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
        }

        @Override
        public boolean addAll(XByteCollection values) {
            return this.addAll(this._size, values);
        }

        @Override
        public boolean addAll(int index, XByteCollection values) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            ByteNode indexNode = this.nodeAt(index);
            XByteIterator i = values.iterator();
            while (i.hasNext()) {
                this._list.addBefore(indexNode, i.next());
            }
            if (values.size() > 0) {
                if (index == 0) {
                    this._head = this._head.getPrevious();
                } else if (index == this._size) {
                    this._tail = indexNode.getPrevious();
                }
            }
            this._size += values.size();
            return values.size() != 0;
        }

        @Override
        public byte get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.nodeAt(index)._value;
        }

        @Override
        public byte set(int index, byte value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            ByteNode node = this.nodeAt(index);
            byte previousValue = node._value;
            node._value = value;
            return previousValue;
        }

        @Override
        public boolean add(byte element) {
            this.add(this._size, element);
            return true;
        }

        @Override
        public void add(int index, byte element) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            this._list.addBefore(this.nodeAt(index), element);
            if (index == 0) {
                this._head = this._head.getPrevious();
            } else if (index == this._size) {
                this._tail = this._tail.getNext();
            }
            ++this._size;
        }

        @Override
        public byte remove(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            ByteNode node = this.nodeAt(index);
            byte previousValue = node._value;
            this._list.delete(node);
            if (index == 0) {
                this._head = this._head.getNext();
            } else if (index == this._size) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
            return previousValue;
        }

        @Override
        public int indexOf(byte value) {
            int index = 0;
            ByteNode n = this._head;
            ByteNode end = this._tail;
            while ((n = n._next) != end) {
                if (value == n._value) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(byte value) {
            int index = this.size() - 1;
            ByteNode n = this._tail;
            ByteNode end = this._head;
            while ((n = n._previous) != end) {
                if (value == n._value) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        @Override
        public XByteListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public XByteListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return XByteLinkedListIterator.valueOf(this._list, this.nodeAt(index), index, this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        @Override
        public XByteList subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            SubList subList = SubList.valueOf(this._list, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
            return subList;
        }

        private final ByteNode nodeAt(int index) {
            if (index <= this._size >> 1) {
                ByteNode node = this._head;
                int i = index;
                while (i-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            ByteNode node = this._tail;
            int i = this._size - index;
            while (i-- > 0) {
                node = node._previous;
            }
            return node;
        }

        @Override
        public void clear() {
            while (this._size > 0) {
                this.remove(0);
            }
        }
    }

    public static class ByteNode
    implements XCollection.Record {
        private ByteNode _next;
        private ByteNode _previous;
        private byte _value;

        protected ByteNode() {
        }

        public final byte getValue() {
            return this._value;
        }

        @Override
        public final ByteNode getNext() {
            return this._next;
        }

        @Override
        public final ByteNode getPrevious() {
            return this._previous;
        }
    }
}

