/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.aep.messaging;

import com.neeve.aep.AepBusConnection;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.event.AepBusBindingUpEvent;
import com.neeve.config.Config;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.perf.aep.messaging.Configurer;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageView;
import com.neeve.sma.event.MessageEvent;
import com.neeve.util.UtlTime;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Receiver
implements IEventHandler {
    private static final String APP_NAME = "receiver";
    private final MessageBusDescriptor _busDescriptor;
    private final Map<String, AepEngineDescriptor.ChannelConfig> _channelsConfig;
    private final Properties _props;
    private final LatencyRecorder _latencyRecorder;

    private Receiver(MessageBusDescriptor busDescriptor, Map<String, AepEngineDescriptor.ChannelConfig> channelsConfig, Properties props) {
        this._busDescriptor = busDescriptor;
        this._channelsConfig = channelsConfig;
        this._props = props;
        this._latencyRecorder = new LatencyRecorder(Config.getValue((String)"perf.aep.sendCount", (int)10000));
    }

    private final void run() throws Exception {
        AepBusConnection connection = AepBusConnection.create((String)APP_NAME, (MessageBusDescriptor)this._busDescriptor, this._channelsConfig, (IEventHandler)this, (Properties)this._props);
        connection.open();
        Thread.sleep(Long.MAX_VALUE);
    }

    public void onEvent(Event event) {
        if (event instanceof MessageEvent) {
            MessageView message = ((MessageEvent)event).getMessageView();
            message.setReceiveTs(UtlTime.now());
            MessageLatencyManager latencyManager = (MessageLatencyManager)message.getTag(3);
            if (latencyManager != null) {
                latencyManager.update(message, MessageLatencyManager.MessagingDirection.Inbound);
            }
        } else {
            if (event instanceof AepBusBindingUpEvent) {
                ((AepBusBindingUpEvent)event).getMessageBusBinding().getLatencyManager().setUpdateListener((MessageLatencyManager.UpdateListener)this._latencyRecorder);
            }
            System.out.println("Event: " + event);
        }
    }

    public static void main(String[] args) {
        try {
            HashMap<String, AepEngineDescriptor.ChannelConfig> channelsConfig = new HashMap<String, AepEngineDescriptor.ChannelConfig>();
            Properties props = new Properties();
            MessageBusDescriptor busDescriptor = Configurer.configure(APP_NAME, true, channelsConfig, props);
            new Receiver(busDescriptor, channelsConfig, props).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final class LatencyRecorder
    implements MessageLatencyManager.UpdateListener {
        private final int _expectedMsgCount;
        private final int[] _w2rLatencies;
        private int _latencyCount;

        LatencyRecorder(int expectedMsgCount) {
            this._expectedMsgCount = expectedMsgCount;
            this._w2rLatencies = new int[this._expectedMsgCount];
        }

        private final void writeDataToFile(String filename, int[] data) {
            try {
                FileOutputStream fos = new FileOutputStream(new File(filename));
                DataOutputStream dos = new DataOutputStream(fos);
                for (int i = 0; i < data.length; ++i) {
                    dos.writeInt(i);
                    dos.writeInt(data[i]);
                }
                dos.flush();
                dos.close();
                System.out.println("wrote: " + filename + ", n-data points: " + data.length);
            }
            catch (FileNotFoundException ex_) {
                ex_.printStackTrace();
            }
            catch (IOException ex_) {
                ex_.printStackTrace();
            }
        }

        private final void writeLatencies() {
            System.out.println("Writing latencies... date/time:" + LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME));
            this.writeDataToFile("w2r.bin", this._w2rLatencies);
            System.out.println("Finished writing latencies");
        }

        public final void onUpdate(MessageBusBinding binding, MessageView view, MessageLatencyManager.MessagingDirection direction) {
            if (direction == MessageLatencyManager.MessagingDirection.Inbound) {
                this._w2rLatencies[this._latencyCount] = (int)(view.getReceiveTs() - view.getPostWireTs());
                ++this._latencyCount;
                if (this._latencyCount == this._expectedMsgCount) {
                    this.writeLatencies();
                }
            }
        }
    }
}

