/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.aep.engine.ccm;

import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.AepEventDispatcher;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.config.Config;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxNwLnkAcceptor;
import com.neeve.emx.EmxNwLnkBlockingReader;
import com.neeve.emx.EmxNwLnkConnector;
import com.neeve.emx.EmxNwLnkReader;
import com.neeve.emx.IEmxNwLnkClientEndpoint;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.event.Event;
import com.neeve.event.EventMultiplexerFreeThreadedSerialized;
import com.neeve.event.EventMultiplexerPassThrough;
import com.neeve.event.EventMultiplexerSingleThreaded;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventMultiplexer;
import com.neeve.io.IIOBufferBackedEntity;
import com.neeve.io.IOBuffer;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.perf.aep.engine.ccm.Processor;
import com.neeve.perf.serialization.rumi.protobuf.Car;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.log.RogMessageLog;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusBindingFactory;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.util.UtlProc;
import com.neeve.util.UtlThread;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;

final class Ccm {
    private static final String APP_NAME = "processor";
    private final Processor _processor;
    private final boolean _primary;
    private final long _mainAffinity;
    private final AepEngineDescriptor _engineDescriptor;
    private final StoreDescriptor _storeDescriptor;
    private final MessageBusDescriptor _busDescriptor;
    private final RogMessageLog _log;
    private final RdmaReplicator _replicator;
    private final MultiplexEventHandler _multiplexEventHandler;
    private final DispatchEventHandler _dispatchEventHandler;
    private final IEventMultiplexer _multiplexer;
    private final AepEventDispatcher _dispatcher;
    private MessageBusBinding _binding;
    private MessageChannel _channel;
    private IRogMessage _inMessage;
    private IRogMessage _outMessage;

    Ccm(Processor processor) throws Exception {
        this._processor = processor;
        this._primary = Config.getValue((String)"processor.role", (String)"Primary").equalsIgnoreCase("primary");
        this._mainAffinity = UtlThread.parseAffinityMask((String)Config.getValue((String)"processor.mainaffinity", (String)"0"));
        this._storeDescriptor = StoreDescriptor.exists((String)APP_NAME) ? StoreDescriptor.load((String)APP_NAME) : null;
        this._busDescriptor = MessageBusDescriptor.load((String)APP_NAME, (String)APP_NAME);
        this._engineDescriptor = AepEngineDescriptor.load((String)APP_NAME);
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory("com.neeve.perf.aep.messages.MessageFactory");
        StoreObjectFactoryRegistry.getInstance().registerObjectFactory("com.neeve.perf.aep.messages.MessageFactory");
        if (this._storeDescriptor != null && this._storeDescriptor.getPersister() != null) {
            this._log = RogMessageLog.create((String)"recovery", (Properties)StorePersisterDescriptor.load((String)this._storeDescriptor.getPersister()).getProperties());
            this._log.open();
        } else {
            this._log = null;
        }
        this._replicator = this._storeDescriptor != null && this._storeDescriptor.getReplicator() != null ? new RdmaReplicator(StoreReplicatorDescriptor.load((String)this._storeDescriptor.getReplicator())) : null;
        this._dispatcher = AepEventDispatcher.create(new HashSet<Object>(Arrays.asList(this)), null);
        this._multiplexEventHandler = new MultiplexEventHandler();
        this._dispatchEventHandler = new DispatchEventHandler();
        System.out.println("Multiplexer type is '" + this._engineDescriptor.getEventMultiplexerType() + "'.");
        switch (this._engineDescriptor.getEventMultiplexerType()) {
            case FreeThreadedSerialized: {
                this._multiplexer = EventMultiplexerFreeThreadedSerialized.create((String)this._engineDescriptor.getName(), (boolean)this._engineDescriptor.getAdministrative(), (IEventHandler)this._dispatchEventHandler, (Properties)this._engineDescriptor.getEventMultiplexerProperties());
                break;
            }
            case DedicatedThreaded: {
                this._multiplexer = EventMultiplexerSingleThreaded.create((String)this._engineDescriptor.getName(), (boolean)this._engineDescriptor.getAdministrative(), (IEventHandler)this._dispatchEventHandler, (Properties)this._engineDescriptor.getEventMultiplexerProperties());
                break;
            }
            default: {
                this._multiplexer = EventMultiplexerPassThrough.create((String)this._engineDescriptor.getName(), (boolean)this._engineDescriptor.getAdministrative(), (IEventHandler)this._dispatchEventHandler, (Properties)this._engineDescriptor.getEventMultiplexerProperties());
            }
        }
        this._multiplexer.open();
    }

    private final void checkAndStartMessaging() {
        try {
            if (this._primary) {
                System.out.println("Starting messaging...");
                this._binding = MessageBusBindingFactory.getInstance().createBinding(APP_NAME, this._busDescriptor, (IEventHandler)this._multiplexEventHandler);
                this._channel = this._binding.getMessageChannel("client");
                this._channel.join(0);
                this._binding.start();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private final void commit() throws Exception {
        try {
            if (this._log != null) {
                this._log.log(this._inMessage, true, true);
            }
            if (this._primary) {
                if (this._replicator != null) {
                    this._replicator.replicate(this._inMessage);
                }
                if (this._outMessage != null) {
                    this._outMessage.setPostWireTs(this._inMessage.getPostWireTs());
                    this._channel.sendMessage((MessageView)this._outMessage, 62);
                }
            }
        }
        finally {
            if (this._outMessage != null) {
                this._outMessage.dispose();
            }
            this._outMessage = null;
            this._inMessage = null;
        }
    }

    @EventHandler
    public final void onMessage(Car inMessage) {
        try {
            this._inMessage = inMessage;
            this._processor.handleMessage(inMessage);
            this.commit();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    final void run() throws Exception {
        UtlThread.setCPUAffinityMask((long)this._mainAffinity);
        System.out.println("PID is " + UtlProc.getPid());
        System.out.println("Persistence is " + (this._log != null ? "ON" : "OFF"));
        System.out.println("Replication is " + (this._replicator != null ? "ON (" + this._replicator.descriptor() + ")" : "OFF"));
        System.out.println("Press any key to continue...");
        System.in.read();
        if (this._replicator != null) {
            this._replicator.open(this._primary);
        }
        this.checkAndStartMessaging();
        Thread.sleep(Long.MAX_VALUE);
    }

    final void sendMessage(IRogMessage message) {
        this._outMessage = message;
    }

    private final class DispatchEventHandler
    implements IEventHandler {
        private DispatchEventHandler() {
        }

        public final void onEvent(Event event) {
            Ccm.this._dispatcher.onEvent(event);
        }
    }

    private final class MultiplexEventHandler
    implements IEventHandler {
        private MultiplexEventHandler() {
        }

        public final void onEvent(Event event) {
            Ccm.this._multiplexer.multiplexEvent(event, 0);
        }
    }

    private final class RdmaReplicator
    extends Replicator
    implements IEmxNwLnkPeerEndpoint.IDataReceiver {
        private IEmxNwLnkClientEndpoint _cep;
        private IEmxNwLnkServerEndpoint _sep;
        private IEmxNwLnkPeerEndpoint _pep;

        RdmaReplicator(StoreReplicatorDescriptor descriptor) {
            this._descriptor = "rdma://" + descriptor.getProperty("localIfAddr") + ":" + descriptor.getProperty("localPort", "0");
        }

        private final void connect() throws Exception {
            this._cep = EmxFactory.getInstance().createNwLnkClientEndpoint(EmxFactory.EmxImpl.UCX, this._descriptor, null);
            this._pep = this._cep.connect();
        }

        private final void accept() throws Exception {
            this._sep = EmxFactory.getInstance().createNwLnkServerEndpoint(EmxFactory.EmxImpl.UCX, this._descriptor, null);
            this._pep = this._sep.accept();
        }

        final void open(boolean primary) throws Exception {
            if (primary) {
                this.connect();
            } else {
                this.accept();
                this._pep.read((IEmxNwLnkPeerEndpoint.IDataReceiver)this);
            }
        }

        final void replicate(IRogMessage message) throws Exception {
            IIOBufferBackedEntity bbe = (IIOBufferBackedEntity)message;
            this._pep.write(bbe.getSerializedBuffer(), 0, bbe.getSerializedBufferLength());
        }

        public final void onData(long addr, int offset, int len) {
        }
    }

    private final class SocketReplicator
    extends Replicator {
        private EmxNwLnk _link;

        SocketReplicator(StoreReplicatorDescriptor descriptor) {
            this._descriptor = "tcp://" + descriptor.getProperty("localIfAddr") + ":" + descriptor.getProperty("localPort", "0");
        }

        private final EmxNwLnk prepare(EmxNwLnk link) throws Exception {
            link.setReadBuffer(IOBuffer.create((int)8192), 0);
            link.configureBlockingRead(true);
            link.configureBlockingWrite(true);
            return link;
        }

        private final void connect() throws Exception {
            this._link = this.prepare(EmxNwLnkConnector.create((String)this._descriptor).connect());
        }

        private final void accept() throws Exception {
            this._link = this.prepare(EmxNwLnkAcceptor.create((String)this._descriptor, (EmxNwLnkAcceptor.Callback)new AcceptCallback()).accept());
        }

        private final void startRead() throws Exception {
            new Thread((Runnable)EmxNwLnkBlockingReader.create((EmxNwLnk)this._link, (EmxNwLnkReader.Callback)new ReadCallback())).start();
        }

        final void open(boolean primary) throws Exception {
            if (primary) {
                this.connect();
            } else {
                this.accept();
                this.startRead();
            }
        }

        final void replicate(IIOBufferBackedEntity message) throws Exception {
            this._link.write(message.getSerializedBuffer(), 0, message.getSerializedBufferLength());
        }

        private final class ReadCallback
        implements EmxNwLnkReader.Callback {
            private ReadCallback() {
            }

            public final int handleReadData(EmxNwLnk link, IOBuffer iobuf, int length) {
                return length;
            }

            public final void handleLinkClosure(EmxNwLnk lnk) {
                System.out.println("Link closed by peer");
            }

            public final void handleLinkFailure(EmxNwLnk lnk, Throwable cause) {
                cause.printStackTrace();
            }
        }

        private final class AcceptCallback
        implements EmxNwLnkAcceptor.Callback {
            private AcceptCallback() {
            }

            public final void handleAcceptedLink(EmxNwLnk link) {
            }

            public final void handleAcceptorFailure(Throwable cause) {
            }
        }
    }

    private abstract class Replicator {
        protected String _descriptor;

        private Replicator() {
        }

        final String descriptor() {
            return this._descriptor;
        }
    }
}

