/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.aep.messaging;

import com.neeve.aep.AepBusConnection;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.event.AepBusBindingUpEvent;
import com.neeve.config.Config;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.perf.aep.messaging.Configurer;
import com.neeve.perf.serialization.MessageFactory;
import com.neeve.rog.IRogMessage;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageView;
import com.neeve.util.UtlGovernor;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Sender
implements IEventHandler {
    private static final String APP_NAME = "sender";
    private final int _keyCount = Config.getValue((String)"perf.aep.keyCount", (int)1000);
    private final int _sendCount = Config.getValue((String)"perf.aep.sendCount", (int)10000);
    private final int _sendRate = Config.getValue((String)"perf.aep.sendRate", (int)1000);
    private final LatencyRecorder _latencyRecorder = new LatencyRecorder(this._sendCount);

    private Sender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendMessages(AepBusConnection connection) throws Exception {
        System.out.println("Sending " + this._sendCount + " messages at " + this._sendRate + "/sec");
        MessageFactory messageFactory = new MessageFactory("rumi.protobuf");
        UtlGovernor sendGoverner = new UtlGovernor(this._sendRate);
        int sent = 0;
        while (sent++ < this._sendCount) {
            IRogMessage message = (IRogMessage)messageFactory.createCar(false);
            try {
                long pre = System.nanoTime();
                connection.send(connection.getChannel("messages"), message, 0);
                this._latencyRecorder.updateS((int)(System.nanoTime() - pre));
                if (sent % 10000 == 0) {
                    System.out.println("Sent " + sent + " messages");
                }
            }
            finally {
                message.dispose();
            }
            sendGoverner.blockToNext();
        }
        this._latencyRecorder.writeLatencies();
    }

    private final void run(MessageBusDescriptor busDescriptor, Map<String, AepEngineDescriptor.ChannelConfig> channelsConfig, Properties props) throws Exception {
        AepBusConnection connection = AepBusConnection.create((String)APP_NAME, (MessageBusDescriptor)busDescriptor, channelsConfig, (IEventHandler)this, (Properties)props);
        connection.open();
        this.sendMessages(connection);
    }

    public void onEvent(Event event) {
        if (event instanceof AepBusBindingUpEvent) {
            ((AepBusBindingUpEvent)event).getMessageBusBinding().getLatencyManager().setUpdateListener((MessageLatencyManager.UpdateListener)this._latencyRecorder);
        }
        System.out.println("Event: " + event);
    }

    public static final void main(String[] args) {
        try {
            HashMap<String, AepEngineDescriptor.ChannelConfig> channelsConfig = new HashMap<String, AepEngineDescriptor.ChannelConfig>();
            Properties props = new Properties();
            MessageBusDescriptor busDescriptor = Configurer.configure(APP_NAME, false, channelsConfig, props);
            new Sender().run(busDescriptor, channelsConfig, props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final class LatencyRecorder
    implements MessageLatencyManager.UpdateListener {
        private final int _expectedMsgCount;
        private final int[] _c2wLatencies;
        private final int[] _wLatencies;
        private final int[] _sLatencies;
        private int _latencyCount;

        LatencyRecorder(int expectedMsgCount) {
            this._expectedMsgCount = expectedMsgCount;
            this._c2wLatencies = new int[this._expectedMsgCount];
            this._wLatencies = new int[this._expectedMsgCount];
            this._sLatencies = new int[this._expectedMsgCount];
        }

        private final void writeDataToFile(String filename, int[] data) {
            try {
                FileOutputStream fos = new FileOutputStream(new File(filename));
                DataOutputStream dos = new DataOutputStream(fos);
                for (int i = 0; i < data.length; ++i) {
                    dos.writeInt(i);
                    dos.writeInt(data[i]);
                }
                dos.flush();
                dos.close();
                System.out.println("wrote: " + filename + ", n-data points: " + data.length);
            }
            catch (FileNotFoundException ex_) {
                ex_.printStackTrace();
            }
            catch (IOException ex_) {
                ex_.printStackTrace();
            }
        }

        final void updateS(int val) {
            this._sLatencies[this._latencyCount++] = val;
        }

        public final void onUpdate(MessageBusBinding binding, MessageView view, MessageLatencyManager.MessagingDirection direction) {
            if (direction == MessageLatencyManager.MessagingDirection.Outbound) {
                this._c2wLatencies[this._latencyCount] = (int)(view.getPreWireTs() - view.getCreateTs());
                this._wLatencies[this._latencyCount] = (int)(view.getPostWireSendTs() - view.getPreWireTs());
            }
        }

        public void writeLatencies() {
            System.out.println("Writing latencies... date/time:" + LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME));
            this.writeDataToFile("c2w.bin", this._c2wLatencies);
            this.writeDataToFile("w.bin", this._wLatencies);
            this.writeDataToFile("s.bin", this._sLatencies);
            System.out.println("Finished writing latencies");
        }
    }
}

