/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.tools.AbstractCommand;
import com.neeve.tools.CloudCommand;
import com.neeve.tools.HeartbeatsDumpCommand;
import com.neeve.tools.QuickstartCommand;
import com.neeve.tools.TltCommand;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CliMain {
    private static final Set<String> topLevelCommands = Stream.of("help", "quickstart", "cloud", "tlt", "hbdump").collect(Collectors.toCollection(HashSet::new));

    private static final void printTopLevelUsage() {
        System.out.println("");
        System.out.println("      Rumi -- Compute, Say Hello to Data");
        System.out.println("");
        System.out.println("      Rumi CLI is Rumi's command line tool. Try:");
        System.out.println("");
        System.out.println("      rumi help commands        list the top level commands");
        System.out.println("      rumi help <command>       help on a specific command");
        System.out.println("");
    }

    private static final void printTopLevelCommands() {
        System.out.println("");
        System.out.println("      Rumi CLI commands:");
        System.out.println("");
        System.out.println("         quickstart Commands to generate Rumi quickstart applications");
        System.out.println("         cloud      Commands related to operations that provision Rumi in IaaS cloud providers");
        System.out.println("         tlt        Runs the Rumi Transaction Log Tool");
        System.out.println("         hbdump     Runs the Rumi Heartbeats Dump Tool");
        System.out.println("");
        System.out.println("      Run 'rumi help <command>' for help on a specific command");
        System.out.println("");
    }

    private static final AbstractCommand commandHandler(String command) {
        if (command.equals("quickstart")) {
            return new QuickstartCommand();
        }
        if (command.equals("cloud")) {
            return new CloudCommand();
        }
        if (command.equals("tlt")) {
            return new TltCommand();
        }
        if (command.equals("hbdump")) {
            return new HeartbeatsDumpCommand();
        }
        throw new IllegalArgumentException("unknown command '" + command + "'");
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            String topLevelCommand = args[0].toLowerCase();
            if (topLevelCommands.contains(topLevelCommand)) {
                if (topLevelCommand.equals("help")) {
                    if (args.length > 1) {
                        String command = args[1].toLowerCase();
                        if (command.equals("commands")) {
                            CliMain.printTopLevelCommands();
                        } else if (topLevelCommands.contains(command)) {
                            CliMain.commandHandler(command).help(args.length > 2 ? Arrays.copyOfRange(args, 2, args.length) : new String[]{});
                        } else {
                            System.out.println("No help for '" + command + "'.");
                        }
                    } else {
                        CliMain.printTopLevelUsage();
                    }
                } else {
                    try {
                        CliMain.commandHandler(topLevelCommand).execute(args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        System.out.println("");
                        System.out.println("**** " + (e.getMessage() != null ? e.getMessage() : e.toString()));
                        System.out.println("");
                    }
                }
            } else {
                CliMain.printTopLevelUsage();
            }
        } else {
            CliMain.printTopLevelUsage();
        }
    }
}

