/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.util;

import com.neeve.trace.Tracer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;

public class Helper {
    private static final int SERVER_REACHABILITY_TIMEOUT = 600;

    public static final void copyResourceToFile(String resourcePath, String destinationPath) {
        ClassLoader classLoader = Helper.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(resourcePath);){
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found: " + resourcePath);
            }
            Path destination = Paths.get(destinationPath, new String[0]);
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
            try (FileOutputStream outputStream = new FileOutputStream(destination.toFile());){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy resource '" + resourcePath + "' to file '" + destinationPath + "'", e);
        }
    }

    /*
     * Exception decompiling
     */
    public static final String readResourceFile(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean isPortOpen(String ip, int port, int timeoutMillis) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(ip, port), timeoutMillis);
            try {
                socket.close();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            boolean bl = true;
            return bl;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static final boolean waitForServerToBeReachable(String ip, int timeoutSeconds, int port, Tracer tracer) {
        int intervalMillis = 5000;
        long timeoutMillis = timeoutSeconds * 1000;
        long startTime = System.currentTimeMillis();
        boolean success = false;
        while (!success && System.currentTimeMillis() - startTime < timeoutMillis) {
            if (Helper.isPortOpen(ip, port, 2000)) {
                success = true;
            }
            if (!success) {
                tracer.log("Waiting for instance to be reachable on port " + port + ".", Tracer.Level.VERBOSE);
            }
            try {
                Thread.sleep(intervalMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        if (!success) {
            tracer.log("Server '" + ip + "' is not reachable.", Tracer.Level.VERBOSE);
        }
        return success;
    }

    public static final void executeCommand(String op, ProcessBuilder pb, Tracer tracer) {
        try {
            String line;
            pb.redirectErrorStream(true);
            Process process = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                tracer.log(line, Tracer.Level.VERBOSE);
            }
            while (true) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            if (process.exitValue() != 0) {
                throw new RuntimeException(op + " failed [exit code '" + process.exitValue() + "']");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final void copyPrivateKeyToServer(String serverPublicIP, String keyPair, Tracer tracer) {
        tracer.log("Copying key to server.", Tracer.Level.VERBOSE);
        if (!Helper.waitForServerToBeReachable(serverPublicIP, 600, 22, tracer)) {
            throw new IllegalStateException("server not reachable via public IP '" + serverPublicIP + "'");
        }
        String homeDirectory = System.getProperty("user.home");
        ProcessBuilder pb = new ProcessBuilder("scp", "-i", homeDirectory + "/.ssh/" + keyPair, "-o", "StrictHostKeyChecking=no", "-o", "UserKnownHostsFile=/dev/null", homeDirectory + "/.ssh/" + keyPair, "rumi@" + serverPublicIP + ":/home/rumi/.ssh/rumi");
        Helper.executeCommand("Key copy", pb, tracer);
    }

    public static final void copyFileToServer(String serverPublicIP, String keyPair, String sourceFile, String targetDir, String targetFilePermission, boolean checkServerReachability, Tracer tracer) {
        if (!checkServerReachability || Helper.waitForServerToBeReachable(serverPublicIP, 600, 22, tracer)) {
            String homeDirectory = System.getProperty("user.home");
            ProcessBuilder pb = new ProcessBuilder("scp", "-i", homeDirectory + "/.ssh/" + keyPair, "-o", "StrictHostKeyChecking=no", "-o", "UserKnownHostsFile=/dev/null", sourceFile, "rumi@" + serverPublicIP + ":" + targetDir);
            Helper.executeCommand("Copy file", pb, tracer);
            if (targetFilePermission != null) {
                pb = new ProcessBuilder("ssh", "-i", homeDirectory + "/.ssh/" + keyPair, "-o", "StrictHostKeyChecking=no", "-o", "UserKnownHostsFile=/dev/null", "rumi@" + serverPublicIP, "bash", "-c", "\"chmod", targetFilePermission, targetDir + File.separator + new File(sourceFile).getName() + "\"");
                Helper.executeCommand("Set file permission", pb, tracer);
            }
        } else {
            throw new IllegalStateException("server not reachable via public IP '" + serverPublicIP + "'");
        }
    }

    public static final void copyFileToServer(String serverPublicIP, String keyPair, String sourceFile, String targetDir, String targetFilePermission, Tracer tracer) {
        Helper.copyFileToServer(serverPublicIP, keyPair, sourceFile, targetDir, targetFilePermission, true, tracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyScriptsToServer(String serverPublicIP, String keyPair, String[] resourcePaths, Tracer tracer) {
        if (Helper.waitForServerToBeReachable(serverPublicIP, 600, 22, tracer)) {
            for (String resourcePath : resourcePaths) {
                int slashIndex = resourcePath.lastIndexOf(File.separator);
                String resourceFilename = slashIndex == -1 ? resourcePath : resourcePath.substring(slashIndex + 1);
                String homeDirectory = System.getProperty("user.home");
                String destinationPath = homeDirectory + File.separator + ".rumi" + File.separator + "temp" + File.separator + resourceFilename;
                File destinationFile = new File(destinationPath);
                if (destinationFile.exists()) {
                    destinationFile.delete();
                }
                Helper.copyResourceToFile(resourcePath, destinationPath);
                tracer.log("Copying '" + resourceFilename + "'.", Tracer.Level.VERBOSE);
                try {
                    Helper.copyFileToServer(serverPublicIP, keyPair, destinationPath, "/home/rumi/scripts", "+x", false, tracer);
                }
                finally {
                    destinationFile.delete();
                }
            }
        } else {
            throw new IllegalStateException("server not reachable via public IP '" + serverPublicIP + "'");
        }
    }

    public static final void executeScriptOnServer(String serverPublicIP, String keyPair, String scriptFilename, String[] scriptArgs, Tracer tracer) {
        ArrayList<String> command;
        tracer.log("Running '" + scriptFilename + "' on server.", Tracer.Level.VERBOSE);
        if (Helper.waitForServerToBeReachable(serverPublicIP, 600, 22, tracer)) {
            String homeDirectory = System.getProperty("user.home");
            command = new ArrayList<String>();
            command.add("ssh");
            command.add("-i");
            command.add(homeDirectory + "/.ssh/" + keyPair);
            command.add("-o");
            command.add("StrictHostKeyChecking=no");
            command.add("-o");
            command.add("UserKnownHostsFile=/dev/null");
            command.add("rumi@" + serverPublicIP);
            command.add("bash");
            command.add("-c");
            if (scriptArgs != null) {
                command.add("\"/home/rumi/" + scriptFilename);
                for (int i = 0; i < scriptArgs.length; ++i) {
                    command.add(i < scriptArgs.length - 1 ? scriptArgs[i] : scriptArgs[i] + "\"");
                }
            } else {
                command.add("/home/rumi/" + scriptFilename);
            }
        } else {
            throw new IllegalStateException("server not reachable via public IP '" + serverPublicIP + "'");
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        Helper.executeCommand("Script execution", pb, tracer);
    }
}

