/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Command;
import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.controller.XVM;
import com.neeve.controller.XVMUnreachableException;
import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlText;
import com.neeve.util.UtlUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

final class Wait
extends Command {
    String _appName;
    XVM _xvm;
    String _command;
    private List<String> _values;
    String _args;
    long _timeout = (long)UtlUnit.convertDuration((double)1.0, (TimeUnit)TimeUnit.DAYS, (TimeUnit)TimeUnit.MILLISECONDS);
    long _pollingInterval = (long)UtlUnit.convertDuration((double)5.0, (TimeUnit)TimeUnit.SECONDS, (TimeUnit)TimeUnit.MILLISECONDS);

    Wait(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        super(controller, progressMonitorHelper, system, script, lineNum, line);
    }

    private final void syntaxError(String message, int lineNum) {
        this.error((message != null ? message + ": " : "") + "Line " + lineNum + ": Syntax error: wait [for N <timeunit>] [with N <timeunit> polls] until the <appName> app in the <xvmName> xvm {is <command> | <command> is <value> [or value2 [or valueN]]} [with <params>]}");
    }

    private final void syntaxError(int lineNum) {
        this.syntaxError(null, lineNum);
    }

    @Override
    final String name() {
        return "wait";
    }

    @Override
    final boolean parse(Command.Args tokenizer) {
        String[] remainingArgs;
        int index;
        String tok;
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        if ((tok = tokenizer.nextToken()).equals("for")) {
            String timeunit;
            if (!tokenizer.hasMoreTokens()) {
                this.syntaxError(this.lineNum());
            }
            String timeout = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                this.syntaxError(this.lineNum());
            }
            if ((timeunit = tokenizer.nextToken()).equalsIgnoreCase("with") || timeunit.equalsIgnoreCase("until")) {
                tok = timeunit;
            } else {
                timeout = timeout + " " + timeunit;
                if (!tokenizer.hasMoreTokens()) {
                    this.syntaxError(this.lineNum());
                }
                tok = tokenizer.nextToken();
            }
            this._timeout = (long)UtlUnit.parseDuration((String)timeout, (TimeUnit)TimeUnit.SECONDS, (TimeUnit)TimeUnit.MILLISECONDS);
            if (this._timeout < 1000L) {
                this.syntaxError("Minimum timeout for wait is 1 second", this.lineNum());
            }
        }
        if (tok.equals("with")) {
            if (!tokenizer.hasMoreTokens()) {
                this.syntaxError(this.lineNum());
            }
            String pollingInterval = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                this.syntaxError(this.lineNum());
            }
            pollingInterval = pollingInterval + " " + tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                this.syntaxError(this.lineNum());
            }
            if (!(tok = tokenizer.nextToken()).equals("polls")) {
                this.syntaxError(this.lineNum());
            }
            this._pollingInterval = (long)UtlUnit.parseDuration((String)pollingInterval, null, (TimeUnit)TimeUnit.MILLISECONDS);
            if (this._pollingInterval < 500L) {
                this.syntaxError("Minimum timeout for wait is 500 milliseconds but '" + pollingInterval + "' was specified", this.lineNum());
            }
            tok = tokenizer.nextToken();
        }
        if (!tok.equals("until")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        this._appName = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("app")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("in")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        String token = tokenizer.nextToken();
        this._xvm = this.system().getXVM(token);
        if (this._xvm == null) {
            this.error("Line " + this.lineNum() + ": XVM '" + token + "' is not configured in the '" + this.system().getHome().getName() + "' system");
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvm")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        if ((index = 0) == (remainingArgs = this.getRemainingArgs(tokenizer)).length) {
            this.syntaxError(this.lineNum());
        }
        if (remainingArgs[index].equalsIgnoreCase("is")) {
            if (++index == remainingArgs.length) {
                this.syntaxError(this.lineNum());
            }
            this._command = remainingArgs[index++];
        } else {
            this._command = remainingArgs[index++];
            if (index == remainingArgs.length || !remainingArgs[index++].equalsIgnoreCase("is")) {
                this.syntaxError("Expected 'is' after " + this._command, this.lineNum());
            }
            this._values = new ArrayList<String>();
            boolean expectingValue = true;
            while (index < remainingArgs.length) {
                if ("with".equalsIgnoreCase(remainingArgs[index])) {
                    if (!expectingValue) break;
                    this.syntaxError("Expected <value> before 'with'", this.lineNum());
                    break;
                }
                this._values.add(remainingArgs[index++]);
                expectingValue = false;
                if (index >= remainingArgs.length || !"or".equals(remainingArgs[index])) continue;
                expectingValue = true;
                ++index;
            }
        }
        if (index < remainingArgs.length && !"with".equalsIgnoreCase(remainingArgs[index++])) {
            this.syntaxError(this.lineNum());
        }
        if (index < remainingArgs.length) {
            StringBuilder sb = new StringBuilder();
            while (index < remainingArgs.length) {
                sb.append(UtlText.quoteAndEscape((String)remainingArgs[index++]));
                if (index >= remainingArgs.length) continue;
                sb.append(" ");
            }
            this._args = sb.toString();
        } else {
            this._args = null;
        }
        return true;
    }

    @Override
    final void execute() {
        String with;
        long start = java.lang.System.currentTimeMillis();
        long timeout = java.lang.System.currentTimeMillis() + this._timeout;
        String string = with = this._args != null ? " (with " + this._args + ")" : "";
        while (!this.mock()) {
            block13: {
                String value;
                if (this.script().aborted() || Thread.interrupted()) {
                    this.script().abortNow();
                }
                if (this._values == null) {
                    try {
                        this.info("......checking if " + this._appName + " is " + this._command + with + "...");
                        value = (String)UtlDataTypes.convert(String.class, (Object)this.remoteCommand(this._xvm.name(), this._appName, this._args == null ? this._command : this._command + " " + this._args, true, 1));
                        if (value.trim().equalsIgnoreCase("false")) {
                            this.info("......app is not '" + this._command + "' (returned false)...");
                            break block13;
                        }
                        this.info("......done.");
                        break;
                    }
                    catch (XVMUnreachableException e) {
                        if (this.isTreatUnreachableXVMAsNonFatal()) {
                            this.info("......xvm '" + this._xvm.name() + "' is unreachable. configured to ignore...");
                            break;
                        }
                        this.error("Line " + this.lineNum() + ": " + e.toString() + ".", e);
                        break block13;
                    }
                    catch (Exception e) {
                        this.info("......app is not '" + this._command + with + "' [" + e.getMessage() + "]...");
                        break block13;
                    }
                }
                this.info("......checking if " + this._appName + " " + this._command + with + "is in '" + this._values + "'...");
                try {
                    value = (String)UtlDataTypes.convert(String.class, (Object)this.remoteCommand(this._xvm.name(), this._appName, this._args == null ? this._command : this._command + " " + this._args, true, 1));
                    if (!this._values.contains(value)) {
                        this.info("......" + this._appName + " " + this._command + with + " is '" + value + "' (not one of " + this._values + "])...");
                        break block13;
                    }
                    this.info("......done.");
                }
                catch (Exception e) {
                    if (e instanceof XVMUnreachableException && this.isTreatUnreachableXVMAsNonFatal()) {
                        this.info("......xvm '" + this._xvm.name() + "' is unreachable. configured to ignore...");
                        break;
                    }
                    this.error("Line " + this.lineNum() + ": " + this._appName + " " + this._command + " returned error: [" + e.getMessage() + "].", e);
                }
                break;
            }
            long pollInterval = Math.min(this._pollingInterval, timeout - java.lang.System.currentTimeMillis());
            if (pollInterval > 0L) {
                this.sleep(pollInterval);
                continue;
            }
            this.error("Line " + this.lineNum() + ": " + this._appName + " " + this._command + " timed out after " + UtlUnit.formatDuration((double)(java.lang.System.currentTimeMillis() - start), (TimeUnit)TimeUnit.MILLISECONDS));
        }
    }

    @Override
    final void cleanup() {
    }
}

