/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.impl;

import com.neeve.config.Config;
import com.neeve.lang.XString;

public final class BuiltInChannelKeyFunctions {
    public static void hash(XString messageKey, XString value, XString partitions) {
        if (value == null || value.isNull() || value.length() == 0) {
            throw new IllegalArgumentException("'value' cannot be null or empty string.");
        }
        if (partitions.getValueAsLong() < 1L) {
            throw new IllegalArgumentException("'partitions' must be positive integer.");
        }
        messageKey.append((long)Math.abs(value.hashCode()) % partitions.getValueAsLong() + 1L);
    }

    public static void concat(XString messageKey, XString value1, XString value2) {
        if (value1 == null || value1.isNull()) {
            throw new IllegalArgumentException("'value1' cannot be null");
        }
        if (value2 == null || value2.isNull()) {
            throw new IllegalArgumentException("'value2' cannot be null");
        }
        messageKey.append(value1);
        messageKey.append(value2);
    }

    public static void env(XString messageKey, XString propertyName) {
        if (propertyName == null || propertyName.isNull()) {
            throw new IllegalArgumentException("'key' cannot be null");
        }
        String value = Config.getValue((String)propertyName.getValue(), (String)null);
        if (value != null) {
            messageKey.append((CharSequence)value);
        }
    }

    public static void env(XString messageKey, XString propertyName, XString defaultValue) {
        if (defaultValue == null || defaultValue.isNull()) {
            BuiltInChannelKeyFunctions.env(messageKey, propertyName);
            return;
        }
        if (propertyName == null || propertyName.isNull()) {
            throw new IllegalArgumentException("'key' cannot be null");
        }
        messageKey.append((CharSequence)Config.getValue((String)propertyName.getValue(), (String)defaultValue.getValue()));
    }
}

