/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XDoubleIterator;
import java.util.NoSuchElementException;

public final class XDoubleSequence
implements XDoubleIterator {
    private static final byte FLG_INITIALIZED = 1;
    private static final byte FLG_OWNED = 2;
    private byte _flags;
    private long _addr;
    private int _offset;
    private int _nelem;
    private int _index;

    private XDoubleSequence() {
    }

    public static final XDoubleSequence create() {
        return new XDoubleSequence();
    }

    private final XDoubleSequence setInitialized(boolean val) {
        this._flags = val ? (byte)(this._flags | 1) : (byte)(this._flags & 0xFFFFFFFE);
        return this;
    }

    public final boolean isInitialized() {
        return (this._flags & 1) != 0;
    }

    private final XDoubleSequence setOwned(boolean val) {
        this._flags = val ? (byte)(this._flags | 2) : (byte)(this._flags & 0xFFFFFFFD);
        return this;
    }

    public final boolean isOwned() {
        return (this._flags & 2) != 0;
    }

    @Override
    public XDoubleIterator toFirst() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        this._index = 0;
        return this;
    }

    @Override
    public final boolean hasNext() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._index < this._nelem;
    }

    @Override
    public final double next() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        if (this._index == this._nelem) {
            throw new NoSuchElementException("no more elements");
        }
        return IOBuffer.getDouble(this._addr, this._offset + this._index++ * 8);
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public final XDoubleSequence wrap(long addr, int offset, int len) {
        this.reset();
        this._addr = addr;
        this._offset = offset;
        this._nelem = len / 8;
        this._index = 0;
        this.setInitialized(true).setOwned(false);
        return this;
    }

    public final XDoubleSequence wrap(IOBuffer buffer, int offset, int len) {
        return this.wrap(buffer.getNativeAddress(), offset, len);
    }

    public final XDoubleSequence setFrom(long addr, int offset, int len) {
        this.reset();
        this._addr = IOBuffer.allocateMemoryBlock(len, false);
        IOBuffer.copy(addr, offset, this._addr, 0, len);
        this._nelem = len / 8;
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final XDoubleSequence setFrom(IOBuffer buffer, int offset, int len) {
        this.reset();
        this._addr = IOBuffer.allocateMemoryBlock(len, false);
        IOBuffer.copy(buffer.getNativeAddress(), offset, this._addr, 0, len);
        this._nelem = len / 8;
        this._offset = 0;
        this._index = 0;
        this.setInitialized(true).setOwned(true);
        return this;
    }

    public final XDoubleSequence setFrom(XDoubleSequence sequence) {
        this.reset();
        if (sequence.isInitialized()) {
            int serializedLength = sequence.serializedLength();
            this._addr = IOBuffer.allocateMemoryBlock(serializedLength, false);
            IOBuffer.copy(sequence._addr, sequence._offset, this._addr, 0, serializedLength);
            this._nelem = sequence.numElements();
            this._offset = 0;
            this._index = 0;
            this.setInitialized(true).setOwned(true);
        }
        return this;
    }

    public final XDoubleSequence setFrom(XDoubleIterator iterator) {
        this.reset();
        if (iterator instanceof XDoubleSequence) {
            return this.setFrom((XDoubleSequence)iterator);
        }
        throw new IllegalArgumentException("iterator implementations other than XDoubleSequence are not currently supported");
    }

    public final int numElements() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._nelem;
    }

    public final int serializedLength() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this._nelem * 8;
    }

    public final int getTo(double[] val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        IOBuffer.getTo(this._addr, this._offset, val, offset, this._nelem);
        return this.serializedLength();
    }

    public final int getTo(byte[] val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        int serializedLength = this.serializedLength();
        IOBuffer.getTo(this._addr, this._offset, val, offset, serializedLength);
        return serializedLength;
    }

    public final int getTo(long addr, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        int serializedLength = this.serializedLength();
        IOBuffer.copy(this._addr, this._offset, addr, offset, serializedLength);
        return serializedLength;
    }

    public final int getTo(IOBuffer val, int offset) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        int serializedLength = this.serializedLength();
        val.putFrom(offset, this._addr, this._offset, serializedLength);
        return serializedLength;
    }

    public final XDoubleIterator iterator() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sequence not initialized. use wrap() or setFrom() to initialize the sequence");
        }
        return this.toFirst();
    }

    public final XDoubleSequence reset() {
        if (this.isInitialized()) {
            if (this.isOwned() && this._addr != 0L) {
                IOBuffer.freeMemoryBlock(this._addr, this.serializedLength());
            }
            this.setInitialized(false);
        }
        return this;
    }
}

