/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxTimeoutException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkSTRContainer;
import com.neeve.tools.interactive.InteractiveTool;
import com.neeve.tools.interactive.commands.Accept;
import com.neeve.tools.interactive.commands.Close;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.tools.interactive.commands.Connect;
import com.neeve.tools.interactive.commands.EnqueData;
import com.neeve.tools.interactive.commands.EnqueType;
import com.neeve.tools.interactive.commands.Flush;
import com.neeve.tools.interactive.commands.Join;
import com.neeve.tools.interactive.commands.Leave;
import com.neeve.tools.interactive.commands.Links;
import com.neeve.tools.interactive.commands.StartRead;
import com.neeve.tools.interactive.commands.StartStats;
import com.neeve.tools.interactive.commands.Stats;
import com.neeve.tools.interactive.commands.StopRead;
import com.neeve.tools.interactive.commands.StopStats;

public class LinkTool
extends LnkSTRContainer {
    private final ILnkEventHandler eventHandler;
    protected final InteractiveTool interactiveTool = new InteractiveTool();

    protected LinkTool() throws Exception {
        super(null, "linktool", EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, "linktool", null), 0);
        this.eventHandler = new LinkEventHandler();
        this.interactiveTool.registerCommand((Command)new Links(this));
        this.interactiveTool.registerCommand((Command)new Connect(this, new Links(this), new Join(this, this.eventHandler)));
        this.interactiveTool.registerCommand((Command)new Accept(this, new Links(this), new Join(this, this.eventHandler)));
        this.interactiveTool.registerCommand((Command)new Join(this, this.eventHandler));
        this.interactiveTool.registerCommand((Command)new Leave(this));
        this.interactiveTool.registerCommand((Command)new StartRead(this));
        this.interactiveTool.registerCommand((Command)new StopRead(this));
        this.interactiveTool.registerCommand((Command)new EnqueType(this));
        this.interactiveTool.registerCommand((Command)new EnqueData(this));
        this.interactiveTool.registerCommand((Command)new Flush(this));
        this.interactiveTool.registerCommand((Command)new Close(this, new Links(this)));
        this.interactiveTool.registerCommand((Command)new Stats());
        this.interactiveTool.registerCommand((Command)new StartStats());
        this.interactiveTool.registerCommand((Command)new StopStats());
        this.interactiveTool.registerCommand((Command)new Run());
    }

    protected final void run() throws Exception {
        Thread.currentThread().setName("LinkTool Main");
        this.interactiveTool.run();
    }

    public static void main(String[] args) {
        try {
            new LinkTool().run();
        }
        catch (Throwable e) {
            System.out.println("Unhandled fault [" + e + ", " + e.toString() + "]");
            e.printStackTrace();
        }
    }

    private final class LinkEventHandler
    implements ILnkEventHandler {
        private LinkEventHandler() {
        }

        @Override
        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
            System.out.println("LINK EVENT\n{\n type=" + type + "\n data=" + data + "\n source='" + ((ILnkPeerEndpoint)ep).getName() + "'\n}");
        }
    }

    private final class Run
    extends Command {
        private Run() {
        }

        private void processRun(int timeout) {
            System.out.println("Running [" + timeout + "ms]...");
            try {
                LinkTool.this.getReader().run(timeout, null);
            }
            catch (EEmxTimeoutException eEmxTimeoutException) {
            }
            catch (EEmxException eEmxException) {
                // empty catch block
            }
            System.out.println("Done.");
        }

        public final void run(String[] args) {
            if (args.length != 1) {
                System.out.println("Syntax error: run <timeout>");
            } else {
                this.processRun(Integer.parseInt(args[0]));
            }
        }

        public final void help() {
            System.out.println("run <timeout>");
            System.out.println("  Run the dispatcher for a specified amount of time (in milliseconds)");
        }

        public final String[] keywords() {
            return new String[]{"run"};
        }
    }
}

