/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxDispatcherRunCompletionChecker;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ELnkRequestInvalidStateException;
import com.neeve.link.LnkSender;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderRR;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;

public final class LnkRequest {
    private final LnkSender sender;
    private final Result result;
    private final CompletionChecker completionChecker;
    private final Tracer tracer;
    private long corrid;
    private volatile PktPacket packet;
    private IEmxDispatcher dispatcher;
    private boolean waiting;
    private volatile State state;

    LnkRequest(LnkSender sender, PktPacket packet, Tracer tracer) {
        this.sender = sender;
        this.result = new Result();
        this.completionChecker = new CompletionChecker();
        this.tracer = tracer;
        this.state = State.CREATED;
        if (packet != null) {
            try {
                this.init(packet);
            }
            catch (ELnkRequestInvalidStateException e) {
                throw new InternalError("Received invalid state exception when request object was initialized from constructor!");
            }
        }
    }

    private final long prepareRequestPacket(PktPacket packet) {
        PktSubheaderRR subheaderRR = packet.getHeader().activateRRSubheader(false);
        subheaderRR.setCorrelationId(this.sender.getLink().getNextSequenceNum());
        subheaderRR.setRequest(0L);
        return subheaderRR.getCorrelationId();
    }

    final IEmxDispatcherRunCompletionChecker getCompletionChecker() {
        return this.completionChecker;
    }

    final IEmxDispatcher getDispatcher() {
        return this.dispatcher;
    }

    final void setActive(IEmxDispatcher dispatcher, boolean waiting) throws ELnkRequestInvalidStateException {
        if (this.state != State.INITIALIZED) {
            throw new ELnkRequestInvalidStateException("set active", this.state.toString());
        }
        this.dispatcher = dispatcher;
        this.waiting = waiting;
        this.state = State.ACTIVE;
    }

    final void onReply(PktPacket packet) {
        this.result.replies.append((UtlListElement)packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean onComplete(IEmxDispatcher dispatcher, Exception e) {
        this.state = State.COMPLETE;
        if (this.tracer.debug) {
            this.tracer.log("Request complete [" + (e == null ? "null" : e.toString()) + "]", Tracer.Level.DEBUG);
        }
        this.result.e = e != null ? (e instanceof ELnkOpFailedException ? (ELnkOpFailedException)((Object)e) : new ELnkOpFailedException(e)) : null;
        if (this.waiting) {
            if (this.tracer.debug) {
                this.tracer.log("Sender is waiting. Waking up sender...", Tracer.Level.DEBUG);
            }
            if (this.dispatcher != dispatcher) {
                if (this.dispatcher != null) {
                    if (this.tracer.debug) {
                        this.tracer.log("Sender waiting on dispatcher. Posting user event to wake up.", Tracer.Level.DEBUG);
                    }
                    IEmxUserEvent event = EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, null);
                    this.dispatcher.schedUserEv(event);
                } else {
                    if (this.tracer.debug) {
                        this.tracer.log("Sender waiting on notify. Notifying to wake up.", Tracer.Level.DEBUG);
                    }
                    LnkRequest lnkRequest = this;
                    synchronized (lnkRequest) {
                        this.notify();
                    }
                }
            } else if (this.tracer.debug) {
                this.tracer.log("Sender same as receiver.", Tracer.Level.DEBUG);
            }
            return true;
        }
        if (this.tracer.debug) {
            this.tracer.log("Sender is not waiting.", Tracer.Level.DEBUG);
        }
        return false;
    }

    public final LnkRequest init(PktPacket packet) throws ELnkRequestInvalidStateException {
        if (this.state != State.ACTIVE) {
            this.corrid = this.prepareRequestPacket(packet);
            this.packet = packet;
            this.result.reset();
            this.state = State.INITIALIZED;
            return this;
        }
        throw new ELnkRequestInvalidStateException("initialize request", this.state.toString());
    }

    public final long getCorrelationId() {
        return this.corrid;
    }

    public final PktPacket getPacket() {
        return this.packet;
    }

    public final void detachPacket() {
        if (this.state == State.INITIALIZED) {
            throw new ELnkRequestInvalidStateException("detach packet", this.state.toString());
        }
        this.packet = null;
    }

    public final Result getResult() {
        return this.result;
    }

    public final State getState() {
        return this.state;
    }

    private final class CompletionChecker
    implements IEmxDispatcherRunCompletionChecker {
        private CompletionChecker() {
        }

        @Override
        public final boolean isDone() {
            return LnkRequest.this.getState() == State.COMPLETE;
        }

        @Override
        public final Object getCompletion() throws Exception {
            Result result = LnkRequest.this.getResult();
            if (result.e != null) {
                throw result.e;
            }
            return result.replies;
        }
    }

    public final class Result {
        int replyCount;
        UtlList replies = UtlList.create();
        ELnkOpFailedException e;

        Result() {
            this.reset();
        }

        final void reset() {
            this.replies.clear();
            this.replyCount = -1;
            this.e = null;
        }

        public final ELnkOpFailedException getStatus() {
            return this.e;
        }

        public final int getReplyCount() {
            return this.replyCount;
        }

        public final UtlList getReplies() {
            return this.replies;
        }
    }

    public static enum State {
        CREATED,
        INITIALIZED,
        ACTIVE,
        COMPLETE;

    }
}

