/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxObject;
import com.neeve.emx.IEmxAction;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThrowable;

public final class EmxActionExecutor<E, V>
extends EmxObject {
    public static final int FLG_SYNC = 1;
    private final ITCTEventHandler<E, V> itctEventHandler;

    public EmxActionExecutor() {
        this.itctEventHandler = new ITCTEventHandler(this.tracer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V invoke(IEmxDispatcher dispatcher, IEmxAction<E, V> action, E object, int flags) throws Exception {
        boolean sync;
        boolean bl = sync = (flags & 1) == 1;
        if (dispatcher.getOwner() == Thread.currentThread() && sync) {
            return action.execute(dispatcher, object);
        }
        ITCTContext<E, V> context = new ITCTContext<E, V>(action, object, sync);
        IEmxUserEvent userEvent = (IEmxUserEvent)EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, this.itctEventHandler).setAttachment(context);
        dispatcher.schedUserEv(userEvent);
        if (context.sync) {
            ITCTContext<E, V> iTCTContext = context;
            synchronized (iTCTContext) {
                while (!context.complete) {
                    try {
                        context.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (context.e != null) {
                throw context.e;
            }
            return context.response;
        }
        return null;
    }

    private static final class ITCTEventHandler<E, V>
    implements IEmxEventHandler {
        private final Tracer tracer;

        public ITCTEventHandler(Tracer tracer) {
            this.tracer = tracer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            ITCTContext context = (ITCTContext)event.getAttachment();
            try {
                context.response = context.action.execute(dispatcher, context.request);
            }
            catch (Throwable e) {
                if (!context.sync) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Asynchronous action executor [" + context.action + "] faulted with error [" + e.toString() + "] with the following stack trace:\n");
                    sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                    this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
                }
                if (e instanceof Exception) {
                    context.e = (Exception)e;
                }
                throw (Error)e;
            }
            ITCTContext iTCTContext = context;
            synchronized (iTCTContext) {
                context.complete = true;
                if (context.sync) {
                    context.notifyAll();
                }
            }
            return false;
        }
    }

    private static final class ITCTContext<E, V> {
        final IEmxAction<E, V> action;
        final E request;
        final boolean sync;
        boolean complete;
        V response;
        Exception e;

        ITCTContext(IEmxAction<E, V> action, E request, boolean sync) {
            this.action = action;
            this.request = request;
            this.sync = sync;
            this.complete = false;
            this.response = null;
            this.e = null;
        }
    }
}

