/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.StatementNode;
import com.akiban.sql.parser.TableName;

public abstract class DDLStatementNode
extends StatementNode {
    public static final int UNKNOWN_TYPE = 0;
    public static final int ADD_TYPE = 1;
    public static final int DROP_TYPE = 2;
    public static final int MODIFY_TYPE = 3;
    public static final int LOCKING_TYPE = 4;
    private TableName objectName;
    private boolean initOk;
    boolean implicitCreateSchema;

    @Override
    public void init(Object objectName) throws StandardException {
        this.initAndCheck(objectName);
    }

    protected void initAndCheck(Object objectName) throws StandardException {
        this.objectName = (TableName)objectName;
        this.initOk = true;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        DDLStatementNode other = (DDLStatementNode)node;
        this.objectName = (TableName)this.getNodeFactory().copyNode(other.objectName, this.getParserContext());
        this.initOk = other.initOk;
        this.implicitCreateSchema = other.implicitCreateSchema;
    }

    public boolean isAtomic() {
        return true;
    }

    public String getRelativeName() {
        return this.objectName.getTableName();
    }

    public String getFullName() {
        return this.objectName.getFullTableName();
    }

    public final TableName getObjectName() {
        return this.objectName;
    }

    @Override
    public String toString() {
        return (this.objectName == null ? "" : "name: " + this.objectName.toString() + "\n") + super.toString();
    }
}

