/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep;

import com.neeve.aep.AepBusConnection;
import com.neeve.aep.IAepBusConnectionStats;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.stats.IStats;
import com.neeve.stats.Stats;
import java.text.NumberFormat;

public final class AepBusConnectionStats
extends Stats
implements IAepBusConnectionStats {
    private AepBusConnection busConnection;
    private NumberFormat format;
    private long startTime;
    private long deltaStartTime;
    private long numMsgsRcvdLast;
    private long numMsgsInBatchesRcvdLast;
    private long numMsgBatchesRcvdLast;
    private long numAcksSentLast;
    private long numMsgsEnqueuedLast;
    private long numMsgsSentLast;
    private long numStabilityRcvdLast;
    private long numStabilityInBatchesRcvdLast;
    private long numStabilityBatchesRcvdLast;
    private long numPacketsRcvdLast;
    private long numCommitsLast;
    private long numRollbacksLast;
    private long numPartialRollbacksLast;
    volatile long numMsgsRcvd;
    volatile long numMsgsInBatchesRcvd;
    volatile long numMsgBatchesRcvd;
    volatile long numAcksSent;
    volatile long numMsgsEnqueued;
    volatile long numMsgsSent;
    volatile long numStabilityRcvd;
    volatile long numStabilityInBatchesRcvd;
    volatile long numStabilityBatchesRcvd;
    volatile long numPacketsRcvd;
    volatile long numCommits;
    volatile long numRollbacks;
    volatile long numPartialRollbacks;
    volatile int numClients;
    volatile int numChannelsUp;
    volatile int numBindingFailures;
    final Stats.LatencyManager o2p = new Stats.LatencyManager("o2p");

    AepBusConnectionStats(AepBusConnection busConnection, String name, String startProp) {
        super("nv.aep.busconnection", name, "nv.aep.busconnection.stats", startProp);
        this.busConnection = busConnection;
        this.format = NumberFormat.getInstance();
        this.format.setMaximumFractionDigits(2);
    }

    private void stamp() {
        this.deltaStartTime = System.currentTimeMillis();
        this.numMsgsRcvdLast = this.numMsgsRcvd;
        this.numMsgsInBatchesRcvdLast = this.numMsgsInBatchesRcvd;
        this.numMsgBatchesRcvdLast = this.numMsgBatchesRcvd;
        this.numAcksSentLast = this.numAcksSent;
        this.numMsgsEnqueuedLast = this.numMsgsEnqueued;
        this.numMsgsSentLast = this.numMsgsSent;
        this.numStabilityRcvdLast = this.numStabilityRcvd;
        this.numStabilityInBatchesRcvdLast = this.numStabilityInBatchesRcvd;
        this.numStabilityBatchesRcvdLast = this.numStabilityBatchesRcvd;
        this.numPacketsRcvdLast = this.numPacketsRcvd;
        this.numCommitsLast = this.numCommits;
        this.numRollbacksLast = this.numRollbacks;
        this.numPartialRollbacksLast = this.numPartialRollbacks;
    }

    protected final void init() {
        this.startTime = System.currentTimeMillis();
        this.stamp();
    }

    public final synchronized void get(StringBuilder sb) {
        MessageBusBinding binding;
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.deltaStartTime;
        long deltaTotalTime = currentTime - this.startTime;
        long numMsgsRcvdCurrent = this.numMsgsRcvd;
        long numMsgsInBatchesRcvdCurrent = this.numMsgsInBatchesRcvd;
        long numMsgBatchesRcvdCurrent = this.numMsgBatchesRcvd;
        long numAcksSentCurrent = this.numAcksSent;
        long numMsgsEnqueuedCurrent = this.numMsgsEnqueued;
        long numMsgsSentCurrent = this.numMsgsSent;
        long numStabilityRcvdCurrent = this.numStabilityRcvd;
        long numStabilityInBatchesRcvdCurrent = this.numStabilityInBatchesRcvd;
        long numStabilityBatchesRcvdCurrent = this.numStabilityBatchesRcvd;
        long numPacketsRcvdCurrent = this.numPacketsRcvd;
        long numCommitsCurrent = this.numCommits;
        long numRollbacksCurrent = this.numRollbacks;
        long numPartialRollbacksCurrent = this.numPartialRollbacks;
        long numClientsCurrent = this.numClients;
        long numChannelsUpCurrent = this.numChannelsUp;
        int numBindingFailuresCurrent = this.numBindingFailures;
        int disruptorCapacityCurrent = this.busConnection.getDisruptorCapacity();
        int disruptorRemainingCurrent = this.busConnection.getDisruptorRemaining();
        int disruptorUsedCurrent = disruptorCapacityCurrent - disruptorRemainingCurrent;
        this.o2p.compute();
        String numMsgsRcvdStr = this.format.format(numMsgsRcvdCurrent);
        String deltaNumMsgsRcvdStr = this.format.format(numMsgsRcvdCurrent - this.numMsgsRcvdLast);
        String msgRecvRateStr = this.format.format(numMsgsRcvdCurrent * 1000L / deltaTotalTime);
        String deltaMsgRecvRateStr = this.format.format((numMsgsRcvdCurrent - this.numMsgsRcvdLast) * 1000L / deltaTime);
        String numMsgsInBatchesRcvdStr = this.format.format(numMsgsInBatchesRcvdCurrent);
        String deltaNumMsgsInBatchesRcvdStr = this.format.format(numMsgsInBatchesRcvdCurrent - this.numMsgsInBatchesRcvdLast);
        String msgsInBatchRecvRateStr = this.format.format(numMsgsInBatchesRcvdCurrent * 1000L / deltaTotalTime);
        String deltaMsgsInBatchRecvRateStr = this.format.format((numMsgsInBatchesRcvdCurrent - this.numMsgsInBatchesRcvdLast) * 1000L / deltaTime);
        String numMsgBatchesRcvdStr = this.format.format(numMsgBatchesRcvdCurrent);
        String deltaNumMsgBatchesRcvdStr = this.format.format(numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast);
        String msgBatchRecvRateStr = this.format.format(numMsgBatchesRcvdCurrent * 1000L / deltaTotalTime);
        String deltaMsgBatchRecvRateStr = this.format.format((numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast) * 1000L / deltaTime);
        long avgRecvBatchSize = numMsgBatchesRcvdCurrent == 0L ? 0L : numMsgsInBatchesRcvdCurrent / numMsgBatchesRcvdCurrent;
        long deltaAvgRecvBatchSize = numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast == 0L ? 0L : (numMsgsInBatchesRcvdCurrent - this.numMsgsInBatchesRcvdLast) / (numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast);
        String avgRecvBatchSizeStr = this.format.format(avgRecvBatchSize);
        String deltaAvgRecvBatchSizeStr = this.format.format(deltaAvgRecvBatchSize);
        String numAcksSentStr = this.format.format(numAcksSentCurrent);
        String deltaNumAcksSentStr = this.format.format(numAcksSentCurrent - this.numAcksSentLast);
        String acksSentRateStr = this.format.format(numAcksSentCurrent * 1000L / deltaTotalTime);
        String deltaAcksSentRateStr = this.format.format((numAcksSentCurrent - this.numAcksSentLast) * 1000L / deltaTime);
        String numMsgsEnqueuedStr = this.format.format(numMsgsEnqueuedCurrent);
        String deltaNumMsgsEnqueuedStr = this.format.format(numMsgsEnqueuedCurrent - this.numMsgsEnqueuedLast);
        String msgEnqueRateStr = this.format.format(numMsgsEnqueuedCurrent * 1000L / deltaTotalTime);
        String deltaMsgEnqueRateStr = this.format.format((numMsgsEnqueuedCurrent - this.numMsgsEnqueuedLast) * 1000L / deltaTime);
        String numMsgsSentStr = this.format.format(numMsgsSentCurrent);
        String deltaNumMsgsSentStr = this.format.format(numMsgsSentCurrent - this.numMsgsSentLast);
        String msgSendRateStr = this.format.format(numMsgsSentCurrent * 1000L / deltaTotalTime);
        String deltaMsgSendRateStr = this.format.format((numMsgsSentCurrent - this.numMsgsSentLast) * 1000L / deltaTime);
        String numStabilityRcvdStr = this.format.format(numStabilityRcvdCurrent);
        String deltaNumStabilityRcvdStr = this.format.format(numStabilityRcvdCurrent - this.numStabilityRcvdLast);
        String stabilityRateStr = this.format.format(numStabilityRcvdCurrent * 1000L / deltaTotalTime);
        String deltaStabilityRateStr = this.format.format((numStabilityRcvdCurrent - this.numStabilityRcvdLast) * 1000L / deltaTime);
        String numStabilityBatchesRcvdStr = this.format.format(numStabilityBatchesRcvdCurrent);
        String deltaNumStabilityBatchesRcvdStr = this.format.format(numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast);
        String stabilityBatchesRateStr = this.format.format(numStabilityBatchesRcvdCurrent * 1000L / deltaTotalTime);
        String deltaStabilityBatchesRateStr = this.format.format((numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast) * 1000L / deltaTime);
        long avgStabilityBatchSize = numStabilityBatchesRcvdCurrent == 0L ? 0L : numStabilityInBatchesRcvdCurrent / numStabilityBatchesRcvdCurrent;
        long deltaAvgStabilityBatchSize = numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast == 0L ? 0L : (numStabilityInBatchesRcvdCurrent - this.numStabilityInBatchesRcvdLast) / (numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast);
        String avgStabilityBatchSizeStr = this.format.format(avgStabilityBatchSize);
        String deltaAvgStabilityBatchSizeStr = this.format.format(deltaAvgStabilityBatchSize);
        String numPacketsRcvdStr = this.format.format(numPacketsRcvdCurrent);
        String deltaNumPacketsRcvdStr = this.format.format(numPacketsRcvdCurrent - this.numPacketsRcvdLast);
        String packetRecvRateStr = this.format.format(numPacketsRcvdCurrent * 1000L / deltaTotalTime);
        String deltaPacketRecvRateStr = this.format.format((numPacketsRcvdCurrent - this.numPacketsRcvdLast) * 1000L / deltaTime);
        String numCommitsStr = this.format.format(numCommitsCurrent);
        String deltaNumCommitsStr = this.format.format(numCommitsCurrent - this.numCommitsLast);
        String commitRateStr = this.format.format(numCommitsCurrent * 1000L / deltaTotalTime);
        String deltaCommitRateStr = this.format.format((numCommitsCurrent - this.numCommitsLast) * 1000L / deltaTime);
        String numRollbacksStr = this.format.format(numRollbacksCurrent);
        String deltaNumRollbacksStr = this.format.format(numRollbacksCurrent - this.numRollbacksLast);
        String rollbackRateStr = this.format.format(numRollbacksCurrent * 1000L / deltaTotalTime);
        String deltaRollbackRateStr = this.format.format((numRollbacksCurrent - this.numRollbacksLast) * 1000L / deltaTime);
        String numPartialRollbacksStr = this.format.format(numPartialRollbacksCurrent);
        String deltaNumPartialRollbacksStr = this.format.format(numPartialRollbacksCurrent - this.numPartialRollbacksLast);
        String partialRollbackRateStr = this.format.format(numPartialRollbacksCurrent * 1000L / deltaTotalTime);
        String deltaPartialRollbackRateStr = this.format.format((numRollbacksCurrent - this.numRollbacksLast) * 1000L / deltaTime);
        int disruptorUsagePctCurrent = disruptorCapacityCurrent > 0 ? (disruptorCapacityCurrent - disruptorRemainingCurrent) * 100 / disruptorCapacityCurrent : 0;
        String disruptorCapacityStr = this.format.format(disruptorCapacityCurrent);
        String disruptorUsedStr = this.format.format(disruptorUsedCurrent);
        String disruptorUsagePctStr = this.format.format(disruptorUsagePctCurrent);
        sb.append("In.........{").append("\n");
        sb.append("...Msg{");
        sb.append(numMsgsRcvdStr + "(" + deltaNumMsgsRcvdStr + ") ");
        sb.append(msgRecvRateStr + "(" + deltaMsgRecvRateStr + ") ");
        sb.append(numMsgsInBatchesRcvdStr + "(" + deltaNumMsgsInBatchesRcvdStr + ") ");
        sb.append(msgsInBatchRecvRateStr + "(" + deltaMsgsInBatchRecvRateStr + ") ");
        sb.append(numMsgBatchesRcvdStr + "(" + deltaNumMsgBatchesRcvdStr + ") ");
        sb.append(msgBatchRecvRateStr + "(" + deltaMsgBatchRecvRateStr + ") ");
        sb.append(avgRecvBatchSizeStr + "(" + deltaAvgRecvBatchSizeStr + ")");
        sb.append("}").append("\n");
        sb.append("...Ack{");
        sb.append(numAcksSentStr + "(" + deltaNumAcksSentStr + ") ");
        sb.append(acksSentRateStr + "(" + deltaAcksSentRateStr + ")");
        sb.append("}").append("\n");
        sb.append("...Pkt{");
        sb.append(numPacketsRcvdStr + "(" + deltaNumPacketsRcvdStr + ") ");
        sb.append(packetRecvRateStr + "(" + deltaPacketRecvRateStr + ")");
        sb.append("}").append("\n");
        sb.append("...Stab{");
        sb.append(numStabilityRcvdStr + "(" + deltaNumStabilityRcvdStr + ") ");
        sb.append(stabilityRateStr + "(" + deltaStabilityRateStr + ") ");
        sb.append(numStabilityBatchesRcvdStr + "(" + deltaNumStabilityBatchesRcvdStr + ") ");
        sb.append(stabilityBatchesRateStr + "(" + deltaStabilityBatchesRateStr + ") ");
        sb.append(avgStabilityBatchSizeStr + "(" + deltaAvgStabilityBatchSizeStr + ")");
        sb.append("}").append("\n");
        sb.append("}").append("\n");
        sb.append("Out........{").append("\n");
        sb.append("...Msg{");
        sb.append(numMsgsEnqueuedStr + "(" + deltaNumMsgsEnqueuedStr + ") ");
        sb.append(msgEnqueRateStr + "(" + deltaMsgEnqueRateStr + ") ");
        sb.append(numMsgsSentStr + "(" + deltaNumMsgsSentStr + ") ");
        sb.append(msgSendRateStr + "(" + deltaMsgSendRateStr + ") ");
        sb.append(numMsgsEnqueuedCurrent - numMsgsSentCurrent);
        sb.append("}").append("\n");
        sb.append("}").append("\n");
        sb.append("Txn........{");
        sb.append(numCommitsStr + "(" + deltaNumCommitsStr + ") ");
        sb.append(commitRateStr + "(" + deltaCommitRateStr + ") ");
        sb.append(numRollbacksStr + "(" + deltaNumRollbacksStr + ") ");
        sb.append(rollbackRateStr + "(" + deltaRollbackRateStr + ")");
        sb.append(numPartialRollbacksStr + "(" + deltaNumPartialRollbacksStr + ") ");
        sb.append(partialRollbackRateStr + "(" + deltaPartialRollbackRateStr + ")");
        sb.append("}").append("\n");
        sb.append("Disruptor..{");
        sb.append("[").append(disruptorUsedStr).append(" of ").append(disruptorCapacityStr).append("] ").append(disruptorUsagePctStr).append("%").append(" (" + this.busConnection.getDisruptorClaimStrategy() + ", " + this.busConnection.getDisruptorWaitStrategy() + ")");
        sb.append("}").append("\n");
        this.o2p.get(sb);
        sb.append("Clients....{");
        sb.append(numClientsCurrent);
        sb.append("}").append("\n");
        sb.append("Channels...{");
        sb.append(numChannelsUpCurrent);
        sb.append("}").append("\n");
        sb.append("Fails......{");
        sb.append(numBindingFailuresCurrent);
        sb.append("}").append("\n");
        if (MessageLatencyManager.recordMsgLegLatencies) {
            MessageLatencyManager mlm = this.getLatencyManager();
            if (mlm != null) {
                mlm.compute();
                mlm.get(sb, false);
            } else {
                sb.append("[Binding not established. No latency connection]").append("\n");
            }
        }
        if ((binding = this.busConnection.getBusBinding()) != null) {
            sb.append("[Binding '" + binding.getName() + "']").append("\n");
            binding.getStats(sb);
            sb.append("\n");
        } else {
            sb.append("[Binding not established. No binding level stats]").append("\n");
        }
        this.stamp();
    }

    @Override
    public final AepBusConnection getBusConnection() {
        return this.busConnection;
    }

    @Override
    public final long getNumMsgsRcvd() {
        return this.numMsgsRcvd;
    }

    @Override
    public final long getNumMsgsInBatchesRcvd() {
        return this.numMsgsInBatchesRcvd;
    }

    @Override
    public final long getNumMsgBatchesRcvd() {
        return this.numMsgBatchesRcvd;
    }

    @Override
    public final long getNumAcksSent() {
        return this.numAcksSent;
    }

    @Override
    public final long getNumMsgsEnqueued() {
        return this.numMsgsEnqueued;
    }

    @Override
    public final long getNumMsgsSent() {
        return this.numMsgsSent;
    }

    @Override
    public final long getNumStabilityRcvd() {
        return this.numStabilityRcvd;
    }

    @Override
    public final long getNumStabilityInBatchesRcvd() {
        return this.numStabilityInBatchesRcvd;
    }

    @Override
    public final long getNumStabilityBatchesRcvd() {
        return this.numStabilityBatchesRcvd;
    }

    @Override
    public final long getNumPacketsRcvd() {
        return this.numPacketsRcvd;
    }

    @Override
    public final long getNumCommits() {
        return this.numCommits;
    }

    @Override
    public final long getNumRollbacks() {
        return this.numRollbacks;
    }

    @Override
    public final long getNumPartialRollbacks() {
        return this.numPartialRollbacks;
    }

    @Override
    public final int getNumClients() {
        return this.numClients;
    }

    @Override
    public final int getNumChannelsUp() {
        return this.numChannelsUp;
    }

    @Override
    public final int getNumBindingFailures() {
        return this.numBindingFailures;
    }

    @Override
    public final boolean isDetachedCommit() {
        return this.busConnection.isDetachedCommit();
    }

    @Override
    public final int getDisruptorCapacity() {
        return this.busConnection.getDisruptorCapacity();
    }

    @Override
    public final int getDisruptorRemaining() {
        return this.busConnection.getDisruptorRemaining();
    }

    @Override
    public final String getDisruptorClaimStrategy() {
        return this.busConnection.getDisruptorClaimStrategy();
    }

    @Override
    public final String getDisruptorWaitStrategy() {
        return this.busConnection.getDisruptorWaitStrategy();
    }

    @Override
    public final IStats.Latencies getDisruptorOfferToPollLatencies() {
        return this.o2p;
    }

    @Override
    public final MessageLatencyManager getLatencyManager() {
        MessageBusBinding binding = this.busConnection.getBusBinding();
        if (binding != null) {
            return binding.getLatencyManager();
        }
        return null;
    }
}

