/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmGeneratorDescriptor;
import com.neeve.adm.AdmObject;
import com.neeve.adm.EAdmException;
import com.neeve.adm.IAdmGenerator;
import com.neeve.trace.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public final class AdmGeneratorRegistry
extends AdmObject {
    private static final AdmGeneratorRegistry instance = new AdmGeneratorRegistry();
    private final HashMap<String, IAdmGenerator> generators = new HashMap();

    private AdmGeneratorRegistry() {
    }

    public static final AdmGeneratorRegistry getInstance() {
        return instance;
    }

    private final IAdmGenerator createGenerator(String className, String name) throws EAdmException {
        Class<?> generatorClass = null;
        try {
            generatorClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new EAdmException("Generator class [" + className + "] could not be found");
        }
        catch (UnsupportedClassVersionError e) {
            throw new EAdmException("Generator class [" + className + "] is not supported by this VM <version=" + System.getProperty("java.vm.version") + ">");
        }
        Method generatorCreateMethod = null;
        try {
            Class[] parameterTypes = new Class[]{Class.forName("java.lang.String")};
            generatorCreateMethod = generatorClass.getMethod("create", parameterTypes);
        }
        catch (ClassNotFoundException e) {
            throw new InternalError("Failed to load java.lang.String during instantiation of generator class [" + className + "]");
        }
        catch (SecurityException e) {
            throw new EAdmException("Access to instantiation method in generator class [" + className + "] is denied");
        }
        catch (NoSuchMethodException e) {
            throw new EAdmException("Instantiation method in generator class [" + className + "] could not be found");
        }
        IAdmGenerator generator = null;
        try {
            try {
                Object[] parameters = new Object[]{name};
                generator = (IAdmGenerator)generatorCreateMethod.invoke(null, parameters);
                if (generator == null) {
                    throw new EAdmException("Instantiation method in generator class [" + className + "] returned a null object");
                }
            }
            catch (ClassCastException e) {
                throw new EAdmException("Instantiation method in generator class [" + className + "] returned object of incorrect type");
            }
        }
        catch (IllegalAccessException e) {
            throw new EAdmException("Access to instantiation method in generator class [" + className + "] is denied");
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof EAdmException) {
                throw (EAdmException)((Object)e.getCause());
            }
            throw new EAdmException(e.getCause());
        }
        return generator;
    }

    private final IAdmGenerator createGenerator(String name) throws EAdmException {
        if (AdmGeneratorDescriptor.exists(name)) {
            AdmGeneratorDescriptor descriptor = AdmGeneratorDescriptor.load(name);
            return this.createGenerator(descriptor.getClassName(), descriptor.getName());
        }
        throw new EAdmException("invalid encoding type '" + name + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object[] getGeneratorNames() {
        try {
            HashMap<String, IAdmGenerator> hashMap = this.generators;
            synchronized (hashMap) {
                ArrayList<String> names = new ArrayList<String>();
                for (AdmGeneratorDescriptor descriptor : AdmGeneratorDescriptor.loadAll()) {
                    names.add(descriptor.getName());
                }
                return names.toArray(new Object[names.size()]);
            }
        }
        catch (EAdmException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerGenerator(IAdmGenerator generator) throws EAdmException {
        if (generator == null) {
            throw new IllegalArgumentException("generator cannot be null");
        }
        HashMap<String, IAdmGenerator> hashMap = this.generators;
        synchronized (hashMap) {
            if (this.tracer.debug) {
                this.tracer.log("[AdmGeneratorRegistry] Registering generator '" + generator.getName() + "'...", Tracer.Level.DEBUG);
            }
            this.generators.put(generator.getName().toLowerCase(), generator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IAdmGenerator getGenerator(String name) throws EAdmException {
        if (name == null) {
            throw new IllegalArgumentException("generator name cannot be null");
        }
        name = name.toLowerCase();
        HashMap<String, IAdmGenerator> hashMap = this.generators;
        synchronized (hashMap) {
            IAdmGenerator generator;
            if (this.tracer.debug) {
                this.tracer.log("[AdmGeneratorRegistry] Getting generator '" + name + "'...", Tracer.Level.DEBUG);
            }
            if ((generator = this.generators.get(name)) == null) {
                if (this.tracer.debug) {
                    this.tracer.log("[AdmGeneratorRegistry] Generator not created. Creating...", Tracer.Level.DEBUG);
                }
                generator = this.createGenerator(name);
                this.generators.put(name, generator);
            } else if (this.tracer.debug) {
                this.tracer.log("[AdmGeneratorRegistry] Generator already created. Returning...", Tracer.Level.DEBUG);
            }
            return generator;
        }
    }
}

