/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.util;

import java.util.regex.Pattern;

public class UtlQueryRegex {
    public static final String REGEX_LIKE_PREFIX = "NVX:REGEX:";

    public static boolean like(String text, String likeMask) {
        Pattern p = UtlQueryRegex.createLikePattern(likeMask);
        return p.matcher(text).matches();
    }

    public static Pattern createLikePattern(String likeMask) {
        String regex = UtlQueryRegex.escapeMetaChars(likeMask);
        regex = regex.replace("_", ".").replace("%", ".*?");
        return Pattern.compile(regex, 34);
    }

    private static String escapeMetaChars(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String cannot be null");
        }
        int len = s.length();
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if ("(){}.*+?$|#\\".indexOf(c) != -1) {
                sb.append("\\");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String preprocessRegexLikeOperator(String xsql) {
        return xsql.replaceAll("\\b(?iu)REGEX_LIKE\\W'", "LIKE 'NVX:REGEX:");
    }

    public static String[] tokens(String sql) {
        String sql2 = sql.replaceAll(",\\b", ", ");
        return sql2.split("\\s+");
    }
}

