/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods;

import com.eaio.uuid.UUID;
import com.neeve.event.Event;
import com.neeve.event.EventMultiplexerSingleThreaded;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventMultiplexer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreBindingStats;
import com.neeve.ods.IStoreCommitCompletionEvent;
import com.neeve.ods.IStoreEvent;
import com.neeve.ods.IStoreEventHandler;
import com.neeve.ods.IStoreField;
import com.neeve.ods.IStoreIndex;
import com.neeve.ods.IStoreMember;
import com.neeve.ods.IStoreMemberControlEvent;
import com.neeve.ods.IStoreNonUniqueIndex;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.IStoreQueryEngine;
import com.neeve.ods.IStoreQueryRepository;
import com.neeve.ods.IStoreReplicatorNotificationHandler;
import com.neeve.ods.IStoreSender;
import com.neeve.ods.IStoreTransactionLog;
import com.neeve.ods.IStoreUniqueIndex;
import com.neeve.ods.OdsException;
import com.neeve.ods.StoreBindingFactory;
import com.neeve.ods.StoreDescriptor;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;
import com.neeve.query.IQueryAPICallerContext;
import java.util.Map;

public final class StoreBinding
implements IStoreBinding {
    private final IStoreBinding binding;
    private final IStoreEventHandler eventHandler;
    private final IEventMultiplexer multiplexer;

    private StoreBinding(String memberName, StoreDescriptor descriptor, IStoreEventHandler eventHandler, IStoreReplicatorNotificationHandler replicatorNotificationHandler, int flags) throws OdsException {
        this.eventHandler = eventHandler;
        this.multiplexer = EventMultiplexerSingleThreaded.create((String)memberName, (boolean)true, (IEventHandler)new EventMultiplexerEventHandler(), null);
        this.multiplexer.open();
        this.binding = StoreBindingFactory.getInstance().createBinding(memberName, descriptor, (IStoreEventHandler)new StoreEventHandler(), replicatorNotificationHandler, flags | 2);
    }

    public static final IStoreBinding create(String memberName, StoreDescriptor descriptor, IStoreEventHandler eventHandler, IStoreReplicatorNotificationHandler replicatorNotificationHandler, int flags) throws OdsException {
        if ((flags & 2) == 2) {
            throw new IllegalArgumentException("FLG_CREATE_CORE_BINDING cannot be specified when creating this store binding. Please use StoreBindingFactory.getInstance().createBinding() directly to create core bindings");
        }
        return new StoreBinding(memberName, descriptor, eventHandler, replicatorNotificationHandler, flags);
    }

    public static final IStoreBinding create(String memberName, StoreDescriptor descriptor, IStoreEventHandler eventHandler, int flags) throws OdsException {
        return StoreBinding.create(memberName, descriptor, eventHandler, null, flags);
    }

    private static final int fromStoreOperation(IStoreBinding.Operation operation) {
        switch (operation) {
            case Put: {
                return 8;
            }
            case Update: {
                return 16;
            }
            case Send: {
                return 64;
            }
            case Remove: {
                return 32;
            }
        }
        throw new RuntimeException("unknown store operation [" + (Object)((Object)operation) + "]");
    }

    public static final void prepareStorePacketHeader(IStoreObject object, PktPacket packet, IStoreBinding.Operation operation, UUID oid, short ofid, short otype, long transactionId, long stableTransactionId, long checkpointVersion, IStoreObject.EncodingType contentEncodingType, boolean commitStart, boolean commitEnd, IOElasticBuffer serializedPersisterMetadata) {
        PktSubheaderODS subheaderODS = packet.getHeader().activateODSSubheader(false);
        int flags = StoreBinding.fromStoreOperation(operation);
        if (commitStart) {
            flags |= 2;
        }
        if (commitEnd) {
            flags |= 1;
        }
        IOElasticBuffer serializedMetadata = subheaderODS.getBuffer();
        int serializedMetadataOffset = subheaderODS.getObjectMetadataOffset();
        subheaderODS.setObjectMetadataLengthUnsafe((short)object.serializeMetadata(serializedMetadata, serializedMetadataOffset));
        if (commitStart && serializedPersisterMetadata != null && serializedPersisterMetadata.getLength() > 0) {
            subheaderODS.copyPersisterMetadataFrom(serializedPersisterMetadata);
        }
        PktSubheaderODS.prepare((PktPacket)packet, (UUID)oid, (short)ofid, (short)otype, (short)((short)(contentEncodingType == null ? 0 : contentEncodingType.toMessageViewEncoding())), (long)transactionId, (long)stableTransactionId, (long)checkpointVersion, (long)System.currentTimeMillis(), (byte)((byte)flags));
    }

    public final String getName() {
        return this.binding.getName();
    }

    @Override
    public final void open() throws OdsException {
        this.binding.open();
    }

    @Override
    public final void open(Map<IStoreBinding.StartupExpectation, Enum<?>> expectations) throws OdsException {
        this.binding.open(expectations);
    }

    @Override
    public final IStoreMember getMember() {
        return this.binding.getMember();
    }

    @Override
    public final StoreDescriptor getDescriptor() {
        return this.binding.getDescriptor();
    }

    @Override
    public final IStoreEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public final IStoreBinding.State getState() {
        return this.binding.getState();
    }

    @Override
    public final IStoreBindingStats getStats() {
        return this.binding.getStats();
    }

    @Override
    public final IStoreBinding.Role getRole() {
        return this.binding.getRole();
    }

    @Override
    public final IStoreBinding.InterClusterReplicationRole getInterClusterReplicationRole() {
        return this.binding.getInterClusterReplicationRole();
    }

    @Override
    public final int getMemberCount() {
        return this.binding.getMemberCount();
    }

    @Override
    public final boolean isPersistenceQuorumMet() {
        return this.binding.isPersistenceQuorumMet();
    }

    @Override
    public final IStorePersister getPersister() {
        return this.binding.getPersister();
    }

    @Override
    public final IStoreSender getICRSender() {
        return this.binding.getICRSender();
    }

    @Override
    public final IStoreTransactionLog getTransactionLog() {
        return this.binding.getTransactionLog();
    }

    @Override
    public final IStoreQueryEngine getQueryEngine() {
        return this.binding.getQueryEngine();
    }

    @Override
    public final IStoreQueryRepository asQueryRepository() {
        return this.binding.asQueryRepository();
    }

    @Override
    public final IStoreCommitCompletionEvent createCommitCompletionEvent() {
        return this.binding.createCommitCompletionEvent();
    }

    @Override
    public final int sizeUnprotected() {
        return this.binding.sizeUnprotected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int size() {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.size();
        }
    }

    @Override
    public final void processMemberControlEvent(IStoreMemberControlEvent event) {
        throw new UnsupportedOperationException("illegal to invoke this method. the method is automatically invoked by the store binding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> void recordFieldUpdate(IStoreObject object, IStoreField<T> field, T oldValue, T newValue) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            this.binding.recordFieldUpdate(object, field, oldValue, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IStoreBinding put(IStoreObject object) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.put(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IStoreBinding send(IStoreObject object) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.send(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IStoreObject get(UUID id) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IStoreBinding remove(IStoreObject object) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IStoreCommitCompletionEvent commit(long transactionId, long stableTransactionId, IStoreObject[] messages, int messageCount, IStoreCommitCompletionEvent completionEvent, int flags) throws OdsException {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.commit(transactionId, stableTransactionId, messages, messageCount, completionEvent, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IStoreCommitCompletionEvent commit(long transactionId, long stableTransactionId, IStoreCommitCompletionEvent completionEvent, int flags) throws OdsException {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.commit(transactionId, stableTransactionId, completionEvent, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IStoreCommitCompletionEvent commit(IStoreCommitCompletionEvent completionEvent) throws OdsException {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.commit(completionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int createSavepoint() {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.createSavepoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getLastSavepoint() {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.getLastSavepoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IStoreBinding rollback() {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IStoreBinding rollback(int savepoint) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.rollback(savepoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fail(Exception e) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            this.binding.fail(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close(int flags) {
        this.multiplexer.close();
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            this.binding.close(flags);
        }
    }

    public final IStoreBinding getUnderlyingBinding() {
        return this.binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQueryAPICallerContext(IQueryAPICallerContext queryAPICallerContext) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            this.binding.setQueryAPICallerContext(queryAPICallerContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, T extends IStoreObject> IStoreUniqueIndex<K, T> createUniqueIndex(String fieldPath, String name) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.createUniqueIndex(fieldPath, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, T extends IStoreObject> IStoreNonUniqueIndex<K, T> createNonUniqueIndex(String fieldPath, String name) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.createNonUniqueIndex(fieldPath, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropIndexByName(String name) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.dropIndexByName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropIndex(String fieldPath) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.dropIndex(fieldPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropIndex(IStoreIndex<?, ?> index) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.dropIndex(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, T extends IStoreObject> IStoreUniqueIndex<K, T> getUniqueIndex(String fieldPath) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.getUniqueIndex(fieldPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, T extends IStoreObject> IStoreNonUniqueIndex<K, T> getNonUniqueIndex(String fieldPath) {
        StoreBinding storeBinding = this;
        synchronized (storeBinding) {
            return this.binding.getNonUniqueIndex(fieldPath);
        }
    }

    private final class EventMultiplexerEventHandler
    implements IEventHandler {
        private EventMultiplexerEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onEvent(Event event) {
            switch (event.getType()) {
                case 312: 
                case 313: 
                case 314: 
                case 315: 
                case 316: 
                case 317: 
                case 318: 
                case 319: 
                case 320: {
                    StoreBinding storeBinding = StoreBinding.this;
                    synchronized (storeBinding) {
                        StoreBinding.this.binding.processMemberControlEvent((IStoreMemberControlEvent)event);
                        break;
                    }
                }
                case 301: {
                    StoreBinding.this.close(0);
                    break;
                }
            }
        }
    }

    private final class StoreEventHandler
    implements IStoreEventHandler {
        private StoreEventHandler() {
        }

        @Override
        public final void onEvent(IStoreEvent event) {
            switch (event.getType()) {
                case 312: 
                case 313: 
                case 314: 
                case 315: 
                case 316: 
                case 317: 
                case 318: 
                case 319: 
                case 320: {
                    StoreBinding.this.multiplexer.multiplexEvent((Event)event, 1);
                    break;
                }
                default: {
                    if (event.getType() == 301) {
                        StoreBinding.this.multiplexer.multiplexEvent((Event)event, 1);
                    }
                    StoreBinding.this.eventHandler.onEvent(event);
                }
            }
        }
    }
}

