/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.link;

import com.neeve.aep.event.AepClientConnectedEvent;
import com.neeve.aep.event.AepClientDisconnectedEvent;
import com.neeve.aep.event.AepClientPacketEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.event.Event;
import com.neeve.link.ELnkException;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.server.link.SrvLink;
import com.neeve.server.link.SrvLinkClient;
import com.neeve.server.link.SrvLinkClientStats;
import com.neeve.server.link.SrvLinkInboundManager;
import com.neeve.server.link.SrvLinkSmaMessageBusBinding;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.sma.impl.MessageChannelBase;
import com.neeve.trace.Tracer;

public final class SrvLinkSmaMessageChannel
extends MessageChannelBase
implements ILnkEventHandler {
    private final Tracer packetTracer = Tracer.get((String)"nv.packet");
    private final SrvLinkSmaMessageBusBinding binding;
    private SrvLinkInboundManager manager;
    private SrvLink link;
    private SrvLinkClient client;
    private SrvLinkClientStats stats;
    private IEmxDispatcher dispatcher;

    SrvLinkSmaMessageChannel(MessageChannelDescriptor descriptor, SrvLinkSmaMessageBusBinding binding) throws SmaException {
        super(null, descriptor, (MessageBusBindingBase)binding);
        this.binding = binding;
        this.stats = new SrvLinkClientStats(this.getName(), "nv.server.link.client." + this.getName() + ".stats.interval");
    }

    private final boolean send(PktPacket packet, int flags) throws SmaException {
        PktHeader header = packet.getHeader();
        if (this.client.getSrvLtp() != -1) {
            header.setSrcPort(this.client.getSrvLtp());
        }
        if (this.client.getClientLtp() != -1) {
            header.setDestPort(this.client.getClientLtp());
        }
        if (this.packetTracer.debug) {
            this.packetTracer.log("[PTRACE.CLCHANNEL." + this.getName() + "->] " + packet.getHeader(), Tracer.Level.DEBUG);
        }
        ++this.stats.numPktsSent;
        try {
            boolean bl = this.link.getCommLink().enque(this.client.getSrvLtp(), packet, null, flags);
            return bl;
        }
        catch (ELnkException e) {
            throw new SmaException((Throwable)e);
        }
        finally {
            packet.dispose();
        }
    }

    private final void onLinkDown(Exception cause) {
        this.tracer.log("Client '" + this.client.getName() + "' has disconnected [" + cause.getMessage() + "].", Tracer.Level.INFO);
        if (cause.getMessage() == null) {
            cause.printStackTrace();
        }
        try {
            this.link.getCommLink().getContainer().stopRead(this.link.getCommLink());
        }
        catch (Exception e) {
            this.tracer.log(this.tracePrefix + "Failed to stop read on a failed link [" + e.toString() + "]. Ignoring.", Tracer.Level.WARNING);
        }
        this.onFail(cause);
        this.onEvent((Event)AepClientDisconnectedEvent.create((MessageBusBinding)this.binding, (MessageChannel)this));
    }

    final IEmxDispatcher getDispatcher() {
        return this.dispatcher;
    }

    final String getClientAppName() {
        return this.client.getAppInfo().getName();
    }

    final void attachLink(SrvLinkInboundManager manager, SrvLink link, IEmxDispatcher dispatcher) throws Exception {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Attaching link " + (Object)((Object)link) + " to channel...", Tracer.Level.DEBUG);
        }
        if (this.link != null) {
            this.tracer.log(this.tracePrefix + "Attached link '" + (Object)((Object)link) + "' will overwrite existing link!" + (Object)((Object)this.link) + "...", Tracer.Level.WARNING);
        }
        this.manager = manager;
        this.link = link;
        this.client = (SrvLinkClient)link.getAgent();
        this.dispatcher = dispatcher;
        if (dispatcher.getOwner() != Thread.currentThread()) {
            throw new InternalError("attach link method invoked with a dispatcher whose owner is not the calling thread!");
        }
        link.getCommLink().join(this.client.getSrvLtp(), (ILnkEventHandler)this);
        link.getCommLink().getContainer().startRead(link.getCommLink());
        this.binding.onClientConnected(this);
        this.onEvent((Event)AepClientConnectedEvent.create((MessageBusBinding)this.binding, (MessageChannel)this));
        this.join(0);
        this.tracer.log("Client '" + this.client.getName() + "' has connected <thread='" + link.getCommLink().getContainer().getName() + "' app=" + this.client.getAppInfo() + ">.", Tracer.Level.INFO);
    }

    final void flush() throws SmaException {
        try {
            this.link.getCommLink().flush(this.client.getSrvLtp(), null);
        }
        catch (ELnkException e) {
            throw new SmaException((Throwable)e);
        }
        catch (Exception e) {
            throw new SmaException((Throwable)e);
        }
    }

    protected final void doJoin(String[] filters, int flags) throws SmaException {
    }

    protected final void doLeave(int flags) throws SmaException {
    }

    protected final boolean doSend(MessageView view, int flags) throws SmaException {
        int nvxFlags = 0;
        if ((flags & 1) == 1) {
            nvxFlags |= 0x10;
        }
        return this.send(view.serializeToPacket(), nvxFlags);
    }

    protected final void doClose() throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " closing channel link='" + (Object)((Object)this.link) + "'", Tracer.Level.DEBUG);
        }
        this.stats.close();
        if (this.link != null) {
            this.binding.onClientDisconnected(this);
            this.manager.onLinkDown(this.link);
        }
    }

    public final String getType() {
        return "server";
    }

    public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
        switch (type) {
            case 5: {
                ++this.stats.numPktsRcvd;
                this.onEvent((Event)AepClientPacketEvent.create((MessageBusBinding)this.binding, (MessageChannel)this, (PktPacket)((PktPacket)data)));
                break;
            }
            case 8: {
                this.onLinkDown((Exception)data);
                break;
            }
            default: {
                throw new InternalError("Invalid event type [" + type + "]");
            }
        }
    }

    public final String toString() {
        return this.client != null ? this.client.toString() : super.toString();
    }
}

