/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.admin.impl.direct;

import com.neeve.adm.AdmFactory;
import com.neeve.client.EClientOpFailedException;
import com.neeve.client.EClientOpTimeoutException;
import com.neeve.client.EClientRootException;
import com.neeve.client.IClientConnectionPoolEventHandler;
import com.neeve.client.IClientEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkRequest;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderSMA;
import com.neeve.pkt.types.PktBodyServerAdminReply;
import com.neeve.rog.IRogMessage;
import com.neeve.server.admin.impl.direct.AdminClientConnection;
import com.neeve.server.admin.impl.direct.EAdminClientServerError;
import com.neeve.server.client.SrvClient;
import com.neeve.server.mon.SrvMonHeartbeatFactory;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.alert.SrvMonAlertFactory;
import com.neeve.server.mon.cnc.ISrvMonXvmRequest;
import com.neeve.server.mon.cnc.SrvMonCncFactory;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandRequest;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandResponse;
import com.neeve.server.mon.cnc.SrvMonStartAppWatchCommand;
import com.neeve.server.mon.cnc.SrvMonStartTraceWatchRequest;
import com.neeve.server.mon.cnc.SrvMonStopTraceWatchRequest;
import com.neeve.server.mon.lifecycle.SrvMonLifecycleFactory;
import com.neeve.server.mon.util.SrvMonUtil;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlList;
import com.neeve.util.UtlThrowable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

final class AdminClient
extends SrvClient<AdminClientConnection> {
    static final short MIN_APP_VERSION = 1;
    private final SrvMonHeartbeatFactory monHeartbeatFactory;
    private final SrvMonCncFactory monCncFactory;
    private final SrvMonLifecycleFactory monLifecycleFactory;
    private final SrvMonAlertFactory monAlertFactory;
    private final String tracePrefix;
    private AtomicBoolean traceWatchStarted = new AtomicBoolean(false);
    private AtomicBoolean appWatchStarted = new AtomicBoolean(false);
    private AtomicBoolean appWatchJoined = new AtomicBoolean(false);
    private int adminCompatLevel = 1;

    AdminClient(String name, IClientEventHandler eventHandler) {
        super("admin", name, eventHandler);
        this.monHeartbeatFactory = new SrvMonHeartbeatFactory();
        this.monCncFactory = new SrvMonCncFactory();
        this.monLifecycleFactory = new SrvMonLifecycleFactory();
        this.monAlertFactory = new SrvMonAlertFactory();
        this.tracePrefix = "[AdminClient '" + name + "'] ";
    }

    public static AdminClient create(String name, IClientEventHandler eventHandler) {
        return new AdminClient(name, eventHandler);
    }

    @Override
    protected final AdminClientConnection doCreateConnection(String name, IClientConnectionPoolEventHandler eventHandler) {
        return new AdminClientConnection(name, this, eventHandler);
    }

    @Override
    protected final void onPacket(PktPacket packet) {
        MessageView message = this.packetToMessage(packet);
        if (message != null) {
            this.dispatchEvent(452, message);
            if (message instanceof SrvMonHeartbeatMessage) {
                this.appWatchJoined.set(true);
            }
            message.dispose();
        } else {
            PktBody body = packet.getBody();
            int packetType = body.getType();
            this.tracer.log(this.tracePrefix + "Received unknown admin message type '" + packetType + "/'" + body.getClass().getSimpleName() + "': " + packet, Tracer.Level.WARNING);
        }
    }

    @Override
    protected final void onFlushCompletion(ILnkPeerEndpoint.AsynchronousFlushContext flushContext) {
    }

    final int getAdminCompatLevel() throws EClientOpFailedException {
        block7: {
            try {
                String result = (String)this.invokeCommand(5000, "server", "get_admin_compat_level", new Object[0]);
                try {
                    int dot = result.indexOf(46);
                    int adminCompatLevel = dot == -1 ? Integer.parseInt(result) : Integer.parseInt(result.substring(0, dot));
                    if (adminCompatLevel >= 2) {
                        this.adminCompatLevel = adminCompatLevel;
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "adminCompatLevel reported by remote server is " + adminCompatLevel, Tracer.Level.DEBUG);
                        }
                        return this.adminCompatLevel;
                    }
                    this.tracer.log(this.tracePrefix + "Received invalid admin compat level: " + adminCompatLevel, Tracer.Level.WARNING);
                }
                catch (NumberFormatException e) {
                    this.tracer.log(this.tracePrefix + "Received invalid response to get_admin_compat_level: " + result, Tracer.Level.WARNING);
                }
            }
            catch (EAdminClientServerError e) {
                if (!this.tracer.debug) break block7;
                this.tracer.log(this.tracePrefix + "get_admin_compat_level is not supported by the server: " + e.getMessage(), Tracer.Level.DEBUG);
            }
        }
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Falling back to adminCompatLevel 1", Tracer.Level.DEBUG);
        }
        return this.adminCompatLevel;
    }

    final PktPacket messageToPacket(IRogMessage message) {
        PktPacket packet = message.serializeToPacket();
        PktSubheaderSMA.prepare((PktPacket)packet, (byte)((byte)message.getMessageEncodingType()), (short)message.getVfid(), (short)message.getMessageType(), (int)0, (long)0L, (short)0, null);
        return packet;
    }

    final MessageView packetToMessage(PktPacket packet) {
        PktSubheaderSMA smaHeader = packet.getHeader().getSMASubheader();
        PktBody body = packet.getBody();
        int packetType = body.getType();
        if (smaHeader != null) {
            int encoding = smaHeader.getMessageEncodingType();
            short vfid = smaHeader.getMessageViewFactoryId();
            short vtype = smaHeader.getMessageViewType();
            if (vfid == 1 || vfid == 7) {
                vfid = AdmFactory.decodeObjectFactoryIdFromPacketId((int)packetType);
                vtype = AdmFactory.decodeObjectTypeFormPacketId((int)packetType);
                switch (vfid) {
                    case 32: 
                    case 34: 
                    case 35: 
                    case 36: {
                        encoding = 3;
                        break;
                    }
                    default: {
                        if (!this.tracer.debug) break;
                        this.tracer.log(this.tracePrefix + "Received admin packet of a non monitoring factory packet type: " + packetType, Tracer.Level.DEBUG);
                    }
                }
            }
            Object factory = null;
            switch (vfid) {
                case 1: 
                case 7: {
                    factory = null;
                    break;
                }
                case 36: {
                    factory = this.monCncFactory;
                    break;
                }
                case 32: {
                    factory = this.monHeartbeatFactory;
                    break;
                }
                case 35: {
                    factory = this.monAlertFactory;
                    break;
                }
                case 34: {
                    factory = this.monLifecycleFactory;
                    break;
                }
                default: {
                    factory = MessageViewFactoryRegistry.getInstance().getMessageViewFactory(vfid);
                }
            }
            if (factory != null) {
                MessageView view = factory.wrap(vtype, encoding, packet);
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Received Admin Message: " + view, Tracer.Level.DEBUG);
                }
                return view;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <RequestType extends IRogMessage & ISrvMonXvmRequest> PktPacket sendRequest(RequestType requestMessage, long timeout) throws EClientOpTimeoutException, EClientOpFailedException {
        ((ISrvMonXvmRequest)requestMessage).setAdminClientCompatLevel("5");
        PktPacket requestPacket = this.messageToPacket(requestMessage);
        try {
            LnkRequest linkRequest = this.sendSync(requestPacket, (int)timeout);
            LnkRequest.Result linkResult = linkRequest.getResult();
            UtlList replies = linkResult.getReplies();
            if (replies.count() != 1) {
                throw new InternalError("Received reply to admin request with an invalid number of reply elements <exp=1 actual=" + replies.count() + ">");
            }
            PktPacket reply = (PktPacket)replies.first();
            if (reply.getBody().getType() == 559) {
                PktBodyServerAdminReply replyBody = (PktBodyServerAdminReply)reply.getBody();
                String cmdresult = replyBody.getResult();
                if (cmdresult.startsWith("NOK ")) {
                    throw new EAdminClientServerError(cmdresult.substring(cmdresult.indexOf(32), cmdresult.length()).trim());
                }
                throw new EClientOpFailedException("received a command result from the server with an invalid format: " + cmdresult);
            }
            PktPacket pktPacket = reply;
            return pktPacket;
        }
        finally {
            requestPacket.dispose();
            requestMessage.dispose();
        }
    }

    final <CommandType extends IRogMessage & ISrvMonXvmRequest> void sendOneway(CommandType commandMessage) throws EClientOpFailedException {
        ((ISrvMonXvmRequest)commandMessage).setAdminClientCompatLevel("5");
        PktPacket commandPacket = this.messageToPacket(commandMessage);
        try {
            this.sendStreaming(commandPacket, null, 16);
        }
        finally {
            commandPacket.dispose();
            commandMessage.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object invokeCommand(int timeout, String target, String command, Object ... params) throws EClientOpTimeoutException, EAdminClientServerError, EClientOpFailedException {
        if (target == null) {
            throw new IllegalArgumentException("the command target app cannot be null");
        }
        if (command == null) {
            throw new IllegalArgumentException("the command name cannot be null");
        }
        if (this.tracer.isEnabled(Tracer.Level.VERBOSE)) {
            this.tracer.log(this.tracePrefix + "Invoking admin client command '" + command + "' [target=" + target + ", timeout= " + timeout + ", args= " + (params != null ? Arrays.asList(params) : "[]") + "]", Tracer.Level.VERBOSE);
        }
        SrvMonInvokeCommandRequest invokeRequest = SrvMonInvokeCommandRequest.create();
        invokeRequest.setTarget(target);
        invokeRequest.setCommandName(command);
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                invokeRequest.addParameters((String)UtlDataTypes.convert(String.class, (Object)params[i]));
            }
        }
        if (timeout > 0) {
            MessageView reply = this.packetToMessage(this.sendRequest(invokeRequest, timeout));
            if (reply instanceof SrvMonInvokeCommandResponse) {
                SrvMonInvokeCommandResponse response = (SrvMonInvokeCommandResponse)reply;
                try {
                    if (response.hasErrorMessage()) {
                        throw new EAdminClientServerError(response.getErrorMessage());
                    }
                    Object object = SrvMonUtil.getResponseValue(response);
                    return object;
                }
                finally {
                    try {
                        response.dispose();
                    }
                    catch (Throwable thrown) {
                        this.tracer.log(this.tracePrefix + "Error disposing command response container: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.SEVERE);
                    }
                }
            }
            throw new EClientOpFailedException("received a command result from the server with an invalid format: " + reply.getClass());
        }
        this.sendOneway(invokeRequest);
        return null;
    }

    @Override
    public final void open() throws EClientRootException {
        super.open();
    }

    public final void startTraceWatch() throws EClientOpFailedException {
        if (this.traceWatchStarted.compareAndSet(false, true)) {
            boolean success = false;
            try {
                this.sendOneway(SrvMonStartTraceWatchRequest.create());
                success = true;
            }
            finally {
                if (!success) {
                    this.traceWatchStarted.set(false);
                }
            }
        }
    }

    public final void stopTraceWatch() throws EClientOpFailedException {
        if (this.traceWatchStarted.compareAndSet(true, false)) {
            boolean success = false;
            try {
                this.sendOneway(SrvMonStopTraceWatchRequest.create());
                success = true;
            }
            finally {
                if (!success) {
                    this.traceWatchStarted.set(true);
                }
            }
        }
    }

    public final void startAppWatch() throws EClientOpFailedException {
        if (this.appWatchStarted.compareAndSet(false, true)) {
            this.appWatchJoined.set(false);
            boolean success = false;
            try {
                this.sendOneway(SrvMonStartAppWatchCommand.create());
                success = true;
            }
            finally {
                if (!success) {
                    this.appWatchStarted.set(false);
                }
            }
        }
    }

    public final void waitForAppWatchJoin(int timeoutMillis) throws EAdminClientServerError, EClientOpFailedException {
        if (this.appWatchStarted.get()) {
            if (!this.appWatchJoined.get()) {
                this.invokeCommand(timeoutMillis, "server", "app_ping", "admin");
                this.appWatchJoined.set(this.appWatchStarted.get());
            }
        } else {
            throw new IllegalStateException("App watch has not been started");
        }
    }

    public final void stopAppWatch() throws EClientOpFailedException {
        if (this.appWatchStarted.compareAndSet(true, false)) {
            boolean success = false;
            try {
                this.sendOneway(SrvMonStartAppWatchCommand.create());
                success = true;
            }
            finally {
                if (!success) {
                    this.appWatchStarted.set(true);
                }
            }
        }
    }
}

