/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.aep.event;

import com.neeve.event.Event;
import com.neeve.event.EventFactory;
import com.neeve.event.alert.AlertEvent;
import java.util.Date;
import java.util.Properties;

public final class AepStuckAlertEvent
extends AlertEvent {
    private Reason reason;
    private long lastEventProcessedTimestamp;
    private long lastCommitCompletionTimestamp;
    private int incompleteCommitCount;
    private String message;

    private AepStuckAlertEvent() {
        super((short)528);
    }

    public static Event create(Properties props) {
        return new AepStuckAlertEvent();
    }

    public static AepStuckAlertEvent create(Reason reason, long lastEventProcessingTimestamp, long lastCommitCompletionTimestamp, int incompleteCommitCount) {
        return ((AepStuckAlertEvent)EventFactory.getInstance().createEvent((short)528)).init(reason, lastEventProcessingTimestamp, lastCommitCompletionTimestamp, incompleteCommitCount);
    }

    private final AepStuckAlertEvent init(Reason reason, long lastEventProcessingTimestamp, long lastCommitCompletionTimestamp, int incompleteCommitCount) {
        super.init(null);
        this.reason = reason;
        this.lastEventProcessedTimestamp = lastEventProcessingTimestamp;
        this.lastCommitCompletionTimestamp = lastCommitCompletionTimestamp;
        this.incompleteCommitCount = incompleteCommitCount;
        return this;
    }

    final void setLastCommitCompletionTimestamp(long lastCommitCompletionTimestamp) {
        this.lastCommitCompletionTimestamp = lastCommitCompletionTimestamp;
    }

    final void setIncompleteCommitCount(int incompleteCommitCount) {
        this.incompleteCommitCount = incompleteCommitCount;
    }

    public final void setMessage(String message) {
        this.message = message;
    }

    final void setReason(Reason reason) {
        this.reason = reason;
    }

    final void setLastEventProcessedTimestamp(long lastEventProcessedTimestamp) {
        this.lastEventProcessedTimestamp = lastEventProcessedTimestamp;
    }

    protected final void reset() {
        super.reset();
        this.message = null;
        this.reason = null;
        this.lastCommitCompletionTimestamp = -1L;
        this.incompleteCommitCount = -1;
    }

    public Reason getReason() {
        return this.reason;
    }

    public String message() {
        return this.message;
    }

    public long getLastEventProcessedTimestamp() {
        return this.lastEventProcessedTimestamp;
    }

    public long getLastCommitCompletionTimestamp() {
        return this.lastCommitCompletionTimestamp;
    }

    public int getIncompleteCommitCount() {
        return this.incompleteCommitCount;
    }

    public final String toString() {
        return "[event=ENGINE_STUCK_ALERT, reason=" + (Object)((Object)this.reason) + ", lastEventProcessed=" + new Date(this.lastCommitCompletionTimestamp) + ", lastCommitComplete=" + new Date(this.lastCommitCompletionTimestamp) + ", incompleteCommits= " + this.getIncompleteCommitCount() + ", " + super.toString() + "]";
    }

    public static enum Reason {
        HungTransactionPipeline,
        HungEventHandler;

    }
}

