/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.cloud.local.LocalProvisioner;
import com.neeve.tools.AbstractCommand;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class LocalCommand
extends AbstractCommand {
    private static final Set<String> commands = Stream.of("launch-admin", "start-admin", "stop-admin", "terminate-admin", "launch-monitor", "start-monitor", "stop-monitor", "terminate-monitor", "launch-solace", "start-solace", "stop-solace", "terminate-solace", "launch-kafka", "start-kafka", "stop-kafka", "terminate-kafka", "launch-amq", "start-amq", "stop-amq", "terminate-amq", "launch-platform", "start-platform", "stop-platform", "terminate-platform", "launch-container", "start-container", "stop-container", "terminate-container", "run-command", "provision", "deploy", "configure", "start", "stop", "deprovision").collect(Collectors.toCollection(HashSet::new));

    LocalCommand() {
    }

    private final void printTopLevelUsage() {
        System.out.println("");
        System.out.println("      Rumi 'cloud local' commands:");
        System.out.println("");
        System.out.println("         launch-admin           Provision and start Rumi admin");
        System.out.println("         start-admin            Start Rumi admin");
        System.out.println("         stop-admin             Stop Rumi admin");
        System.out.println("         terminate-admin        Terminate Rumi admin");
        System.out.println("         launch-monitor         Provision and start Rumi monitor");
        System.out.println("         start-monitor          Start Rumi monitor");
        System.out.println("         stop-monitor           Stop Rumi monitor");
        System.out.println("         terminate-monitor      Terminate Rumi monitor");
        System.out.println("         launch-solace          Provision and start Solace");
        System.out.println("         start-solace           Start Solace");
        System.out.println("         stop-solace            Stop Solace");
        System.out.println("         terminate-solace       Terminate Solace");
        System.out.println("         launch-kafka           Provision and start Kafka");
        System.out.println("         start-kafka            Start Kafka");
        System.out.println("         stop-kafka             Stop Kafka");
        System.out.println("         terminate-kafka        Terminate Kafka");
        System.out.println("         launch-amq             Provision and start ActiveMQ");
        System.out.println("         start-amq              Start ActiveMQ");
        System.out.println("         stop-amq               Stop ActiveMQ");
        System.out.println("         terminate-amq          Terminate ActiveMQ");
        System.out.println("         launch-platform        Provision and start Rumi platform (admin, monitor)");
        System.out.println("         start-platform         Start Rumi platform (admin, monitor)");
        System.out.println("         stop-platform          Stop Rumi platform (admin, monitor)");
        System.out.println("         terminate-platform     Terminate Rumi platform (admin, monitor)");
        System.out.println("         launch-container       Provision and start a Rumi service container");
        System.out.println("         start-container        Start a Rumi service container");
        System.out.println("         stop-container         Stop a Rumi service container");
        System.out.println("         terminate-container    Terminate a Rumi service container");
        System.out.println("         run-command            Run a command on a Rumi service container");
        System.out.println("         provision              Provision a local Rumi environment");
        System.out.println("         deploy                 Deploy a Rumi system to the local environment");
        System.out.println("         configure              Update a configuration property in the local environment");
        System.out.println("         start                  Start all services in the local environment");
        System.out.println("         stop                   Stop all services in the local environment");
        System.out.println("         deprovision            Deprovision the local Rumi environment");
        System.out.println("");
        System.out.println("      Run 'rumi help cloud local <command>' for help on a specific command");
        System.out.println("");
    }

    private static final AbstractCommand commandHandler(String command) {
        if (command.equals("launch-admin")) {
            return new LaunchAdminCommand();
        }
        if (command.equals("start-admin")) {
            return new StartAdminCommand();
        }
        if (command.equals("stop-admin")) {
            return new StopAdminCommand();
        }
        if (command.equals("terminate-admin")) {
            return new TerminateAdminCommand();
        }
        if (command.equals("launch-monitor")) {
            return new LaunchMonitorCommand();
        }
        if (command.equals("start-monitor")) {
            return new StartMonitorCommand();
        }
        if (command.equals("stop-monitor")) {
            return new StopMonitorCommand();
        }
        if (command.equals("terminate-monitor")) {
            return new TerminateMonitorCommand();
        }
        if (command.equals("launch-solace")) {
            return new LaunchSolaceCommand();
        }
        if (command.equals("start-solace")) {
            return new StartSolaceCommand();
        }
        if (command.equals("stop-solace")) {
            return new StopSolaceCommand();
        }
        if (command.equals("terminate-solace")) {
            return new TerminateSolaceCommand();
        }
        if (command.equals("launch-kafka")) {
            return new LaunchKafkaCommand();
        }
        if (command.equals("start-kafka")) {
            return new StartKafkaCommand();
        }
        if (command.equals("stop-kafka")) {
            return new StopKafkaCommand();
        }
        if (command.equals("terminate-kafka")) {
            return new TerminateKafkaCommand();
        }
        if (command.equals("launch-amq")) {
            return new LaunchActiveMQCommand();
        }
        if (command.equals("start-amq")) {
            return new StartActiveMQCommand();
        }
        if (command.equals("stop-amq")) {
            return new StopActiveMQCommand();
        }
        if (command.equals("terminate-amq")) {
            return new TerminateActiveMQCommand();
        }
        if (command.equals("launch-platform")) {
            return new LaunchPlatformCommand();
        }
        if (command.equals("start-platform")) {
            return new StartPlatformCommand();
        }
        if (command.equals("stop-platform")) {
            return new StopPlatformCommand();
        }
        if (command.equals("terminate-platform")) {
            return new TerminatePlatformCommand();
        }
        if (command.equals("launch-container")) {
            return new LaunchContainerCommand();
        }
        if (command.equals("start-container")) {
            return new StartContainerCommand();
        }
        if (command.equals("stop-container")) {
            return new StopContainerCommand();
        }
        if (command.equals("terminate-container")) {
            return new TerminateContainerCommand();
        }
        if (command.equals("run-command")) {
            return new RunCommandCommand();
        }
        if (command.equals("provision")) {
            return new ProvisionEnvironmentCommand();
        }
        if (command.equals("deploy")) {
            return new DeploySystemCommand();
        }
        if (command.equals("configure")) {
            return new ConfigureCommand();
        }
        if (command.equals("start")) {
            return new StartEnvironmentCommand();
        }
        if (command.equals("stop")) {
            return new StopEnvironmentCommand();
        }
        if (command.equals("deprovision")) {
            return new DeprovisionEnvironmentCommand();
        }
        throw new IllegalArgumentException("unknown command '" + command + "'");
    }

    @Override
    final void help(String[] args) {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (commands.contains(command)) {
                LocalCommand.commandHandler(command).help(null);
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    @Override
    final void execute(String[] args) throws Exception {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (commands.contains(command)) {
                LocalCommand.commandHandler(command).execute(args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    private static final class DeprovisionEnvironmentCommand
    extends AbstractCommand {
        private DeprovisionEnvironmentCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local deprovision' - deprovisions the local environment");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            DeprovisionEnvironmentCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().deprovisionEnvironment();
        }
    }

    private static final class StopEnvironmentCommand
    extends AbstractCommand {
        private StopEnvironmentCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop' - stops all services in the local environment");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopEnvironmentCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopEnvironment();
        }
    }

    private static final class StartEnvironmentCommand
    extends AbstractCommand {
        private StartEnvironmentCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start' - starts all services in the local environment");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartEnvironmentCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startEnvironment();
        }
    }

    private static final class ConfigureCommand
    extends AbstractCommand {
        private ConfigureCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local configure <args>' where args are:");
            System.out.println("          [{-s, --section the configuration section] (required)");
            System.out.println("          [{-k, --key the property key] (required)");
            System.out.println("          [{-v, --value the property value (use 'null' to remove)] (required)");
            System.out.println("          [{-f, --file the config file path] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ConfigureCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option sectionOption = parser.addStringOption('s', "section");
            CmdLineParser.Option keyOption = parser.addStringOption('k', "key");
            CmdLineParser.Option valueOption = parser.addStringOption('v', "value");
            CmdLineParser.Option fileOption = parser.addStringOption('f', "file");
            parser.parse(args);
            String section = (String)parser.getOptionValue(sectionOption, null);
            String key = (String)parser.getOptionValue(keyOption, null);
            String value = (String)parser.getOptionValue(valueOption, null);
            String file = (String)parser.getOptionValue(fileOption, null);
            if (section != null && key != null && value != null && file != null) {
                LocalProvisioner.create().updateConfig(section, key, value, file);
            } else {
                ConfigureCommand.printUsage();
            }
        }
    }

    private static final class DeploySystemCommand
    extends AbstractCommand {
        private DeploySystemCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local deploy <args>' where args are:");
            System.out.println("          [{-x, --xar the xar file to deploy] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            DeploySystemCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option xarOption = parser.addStringOption('x', "xar");
            parser.parse(args);
            String xarPath = (String)parser.getOptionValue(xarOption, null);
            if (xarPath != null) {
                LocalProvisioner.create().deploySystem(new File(xarPath));
            } else {
                DeploySystemCommand.printUsage();
            }
        }
    }

    private static final class ProvisionEnvironmentCommand
    extends AbstractCommand {
        private ProvisionEnvironmentCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local provision <args>' where args are:");
            System.out.println("          [{-b, --message-broker the messaging broker to provision] (default=<no broker>)");
            System.out.println("                                 valid values: solace, kafka, activemq");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ProvisionEnvironmentCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option messageBrokerOption = parser.addStringOption('b', "message-broker");
            parser.parse(args);
            String messageBroker = (String)parser.getOptionValue(messageBrokerOption, null);
            if (messageBroker != null) {
                LocalProvisioner.create().provisionEnvironmentWithMessageBroker(messageBroker);
            } else {
                LocalProvisioner.create().provisionEnvironment();
            }
        }
    }

    private static final class RunCommandCommand
    extends AbstractCommand {
        private RunCommandCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local run-command <args>' where args are:");
            System.out.println("          [{-n, --name the name of the service container] (required)");
            System.out.println("          [{-c, --command the command to run] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            RunCommandCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option commandOption = parser.addStringOption('c', "command");
            parser.parse(args);
            String name = (String)parser.getOptionValue(nameOption, null);
            String command = (String)parser.getOptionValue(commandOption, null);
            if (name != null && command != null) {
                LocalProvisioner.create().runCommandOnServiceContainer(name, command);
            } else {
                RunCommandCommand.printUsage();
            }
        }
    }

    private static final class TerminateContainerCommand
    extends AbstractCommand {
        private TerminateContainerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-container <args>' where args are:");
            System.out.println("          [{-n, --name the name of the service container] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateContainerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            parser.parse(args);
            String name = (String)parser.getOptionValue(nameOption, null);
            if (name != null) {
                LocalProvisioner.create().terminateServiceContainer(name);
            } else {
                TerminateContainerCommand.printUsage();
            }
        }
    }

    private static final class StopContainerCommand
    extends AbstractCommand {
        private StopContainerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-container <args>' where args are:");
            System.out.println("          [{-n, --name the name of the service container] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopContainerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            parser.parse(args);
            String name = (String)parser.getOptionValue(nameOption, null);
            if (name != null) {
                LocalProvisioner.create().stopServiceContainer(name);
            } else {
                StopContainerCommand.printUsage();
            }
        }
    }

    private static final class StartContainerCommand
    extends AbstractCommand {
        private StartContainerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-container <args>' where args are:");
            System.out.println("          [{-n, --name the name of the service container] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartContainerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            parser.parse(args);
            String name = (String)parser.getOptionValue(nameOption, null);
            if (name != null) {
                LocalProvisioner.create().startServiceContainer(name);
            } else {
                StartContainerCommand.printUsage();
            }
        }
    }

    private static final class LaunchContainerCommand
    extends AbstractCommand {
        private LaunchContainerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-container <args>' where args are:");
            System.out.println("          [{-n, --name the name of the service container] (required)");
            System.out.println("          [{-h, --hostname the hostname for the service] (required)");
            System.out.println("          [{-p, --ports the comma separated set of service ports to expose] (default=null)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchContainerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option hostnameOption = parser.addStringOption('h', "hostname");
            CmdLineParser.Option portsOption = parser.addStringOption('p', "ports");
            parser.parse(args);
            String name = (String)parser.getOptionValue(nameOption, null);
            String hostname = (String)parser.getOptionValue(hostnameOption, null);
            String commaSeparatedPorts = (String)parser.getOptionValue(portsOption, null);
            if (name != null && hostname != null) {
                if (commaSeparatedPorts != null && !commaSeparatedPorts.trim().isEmpty()) {
                    int[] ports = Arrays.stream(commaSeparatedPorts.split(",")).map(String::trim).mapToInt(Integer::parseInt).toArray();
                    LocalProvisioner.create().launchServiceContainer(name, hostname, ports);
                } else {
                    LocalProvisioner.create().launchServiceContainer(name, hostname);
                }
            } else {
                LaunchContainerCommand.printUsage();
            }
        }
    }

    private static final class TerminatePlatformCommand
    extends AbstractCommand {
        private TerminatePlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-platform' - terminates Rumi platform (admin and monitor)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminatePlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().terminatePlatform();
        }
    }

    private static final class StopPlatformCommand
    extends AbstractCommand {
        private StopPlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-platform' - stops Rumi platform (admin and monitor)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopPlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopPlatform();
        }
    }

    private static final class StartPlatformCommand
    extends AbstractCommand {
        private StartPlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-platform' - starts Rumi platform (admin and monitor)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartPlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startPlatform();
        }
    }

    private static final class LaunchPlatformCommand
    extends AbstractCommand {
        private LaunchPlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-platform' - launches Rumi platform (admin and monitor)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchPlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().launchPlatform();
        }
    }

    private static final class TerminateActiveMQCommand
    extends AbstractCommand {
        private TerminateActiveMQCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-amq' - terminates ActiveMQ");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateActiveMQCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().terminateActiveMQBroker();
        }
    }

    private static final class StopActiveMQCommand
    extends AbstractCommand {
        private StopActiveMQCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-amq' - stops ActiveMQ");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopActiveMQCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopActiveMQBroker();
        }
    }

    private static final class StartActiveMQCommand
    extends AbstractCommand {
        private StartActiveMQCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-amq' - starts ActiveMQ");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartActiveMQCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startActiveMQBroker();
        }
    }

    private static final class LaunchActiveMQCommand
    extends AbstractCommand {
        private LaunchActiveMQCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-amq' - launches ActiveMQ");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchActiveMQCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().launchActiveMQBroker();
        }
    }

    private static final class TerminateKafkaCommand
    extends AbstractCommand {
        private TerminateKafkaCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-kafka' - terminates Kafka");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateKafkaCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().terminateKafkaBroker();
        }
    }

    private static final class StopKafkaCommand
    extends AbstractCommand {
        private StopKafkaCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-kafka' - stops Kafka");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopKafkaCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopKafkaBroker();
        }
    }

    private static final class StartKafkaCommand
    extends AbstractCommand {
        private StartKafkaCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-kafka' - starts Kafka");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartKafkaCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startKafkaBroker();
        }
    }

    private static final class LaunchKafkaCommand
    extends AbstractCommand {
        private LaunchKafkaCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-kafka' - launches Kafka");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchKafkaCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().launchKafkaBroker();
        }
    }

    private static final class TerminateSolaceCommand
    extends AbstractCommand {
        private TerminateSolaceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-solace' - terminates Solace");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateSolaceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().terminateSolaceBroker();
        }
    }

    private static final class StopSolaceCommand
    extends AbstractCommand {
        private StopSolaceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-solace' - stops Solace");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopSolaceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopSolaceBroker();
        }
    }

    private static final class StartSolaceCommand
    extends AbstractCommand {
        private StartSolaceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-solace' - starts Solace");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartSolaceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startSolaceBroker();
        }
    }

    private static final class LaunchSolaceCommand
    extends AbstractCommand {
        private LaunchSolaceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-solace' - launches Solace");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchSolaceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().launchSolaceBroker();
        }
    }

    private static final class TerminateMonitorCommand
    extends AbstractCommand {
        private TerminateMonitorCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-monitor' - terminates Rumi monitor");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateMonitorCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().terminateMonitor();
        }
    }

    private static final class StopMonitorCommand
    extends AbstractCommand {
        private StopMonitorCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-monitor' - stops Rumi monitor");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopMonitorCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopMonitor();
        }
    }

    private static final class StartMonitorCommand
    extends AbstractCommand {
        private StartMonitorCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-monitor' - starts Rumi monitor");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartMonitorCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startMonitor();
        }
    }

    private static final class LaunchMonitorCommand
    extends AbstractCommand {
        private LaunchMonitorCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-monitor' - launches Rumi monitor");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchMonitorCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().launchMonitor();
        }
    }

    private static final class TerminateAdminCommand
    extends AbstractCommand {
        private TerminateAdminCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-admin' - terminates Rumi admin");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateAdminCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().terminateAdmin();
        }
    }

    private static final class StopAdminCommand
    extends AbstractCommand {
        private StopAdminCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-admin' - stops Rumi admin");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopAdminCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopAdmin();
        }
    }

    private static final class StartAdminCommand
    extends AbstractCommand {
        private StartAdminCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-admin' - starts Rumi admin");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartAdminCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startAdmin();
        }
    }

    private static final class LaunchAdminCommand
    extends AbstractCommand {
        private LaunchAdminCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-admin' - launches Rumi admin");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchAdminCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().launchAdmin();
        }
    }
}

