/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.lmax.disruptor.AlertException;
import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.DataProvider;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventProcessor;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.neeve.config.Config;
import com.neeve.util.UtlThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public final class UtlDisruptor {
    private static final SequenceBarrier asIntrumentedSequenceBarrier(SequenceBarrier barrier) {
        if (UtlThread.threadWaitStatsEnabled()) {
            return new WaitTrackingSequenceBarrier(barrier);
        }
        return barrier;
    }

    public static final ProducerType legacyClaimStrategyStrToProducerType(String claimStrategyStr) {
        if (claimStrategyStr.equalsIgnoreCase("SingleThreaded")) {
            return ProducerType.SINGLE;
        }
        if (claimStrategyStr.equalsIgnoreCase("MultiThreaded") || claimStrategyStr.equalsIgnoreCase("MultiThreadedSufficientCores")) {
            return ProducerType.MULTI;
        }
        throw new IllegalArgumentException("invalid publisher claim strategy '" + claimStrategyStr + "'");
    }

    public static final String toProducerTypeStr(ProducerType producerType) {
        switch (producerType) {
            case SINGLE: {
                return "SingleThreaded";
            }
            case MULTI: {
                return "MultiThreaded";
            }
        }
        throw new IllegalArgumentException("unknown producer type '" + producerType + "'");
    }

    public static final WaitStrategy getWaitStrategy(String configuredWaitStrategy, boolean optimize) throws IllegalArgumentException {
        BlockingWaitStrategy waitStrategy;
        String waitStrategyStr;
        String string = waitStrategyStr = configuredWaitStrategy == null ? "Blocking" : configuredWaitStrategy;
        if (Config.conserveCPU()) {
            return new BlockingWaitStrategy();
        }
        if (optimize && configuredWaitStrategy == null && !Config.disableDisruptorWaitStrategyOptimizations()) {
            if (Config.tuneForLatency()) {
                waitStrategyStr = "BusySpin";
            } else if (Config.tuneForThroughput()) {
                waitStrategyStr = "Yielding";
            }
        }
        if (waitStrategyStr.equalsIgnoreCase("Blocking")) {
            waitStrategy = new BlockingWaitStrategy();
        } else if (waitStrategyStr.equalsIgnoreCase("Sleeping")) {
            waitStrategy = new SleepingWaitStrategy();
        } else if (waitStrategyStr.equalsIgnoreCase("Yielding")) {
            waitStrategy = new YieldingWaitStrategy();
        } else if (waitStrategyStr.equalsIgnoreCase("BusySpin")) {
            waitStrategy = new BusySpinWaitStrategy();
        } else {
            throw new IllegalArgumentException("invalid wait strategy '" + waitStrategyStr + "'");
        }
        return waitStrategy;
    }

    public static final String waitStrategyToStr(WaitStrategy waitStrategy) {
        if (waitStrategy instanceof BlockingWaitStrategy) {
            return "Blocking";
        }
        if (waitStrategy instanceof SleepingWaitStrategy) {
            return "Sleeping";
        }
        if (waitStrategy instanceof YieldingWaitStrategy) {
            return "Yielding";
        }
        if (waitStrategy instanceof BusySpinWaitStrategy) {
            return "BusySpin";
        }
        throw new IllegalArgumentException("invalid writer wait strategy '" + waitStrategy + "'");
    }

    public static final <T> Disruptor<T> createSingleConsumerDisruptor(EventFactory<T> eventFactory, int size, ThreadFactory threadFactory, ProducerType producerType, WaitStrategy waitStrategy, EventHandler<T> eventHandler) {
        Disruptor disruptor = new Disruptor(eventFactory, size, (ThreadFactory)new SingleConsumerDisruptorThreadFactory(threadFactory), producerType, waitStrategy);
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        SequenceBarrier sequenceBarrier = UtlDisruptor.asIntrumentedSequenceBarrier(ringBuffer.newBarrier(new Sequence[0]));
        BatchEventProcessor batchProcessor = new BatchEventProcessor((DataProvider)ringBuffer, sequenceBarrier, eventHandler);
        if (eventHandler instanceof ExceptionHandler) {
            disruptor.setDefaultExceptionHandler((ExceptionHandler)eventHandler);
        }
        disruptor.handleEventsWith(new EventProcessor[]{batchProcessor});
        return disruptor;
    }

    private static final class WaitTrackingSequenceBarrier
    implements SequenceBarrier {
        private final SequenceBarrier delegate;
        private UtlThread.ThreadStats threadStats;

        WaitTrackingSequenceBarrier(SequenceBarrier sequenceBarrier) {
            this.delegate = sequenceBarrier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final long waitFor(long sequence) throws AlertException, TimeoutException, InterruptedException {
            if (this.threadStats == null) {
                this.threadStats = UtlThread.registerOrGetThreadStats(Thread.currentThread());
            }
            this.threadStats.preWait();
            try {
                long l = this.delegate.waitFor(sequence);
                return l;
            }
            finally {
                this.threadStats.postWait();
            }
        }

        public final long getCursor() {
            return this.delegate.getCursor();
        }

        public final boolean isAlerted() {
            return this.delegate.isAlerted();
        }

        public final void alert() {
            this.delegate.alert();
        }

        public final void clearAlert() {
            this.delegate.clearAlert();
        }

        public final void checkAlert() throws AlertException {
            this.delegate.checkAlert();
        }
    }

    private static final class SingleConsumerDisruptorThreadFactory
    implements ThreadFactory {
        private final ThreadFactory delegate;
        private final AtomicBoolean threadCreated;

        SingleConsumerDisruptorThreadFactory(ThreadFactory threadFactory) {
            this.delegate = threadFactory;
            this.threadCreated = new AtomicBoolean();
        }

        @Override
        public final Thread newThread(Runnable r) {
            if (this.threadCreated.compareAndSet(false, true)) {
                return this.delegate.newThread(r);
            }
            throw new InternalError("multiple threads constructed for single consumer thread factory");
        }
    }
}

