/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.neeve.query.QueryResult;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryAggregateField;
import com.neeve.query.impl.QueryCompositeResult;
import com.neeve.query.impl.QueryResultImpl;
import com.neeve.query.impl.QueryResultSetImpl;
import com.neeve.query.impl.util.collect.UtlSorted;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class QueryOrderedAggregateResult<REC>
extends QueryCompositeResult<REC> {
    private QueryResultSetImpl<?, REC> resultSet;
    private UtlSorted.InterleaveComparator<QueryResultSet.Row<REC>> iteratorComparator;

    public QueryOrderedAggregateResult(QueryResultSetImpl<?, REC> resultSet, List<QueryResult<REC>> queryResults, Comparator<QueryResultSet.Row<REC>> rowComparator) {
        super(queryResults);
        this.resultSet = resultSet;
        this.iteratorComparator = UtlSorted.InterleaveComparator.create(rowComparator);
    }

    @Override
    public Iterator<QueryResultSet.Row<REC>> iterator() {
        ArrayList iterList = Lists.newArrayList();
        for (QueryResult qr : this.queryResults) {
            QueryResultImpl queryResult = (QueryResultImpl)qr;
            QueryResultImpl.QueryResultIterator iter = queryResult.iterator();
            if (!iter.hasNext()) continue;
            iterList.add(iter);
        }
        if (iterList.isEmpty()) {
            return ImmutableSet.of().iterator();
        }
        if (iterList.size() == 1) {
            return (Iterator)iterList.get(0);
        }
        final PriorityQueue<QueryResultSet.Row<REC>> iterators = new PriorityQueue<QueryResultSet.Row<REC>>(iterList.size(), this.iteratorComparator);
        iterators.addAll(iterList);
        return new AbstractIterator<QueryResultSet.Row<REC>>(){

            private QueryAggregateField.Aggregate<REC> extractAggregate(QueryResultSet.Row<REC> row) {
                QueryResultSetImpl.RowImpl rowImpl = (QueryResultSetImpl.RowImpl)row;
                return rowImpl.getAggregate();
            }

            protected QueryResultSet.Row<REC> computeNext() {
                QueryResultImpl.QueryResultIterator iterator = (QueryResultImpl.QueryResultIterator)iterators.poll();
                if (!iterator.hasNext()) {
                    return (QueryResultSet.Row)this.endOfData();
                }
                Object row = iterator.next();
                iterators.offer(iterator);
                QueryAggregateField.Aggregate aggregate = this.extractAggregate((QueryResultSet.Row)row);
                QueryAggregateField.Key key = aggregate.getKey();
                boolean onCurrentKey = true;
                while (onCurrentKey) {
                    QueryResultImpl.QueryResultIterator iter2 = (QueryResultImpl.QueryResultIterator)iterators.poll();
                    if (iter2.hasNext()) {
                        Object row2 = iter2.peek();
                        QueryAggregateField.Aggregate aggregate2 = this.extractAggregate((QueryResultSet.Row)row2);
                        QueryAggregateField.Key key2 = aggregate2.getKey();
                        if (key2.equals(key)) {
                            iter2.next();
                            aggregate = aggregate.merge(aggregate2);
                        } else {
                            onCurrentKey = false;
                        }
                    } else {
                        onCurrentKey = false;
                    }
                    iterators.offer(iter2);
                }
                return QueryOrderedAggregateResult.this.resultSet.forAggregate(aggregate);
            }
        };
    }
}

