/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Command;
import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.controller.XVM;
import com.neeve.controller.util.ProcessHelper;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlThrowable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;

final class Deploy
extends Command {
    private Controller _controller;
    private String _sshUser;
    private String _sshKeyFile;
    private XVM _xvm;
    private boolean fullyProvided;

    Deploy(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        super(controller, progressMonitorHelper, system, script, lineNum, line);
        this._controller = controller;
    }

    private final ProcessBuilder createDeployer() {
        if (!(this._xvm.host().equals(".") || this._sshUser != null && this._sshKeyFile != null)) {
            this.error("ssh user and key file needs to be provided for remote execution");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.resolveScript("rucdeploy"));
        command.add(this._xvm.host().equals(".") ? "sh" : "ssh");
        command.add(this._xvm.runDir());
        command.add(this.system().getJarsDir().getAbsolutePath());
        command.add(this.system().getResourcesDir().exists() ? this.system().getResourcesDir().getAbsolutePath().toString() : "none");
        command.add(this.getDistributionPlatform());
        command.add(this.fullyProvided ? "true" : "false");
        if (!this._xvm.host().equals(".")) {
            command.add(this._sshUser + "@" + this._xvm.host());
            command.add(this._sshKeyFile);
            command.add(String.valueOf(this._xvm.sshPort()));
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        ProcessHelper.cleanEnvironment(pb.environment());
        return pb;
    }

    private final void syntaxError(int lineNum) {
        this.error("Line " + lineNum + ": Syntax error: deploy to the <xvmName> xvm | to all xvms [fully provided]");
    }

    @Override
    final String name() {
        return "deploy";
    }

    @Override
    final boolean parse(Command.Args tokenizer) {
        String token;
        this._sshUser = this.getSshUser();
        this._sshKeyFile = this.getSshKeyFile();
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("to")) {
            this.syntaxError(this.lineNum());
        }
        if ((token = tokenizer.nextToken()).equals("the")) {
            if (!tokenizer.hasMoreTokens()) {
                this.syntaxError(this.lineNum());
            }
            token = tokenizer.nextToken();
            this._xvm = this.system().getXVM(token);
            if (this._xvm == null) {
                this.error("Line " + this.lineNum() + ": XVM '" + token + "' is not configured in the '" + this.system().getHome().getName() + "' system");
            }
            if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvm")) {
                this.syntaxError(this.lineNum());
            }
        } else if (token.equals("all")) {
            if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvms")) {
                this.syntaxError(this.lineNum());
            }
        } else {
            this.syntaxError(this.lineNum());
        }
        if (tokenizer.hasMoreTokens()) {
            if (tokenizer.nextToken().equalsIgnoreCase("fully")) {
                if (tokenizer.hasMoreTokens() && tokenizer.nextToken().equalsIgnoreCase("provided")) {
                    this.fullyProvided = true;
                } else {
                    this.syntaxError(this.lineNum());
                }
            } else {
                this.syntaxError(this.lineNum());
            }
        }
        return true;
    }

    @Override
    final void execute() {
        block12: {
            try {
                String line;
                if (this._xvm == null) {
                    Iterator<XVM> iterator = this.system().getXVMs().iterator();
                    while (iterator.hasNext()) {
                        XVM xvm;
                        this._xvm = xvm = iterator.next();
                        this.execute();
                    }
                    return;
                }
                if (this.mock()) break block12;
                this.info("......deploying to '" + this._xvm.name() + "' ('" + this._xvm.toString() + "')...");
                File extDir = new File(this._controller.getExtDir());
                if (extDir.exists()) {
                    this.troubleshootingInfo("......copying ext jars from '" + extDir + "' to '" + this.system().getJarsDir() + "'...");
                    try {
                        UtlFile.copyDirectory((File)extDir, (File)this.system().getJarsDir());
                    }
                    catch (IOException e) {
                        this.warning("Failed to copy jars from ext directory ('" + extDir + "') to system jars directory ('" + this.system().getJarsDir() + "') :" + UtlThrowable.prepareStackTrace((Throwable)e));
                        return;
                    }
                }
                ProcessBuilder pb = this.createDeployer();
                Process process = pb.start();
                BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = br.readLine()) != null) {
                    this.troubleshootingInfo(line);
                }
                while (true) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                if (process.exitValue() != 0) {
                    this.error("Deploy failed [exit code '" + process.exitValue() + "']");
                }
            }
            catch (Exception e) {
                this.error("Deploy failed [" + e.toString() + "]", e);
            }
        }
    }

    @Override
    final void cleanup() {
    }
}

