/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.tck;

import com.neeve.aep.AepBusConnection;
import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.config.Config;
import com.neeve.event.Event;
import com.neeve.event.IEventHandler;
import com.neeve.lang.XString;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.server.app.annotations.AppHAPolicy;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.server.mon.alert.SrvMonUnhandledMessageMessage;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusBindingFactory;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaPermanentException;
import com.neeve.sma.event.MessageEvent;
import com.neeve.sma.event.UnhandledMessageEvent;
import com.neeve.sma.tck.AbstractSMATckServerTest;
import com.neeve.sma.tck.AbstractSMATckTestApp;
import com.neeve.sma.tck.SMATckFactory;
import com.neeve.sma.tck.SMATckMessage;
import com.neeve.sma.tck.SMATckProviderHelper;
import com.neeve.sma.tck.SMATckTestServer;
import com.neeve.sma.tck.SMATckUnknownMessage;
import com.neeve.util.UtlGovernor;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public abstract class SMATckAepTests
extends AbstractSMATckServerTest {
    protected final String F_BE_1;
    protected final String F_BE_2;
    protected final String F_BE_3;
    protected final String F_BE_FILTER;
    protected final String F_GUAR_1;
    protected final String F_GUAR_2;
    protected final String F_GUAR_3;
    protected final String F_GUAR_FILTER;
    protected final String F_BE_REP_1;
    protected final String F_BE_REP_2;
    protected final String F_BE_REP_3;
    protected final String F_GUAR_REP_1;
    protected final String F_GUAR_REP_2;
    protected final String F_GUAR_REP_3;
    protected final String R_BE_1;
    protected final String R_BE_2;
    protected final String R_BE_3;
    protected final String R_GUAR_1;
    protected final String R_GUAR_2;
    protected final String R_GUAR_3;
    protected final String R_BE_REP_1;
    protected final String R_BE_REP_2;
    protected final String R_BE_REP_3;
    protected final String R_GUAR_REP_1;
    protected final String R_GUAR_REP_2;
    protected final String R_GUAR_REP_3;
    protected static final int F = 0;
    protected static final int R = 1;
    protected static final int BE = 0;
    protected static final int GUAR = 1;
    protected static final int REQ = 0;
    protected static final int REP = 1;
    protected final String[][][][] CHANNELS = new String[2][2][2][4];
    private static Sender sender;
    private static Forwarder forwarder;
    private static Receiver receiver;

    public SMATckAepTests() {
        this.F_BE_1 = "F_BE_1@" + this.getForwarderBusName();
        this.F_BE_2 = "F_BE_2@" + this.getForwarderBusName();
        this.F_BE_3 = "F_BE_3@" + this.getForwarderBusName();
        this.F_BE_FILTER = "F_BE_FILTER@" + this.getForwarderBusName();
        this.F_GUAR_1 = "F_GUAR_1@" + this.getForwarderBusName();
        this.F_GUAR_2 = "F_GUAR_2@" + this.getForwarderBusName();
        this.F_GUAR_3 = "F_GUAR_3@" + this.getForwarderBusName();
        this.F_GUAR_FILTER = "F_GUAR_FILTER@" + this.getForwarderBusName();
        this.F_BE_REP_1 = "F_BE_REP_1@" + this.getForwarderBusName();
        this.F_BE_REP_2 = "F_BE_REP_2@" + this.getForwarderBusName();
        this.F_BE_REP_3 = "F_BE_REP_3@" + this.getForwarderBusName();
        this.F_GUAR_REP_1 = "F_GUAR_REP_1@" + this.getForwarderBusName();
        this.F_GUAR_REP_2 = "F_GUAR_REP_2@" + this.getForwarderBusName();
        this.F_GUAR_REP_3 = "F_GUAR_REP_3@" + this.getForwarderBusName();
        this.R_BE_1 = "R_BE_1@" + this.getReceiverBusName();
        this.R_BE_2 = "R_BE_2@" + this.getReceiverBusName();
        this.R_BE_3 = "R_BE_3@" + this.getReceiverBusName();
        this.R_GUAR_1 = "R_GUAR_1@" + this.getReceiverBusName();
        this.R_GUAR_2 = "R_GUAR_2@" + this.getReceiverBusName();
        this.R_GUAR_3 = "R_GUAR_3@" + this.getReceiverBusName();
        this.R_BE_REP_1 = "R_BE_REP_1@" + this.getReceiverBusName();
        this.R_BE_REP_2 = "R_BE_REP_2@" + this.getReceiverBusName();
        this.R_BE_REP_3 = "R_BE_REP_3@" + this.getReceiverBusName();
        this.R_GUAR_REP_1 = "R_GUAR_REP_1@" + this.getReceiverBusName();
        this.R_GUAR_REP_2 = "R_GUAR_REP_2@" + this.getReceiverBusName();
        this.R_GUAR_REP_3 = "R_GUAR_REP_3@" + this.getReceiverBusName();
        this.CHANNELS[0][0][0][1] = this.F_BE_1;
        this.CHANNELS[0][0][0][2] = this.F_BE_2;
        this.CHANNELS[0][0][0][3] = this.F_BE_3;
        this.CHANNELS[0][0][1][1] = this.F_BE_REP_1;
        this.CHANNELS[0][0][1][2] = this.F_BE_REP_2;
        this.CHANNELS[0][0][1][3] = this.F_BE_REP_3;
        this.CHANNELS[0][1][0][1] = this.F_GUAR_1;
        this.CHANNELS[0][1][0][2] = this.F_GUAR_2;
        this.CHANNELS[0][1][0][3] = this.F_GUAR_3;
        this.CHANNELS[0][1][1][1] = this.F_GUAR_REP_1;
        this.CHANNELS[0][1][1][2] = this.F_GUAR_REP_2;
        this.CHANNELS[0][1][1][3] = this.F_GUAR_REP_3;
        this.CHANNELS[1][0][0][1] = this.R_BE_1;
        this.CHANNELS[1][0][0][2] = this.R_BE_2;
        this.CHANNELS[1][0][0][3] = this.R_BE_3;
        this.CHANNELS[1][0][1][1] = this.R_BE_REP_1;
        this.CHANNELS[1][0][1][2] = this.R_BE_REP_2;
        this.CHANNELS[1][0][1][3] = this.R_BE_REP_3;
        this.CHANNELS[1][1][0][1] = this.R_GUAR_1;
        this.CHANNELS[1][1][0][2] = this.R_GUAR_2;
        this.CHANNELS[1][1][0][3] = this.R_GUAR_3;
        this.CHANNELS[1][1][1][1] = this.R_GUAR_REP_1;
        this.CHANNELS[1][1][1][2] = this.R_GUAR_REP_2;
        this.CHANNELS[1][1][1][3] = this.R_GUAR_REP_3;
    }

    private final Map<String, String> makeDefaultConfigOverrides() {
        HashMap<String, String> configOverrides = new HashMap<String, String>();
        configOverrides.put("ddlPath", "/com/neeve/sma/tck/sma-tck-descriptor.xml");
        configOverrides.put("receiver.bus.descriptor", this.getReceiverBusDescriptor());
        configOverrides.put("forwarder.bus.descriptor", this.getForwarderBusDescriptor());
        configOverrides.put("receiver.bus.name", this.getReceiverBusName());
        configOverrides.put("forwarder.bus.name", this.getForwarderBusName());
        configOverrides.put("outbound.message.logging.policy", "UseDedicated");
        configOverrides.put("nv.aep.duplicate.checking", "true");
        return configOverrides;
    }

    @Before
    public void setup() throws Throwable {
        MessageViewFactoryRegistry.getInstance().registerMessageViewFactory(SMATckFactory.class.getName());
        Map<String, String> configOverrides = this.makeDefaultConfigOverrides();
        if (forwarder == null) {
            forwarder = SMATckAepTests.createApp("sma-tck-forwarder", "primary", Forwarder.class, new HashMap<String, String>(configOverrides));
        }
        if (receiver == null) {
            receiver = SMATckAepTests.createApp("sma-tck-receiver", "primary", Receiver.class, new HashMap<String, String>(configOverrides));
        }
        if (sender == null) {
            sender = SMATckAepTests.createApp("sma-tck-sender", "primary", Sender.class, new HashMap<String, String>(configOverrides));
        }
        sender.getEngine().waitForMessagingToStart();
        sender.waitForChannelUp(this.F_BE_1, 300L);
        forwarder.getEngine().waitForMessagingToStart();
        forwarder.waitForChannelUp(this.R_BE_1, 10L);
        receiver.getEngine().waitForMessagingToStart();
        receiver.waitForChannelUp(this.R_BE_REP_1, 10L);
    }

    @After
    public void cleanup() throws Exception {
        Thread.sleep(100L);
        this.ensureAcksFlushed(sender);
        this.ensureAcksFlushed(forwarder);
        this.ensureAcksFlushed(receiver);
        Thread.sleep(100L);
        if (sender != null) {
            sender.reset();
        }
        if (forwarder != null) {
            forwarder.reset();
        }
        if (receiver != null) {
            receiver.reset();
        }
    }

    protected abstract SMATckProviderHelper getTckHelper(MessageBusBinding var1);

    protected abstract String getReceiverBusDescriptor();

    protected abstract String getForwarderBusDescriptor();

    protected boolean impactedByXPLATFORM1440() {
        return false;
    }

    protected boolean supportsMessageKeyTransport() {
        return true;
    }

    protected boolean supportsTransportMessageId() {
        return true;
    }

    protected boolean supportsGuaranteedMessaging() {
        return true;
    }

    protected boolean supportsChannelFilters() {
        return true;
    }

    protected boolean supportsCyclicGuaranteedMessages() {
        return true;
    }

    protected boolean supportsOriginTsPropagation() {
        return true;
    }

    protected boolean supportsPreWireTsPropagation() {
        return true;
    }

    protected boolean supportsIndividualAcknowledgements() {
        return true;
    }

    protected boolean supportsWildcardSubscriptions() {
        return true;
    }

    protected String getReceiverBusName() {
        return "sma-tck-receiver-bus";
    }

    protected String getForwarderBusName() {
        return "sma-tck-forwarder-bus";
    }

    private final SMATckMessage createTestMessage() {
        SMATckMessage message = SMATckMessage.create();
        message.setStringField(this.testcaseName.getMethodName());
        return message;
    }

    @Test
    public void testSenderForwarderReceiverBestEffort() throws Throwable {
        this.testSenderForwarderReceiver(false, false, false);
    }

    @Test
    public void testSenderForwarderReceiverGuaranteed() throws Throwable {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testSenderForwarderReceiver(true, false, false);
    }

    @Test
    public void testSenderForwarderReceiverBestEffortCompareMessages() throws Throwable {
        this.testSenderForwarderReceiver(false, true, false);
    }

    @Test
    public void testSenderForwarderReceiverGuaranteedCompareMessages() throws Throwable {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testSenderForwarderReceiver(true, true, false);
    }

    @Test
    @Ignore
    public void testSenderForwarderReceiverGuaranteedWithRestart() throws Throwable {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testSenderForwarderReceiver(true, true, true);
    }

    private void testSenderForwarderReceiver(boolean guaranteed, boolean compareMessages, final boolean restartForwarder) throws Throwable {
        final int QOS = guaranteed ? 1 : 0;
        final boolean responsesEnabled = !guaranteed || this.supportsCyclicGuaranteedMessages();
        int sendCount = 100;
        if (responsesEnabled) {
            this.workAroundXPLATFORM1494();
        }
        sender.setHoldMessages(compareMessages);
        forwarder.setHoldMessages(compareMessages);
        forwarder.setHandler(SMATckMessage.class, new SMATCKMessageHandler<SMATckMessage>(){
            boolean restarted = false;

            @Override
            public void handle(SMATckMessage message, AbstractSMATckAepTestApp app) throws Exception {
                String messageChannel = message.getMessageChannel();
                if (app.getChannel(SMATckAepTests.this.CHANNELS[1][QOS][1][1]).getName().equals(messageChannel)) {
                    if (responsesEnabled) {
                        SMATckMessage out = SMATckAepTests.this.createTestMessage();
                        out.setStringField("forwarder-from-" + message.getStringField());
                        out.setIntField(message.getIntField());
                        app.sendMessage(app.getChannel(SMATckAepTests.this.CHANNELS[0][QOS][1][1]), (IRogMessage)out);
                    }
                    Assert.assertEquals((String)"Wrong bus name on receiver receipt", (Object)SMATckAepTests.this.getReceiverBusName(), (Object)message.getMessageBus());
                    Assert.assertEquals((String)"Wrong channel on receiver receipt", (Object)app.getChannel(SMATckAepTests.this.CHANNELS[1][QOS][1][1]).getName(), (Object)message.getMessageChannel());
                    if (SMATckAepTests.this.supportsMessageKeyTransport()) {
                        Assert.assertEquals((String)"Wrong channel key on receiver receipt", (Object)app.getChannel(SMATckAepTests.this.CHANNELS[1][QOS][1][1]).getName(), (Object)message.getMessageKey());
                    }
                } else {
                    SMATckMessage out = SMATckAepTests.this.createTestMessage();
                    out.setStringField("forwarder-from-" + message.getStringField());
                    out.setIntField(message.getIntField());
                    app.sendMessage(app.getChannel(SMATckAepTests.this.CHANNELS[1][QOS][0][1]), (IRogMessage)out);
                    if (restartForwarder && !this.restarted && forwarder.receivedMessageCount == 25) {
                        this.restarted = true;
                        Thread thread = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(1000L);
                                    AbstractSMATckServerTest.restartApp(forwarder, false);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        thread.start();
                        throw new Exception("Intentional failure");
                    }
                    Assert.assertEquals((String)"Wrong bus name on receiver receipt", (Object)SMATckAepTests.this.getForwarderBusName(), (Object)message.getMessageBus());
                    Assert.assertEquals((String)"Wrong channel on receiver receipt", (Object)app.getChannel(SMATckAepTests.this.CHANNELS[0][QOS][0][1]).getName(), (Object)message.getMessageChannel());
                    if (SMATckAepTests.this.supportsMessageKeyTransport()) {
                        Assert.assertEquals((String)"Wrong channel key on receiver receipt", (Object)app.getChannel(SMATckAepTests.this.CHANNELS[0][QOS][0][1]).getName(), (Object)message.getMessageKey());
                    }
                }
            }
        });
        receiver.setHoldMessages(compareMessages);
        receiver.setHandler(SMATckMessage.class, new SMATCKMessageHandler<SMATckMessage>(){

            @Override
            public void handle(SMATckMessage message, AbstractSMATckAepTestApp app) throws Exception {
                if (responsesEnabled) {
                    SMATckMessage out = SMATckAepTests.this.createTestMessage();
                    out.setStringField("receiver");
                    out.setIntField(message.getIntField());
                    app.sendMessage(app.getChannel(SMATckAepTests.this.CHANNELS[1][QOS][1][1]), (IRogMessage)out);
                    Assert.assertEquals((String)"Wrong bus name on receiver receipt", (Object)SMATckAepTests.this.getReceiverBusName(), (Object)message.getMessageBus());
                    Assert.assertEquals((String)"Wrong channel on receiver receipt", (Object)app.getChannel(SMATckAepTests.this.CHANNELS[1][QOS][0][1]).getName(), (Object)message.getMessageChannel());
                    if (SMATckAepTests.this.supportsMessageKeyTransport()) {
                        Assert.assertEquals((String)"Wrong channel key on receiver receipt", (Object)app.getChannel(SMATckAepTests.this.CHANNELS[1][QOS][0][1]).getName(), (Object)message.getMessageKey());
                    }
                }
            }
        });
        sender.waitForChannelUp(this.CHANNELS[0][QOS][0][1], 10L);
        forwarder.waitForChannelUp(this.CHANNELS[0][QOS][0][1], 10L);
        receiver.waitForChannelUp(this.CHANNELS[1][QOS][0][1], 10L);
        System.out.println("Sending Messages...");
        for (int i = 0; i < 100; ++i) {
            SMATckMessage message = this.createTestMessage();
            message.setStringField("sender");
            message.setIntField(i + 1);
            sender.sendMessage(sender.getChannel(this.CHANNELS[0][QOS][0][1]), (IRogMessage)message);
        }
        sender.getChannel(this.CHANNELS[0][QOS][0][1]).getMessageBusBinding().flush();
        System.out.println("Waiting for Messages...");
        sender.waitForMessages(10, 100);
        if (SMATckAepTests.verbose()) {
            System.out.println("Sender received: " + sender.getRcvdMessageCount());
            sender.dumpReceivedMessages(false);
        }
        sender.waitForTransactionStability(1);
        forwarder.waitForTransactionStability(1);
        receiver.waitForTransactionStability(1);
        System.out.println("Checking Messages...");
        this.assertSenderForwarderReceiverMessagesMatch();
        sender.assertExpectedSends(0, 100);
        if (responsesEnabled) {
            sender.assertExpectedReceipt(0, 100);
        }
        forwarder.assertExpectedSends(0, responsesEnabled ? 200 : 100);
        forwarder.assertExpectedReceipt(0, responsesEnabled ? 200 : 100);
        if (responsesEnabled) {
            receiver.assertExpectedSends(0, 100);
        }
        receiver.assertExpectedReceipt(0, 100);
        sender.reset();
        forwarder.reset();
        receiver.reset();
        if (sender.getChannel(this.CHANNELS[0][QOS][0][1]).getMessageBusBinding().acksRequireFlush()) {
            sender.injectMessage(this.createTestMessage());
            forwarder.injectMessage(this.createTestMessage());
            receiver.injectMessage(this.createTestMessage());
            sender.waitForTransactionStability(1);
            forwarder.waitForTransactionStability(1);
            receiver.waitForTransactionStability(1);
        }
    }

    private void assertSenderForwarderReceiverMessagesMatch() throws Exception {
        boolean compareChannelName = true;
        boolean compareBusName = true;
        boolean compareMessageKey = this.supportsMessageKeyTransport();
        this.assertSentAndReceivedMessageEqual(sender, forwarder, this.CHANNELS[0][0][0][1], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(sender, forwarder, this.CHANNELS[0][0][0][2], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(sender, forwarder, this.CHANNELS[0][0][0][3], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(sender, forwarder, this.CHANNELS[0][1][0][1], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(sender, forwarder, this.CHANNELS[0][1][0][2], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(sender, forwarder, this.CHANNELS[0][1][0][3], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(forwarder, receiver, this.CHANNELS[1][0][0][1], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(forwarder, receiver, this.CHANNELS[1][0][0][2], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(forwarder, receiver, this.CHANNELS[1][0][0][3], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(forwarder, receiver, this.CHANNELS[1][1][0][1], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(forwarder, receiver, this.CHANNELS[1][1][0][2], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(forwarder, receiver, this.CHANNELS[1][1][0][3], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(receiver, forwarder, this.CHANNELS[1][0][1][1], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(receiver, forwarder, this.CHANNELS[1][0][1][2], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(receiver, forwarder, this.CHANNELS[1][0][1][3], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(receiver, forwarder, this.CHANNELS[1][1][1][1], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(receiver, forwarder, this.CHANNELS[1][1][1][2], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(receiver, forwarder, this.CHANNELS[1][1][1][3], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(forwarder, sender, this.CHANNELS[0][0][1][1], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(forwarder, sender, this.CHANNELS[0][0][1][2], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(forwarder, sender, this.CHANNELS[0][0][1][3], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(forwarder, sender, this.CHANNELS[0][1][1][1], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(forwarder, sender, this.CHANNELS[0][1][1][2], true, true, compareMessageKey);
        this.assertSentAndReceivedMessageEqual(forwarder, sender, this.CHANNELS[0][1][1][3], true, true, compareMessageKey);
    }

    @Test
    public void testMessageWithChannelNotJoinedBestEffort() throws Exception {
        this.testMessageWithChannelNotJoined(MessageChannel.Qos.BestEffort);
    }

    @Test
    public void testMessageWithChannelNotJoinedGuaranteed() throws Exception {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testMessageWithChannelNotJoined(MessageChannel.Qos.Guaranteed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMessageWithChannelNotJoined(MessageChannel.Qos qos) throws Exception {
        MessageChannel joinedChannel = forwarder.getChannel(qos == MessageChannel.Qos.BestEffort ? this.F_BE_1 : this.F_GUAR_1);
        MessageChannel notJoinedChannel = forwarder.getChannel(qos == MessageChannel.Qos.BestEffort ? this.F_BE_REP_1 : this.F_GUAR_REP_1);
        MessageBusBinding bus = joinedChannel.getMessageBusBinding();
        SMATckProviderHelper helper = this.getTckHelper(bus);
        try {
            helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), notJoinedChannel.getName(), joinedChannel.getName(), 0);
            Assert.assertEquals((String)"Didn't get UnhandledMessageEvent", (Object)Boolean.TRUE, (Object)SMATckAepTests.forwarder.umeLatch.await(10L, TimeUnit.SECONDS));
            forwarder.validateExpectedUME(this.supportsMessageKeyTransport(), this.supportsTransportMessageId(), joinedChannel.getName(), notJoinedChannel.getName(), bus.getName(), bus.getType(), "not joined", 0, true);
        }
        finally {
            helper.cleanup();
        }
    }

    @Test
    public void testNullMessageChannelNameBestEffort() throws Exception {
        this.testNullMessageChannelName(MessageChannel.Qos.BestEffort);
    }

    @Test
    public void testNullMessageChannelNameGuaranteed() throws Exception {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testNullMessageChannelName(MessageChannel.Qos.Guaranteed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNullMessageChannelName(MessageChannel.Qos qos) throws Exception {
        MessageChannel joinedChannel = forwarder.getChannel(qos == MessageChannel.Qos.BestEffort ? this.F_BE_1 : this.F_GUAR_1);
        MessageBusBinding bus = joinedChannel.getMessageBusBinding();
        SMATckProviderHelper helper = this.getTckHelper(bus);
        try {
            helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), null, joinedChannel.getName(), 0);
            Assert.assertEquals((String)"Didn't get UnhandledMessageEvent", (Object)Boolean.TRUE, (Object)SMATckAepTests.forwarder.umeLatch.await(10L, TimeUnit.SECONDS));
            forwarder.validateExpectedUME(this.supportsMessageKeyTransport(), this.supportsTransportMessageId(), joinedChannel.getName(), null, bus.getName(), bus.getType(), "Channel (name=null, id=-1) not found", 0, true);
        }
        finally {
            helper.cleanup();
        }
    }

    @Test
    public void testMessageWithUnkownChannelBestEffort() throws Exception {
        this.testMessageWithUnkownChannel(MessageChannel.Qos.BestEffort);
    }

    @Test
    public void testMessageWithUnkownChannelGuaranteed() throws Exception {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testMessageWithUnkownChannel(MessageChannel.Qos.Guaranteed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMessageWithUnkownChannel(MessageChannel.Qos qos) throws Exception {
        MessageChannel joinedChannel = forwarder.getChannel(qos == MessageChannel.Qos.BestEffort ? this.F_BE_1 : this.F_GUAR_1);
        MessageBusBinding bus = joinedChannel.getMessageBusBinding();
        SMATckProviderHelper helper = this.getTckHelper(bus);
        try {
            helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), "channel52", joinedChannel.getName(), 0);
            Assert.assertEquals((String)"Didn't get UnhandledMessageEvent", (Object)Boolean.TRUE, (Object)SMATckAepTests.forwarder.umeLatch.await(10L, TimeUnit.SECONDS));
            forwarder.validateExpectedUME(this.supportsMessageKeyTransport(), this.supportsTransportMessageId(), joinedChannel.getName(), "channel52", bus.getName(), bus.getType(), "Channel (name=channel52, id=-1) not found", 0, true);
        }
        finally {
            helper.cleanup();
        }
    }

    @Test
    public void testCatchallMessageChannelGuaranteed() throws Throwable {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testCatchallMessageChannel(true);
    }

    @Test
    public void testCatchallMessageChannelBestEffort() throws Throwable {
        this.testCatchallMessageChannel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCatchallMessageChannel(boolean guar) throws Throwable {
        SMATckTestServer<?> server;
        String forwarderBusName = forwarder.getChannel(guar ? this.F_GUAR_1 : this.F_BE_1).getMessageBusBinding().getName();
        try {
            MessageBusDescriptor.load((String)forwarderBusName).delete();
            Config.getRepository().commit();
            server = forwarder.getServer();
            server.getConfigOverrides().put("forwarder.bus.descriptor", this.getForwarderBusDescriptor() + "&" + "auto_add_catchall_channel" + "=true");
            System.out.println("RESTARTING FORWARDER CONFIGURED WITH CATCHALL CHANNEL.");
            this.restartAll();
            System.out.println("RESTARTED FORWARDER CONFIGURED WITH CATCHALL CHANNEL.");
            MessageChannel joinedChannel = forwarder.getChannel(guar ? this.F_GUAR_1 : this.F_BE_1);
            MessageChannel notJoinedChannel = forwarder.getChannel(this.F_BE_REP_1);
            MessageBusBinding bus = joinedChannel.getMessageBusBinding();
            SMATckProviderHelper helper = this.getTckHelper(bus);
            try {
                forwarder.reset();
                sender.reset();
                SMATckMessage message = this.createTestMessage();
                message.setStringField("No Joined");
                helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), notJoinedChannel.getName(), joinedChannel.getName(), 0);
                message = this.createTestMessage();
                message.setStringField("Channel not found");
                helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), "channel52", joinedChannel.getName(), 0);
                message = this.createTestMessage();
                message.setStringField("No channel specified");
                helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), null, joinedChannel.getName(), 0);
                Assert.assertTrue((String)"Timed out waiting for messages", (boolean)forwarder.waitForMessages(5, 3));
                Assert.assertNull((String)"Received unexpected UnhandledMessageEvent", (Object)SMATckAepTests.forwarder.ume);
                IRogMessage r1 = forwarder.getRcvdMessages().get(0);
                Assert.assertEquals((String)"Received message was not on wildcard", (Object)"_CATCHALL_", (Object)r1.getMessageChannel());
                Assert.assertEquals((String)"Received message was not on right bus", (Object)bus.getName(), (Object)r1.getMessageBus());
                IRogMessage r2 = forwarder.getRcvdMessages().get(1);
                Assert.assertEquals((String)"Received message was not on wildcard", (Object)"_CATCHALL_", (Object)r2.getMessageChannel());
                Assert.assertEquals((String)"Received message was not on right bus", (Object)bus.getName(), (Object)r2.getMessageBus());
                IRogMessage r3 = forwarder.getRcvdMessages().get(1);
                Assert.assertEquals((String)"Received message was not on wildcard", (Object)"_CATCHALL_", (Object)r3.getMessageChannel());
                Assert.assertEquals((String)"Received message was not on right bus", (Object)bus.getName(), (Object)r3.getMessageBus());
                message = this.createTestMessage();
                Assert.assertTrue((String)"Timed out waiting for transaction stability", (boolean)forwarder.waitForTransactionStability(2));
                forwarder.injectMessage(message);
                Assert.assertTrue((String)"Timed out waiting for messages", (boolean)forwarder.waitForMessages(5, 4));
                this.ensureAcksFlushed(forwarder);
                this.ensureAcksFlushed(receiver);
                Assert.assertTrue((String)"Timed out waiting for transaction stability", (boolean)forwarder.waitForTransactionStability(2));
                forwarder.getEngine().stop(new Exception("Stopping with subscriptions preserved"));
                this.restartAll();
                String forwarderReqChannelName = guar ? this.F_GUAR_1 : this.F_BE_1;
                sender.waitForChannelUp(forwarderReqChannelName, 10L);
                forwarder.waitForChannelUp(forwarderReqChannelName, 10L);
                if (guar) {
                    Assert.assertFalse((String)"Retransmission ruined expectations", (boolean)forwarder.waitForMessages(1, 1));
                }
                forwarder.assertExpectedReceipt(0, 0);
                if (!guar) {
                    Thread.sleep(2000L);
                }
                sender.sendMessage(sender.getChannel(forwarderReqChannelName), (IRogMessage)this.createTestMessage());
                System.out.println("Sending new message after forwarder restart");
                Assert.assertTrue((String)"Timed out waiting for messages", (boolean)forwarder.waitForMessages(30, 1));
                forwarder.waitForMessages(1, 2);
                Assert.assertNull((String)"Received unexpected UnhandledMessageEvent", (Object)SMATckAepTests.forwarder.ume);
                forwarder.assertExpectedReceipt(0, 1);
                this.ensureAcksFlushed(forwarder);
            }
            finally {
                helper.cleanup();
            }
        }
        finally {
            try {
                MessageBusDescriptor.load((String)forwarderBusName).delete();
            }
            catch (Exception e) {
                System.err.println("Couldn't delete sma-tck-forwarder-bus");
            }
            server = forwarder.getServer();
            server.getConfigOverrides().put("forwarder.bus.descriptor", this.getForwarderBusDescriptor());
            this.restartAll();
        }
    }

    @Test
    public void testExplicitCatchallMessageChannelGuaranteed() throws Throwable {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testExplicitCatchallMessageChannel(true);
    }

    @Test
    public void testExplicitCatchallMessageChannelBestEffort() throws Throwable {
        this.testExplicitCatchallMessageChannel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testExplicitCatchallMessageChannel(boolean guar) throws Throwable {
        SMATckTestServer<?> server;
        String forwarderBusName = forwarder.getChannel(guar ? this.F_GUAR_1 : this.F_BE_1).getMessageBusBinding().getName();
        this.restartAll();
        try {
            MessageBusDescriptor.load((String)forwarderBusName).delete();
            server = forwarder.getServer();
            server.getConfigOverrides().put("forwarder.bus.descriptor", this.getForwarderBusDescriptor() + "&" + "auto_add_catchall_channel" + "=true");
            server.getConfigOverrides().put("wildcard.channel.id", "32767");
            this.restartAll();
            forwarder.waitForChannelUp(guar ? this.F_GUAR_1 : this.F_BE_1, 10L);
            sender.waitForChannelUp(guar ? this.F_GUAR_1 : this.F_BE_1, 10L);
            MessageChannel joinedChannel = forwarder.getChannel(guar ? this.F_GUAR_1 : this.F_BE_1);
            MessageChannel notJoinedChannel = forwarder.getChannel(this.F_BE_REP_1);
            MessageBusBinding bus = joinedChannel.getMessageBusBinding();
            SMATckProviderHelper helper = this.getTckHelper(bus);
            try {
                receiver.reset();
                sender.reset();
                SMATckMessage message = this.createTestMessage();
                message.setStringField("No Joined");
                helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), notJoinedChannel.getName(), joinedChannel.getName(), 0);
                message = this.createTestMessage();
                message.setStringField("Channel not found");
                helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), "channel52", joinedChannel.getName(), 0);
                message = this.createTestMessage();
                message.setStringField("No channel specified");
                helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), null, joinedChannel.getName(), 0);
                forwarder.waitForMessages(5, 3);
                Assert.assertNull((String)"Received unexpected UnhandledMessageEvent", (Object)SMATckAepTests.forwarder.ume);
                IRogMessage r1 = forwarder.getRcvdMessages().get(0);
                Assert.assertEquals((String)"Received message was not on wildcard", (Object)"*", (Object)r1.getMessageChannel());
                Assert.assertEquals((String)"Received message was not on right bus", (Object)bus.getName(), (Object)r1.getMessageBus());
                IRogMessage r2 = forwarder.getRcvdMessages().get(1);
                Assert.assertEquals((String)"Received message was not on wildcard", (Object)"*", (Object)r2.getMessageChannel());
                Assert.assertEquals((String)"Received message was not on right bus", (Object)bus.getName(), (Object)r2.getMessageBus());
                IRogMessage r3 = forwarder.getRcvdMessages().get(2);
                Assert.assertEquals((String)"Received message was not on wildcard", (Object)"*", (Object)r3.getMessageChannel());
                Assert.assertEquals((String)"Received message was not on right bus", (Object)bus.getName(), (Object)r3.getMessageBus());
                if (guar) {
                    message = this.createTestMessage();
                    forwarder.waitForTransactionStability(2);
                    forwarder.injectMessage(message);
                    forwarder.waitForMessages(5, 4);
                    this.ensureAcksFlushed(forwarder);
                    forwarder.waitForTransactionStability(2);
                    forwarder.getEngine().stop(new Exception("Stopping with subscriptions preserved"));
                    forwarder = SMATckAepTests.restartApp(forwarder, false);
                    sender.waitForChannelUp(guar ? this.F_GUAR_1 : this.F_BE_1, 30L);
                    System.out.println("Sending new message after forwarder restart...");
                    sender.sendMessage(sender.getChannel(guar ? this.F_GUAR_1 : this.F_BE_1), (IRogMessage)this.createTestMessage());
                    forwarder.assertExpectedReceipt(30, 5);
                    Assert.assertNull((String)"Received unexpected UnhandledMessageEvent", (Object)SMATckAepTests.forwarder.ume);
                }
            }
            finally {
                helper.cleanup();
            }
        }
        finally {
            MessageBusDescriptor.load((String)forwarderBusName).delete();
            server = forwarder.getServer();
            server.getConfigOverrides().put("forwarder.bus.descriptor", this.getForwarderBusDescriptor());
            server.getConfigOverrides().put("wildcard.channel.id", "100");
            this.restartAll();
        }
    }

    @Test
    public void testMessageWithUnkownVfidBestEffort() throws Exception {
        this.testMessageWithUnkownVfid(MessageChannel.Qos.BestEffort);
    }

    @Test
    public void testMessageWithUnkownVfidGuaranteed() throws Exception {
        Assume.assumeTrue((String)"Supports guaranteed", (boolean)this.supportsGuaranteedMessaging());
        this.testMessageWithUnkownVfid(MessageChannel.Qos.Guaranteed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMessageWithUnkownVfid(MessageChannel.Qos qos) throws Exception {
        MessageChannel joinedChannel = forwarder.getChannel(qos == MessageChannel.Qos.BestEffort ? this.F_BE_1 : this.F_GUAR_1);
        MessageBusBinding bus = joinedChannel.getMessageBusBinding();
        SMATckProviderHelper helper = this.getTckHelper(bus);
        try {
            helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), joinedChannel.getName(), joinedChannel.getName(), SMATckProviderHelper.FLG_WRONG_VFID);
            Assert.assertEquals((String)"Didn't get UnhandledMessageEvent", (Object)Boolean.TRUE, (Object)SMATckAepTests.forwarder.umeLatch.await(10L, TimeUnit.SECONDS));
            forwarder.validateExpectedUME(this.supportsMessageKeyTransport(), this.supportsTransportMessageId(), joinedChannel.getName(), joinedChannel.getName(), bus.getName(), bus.getType(), "View factory '2300' could not be found", SMATckProviderHelper.FLG_WRONG_VFID, true);
        }
        finally {
            helper.cleanup();
        }
    }

    @Test
    public void testMessageWithUnkownViewTypeBestEffort() throws Exception {
        this.testMessageWithUnkownViewType(MessageChannel.Qos.BestEffort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test(timeout=60000L)
    public void testConnectionDrop() throws Exception {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        sender.waitForChannelUp(this.F_GUAR_1, 10L);
        forwarder.waitForChannelUp(this.F_GUAR_1, 10L);
        SMATckProviderHelper helper = this.getTckHelper(forwarder.getChannel(this.F_GUAR_1).getMessageBusBinding());
        try {
            sender.sendMessage(this.F_GUAR_1, (IRogMessage)this.createTestMessage());
            Assert.assertTrue((String)"Expected initial message on forwarder", (boolean)forwarder.waitForMessages(5, 1));
            this.ensureAcksFlushed(forwarder);
            Assert.assertTrue((String)"Expected sender transactions to stabilize", (boolean)sender.waitForTransactionStability(2));
            MessageChannel senderChannel = sender.getChannel(this.F_GUAR_1);
            for (int i = 1; i < 50; ++i) {
                if (i % 10 == 0) {
                    try {
                        helper.forceClose(senderChannel);
                    }
                    catch (UnsupportedOperationException e) {
                        Assume.assumeTrue((String)"Helper supports forceClose()", (boolean)false);
                    }
                }
                sender.sendMessage(this.F_GUAR_1, (IRogMessage)this.createTestMessage());
            }
            Assert.assertTrue((String)"Expected 50 messages total", (boolean)forwarder.waitForMessages(5, 50));
            this.ensureAcksFlushed(forwarder);
            Assert.assertTrue((String)"Expected sender transactions to stabilize", (boolean)sender.waitForTransactionStability(2));
            this.assertSentAndReceivedMessageEqual(sender, forwarder);
        }
        finally {
            helper.cleanup();
        }
    }

    @Test
    public void testReverseMessageFlowBestEffort() throws Throwable {
        this.testReverseMessageFlow(false);
    }

    @Test
    public void testReverseMessageFlowGuaranteed() throws Throwable {
        this.testReverseMessageFlow(true);
    }

    private void testReverseMessageFlow(boolean guaranteed) throws Throwable {
        String channel = guaranteed ? this.R_GUAR_REP_1 : this.R_BE_REP_1;
        receiver.waitForChannelUp(channel, 300L);
        forwarder.waitForChannelUp(channel, 300L);
        receiver.sendMessage(channel, (IRogMessage)this.createTestMessage());
        Assert.assertTrue((String)"Expected a message from the receiver", (boolean)forwarder.waitForMessages(5, 1));
        this.ensureAcksFlushed(forwarder);
        Assert.assertTrue((String)"Expected receiver transaction to stabilize", (boolean)receiver.waitForTransactionStability(2));
        this.assertSentAndReceivedMessageEqual(receiver, forwarder);
    }

    @Test
    public void testSimpleChannelFilterBestEffort() throws Throwable {
        this.testSimpleChannelFilter(false);
    }

    @Test
    public void testSimpleChannelFilterGuaranteed() throws Throwable {
        Assume.assumeTrue((String)"Supports guaranteed", (boolean)this.supportsGuaranteedMessaging());
        this.testSimpleChannelFilter(true);
    }

    private void testSimpleChannelFilter(boolean guaranteed) throws Throwable {
        Assume.assumeTrue((String)"Supports channel filters", (boolean)this.supportsChannelFilters());
        String channel = guaranteed ? this.F_GUAR_FILTER : this.F_BE_FILTER;
        sender.reset();
        forwarder.reset();
        sender.waitForChannelUp(channel, 10L);
        forwarder.waitForChannelUp(channel, 10L);
        SMATckMessage a = this.createTestMessage();
        a.setStringField("A");
        SMATckMessage b = this.createTestMessage();
        b.setStringField("B");
        sender.sendMessage(channel, (IRogMessage)a);
        sender.sendMessage(channel, (IRogMessage)b);
        Assert.assertTrue((String)"Expected a message from the sender", (boolean)forwarder.waitForMessages(5, 1));
        Assert.assertFalse((String)"Expected exactly one message to be received & processed", (boolean)forwarder.waitForMessages(1, 2));
        Assert.assertEquals((long)2L, (long)sender.getSentMessageCount());
        Assert.assertEquals((long)1L, (long)forwarder.getRcvdMessageCount());
    }

    @Test
    public void testChannelFilterWithCleanKeysBestEffort() throws Throwable {
        this.testChannelFilterWithCleanKeys(false);
    }

    @Test
    public void testChannelFilterWithCleanKeysGuaranteed() throws Throwable {
        Assume.assumeTrue((String)"Supports guaranteed", (boolean)this.supportsGuaranteedMessaging());
        this.testChannelFilterWithCleanKeys(true);
    }

    private void testChannelFilterWithCleanKeys(boolean guaranteed) throws Throwable {
        Assume.assumeTrue((String)"Supports channel filters", (boolean)this.supportsChannelFilters());
        String channel = guaranteed ? this.F_GUAR_FILTER : this.F_BE_FILTER;
        sender.reset();
        forwarder.reset();
        sender.waitForChannelUp(channel, 10L);
        forwarder.waitForChannelUp(channel, 10L);
        SMATckMessage a = this.createTestMessage();
        a.setStringField("E/F");
        SMATckMessage b = this.createTestMessage();
        b.setStringField("D/E");
        sender.sendMessage(channel, (IRogMessage)a);
        sender.sendMessage(channel, (IRogMessage)b);
        Assert.assertTrue((String)"Expected a message from the sender", (boolean)forwarder.waitForMessages(5, 1));
        Assert.assertFalse((String)"Expected one message to be received & processed", (boolean)forwarder.waitForMessages(1, 2));
        this.ensureAcksFlushed(forwarder);
        Assert.assertTrue((String)"Expected sender transaction to stabilize", (boolean)sender.waitForTransactionStability(2));
        Assert.assertEquals((long)2L, (long)sender.getSentMessageCount());
        Assert.assertEquals((long)1L, (long)forwarder.getRcvdMessageCount());
    }

    @Test
    public void testTwoClientReverseMessageFlowBestEffort() throws Throwable {
        this.testTwoClientReverseMessageFlow(false);
    }

    @Test
    public void testTwoClientReverseMessageFlowGuaranteed() throws Throwable {
        Assume.assumeTrue((String)"Supports guaranteed", (boolean)this.supportsGuaranteedMessaging());
        this.testTwoClientReverseMessageFlow(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTwoClientReverseMessageFlow(boolean guaranteed) throws Throwable {
        String channel = guaranteed ? this.F_GUAR_REP_1 : this.F_BE_REP_1;
        Sender sender2 = SMATckAepTests.createApp("sma-tck-sender-2", "primary", Sender.class, this.makeDefaultConfigOverrides());
        try {
            sender2.getEngine().waitForMessagingToStart();
            sender2.waitForChannelUp(channel, 10L);
            sender.waitForChannelUp(channel, 10L);
            forwarder.waitForChannelUp(channel, 10L);
            SMATckMessage message = this.createTestMessage();
            forwarder.sendMessage(channel, (IRogMessage)message);
            Assert.assertTrue((String)"sender expected a message from the forwarder", (boolean)sender.waitForMessages(5, 1));
            this.ensureAcksFlushed(sender);
            Assert.assertTrue((String)"sender2 expected a message from the forwarder", (boolean)sender2.waitForMessages(5, 1));
            if (sender2.getChannel(channel).getMessageBusBinding().acksRequireFlush()) {
                sender2.getChannel(channel).getMessageBusBinding().flush();
            }
            Assert.assertTrue((String)"Expected forwarder transactions to stabilize", (boolean)forwarder.waitForTransactionStability(2));
            this.assertSentAndReceivedMessageEqual(sender, receiver);
            this.assertSentAndReceivedMessageEqual(sender2, receiver);
            forwarder.waitForTransactionStability(2);
            sender.waitForTransactionStability(2);
            sender2.waitForTransactionStability(2);
            this.ensureAcksFlushed(sender);
            this.ensureAcksFlushed(sender2);
            this.ensureAcksFlushed(forwarder);
        }
        finally {
            SMATckAepTests.stopApp(sender2, true);
        }
    }

    @Test
    public void testMessageWithUnkownViewTypeGuaranteed() throws Exception {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testMessageWithUnkownViewType(MessageChannel.Qos.Guaranteed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMessageWithUnkownViewType(MessageChannel.Qos qos) throws Exception {
        MessageChannel joinedChannel = forwarder.getChannel(qos == MessageChannel.Qos.BestEffort ? this.F_BE_1 : this.F_GUAR_1);
        MessageBusBinding bus = joinedChannel.getMessageBusBinding();
        SMATckProviderHelper helper = this.getTckHelper(bus);
        try {
            helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), joinedChannel.getName(), joinedChannel.getName(), SMATckProviderHelper.FLG_WRONG_VID);
            Assert.assertTrue((String)"Didn't get UnhandledMessageEvent", (boolean)SMATckAepTests.forwarder.umeLatch.await(10L, TimeUnit.SECONDS));
            forwarder.validateExpectedUME(this.supportsMessageKeyTransport(), this.supportsTransportMessageId(), joinedChannel.getName(), joinedChannel.getName(), bus.getName(), bus.getType(), "type: 2400", SMATckProviderHelper.FLG_WRONG_VID, true);
        }
        finally {
            helper.cleanup();
        }
    }

    @Test
    public void testUnknownMessageEncodingTypeBestEffort() throws Exception {
        this.testUnknownMessageEncodingType(MessageChannel.Qos.BestEffort);
    }

    @Test
    public void testUnknownMessageEncodingTypeGuaranteed() throws Exception {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testUnknownMessageEncodingType(MessageChannel.Qos.Guaranteed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnknownMessageEncodingType(MessageChannel.Qos qos) throws Exception {
        MessageChannel joinedChannel = forwarder.getChannel(qos == MessageChannel.Qos.BestEffort ? this.F_BE_1 : this.F_GUAR_1);
        MessageBusBinding bus = joinedChannel.getMessageBusBinding();
        SMATckProviderHelper helper = this.getTckHelper(bus);
        try {
            helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), joinedChannel.getName(), joinedChannel.getName(), SMATckProviderHelper.FLG_WRONG_ENCODING);
            Assert.assertEquals((String)"Didn't get UnhandledMessageEvent", (Object)Boolean.TRUE, (Object)SMATckAepTests.forwarder.umeLatch.await(10L, TimeUnit.SECONDS));
            forwarder.validateExpectedUME(this.supportsMessageKeyTransport(), this.supportsTransportMessageId(), joinedChannel.getName(), joinedChannel.getName(), bus.getName(), bus.getType(), "unknown encoding type: 8", SMATckProviderHelper.FLG_WRONG_ENCODING, true);
        }
        finally {
            helper.cleanup();
        }
    }

    @Test
    public void testMissingMetadataBestEffort() throws Exception {
        this.testMissingMetadata(MessageChannel.Qos.BestEffort);
    }

    @Test
    public void testMissingMetadataGuaranteed() throws Exception {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testMissingMetadata(MessageChannel.Qos.Guaranteed);
    }

    protected boolean missingMetadataPossible() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMissingMetadata(MessageChannel.Qos qos) throws Exception {
        if (!this.missingMetadataPossible()) {
            return;
        }
        MessageChannel joinedChannel = forwarder.getChannel(qos == MessageChannel.Qos.BestEffort ? this.F_BE_1 : this.F_GUAR_1);
        MessageBusBinding bus = joinedChannel.getMessageBusBinding();
        SMATckProviderHelper helper = this.getTckHelper(bus);
        try {
            SMATckAepTests.forwarder.suppressUmeAck = false;
            helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), joinedChannel.getName(), joinedChannel.getName(), SMATckProviderHelper.FLG_NO_METADATA);
            Assert.assertEquals((String)"Didn't get UnhandledMessageEvent", (Object)Boolean.TRUE, (Object)SMATckAepTests.forwarder.umeLatch.await(10L, TimeUnit.SECONDS));
            forwarder.validateExpectedUME(this.supportsMessageKeyTransport(), this.supportsTransportMessageId(), joinedChannel.getName(), null, bus.getName(), bus.getType(), "no SMA metadata in message", SMATckProviderHelper.FLG_NO_METADATA, true);
        }
        finally {
            helper.cleanup();
        }
    }

    @Ignore(value="Missing payload is not an error with V2 headers")
    @Test
    public void testMissingPayloadBestEffort() throws Exception {
        this.testMissingPayload(MessageChannel.Qos.BestEffort);
    }

    @Ignore(value="Missing payload is not an error with V2 headers")
    @Test
    public void testMissingPayloadGuaranteed() throws Exception {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testMissingPayload(MessageChannel.Qos.Guaranteed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMissingPayload(MessageChannel.Qos qos) throws Exception {
        MessageChannel joinedChannel = forwarder.getChannel(qos == MessageChannel.Qos.BestEffort ? this.F_BE_1 : this.F_GUAR_1);
        MessageBusBinding bus = joinedChannel.getMessageBusBinding();
        SMATckProviderHelper helper = this.getTckHelper(bus);
        try {
            Assume.assumeTrue((String)"Missing payload not possible for bus implementation", (boolean)helper.isMissingPayloadPossible());
            SMATckAepTests.forwarder.suppressUmeAck = false;
            helper.sendMessage((MessageView)this.createTestMessage(), joinedChannel.getQos(), joinedChannel.getName(), joinedChannel.getName(), SMATckProviderHelper.FLG_NO_PAYLOAD);
            Assert.assertEquals((String)"Didn't get UnhandledMessageEvent", (Object)Boolean.TRUE, (Object)SMATckAepTests.forwarder.umeLatch.await(10L, TimeUnit.SECONDS));
            forwarder.validateExpectedUME(this.supportsMessageKeyTransport(), this.supportsTransportMessageId(), joinedChannel.getName(), joinedChannel.getName(), bus.getName(), bus.getType(), "no message type in message body", SMATckProviderHelper.FLG_NO_PAYLOAD, true);
        }
        finally {
            helper.cleanup();
        }
    }

    @Test
    public void testInvalidTransportMessageBestEffort() throws Exception {
        this.testInvalidTransportMessage(MessageChannel.Qos.BestEffort);
    }

    @Test
    public void testInvalidTransportMessageGuaranteed() throws Exception {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testInvalidTransportMessage(MessageChannel.Qos.Guaranteed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInvalidTransportMessage(MessageChannel.Qos qos) throws Exception {
        MessageChannel joinedChannel = forwarder.getChannel(qos == MessageChannel.Qos.BestEffort ? this.F_BE_1 : this.F_GUAR_1);
        MessageBusBinding bus = joinedChannel.getMessageBusBinding();
        SMATckProviderHelper helper = this.getTckHelper(bus);
        try {
            Assume.assumeTrue((String)"Invalid tranport container is not possible for bus implementation", (boolean)helper.isInvalidTransportMessagePossible());
            SMATckAepTests.forwarder.suppressUmeAck = false;
            helper.sendMessage((MessageView)SMATckMessage.create(), joinedChannel.getQos(), joinedChannel.getName(), joinedChannel.getName(), SMATckProviderHelper.FLG_INVALID_TRANSPORT_MESSAGE);
            Assert.assertEquals((String)"Didn't get UnhandledMessageEvent", (Object)Boolean.TRUE, (Object)SMATckAepTests.forwarder.umeLatch.await(10L, TimeUnit.SECONDS));
            forwarder.validateExpectedUME(this.supportsMessageKeyTransport(), this.supportsTransportMessageId(), joinedChannel.getName(), joinedChannel.getName(), bus.getName(), bus.getType(), "unsupported message type", SMATckProviderHelper.FLG_INVALID_TRANSPORT_MESSAGE, true);
        }
        finally {
            helper.cleanup();
        }
    }

    @Test
    public void testUnackedGuarMessageRedelivery() throws Throwable {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.restartAll();
        MessageChannel senderChannel = sender.getChannel(this.F_GUAR_1);
        try {
            sender.setHoldMessages(true);
            forwarder.setHoldMessages(true);
            forwarder.setHandler(SMATckMessage.class, new SMATCKMessageHandler<SMATckMessage>(){

                @Override
                public void handle(SMATckMessage message, AbstractSMATckAepTestApp app) throws Exception {
                    throw new RuntimeException("Intentional App Exception");
                }
            });
            sender.getEngine().waitForMessagingToStart();
            forwarder.getEngine().waitForMessagingToStart();
            Thread.sleep(1000L);
            SMATckMessage message = this.createTestMessage();
            message.setStringField("Message#1");
            System.out.println("SENDING MESSAGE # 1");
            sender.sendMessage(senderChannel, (IRogMessage)message);
            Assert.assertTrue((String)"Didn't get message", (boolean)forwarder.waitForMessages(10, 1));
            forwarder.waitForTransactionStability(5);
            forwarder = SMATckAepTests.restartApp(forwarder, false);
            System.out.println("CHECKING FOR EXPECTED MESSAGE REDELIVERY");
            Assert.assertTrue((String)"Message was not redelivered", (boolean)forwarder.waitForMessages(30, 1));
            this.assertSenderForwarderReceiverMessagesMatch();
            forwarder.waitForTransactionStability(10);
            this.ensureAcksFlushed(forwarder);
            forwarder.waitForTransactionStability(5);
            forwarder.getEngine().stop(new Exception("Intentional unclean shutdown."));
            forwarder = SMATckAepTests.restartApp(forwarder, false);
            message = this.createTestMessage();
            message.setStringField("Message#2");
            sender.waitForChannelUp(this.F_GUAR_1, 30L);
            senderChannel = sender.getChannel(this.F_GUAR_1);
            sender.sendMessage(senderChannel, (IRogMessage)message);
            Assert.assertTrue((String)"Second message was not delivered", (boolean)forwarder.waitForMessages(5, 2));
            this.assertSenderForwarderReceiverMessagesMatch();
        }
        finally {
            forwarder.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnhandledMessageEventAcknowledgement() throws Throwable {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        MessageChannel sendChannel = sender.getChannel(this.F_GUAR_1);
        MessageChannel joinedChannel = forwarder.getChannel(this.F_GUAR_1);
        MessageBusBinding bus = joinedChannel.getMessageBusBinding();
        SMATckProviderHelper helper = this.getTckHelper(bus);
        try {
            SMATckAepTests.forwarder.suppressUmeAck = true;
            sender.sendMessage(sendChannel, (IRogMessage)SMATckUnknownMessage.create());
            Assert.assertEquals((String)"Didn't get UnhandledMessageEvent", (Object)Boolean.TRUE, (Object)SMATckAepTests.forwarder.umeLatch.await(10L, TimeUnit.SECONDS));
            try {
                forwarder.validateExpectedUME(this.supportsMessageKeyTransport(), this.supportsTransportMessageId(), joinedChannel.getName(), joinedChannel.getName(), bus.getName(), bus.getType(), "View factory '-1001' could not be found", SMATckProviderHelper.FLG_WRONG_ENCODING, false);
            }
            finally {
                if (SMATckAepTests.forwarder.ume != null) {
                    SMATckAepTests.forwarder.ume.acknowledge();
                }
            }
            this.ensureAcksFlushed(forwarder);
            forwarder.getEngine().stop(new Exception("Intentional failure after ack"));
            this.restartAll();
            sendChannel = sender.getChannel(this.F_GUAR_1);
            sender.sendMessage(sendChannel, (IRogMessage)this.createTestMessage());
            Assert.assertTrue((String)"Didn't get new valid message after unhandled message", (boolean)forwarder.waitForMessages(30, 1));
            Assert.assertNull((String)"Unhandled messages was redelivered, but should have been acknowledged", (Object)SMATckAepTests.forwarder.ume);
        }
        finally {
            helper.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnackedUnhandledMessageEventRedelivery() throws Throwable {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        Assume.assumeFalse((String)"Impacted by XPLATFORM-1440", (boolean)this.impactedByXPLATFORM1440());
        MessageChannel sendChannel = sender.getChannel(this.F_GUAR_1);
        MessageChannel joinedChannel = forwarder.getChannel(this.F_GUAR_1);
        MessageBusBinding bus = joinedChannel.getMessageBusBinding();
        SMATckProviderHelper helper = this.getTckHelper(bus);
        try {
            SMATckAepTests.forwarder.suppressUmeAck = true;
            sender.sendMessage(sendChannel, (IRogMessage)SMATckUnknownMessage.create());
            Assert.assertEquals((String)"Didn't get UnhandledMessageEvent", (Object)Boolean.TRUE, (Object)SMATckAepTests.forwarder.umeLatch.await(10L, TimeUnit.SECONDS));
            forwarder.validateExpectedUME(this.supportsMessageKeyTransport(), this.supportsTransportMessageId(), joinedChannel.getName(), joinedChannel.getName(), bus.getName(), bus.getType(), "View factory '-1001' could not be found", SMATckProviderHelper.FLG_WRONG_ENCODING, false);
            sender.reset();
            SMATckMessage message = this.createTestMessage();
            message.setStringField("Message A");
            sender.sendMessage(sendChannel, (IRogMessage)message);
            forwarder.waitForMessages(5, 1);
            this.assertSentAndReceivedMessageEqual(sender, forwarder);
            forwarder.waitForTransactionStability(5);
            this.ensureAcksFlushed(forwarder);
            forwarder.getEngine().stop(new Exception("Intentional failure after ack"));
            this.restartAll();
            sendChannel = sender.getChannel(this.F_GUAR_1);
            joinedChannel = forwarder.getChannel(this.F_GUAR_1);
            sender.waitForChannelUp(this.F_GUAR_1, 10L);
            if (!this.supportsIndividualAcknowledgements()) {
                sender.recordSend(sendChannel, message);
            }
            System.out.println("Sending new messages after forwarder restart");
            message = this.createTestMessage();
            message.setStringField("Message B");
            sender.sendMessage(sendChannel, (IRogMessage)message);
            System.out.println("Wating for messages after forwarder restart");
            forwarder.waitForMessages(30, this.supportsIndividualAcknowledgements() ? 1 : 2);
            forwarder.validateExpectedUME(this.supportsMessageKeyTransport(), this.supportsTransportMessageId(), joinedChannel.getName(), joinedChannel.getName(), bus.getName(), bus.getType(), "View factory '-1001' could not be found", SMATckProviderHelper.FLG_WRONG_ENCODING, true);
            this.assertSentAndReceivedMessageEqual(sender, forwarder);
        }
        finally {
            helper.cleanup();
        }
    }

    @Test
    public void testEmptyChannelKeyLevelAppExceptionHandling() throws Exception {
        MessageChannel sendChannel = sender.getChannel(this.F_BE_1);
        SMATckMessage message = this.createTestMessage();
        message.setMessageKey("/InvalidEmptyLevel//");
        String expectedErrorContent = "Empty key level detected in key";
        try {
            sendChannel.validateResolvedMessageKey((MessageView)message);
            Assert.fail((String)"Message Key validation should have failed");
        }
        catch (SmaException e) {
            Assert.assertTrue((String)("Wrong error thrown from key validation. Expected '" + expectedErrorContent + "' but was: " + e.getMessage()), (e.getMessage().indexOf(expectedErrorContent) >= 0 ? 1 : 0) != 0);
        }
        try {
            sendChannel.sendMessage((MessageView)message, 0);
            Assert.fail((String)"Message Key validation should have caused send to fail");
        }
        catch (SmaException e) {
            Assert.assertTrue((String)("Wrong error thrown from key validation. Expected '" + expectedErrorContent + "' but was: " + e.getMessage()), (e.getMessage().indexOf(expectedErrorContent) >= 0 ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxChannelKeyLength() {
        MessageChannel sendChannel = sender.getChannel(this.F_BE_1);
        MessageChannel joinedChannel = forwarder.getChannel(this.F_BE_1);
        SMATckProviderHelper helper = this.getTckHelper(joinedChannel.getMessageBusBinding());
        try {
            int tooLong = Config.getValue((String)"nv.sma.maxresolvedkeylength", (int)512) + 1;
            if (helper.getProviderMaxMessageKeyLength() > 0) {
                tooLong = (short)Math.min(tooLong, helper.getProviderMaxMessageKeyLength() + 1);
            }
            XString tooLongKey = XString.create((short)tooLong);
            for (int i = 0; i < tooLong; ++i) {
                tooLongKey.append('a');
            }
            SMATckMessage message = this.createTestMessage();
            message.setMessageKeyAsRaw(tooLongKey);
            String expectedErrorContent = "has exceeded the max";
            try {
                sendChannel.validateResolvedMessageKey((MessageView)message);
                Assert.fail((String)"Message Key validation should have failed");
            }
            catch (SmaException e) {
                Assert.assertTrue((String)("Wrong error thrown from key validation. Expected '" + expectedErrorContent + "' but was: " + e.getMessage()), (e.getMessage().indexOf(expectedErrorContent) >= 0 ? 1 : 0) != 0);
            }
            try {
                sendChannel.sendMessage((MessageView)message, 0);
                Assert.fail((String)"Message Key validation should have caused send to fail");
            }
            catch (SmaException e) {
                Assert.assertTrue((String)("Wrong error thrown from key validation. Expected '" + expectedErrorContent + "' but was: " + e.getMessage()), (e.getMessage().indexOf(expectedErrorContent) >= 0 ? 1 : 0) != 0);
            }
        }
        finally {
            helper.cleanup();
        }
    }

    @Test
    public void testMessageLatencyTimestampsBestEffort() throws Throwable {
        this.testMessageLatencyTimestamps(MessageChannel.Qos.BestEffort);
    }

    @Test
    public void testMessageLatencyTimestampsGuaranteed() throws Throwable {
        Assume.assumeTrue((String)"Binding Supports Guaranteed Messaging", (boolean)this.supportsGuaranteedMessaging());
        this.testMessageLatencyTimestamps(MessageChannel.Qos.Guaranteed);
    }

    private void testMessageLatencyTimestamps(MessageChannel.Qos qos) throws Throwable {
        boolean responsesEnabled;
        final int QOS = qos == MessageChannel.Qos.Guaranteed ? 1 : 0;
        boolean bl = responsesEnabled = qos == MessageChannel.Qos.BestEffort || this.supportsCyclicGuaranteedMessages();
        if (responsesEnabled) {
            this.workAroundXPLATFORM1494();
        }
        sender.setHoldMessages(true);
        forwarder.setHoldMessages(true);
        forwarder.setHandler(SMATckMessage.class, new SMATCKMessageHandler<SMATckMessage>(){

            @Override
            public void handle(SMATckMessage message, AbstractSMATckAepTestApp app) throws Exception {
                String messageChannel = message.getMessageChannel();
                if (app.getChannel(SMATckAepTests.this.CHANNELS[1][QOS][1][1]).getName().equals(messageChannel)) {
                    if (responsesEnabled) {
                        SMATckMessage out = SMATckAepTests.this.createTestMessage();
                        out.setStringField("forwarder-from-" + message.getStringField());
                        out.setIntField(message.getIntField());
                        app.sendMessage(app.getChannel(SMATckAepTests.this.CHANNELS[0][QOS][1][1]), (IRogMessage)out);
                    }
                } else {
                    SMATckMessage out = SMATckAepTests.this.createTestMessage();
                    out.setStringField("forwarder-from-" + message.getStringField());
                    out.setIntField(message.getIntField());
                    app.sendMessage(app.getChannel(SMATckAepTests.this.CHANNELS[1][QOS][0][1]), (IRogMessage)out);
                }
            }
        });
        receiver.setHoldMessages(true);
        receiver.setHandler(SMATckMessage.class, new SMATCKMessageHandler<SMATckMessage>(){

            @Override
            public void handle(SMATckMessage message, AbstractSMATckAepTestApp app) throws Exception {
                if (responsesEnabled) {
                    SMATckMessage out = SMATckAepTests.this.createTestMessage();
                    out.setStringField("receiver");
                    out.setIntField(message.getIntField());
                    app.sendMessage(app.getChannel(SMATckAepTests.this.CHANNELS[1][QOS][1][1]), (IRogMessage)out);
                }
            }
        });
        sender.waitForChannelUp(this.CHANNELS[0][QOS][0][1], 10L);
        forwarder.waitForChannelUp(this.CHANNELS[0][QOS][0][1], 10L);
        receiver.waitForChannelUp(this.CHANNELS[1][QOS][0][1], 10L);
        if (qos == MessageChannel.Qos.BestEffort) {
            Thread.sleep(2000L);
        }
        sender.sendMessage(sender.getChannel(this.CHANNELS[0][QOS][0][1]), (IRogMessage)this.createTestMessage());
        sender.getChannel(this.CHANNELS[0][QOS][0][1]).getMessageBusBinding().flush();
        this.ensureAcksFlushed(forwarder);
        this.ensureAcksFlushed(receiver);
        this.ensureAcksFlushed(forwarder);
        this.ensureAcksFlushed(sender);
        if (responsesEnabled) {
            System.out.println("Waiting for Response message...");
            Assert.assertTrue((String)"Expected sender to receive a response message", (boolean)sender.waitForMessages(10, 1));
            if (SMATckAepTests.verbose()) {
                System.out.println("Sender received: " + sender.getRcvdMessageCount());
                sender.dumpReceivedMessages(false);
            }
        } else {
            Assert.assertTrue((String)"Expected forwarder to receive a request message", (boolean)forwarder.waitForMessages(10, 1));
            Assert.assertTrue((String)"Expected receiver to receive a request message", (boolean)receiver.waitForMessages(10, 1));
        }
        sender.waitForTransactionStability(1);
        forwarder.waitForTransactionStability(1);
        receiver.waitForTransactionStability(1);
        if (responsesEnabled) {
            Assert.assertTrue((String)"Sender didn't receive response message", (boolean)sender.waitForMessages(0, 1));
        }
        StringBuilder errors = new StringBuilder();
        long originTs = sender.getSentMessages(this.CHANNELS[0][QOS][0][1]).get(0).getOriginTs();
        long lastTsMs = this.validateUnsolicitedSendTimestamps("Sender->Forwarder Unsolicited Send", (MessageView)sender.getSentMessages(this.CHANNELS[0][QOS][0][1]).get(0), originTs, originTs, errors);
        lastTsMs = this.validateReceivedMessageTimestamps("Sender->Forwarder Received Message", (MessageView)forwarder.getRcvdMessages(this.CHANNELS[0][QOS][0][1]).get(0), originTs, lastTsMs, errors);
        lastTsMs = this.validateSolicitedSendTimestamps("Forwarder->Receiver Solicited Send", (MessageView)forwarder.getSentMessages(this.CHANNELS[1][QOS][0][1]).get(0), originTs, lastTsMs, errors);
        lastTsMs = this.validateReceivedMessageTimestamps("Forwarder->Receiver Received Message", (MessageView)receiver.getRcvdMessages(this.CHANNELS[1][QOS][0][1]).get(0), originTs, lastTsMs, errors);
        if (responsesEnabled) {
            lastTsMs = this.validateSolicitedSendTimestamps("Receiver->Forwarder Solicited Send", (MessageView)receiver.getSentMessages(this.CHANNELS[1][QOS][1][1]).get(0), originTs, lastTsMs, errors);
            lastTsMs = this.validateReceivedMessageTimestamps("Receiver->Forwarder Received Message", (MessageView)forwarder.getRcvdMessages(this.CHANNELS[1][QOS][1][1]).get(0), originTs, lastTsMs, errors);
            lastTsMs = this.validateSolicitedSendTimestamps("Forwarder->Sender Solicited Send", (MessageView)forwarder.getSentMessages(this.CHANNELS[0][QOS][1][1]).get(0), originTs, lastTsMs, errors);
            this.validateReceivedMessageTimestamps("Forwarder->Sender Received Message", (MessageView)sender.getRcvdMessages(this.CHANNELS[0][QOS][1][1]).get(0), originTs, lastTsMs, errors);
        }
        if (errors.length() > 0) {
            System.err.println(errors.toString());
        }
        Assert.assertTrue((String)("Message timestamps had unexpected values:\n" + errors.toString()), (errors.length() == 0 ? 1 : 0) != 0);
    }

    private long validateUnsolicitedSendTimestamps(String messageDescription, MessageView view, long originTs, long minTs, StringBuilder errors) {
        if (originTs > 0L) {
            try {
                Assert.assertEquals((String)(messageDescription + " has incorrect originTs"), (long)originTs, (long)view.getOriginTs());
            }
            catch (AssertionError assertion) {
                if (errors != null) {
                    errors.append(((Throwable)((Object)assertion)).getMessage() + "\n");
                }
                throw assertion;
            }
        } else {
            this.validateTimestamp(messageDescription, false, "originTs", view.getOriginTs(), minTs, TimeUnit.MICROSECONDS, errors);
        }
        this.validateTimestamp(messageDescription, true, "createTs", view.getCreateTs(), minTs, TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "sendTs", view.getSendTs(), view.getCreateTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "outTs", view.getOutTsMicros(), view.getSendTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "preSerializeTs", view.getPreSerializeTs(), view.getOutTsMicros(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "postSerializeTs", view.getPostSerializeTs(), view.getPreSerializeTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, this.supportsPreWireTsPropagation(), "preWireTs", view.getPreWireTs(), view.getPostSerializeTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "postWireTs", view.getPostWireTs(), minTs, TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "preDeserializeTs", view.getPreDeserializeTs(), view.getPostWireTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "postDeserializeTs", view.getPostDeserializeTs(), view.getPreDeserializeTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "preProcessingTs", view.getPreProcessingTsMicros(), view.getPostDeserializeTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "receiveTs", view.getReceiveTs(), view.getPreProcessingTsMicros(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "postProcessingTs", view.getPostProcessingTsMicros(), view.getReceiveTs(), TimeUnit.MICROSECONDS, errors);
        return view.getPreWireTs();
    }

    private long validateReceivedMessageTimestamps(String messageDescription, MessageView view, long originTs, long minTs, StringBuilder errors) {
        if (this.supportsOriginTsPropagation() && originTs > 0L) {
            try {
                Assert.assertEquals((String)(messageDescription + " should have an originTs"), (long)originTs, (long)view.getOriginTs());
            }
            catch (AssertionError assertion) {
                if (errors != null) {
                    errors.append(((Throwable)((Object)assertion)).getMessage() + "\n");
                }
                throw assertion;
            }
        } else {
            this.validateTimestamp(messageDescription, false, "originTs", view.getOriginTs(), minTs, TimeUnit.MICROSECONDS, errors);
        }
        this.validateTimestamp(messageDescription, true, "createTs", view.getCreateTs(), minTs, TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "sendTs", view.getSendTs(), view.getCreateTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "outTs", view.getOutTsMicros(), view.getSendTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "preSerializeTs", view.getPreSerializeTs(), view.getOutTsMicros(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "postSerializeTs", view.getPostSerializeTs(), view.getPreSerializeTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, this.supportsPreWireTsPropagation(), "preWireTs", view.getPreWireTs(), minTs, TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "postWireTs", view.getPostWireTs(), minTs, TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "preDeserializeTs", view.getPreDeserializeTs(), view.getPostWireTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "postDeserializeTs", view.getPostDeserializeTs(), view.getPreDeserializeTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "enqueueTs", view.getEnqueueTsMicros(), view.getPostDeserializeTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "receiveTs", view.getReceiveTs(), view.getEnqueueTsMicros(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "preProcessingTs", view.getPreProcessingTsMicros(), view.getEnqueueTsMicros(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "postProcessingTs", view.getPostProcessingTsMicros(), view.getReceiveTs(), TimeUnit.MICROSECONDS, errors);
        return view.getReceiveTs();
    }

    private long validateSolicitedSendTimestamps(String messageDescription, MessageView view, long originTs, long minTs, StringBuilder errors) {
        if (this.supportsOriginTsPropagation() && originTs > 0L) {
            try {
                Assert.assertEquals((String)(messageDescription + " should have an originTs"), (long)originTs, (long)view.getOriginTs());
            }
            catch (AssertionError assertion) {
                if (errors != null) {
                    errors.append(((Throwable)((Object)assertion)).getMessage()).append("\n");
                }
                throw assertion;
            }
        } else {
            this.validateTimestamp(messageDescription, false, "originTs", view.getOriginTs(), minTs, TimeUnit.MICROSECONDS, errors);
        }
        this.validateTimestamp(messageDescription, true, "createTs", view.getCreateTs(), minTs, TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "outTs", view.getOutTsMicros(), view.getCreateTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "sendTs", view.getSendTs(), view.getOutTsMicros(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "preSerializeTs", view.getPreSerializeTs(), view.getOutTsMicros(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, true, "postSerializeTs", view.getPostSerializeTs(), view.getPreSerializeTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, this.supportsPreWireTsPropagation(), "preWireTs", view.getPreWireTs(), view.getPostSerializeTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "postWireTs", view.getPostWireTs(), minTs, TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "preDeserializeTs", view.getPreDeserializeTs(), view.getPostWireTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "postDeserializeTs", view.getPostDeserializeTs(), view.getPreDeserializeTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "preProcessingTs", view.getPreProcessingTsMicros(), view.getPostDeserializeTs(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "receiveTs", view.getReceiveTs(), view.getPreProcessingTsMicros(), TimeUnit.MICROSECONDS, errors);
        this.validateTimestamp(messageDescription, false, "postProcessingTs", view.getPostProcessingTsMicros(), view.getReceiveTs(), TimeUnit.MICROSECONDS, errors);
        return view.getPreWireTs();
    }

    private void validateTimestamp(String messageDescription, boolean expected, String timestampDescription, long timestamp, long minTsMicros, TimeUnit resolution, StringBuilder validationErrors) {
        try {
            if (expected) {
                Assert.assertNotEquals((String)(messageDescription + " should have " + timestampDescription), (long)0L, (long)timestamp);
                long now = UtlTime.now();
                long adjustedTimestamp = timestamp;
                long adjustedMinTs = minTsMicros;
                switch (resolution) {
                    case MICROSECONDS: {
                        break;
                    }
                    case MILLISECONDS: {
                        adjustedMinTs = timestamp / 1000L;
                        now /= 100L;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid timestamp resolution: " + (Object)((Object)resolution));
                    }
                }
                Assert.assertTrue((String)(messageDescription + " should have " + timestampDescription + " greater than " + minTsMicros + " but was " + adjustedTimestamp), (adjustedTimestamp >= adjustedMinTs ? 1 : 0) != 0);
                Assert.assertTrue((String)(messageDescription + " should have " + timestampDescription + " less than " + now + " but was " + adjustedTimestamp), (adjustedTimestamp < now ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((String)(messageDescription + " should not have " + timestampDescription), (long)0L, (long)timestamp);
            }
        }
        catch (AssertionError assertion) {
            if (validationErrors != null) {
                validationErrors.append(((Throwable)((Object)assertion)).getMessage() + "\n");
            }
            throw assertion;
        }
    }

    @Test
    @Ignore
    public final void testSendGuaranteed() throws Exception {
        sender.setHoldMessages(false);
        forwarder.setHoldMessages(false);
        receiver.setHoldMessages(false);
        final MessageChannel forwardChannel = forwarder.getChannel(this.R_GUAR_1);
        sender.setHandler(SMATckMessage.class, new SMATCKMessageHandler<SMATckMessage>(){

            @Override
            public void handle(SMATckMessage message, AbstractSMATckAepTestApp app) throws Exception {
                app.sendMessage(forwardChannel, (IRogMessage)message.copy());
            }
        });
        UtlGovernor.run((int)100000, (int)10, (Runnable)new Runnable(){
            private int sent;

            @Override
            public final void run() {
                sender.sendMessage(sender.getChannel(SMATckAepTests.this.F_GUAR_1), (IRogMessage)SMATckAepTests.this.createTestMessage());
                if (++this.sent % 1000 == 0) {
                    System.out.println("Sent: " + this.sent);
                }
            }
        });
        this.assertSentAndReceivedMessageEqual(sender, forwarder, this.F_GUAR_1);
    }

    @Test
    @Ignore(value="Not yet implemented")
    public void testMessageKeyResolution() {
    }

    @Test
    public void testWilcardSubscriptionGuaranteed() throws Exception {
        this.testWilcardSubscription(true);
    }

    @Test
    public void testWilcardSubscriptionBestEffort() throws Exception {
        this.testWilcardSubscription(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWilcardSubscription(boolean guaranteed) throws Exception {
        MessageBusDescriptor busDescriptor = MessageBusDescriptor.create((String)("x-sma-tck-" + this.testcaseName.getMethodName()));
        busDescriptor.setProviderConfig(this.getForwarderBusDescriptor());
        MessageChannelDescriptor channelDescriptor = MessageChannelDescriptor.create((String)"filtered-channel", (MessageBusDescriptor)busDescriptor);
        channelDescriptor.setChannelKey("wildcard/${StringField}");
        channelDescriptor.setChannelId((short)1);
        channelDescriptor.setChannelQos(guaranteed ? MessageChannel.Qos.Guaranteed : MessageChannel.Qos.BestEffort);
        busDescriptor.addChannel(channelDescriptor);
        ArrayList<IRogMessage> sentMessages = new ArrayList<IRogMessage>();
        final ArrayList<IRogMessage> rcvdMessages = new ArrayList<IRogMessage>();
        MessageBusBinding senderBus = MessageBusBindingFactory.getInstance().createBinding(this.testcaseName.getMethodName() + "-sender", busDescriptor, new IEventHandler(){

            public void onEvent(Event event) {
            }
        });
        MessageBusBinding receiverBus = MessageBusBindingFactory.getInstance().createBinding(this.testcaseName.getMethodName() + "-receiver", busDescriptor, new IEventHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onEvent(Event event) {
                if (event instanceof MessageEvent) {
                    MessageView view = ((MessageEvent)event).getMessageView();
                    view.acquire();
                    ArrayList arrayList = rcvdMessages;
                    synchronized (arrayList) {
                        rcvdMessages.add((IRogMessage)view);
                        rcvdMessages.notify();
                    }
                }
            }
        });
        senderBus.start();
        MessageChannel sendChannel = senderBus.getMessageChannel("filtered-channel");
        MessageChannel receiveChannel = receiverBus.getMessageChannel("filtered-channel");
        try {
            receiveChannel.join(0);
        }
        catch (SmaPermanentException e) {
            if (!this.supportsWildcardSubscriptions()) {
                Assert.assertTrue((String)"Expected exception containing 'does not support wildcard subscriptions'", (e.getMessage().indexOf("does not support wildcard subscriptions") > 0 ? 1 : 0) != 0);
                if (senderBus != null) {
                    try {
                        senderBus.close(0);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                if (receiverBus != null) {
                    try {
                        receiverBus.close(0);
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
                return;
            }
            throw e;
        }
        receiverBus.start();
        SMATckMessage message = this.createTestMessage();
        message.setStringField("A");
        sendChannel.sendMessage((MessageView)message, 0);
        sentMessages.add(message);
        message = this.createTestMessage();
        message.setStringField("B");
        sendChannel.sendMessage((MessageView)message, 0);
        sentMessages.add(message);
        senderBus.flush();
        long timeout = System.currentTimeMillis() + 5000L;
        ArrayList<IRogMessage> arrayList = rcvdMessages;
        synchronized (arrayList) {
            while (rcvdMessages.size() < 2 && System.currentTimeMillis() < timeout) {
                rcvdMessages.wait(100L);
            }
        }
        finally {
            if (senderBus != null) {
                try {
                    senderBus.close(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (receiverBus != null) {
                try {
                    receiverBus.close(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Thread.sleep(1000L);
        this.assertSentAndReceivedMessageEqual(sentMessages, rcvdMessages);
    }

    protected void validateReceivedTransportHeaders(IRogMessage message) {
        MessageTransportHeaders headers = message.getMessageTransportHeaders();
        if (headers != null) {
            if (SMATckAepTests.verbose()) {
                System.out.println(message.getMessageChannel() + " headers: " + headers);
            } else {
                headers.toString();
            }
        }
    }

    protected final void assertSentAndReceivedMessageEqual(ArrayList<IRogMessage> sentMessages, ArrayList<IRogMessage> rcvdMessages) throws Exception {
        Assert.assertEquals((String)"Receiver has different number of messages than sender", (long)sentMessages.size(), (long)rcvdMessages.size());
        StringBuffer diffBuffer = new StringBuffer();
        for (int i = 1; i <= sentMessages.size(); ++i) {
            if (!RogLogUtil.compareRogNodes((IRogNode)((IRogNode)sentMessages.get(i - 1)), (IRogNode)((IRogNode)rcvdMessages.get(i - 1)), (RogLogUtil.FieldFilter)SENDER_RECEIVER_FILTER, (StringBuffer)diffBuffer)) {
                throw new Exception("Sender (source) and receiver (target) messages diverge at message #" + i + ": " + diffBuffer);
            }
            Assert.assertNull((String)"Sent message should not have transport headers: ", (Object)sentMessages.get(i - 1).getMessageTransportHeaders());
            this.validateReceivedTransportHeaders(rcvdMessages.get(i - 1));
        }
    }

    private final void workAroundXPLATFORM1494() throws Throwable {
        this.restartAll();
    }

    private final void restartAll() throws Throwable {
        SMATckAepTests.stopServer(sender.getServer(), true);
        SMATckAepTests.stopServer(forwarder.getServer(), true);
        SMATckAepTests.stopServer(receiver.getServer(), true);
        forwarder = (Forwarder)SMATckAepTests.createApp(SMATckAepTests.forwarder.descriptor.getName(), forwarder.getServer().getInstanceId(), forwarder.getClass(), forwarder.getServer().getConfigOverrides());
        receiver = (Receiver)SMATckAepTests.createApp(SMATckAepTests.receiver.descriptor.getName(), receiver.getServer().getInstanceId(), receiver.getClass(), receiver.getServer().getConfigOverrides());
        sender = (Sender)SMATckAepTests.createApp(SMATckAepTests.sender.descriptor.getName(), sender.getServer().getInstanceId(), sender.getClass(), sender.getServer().getConfigOverrides());
        sender.getEngine().waitForMessagingToStart();
        sender.waitForChannelUp(this.F_GUAR_1, 30L);
        forwarder.getEngine().waitForMessagingToStart();
        forwarder.waitForChannelUp(this.F_GUAR_REP_1, 30L);
        forwarder.waitForChannelUp(this.R_GUAR_1, 30L);
        receiver.getEngine().waitForMessagingToStart();
        receiver.waitForChannelUp(this.R_GUAR_1, 30L);
    }

    private final void ensureAcksFlushed(AbstractSMATckAepTestApp app) throws Exception {
        if (app != null) {
            app.ensureAcksFlushed();
        }
    }

    static {
        SMATckAepTests.configureForInMemoryConfigRepo(SMATckAepTests.class);
        System.setProperty("nv.msg.latency.stats", "true");
        System.setProperty("nv.sma.cleanmessagekey", "true");
        System.setProperty("nv.sma.cleanchannelfilter", "true");
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    public static final class Receiver
    extends AbstractSMATckAepTestApp {
        public static final String NAME = "sma-tck-receiver";

        @Override
        @EventHandler
        public void onMessage(SMATckMessage view) throws Exception {
            super.onMessage(view);
            if (SMATckAepTests.verbose()) {
                System.out.println("Forwarder received message :" + view.getMessageKey());
            }
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    public static final class Forwarder
    extends AbstractSMATckAepTestApp {
        public static final String NAME = "sma-tck-forwarder";

        @Override
        @EventHandler
        public void onMessage(SMATckMessage view) throws Exception {
            super.onMessage(view);
        }
    }

    @AppHAPolicy(value=AepEngine.HAPolicy.EventSourcing)
    public static final class Sender
    extends AbstractSMATckAepTestApp {
        public static final String NAME = "sma-tck-sender";
    }

    public static abstract class AbstractSMATckAepTestApp
    extends AbstractSMATckTestApp {
        volatile UnhandledMessageEvent ume;
        volatile boolean suppressUmeAck = false;
        CountDownLatch umeLatch = new CountDownLatch(1);
        private HashMap<Class<?>, SMATCKMessageHandler<?>> handlers = new HashMap();

        @EventHandler
        public void onMessage(SMATckMessage view) throws Exception {
            if (SMATckAepTests.verbose()) {
                System.out.println(this.getEngineDescriptor().getName() + " receipt from: " + view.getMessageChannel() + " - " + this.messageToJson(view) + " replayed: " + view.getIsReplayedMessage());
            }
            this.recordReceipt(view);
            SMATCKMessageHandler<?> handler = this.handlers.get(view.getClass());
            if (handler != null) {
                handler.handle(view, this);
            }
        }

        @Override
        @AppInjectionPoint
        protected void setAepEngine(AepEngine engine) {
            super.setAepEngine(engine);
            engine.registerFactory((Object)new SMATckFactory());
        }

        @Override
        @AppInjectionPoint
        protected void setAepEngineDescriptor(AepEngineDescriptor descriptor) {
            super.setAepEngineDescriptor(descriptor);
            descriptor.setMessagingStartFailPolicy(AepEngine.MessagingStartFailPolicy.NeverFail);
            descriptor.setAppExceptionHandlingPolicy(AepEngine.AppExceptionHandlingPolicy.RollbackAndStop);
        }

        public MessageChannel getChannel(String key) {
            return this.getChannelMessageTracker((String)key).channel;
        }

        public void setHandler(Class<?> messageType, SMATCKMessageHandler<?> handler) {
            this.handlers.put(messageType, handler);
        }

        @EventHandler
        public void onUnhandledMessageEvent(UnhandledMessageEvent event) throws SmaException {
            this.ume = event;
            if (this.suppressUmeAck) {
                this.ume.getBackingMessage().serializeToByteArray();
                this.ume.setAutoAck(false);
            } else {
                this.ume.setAutoAck(false);
                this.ume.acknowledge();
            }
            this.ume.acquire();
            this.umeLatch.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void validateExpectedUME(boolean supportsMessageKeyTransport, boolean supportsTransportMessageId, String expectedTopic, String channelName, String expectedBusName, String expectedBusType, String exceptionText, int corruptionFlags, boolean dispose) {
            Assert.assertNotNull((String)"No UnhandledMessageEvent was received", (Object)this.ume);
            try {
                SrvMonUnhandledMessageMessage monAlert = (SrvMonUnhandledMessageMessage)this.ume.getBackingMessage();
                if (exceptionText != null) {
                    Assert.assertNotNull((Object)("Expected exception message to contain '" + exceptionText + "', but no reason was reported."));
                    Assert.assertNotNull((Object)("Expected exception message to contain '" + exceptionText + "', but no reason was reported in SrvMonUnhandledMessageMessage."));
                    if (this.ume.getReason().getMessage().indexOf(exceptionText) == -1) {
                        Assert.fail((String)("Wrong exception, expected exception message to contain '" + exceptionText + "', but was: " + UtlThrowable.prepareStackTrace((Throwable)this.ume.getReason())));
                    }
                    if (monAlert.getException().indexOf(exceptionText) == -1) {
                        Assert.fail((String)("Wrong exception, expected exception message to contain '" + exceptionText + "', but was: " + monAlert.getException()));
                    }
                }
                if (supportsMessageKeyTransport) {
                    Assert.assertEquals((String)"Wrong message key in UnhandledMessageEvent", (Object)expectedTopic, (Object)this.ume.getMessageKey());
                    Assert.assertEquals((String)"Wrong message key in SrvMonUnhandledMessageMessage", (Object)expectedTopic, (Object)monAlert.getTriggeringMessageMessageKey());
                } else {
                    Assert.assertEquals((String)"Wrong message key in UnhandledMessageEvent", null, (Object)this.ume.getMessageKey());
                    Assert.assertEquals((String)"Wrong message key in SrvMonUnhandledMessageMessage", null, (Object)monAlert.getTriggeringMessageMessageKey());
                }
                if (supportsTransportMessageId) {
                    Assert.assertNotNull((String)"Expected MessageSMATransportMessageId to be non null ", (Object)this.ume.getMessageSMATransportMessageId());
                    Assert.assertNotNull((String)"Expected MessageSMATransportMessageId to be non null in SrvMonUnhandledMessageMessage ", (Object)monAlert.getTriggeringMessageSMATransportMessageId());
                } else {
                    Assert.assertNull((String)"Expected MessageSMATransportMessageId to be null ", (Object)this.ume.getMessageSMATransportMessageId());
                    Assert.assertNull((String)"Expected MessageSMATransportMessageId to be null in SrvMonUnhandledMessageMessage ", (Object)monAlert.getTriggeringMessageSMATransportMessageId());
                }
                if (channelName != null) {
                    MessageChannel channel;
                    Assert.assertNotNull((String)"Expected metadata to include channel, but it was null!", (Object)this.ume.getMessageMetadata());
                    if (this.ume.getMessageMetadata().getMessageChannelName() != null) {
                        Assert.assertEquals((String)"Wrong message channel in UnhandledMessageEvent MessageMetadata", (Object)channelName, (Object)this.ume.getMessageMetadata().getMessageChannelName());
                    }
                    if ((channel = this.ume.getMessageChannel()) != null) {
                        Assert.assertEquals((String)"Wrong message channel in UnhandledMessageEvent", (Object)channelName, (Object)this.ume.getMessageChannel().getName());
                    }
                    Assert.assertEquals((String)"Wrong message channel in SrvMonUnhandledMessageMessage MessageMetadata", (Object)channelName, (Object)monAlert.getTriggeringMessageMessageChannelName());
                } else if (channelName == null) {
                    Assert.assertNull((String)"Channel name was not expected, but metadata was not null and contained one", this.ume.getMessageMetadata() != null ? this.ume.getMessageMetadata().getMessageChannelName() : null);
                    Assert.assertEquals((String)"Channel name was not expected, but SrvMonUnhandledMessageMessage contained one", (Object)channelName, (Object)monAlert.getTriggeringMessageMessageChannelName());
                }
                if ((corruptionFlags & SMATckProviderHelper.FLG_NO_PAYLOAD) == 0 && (corruptionFlags & SMATckProviderHelper.FLG_INVALID_TRANSPORT_MESSAGE) == 0) {
                    Assert.assertNotNull((String)"No unwrapped message in UnhandledMessageEvent", (Object)this.ume.getUnwrappedMessage());
                    Assert.assertNotNull((String)"Unexpected null serialized payload in UnhandledMessageEvent", (Object)this.ume.getSerializedPayloadBlob());
                    Assert.assertNotNull((String)"No serialized message in SrvMonUnhandledMessageMessage", (Object)monAlert.getTriggeringMessageSMAMessagePayloadBlob());
                    Assert.assertTrue((String)"Empty serialized message in SrvMonUnhandledMessageMessage", (monAlert.getTriggeringMessageSMAMessagePayloadBlob().length > 0 ? 1 : 0) != 0);
                } else {
                    Assert.assertNull((String)"Unexpected serialized payload in UnhandledMessageEvent", (Object)this.ume.getSerializedPayloadBlob());
                    Assert.assertNull((String)"Unexpected serialized message in SrvMonUnhandledMessageMessage", (Object)monAlert.getTriggeringMessageSMAMessagePayloadBlob());
                    Assert.assertTrue((String)"Unexpected Empty serialized message in SrvMonUnhandledMessageMessage", (monAlert.getTriggeringMessageSMAMessagePayloadBlob() == null ? 1 : 0) != 0);
                }
                if (monAlert.getTriggeringMessageSMAMessageMetadataBlob() != null && (corruptionFlags & SMATckProviderHelper.FLG_NO_METADATA) == 0) {
                    MessageMetadata metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
                    try {
                        metadata.deserialize(ByteBuffer.wrap(monAlert.getTriggeringMessageSMAMessageMetadataBlob()));
                    }
                    catch (SmaException e) {
                        Assert.fail((String)("Unable to wrap reported metadata: " + UtlThrowable.prepareStackTrace((Throwable)e)));
                    }
                }
                if (expectedBusName != null) {
                    Assert.assertEquals((String)"Wrong busname in UnhandledMessageEvent", (Object)expectedBusName, (Object)this.ume.getMessageBusBinding().getName());
                    Assert.assertEquals((String)"Wrong busname in SrvMonUnhandledMessageMessage", (Object)expectedBusName, (Object)monAlert.getTriggeringMessageMessageBusName());
                } else {
                    Assert.assertNull((String)"Wrong busname in UnhandledMessageEvent", (Object)this.ume.getMessageBusBinding());
                    Assert.assertNull((String)"Wrong busname in SrvMonUnhandledMessageMessage", (Object)monAlert.getTriggeringMessageMessageBusName());
                }
                if (expectedBusType != null) {
                    Assert.assertEquals((String)"Wrong busname in UnhandledMessageEvent", (Object)expectedBusType, (Object)this.ume.getMessageBusBinding().getType());
                    Assert.assertEquals((String)"Wrong busname in SrvMonUnhandledMessageMessage", (Object)expectedBusType, (Object)monAlert.getTriggeringMessageMessageBusType());
                } else {
                    Assert.assertNull((String)"Wrong busname in UnhandledMessageEvent", (Object)this.ume.getMessageBusBinding());
                    Assert.assertNull((String)"Wrong busprovider in in SrvMonUnhandledMessageMessage", (Object)monAlert.getTriggeringMessageMessageBusType());
                }
                int c = 0;
                while (this.ume.owners() > 1 && c++ < 5) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                Assert.assertEquals((String)"Unexpected UnhandledMessageEvent ownershipCount", (long)1L, (long)this.ume.owners());
            }
            finally {
                if (dispose) {
                    this.ume.dispose();
                }
            }
        }

        public void reset() {
            this.resetMessageCounts();
            this.ume = null;
            this.umeLatch = new CountDownLatch(1);
            this.handlers.clear();
            this.suppressUmeAck = false;
        }

        public void ensureAcksFlushed() throws SmaException {
            if (this.engine == null) {
                return;
            }
            for (AepBusConnection connection : this.engine.getBusConnections()) {
                boolean needsFlush = false;
                for (MessageChannelDescriptor descriptor : connection.getBusDescriptor().getChannels()) {
                    if (descriptor.getChannelQos() != MessageChannel.Qos.Guaranteed) continue;
                    needsFlush = true;
                    break;
                }
                if (!needsFlush) continue;
                MessageBusBinding messageBusBinding = connection.getBusBinding();
                if (!messageBusBinding.acksRequireFlush()) {
                    // empty if block
                }
                messageBusBinding.flush();
            }
        }
    }

    static class TestMessageEventHandler {
        private volatile MessageView message;
        CountDownLatch messageLatch = new CountDownLatch(1);

        TestMessageEventHandler() {
        }

        @EventHandler
        public void onMessage(MessageView message) {
            this.message = message;
            this.messageLatch.countDown();
        }

        public MessageView getMessage() {
            return this.message;
        }
    }

    public static interface SMATCKMessageHandler<T extends MessageView> {
        public void handle(T var1, AbstractSMATckAepTestApp var2) throws Exception;
    }
}

