/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.tck;

import com.neeve.aep.AepEngine;
import com.neeve.aep.AepEngineDescriptor;
import com.neeve.aep.annotations.EventHandler;
import com.neeve.aep.event.AepChannelDownEvent;
import com.neeve.aep.event.AepChannelUpEvent;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.IRogNode;
import com.neeve.rog.log.RogLogUtil;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.app.annotations.AppEventHandlerContainersAccessor;
import com.neeve.server.app.annotations.AppInjectionPoint;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.tck.SMATckTestServer;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlObjectGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.Assert;

public abstract class AbstractSMATckTestApp {
    private Tracer tracer;
    protected final Random random = new Random(System.currentTimeMillis());
    AepEngineDescriptor descriptor;
    AepEngine engine;
    volatile boolean holdMessages = true;
    volatile int receivedMessageCount = 0;
    volatile List<IRogMessage> received = new ArrayList<IRogMessage>();
    volatile int sentMessageCount = 0;
    volatile List<IRogMessage> sent = new ArrayList<IRogMessage>();
    private volatile Map<String, ChannelMessageTracker> channelTrackers = new ConcurrentHashMap<String, ChannelMessageTracker>();
    private SrvAppLoader appLoader;
    private SMATckTestServer<?> server;

    @AppEventHandlerContainersAccessor
    private final void configure(Set<Object> containers) throws Exception {
        containers.add(this);
    }

    @AppInjectionPoint
    protected void onAppLoaderInjected(SrvAppLoader appLoader) {
        this.appLoader = appLoader;
        this.tracer = Tracer.create((Tracer.Level)Tracer.Level.INFO);
        this.tracer.bind(appLoader.getAppName());
    }

    public SrvAppLoader getAppLoader() {
        return this.appLoader;
    }

    @AppInjectionPoint
    protected void setAepEngine(AepEngine engine) {
        this.engine = engine;
    }

    public void setServer(SMATckTestServer<?> server) {
        this.server = server;
    }

    public SMATckTestServer<?> getServer() {
        return this.server;
    }

    public AepEngine getEngine() {
        return this.engine;
    }

    @AppInjectionPoint
    protected void setAepEngineDescriptor(AepEngineDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public AepEngineDescriptor getEngineDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onChannelUpEventHandler(AepChannelUpEvent event) {
        this.tracer.log("Channel Up: " + event.getMessageChannel().getName() + "@" + event.getMessageBusBinding().getName() + "[id=" + event.getMessageChannel().getId() + "], joined=" + event.getMessageChannel().isJoined(), Tracer.Level.CONFIG);
        ChannelMessageTracker channelTracker = this.getChannelMessageTracker(event.getMessageChannel());
        channelTracker.channel = event.getMessageChannel();
        AbstractSMATckTestApp abstractSMATckTestApp = this;
        synchronized (abstractSMATckTestApp) {
            this.notifyAll();
        }
    }

    @EventHandler
    public void onChannelDownEventHandler(AepChannelDownEvent event) {
        this.tracer.log("Channel Down: " + event.getMessageChannel().getName() + "@" + event.getMessageBusBinding().getName(), Tracer.Level.CONFIG);
        ChannelMessageTracker channelTracker = this.getChannelMessageTracker(event.getMessageChannel());
        channelTracker.channel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForChannelUp(String key, long timeoutSeconds) throws Exception {
        AbstractSMATckTestApp abstractSMATckTestApp = this;
        synchronized (abstractSMATckTestApp) {
            long timeout = System.currentTimeMillis() + timeoutSeconds * 1000L;
            while ((this.channelTrackers.get(key) == null || this.channelTrackers.get((Object)key).channel == null) && System.currentTimeMillis() < timeout) {
                try {
                    this.wait(Math.max(1L, timeout - System.currentTimeMillis()));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.channelTrackers.get(key) == null || this.channelTrackers.get((Object)key).channel == null) {
                throw new Exception("Channel " + key + " did not come up.");
            }
        }
    }

    protected ChannelMessageTracker getChannelMessageTracker(MessageChannel channel) {
        return this.getChannelMessageTracker(channel.getName(), channel.getMessageBusBinding().getName());
    }

    protected ChannelMessageTracker getChannelMessageTracker(String channelName, String busName) {
        return this.getChannelMessageTracker(channelName + "@" + busName);
    }

    protected ChannelMessageTracker getChannelMessageTracker(String key) {
        ChannelMessageTracker tracker = this.channelTrackers.get(key);
        if (tracker == null) {
            tracker = new ChannelMessageTracker();
            this.channelTrackers.put(key, tracker);
        }
        return this.channelTrackers.get(key);
    }

    protected IRogMessage recordReceipt(IRogMessage message) {
        if (this.tracer.debug) {
            RogLogUtil.traceObjectJson((String)(this.getAppLoader().getAppName() + " got message "), (IRogNode)message, (RogLogUtil.MetadataDisplayPolicy)RogLogUtil.MetadataDisplayPolicy.Off, (boolean)true, (RogLogUtil.JsonPrettyPrintStyle)RogLogUtil.JsonPrettyPrintStyle.Minimal, (Tracer)this.tracer, (Tracer.Level)Tracer.Level.DEBUG);
        }
        if (this.holdMessages) {
            message.acquire();
            this.received.add(message);
        }
        ++this.receivedMessageCount;
        ChannelMessageTracker tracker = this.getChannelMessageTracker(message.getMessageChannel(), message.getMessageBus());
        tracker.recordReceipt(message, this.holdMessages);
        return message;
    }

    protected String messageToJson(IRogMessage message) {
        return RogLogUtil.objectToJson((String)"", (IRogNode)message, (RogLogUtil.MetadataDisplayPolicy)RogLogUtil.MetadataDisplayPolicy.Off, (boolean)true, (RogLogUtil.JsonPrettyPrintStyle)RogLogUtil.JsonPrettyPrintStyle.Minimal);
    }

    public void sendMessage(String channelkey, IRogMessage message) {
        ChannelMessageTracker tracker = this.getChannelMessageTracker(channelkey);
        if (tracker == null || tracker.channel == null) {
            throw new IllegalArgumentException("No channel found for " + channelkey);
        }
        this.sendMessage(tracker.channel, message);
    }

    public void sendMessage(MessageChannel channel, IRogMessage message) {
        if (this.engine.getHAPolicy() == AepEngine.HAPolicy.EventSourcing) {
            message.setMessageBusAsRaw(channel.getMessageBusBinding().getNameAsRaw());
            message.setMessageChannelAsRaw(channel.getNameAsRaw());
        }
        if (this.holdMessages) {
            message.acquire();
        }
        this.engine.sendMessage(channel, message);
        this.recordSend(channel, message);
        if (this.holdMessages) {
            message.dispose();
        }
    }

    public final void injectMessage(IRogMessage message) {
        this.injectMessage(message, false, 0);
    }

    public final void injectMessage(IRogMessage message, boolean nonBlocking) {
        this.injectMessage(message, nonBlocking, 0);
    }

    public final void injectMessage(IRogMessage message, boolean nonBlocking, int delay) {
        if (this.engine.getState() == AepEngine.State.Started && this.engine.isPrimary()) {
            this.engine.injectMessage(message, nonBlocking, delay);
        }
    }

    protected IRogMessage recordSend(MessageChannel channel, IRogMessage message) {
        if (this.holdMessages) {
            message.acquire();
            this.sent.add(message);
        }
        ++this.sentMessageCount;
        this.getChannelMessageTracker(channel.getName(), channel.getMessageBusBinding().getName()).recordSend(message, this.holdMessages);
        return message;
    }

    public void setHoldMessages(boolean value) {
        this.holdMessages = value;
    }

    public boolean waitForTransactionStability(int seconds, long minTransactions) throws InterruptedException {
        boolean waiting = true;
        long timeout = System.currentTimeMillis() + (long)(seconds * 1000);
        while ((waiting = this.getEngine().getStats().getNumCommitsCompleted() < minTransactions) && System.currentTimeMillis() < timeout) {
            Thread.sleep(100L);
        }
        return !waiting;
    }

    public boolean waitForTransactionStability(int seconds) throws InterruptedException {
        return this.waitForTransactionStability(seconds, this.getEngine().getStats().getNumCommitsStarted());
    }

    public boolean waitForSends(int seconds, int minMessages) throws InterruptedException {
        boolean waiting = true;
        long lastSendTime = System.currentTimeMillis();
        long lastSendCount = this.receivedMessageCount;
        long timeout = seconds * 1000;
        while ((waiting = this.sentMessageCount < minMessages) && System.currentTimeMillis() - lastSendTime < timeout) {
            Thread.sleep(100L);
            if (lastSendCount >= (long)this.sentMessageCount) continue;
            lastSendCount = this.sentMessageCount;
            lastSendTime = System.currentTimeMillis();
        }
        return !waiting;
    }

    public void assertExpectedSends(int seconds, int expectedSends) throws InterruptedException {
        this.waitForSends(seconds, expectedSends);
        Assert.assertEquals((String)(this.getEngine().getName() + " has unexpected number of sent messages"), (long)expectedSends, (long)this.sentMessageCount);
    }

    public boolean waitForMessages(int seconds, int minMessages) throws InterruptedException {
        boolean waiting = true;
        long lastMessageTime = System.currentTimeMillis();
        long lastMessageCount = this.receivedMessageCount;
        long timeout = seconds * 1000;
        while ((waiting = this.receivedMessageCount < minMessages) && System.currentTimeMillis() - lastMessageTime < timeout) {
            Thread.sleep(100L);
            if (lastMessageCount >= (long)this.receivedMessageCount) continue;
            lastMessageCount = this.receivedMessageCount;
            lastMessageTime = System.currentTimeMillis();
        }
        return !waiting;
    }

    public void assertExpectedReceipt(int seconds, int expectedReceipt) throws InterruptedException {
        this.waitForMessages(seconds, expectedReceipt);
        Assert.assertEquals((String)(this.getEngine().getName() + " has unexpected number of received messages"), (long)expectedReceipt, (long)this.receivedMessageCount);
    }

    public void resetMessageCounts() {
        if (this.holdMessages) {
            for (IRogMessage message : this.received) {
                message.dispose();
            }
            this.received.clear();
            for (IRogMessage message : this.sent) {
                message.dispose();
            }
            this.sent.clear();
        }
        for (ChannelMessageTracker tracker : this.channelTrackers.values()) {
            tracker.reset();
        }
        this.receivedMessageCount = 0;
        this.sentMessageCount = 0;
    }

    public void cleanup() {
        this.resetMessageCounts();
    }

    public int getSentMessageCount() {
        return this.sentMessageCount;
    }

    public List<IRogMessage> getSentMessages() {
        return this.sent;
    }

    public List<IRogMessage> getSentMessages(String key) {
        if (!this.holdMessages) {
            throw new IllegalStateException("Can't get messages holdMessages is not set");
        }
        ChannelMessageTracker tracker = this.getChannelMessageTracker(key);
        if (tracker == null) {
            throw new IllegalArgumentException("Channel '" + key + "' not found for " + (this.descriptor != null ? this.descriptor.getName() : " app"));
        }
        return tracker.sentMessages;
    }

    public int getRcvdMessageCount() {
        return this.receivedMessageCount;
    }

    public List<IRogMessage> getRcvdMessages() {
        return this.received;
    }

    public List<IRogMessage> getRcvdMessages(String key) {
        if (!this.holdMessages) {
            throw new IllegalStateException("Can't get messages holdMessages is not set");
        }
        ChannelMessageTracker tracker = this.getChannelMessageTracker(key);
        if (tracker == null) {
            throw new IllegalArgumentException("Channel '" + key + "' not found for " + (this.descriptor != null ? this.descriptor.getName() : " app"));
        }
        return tracker.rcvdMessages;
    }

    public void dumpReceivedMessages(boolean includeMetadata) {
        this.tracer.log("Received " + this.receivedMessageCount + " messages.", Tracer.Level.INFO);
        if (this.holdMessages) {
            int i = 1;
            for (IRogMessage message : this.received) {
                this.dumpMessage("Message " + i++, message, includeMetadata);
            }
        }
    }

    public IRogMessage populateMessage(IRogMessage message) {
        try {
            UtlObjectGraph.populateObject((Object)message, (Class[])new Class[]{message.getClass()});
        }
        catch (Exception e) {
            throw new RuntimeException("Error populating message", e);
        }
        return message;
    }

    public void dumpMessage(String prefix, IRogMessage message, boolean includeMetadata) {
        RogLogUtil.traceObjectJson((String)(prefix + ":\n"), (IRogNode)message, (RogLogUtil.MetadataDisplayPolicy)(includeMetadata ? RogLogUtil.MetadataDisplayPolicy.On : RogLogUtil.MetadataDisplayPolicy.Off), (boolean)true, (RogLogUtil.JsonPrettyPrintStyle)RogLogUtil.JsonPrettyPrintStyle.SingleLine, (Tracer)this.tracer, (Tracer.Level)Tracer.Level.INFO);
    }

    public static class ChannelMessageTracker {
        public volatile int sentMessageCount;
        public volatile int rcvdMessageCount;
        public volatile int rcvdStabilitySuccessCount;
        public volatile int rcvdStabilityFailCount;
        public volatile MessageChannel channel;
        public volatile List<IRogMessage> rcvdMessages = new ArrayList<IRogMessage>();
        public volatile List<IRogMessage> sentMessages = new ArrayList<IRogMessage>();

        public void recordReceipt(IRogMessage message, boolean hold) {
            ++this.rcvdMessageCount;
            if (hold) {
                message.acquire();
                this.rcvdMessages.add(message);
            }
        }

        public void recordSend(IRogMessage message, boolean hold) {
            ++this.sentMessageCount;
            if (hold) {
                message.acquire();
                this.sentMessages.add(message);
            }
        }

        public void reset() {
            for (IRogMessage message : this.rcvdMessages) {
                message.dispose();
            }
            this.rcvdMessages.clear();
            this.rcvdMessageCount = 0;
            this.rcvdStabilitySuccessCount = 0;
            this.rcvdStabilityFailCount = 0;
            for (IRogMessage message : this.sentMessages) {
                message.dispose();
            }
            this.sentMessages.clear();
            this.sentMessageCount = 0;
        }

        public int getSentMessageCount() {
            return this.sentMessageCount;
        }

        public int getRcvdMessageCount() {
            return this.rcvdMessageCount;
        }

        public String toString() {
            return this.channel.getName() + " sent: " + this.sentMessageCount + " rcvd: " + this.rcvdMessageCount;
        }
    }
}

