/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoField;
import java.nio.ByteBuffer;

public final class StoFloatField
extends StoField {
    private float val;

    private StoFloatField(String name) {
        super(StoField.Type.FLOAT, name);
    }

    private StoFloatField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    @Override
    protected final void doSyncToBuffer(ByteBuffer buffer, int bufferOffset) {
        StoFloatField.put(buffer, bufferOffset, this.val);
    }

    @Override
    protected final void onBackingBufferAttach() {
        StoFloatField.put(this.buffer, this.bodyOffset, this.val);
    }

    @Override
    protected final void onBackingBufferDetach() {
        if ((double)this.val == 0.0) {
            this.val = StoFloatField.get(this.buffer, this.bodyOffset);
        }
    }

    @Override
    protected final void onBackingBufferChange() {
        this.val = 0.0f;
    }

    @Override
    protected final int getSerializedLength() {
        return 4;
    }

    @Override
    protected final String getValueString() {
        return String.valueOf(this.getValue());
    }

    @Override
    protected final boolean bodyContentsEquals(StoField other) {
        return this.getValue() == ((StoFloatField)other).getValue();
    }

    @Override
    protected final void cloneBody(StoField clonee) {
        ((StoFloatField)clonee).setValue(this.getValue());
    }

    public static StoFloatField create(String name) {
        return new StoFloatField(name);
    }

    public static StoFloatField create(ByteBuffer buffer, int bufferOffset) {
        return new StoFloatField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        return 4;
    }

    public static void put(ByteBuffer buffer, int offset, float val) {
        buffer.putFloat(offset, val);
    }

    public static float get(ByteBuffer buffer, int offset) {
        return buffer.getFloat(offset);
    }

    @Override
    public final boolean isVariableLength() {
        return false;
    }

    @Override
    public final void reset() {
        this.setValue(0.0f);
    }

    public final void setValue(float val) {
        this.val = val;
        if (this.buffer != null) {
            StoFloatField.put(this.buffer, this.bodyOffset, val);
        }
    }

    public final float getValue() {
        if ((double)this.val == 0.0 && this.buffer != null) {
            this.val = StoFloatField.get(this.buffer, this.bodyOffset);
        }
        return this.val;
    }
}

