#!/bin/bash

# Create the Rumi user
sudo adduser rumi
# ...add it to the sudo group 
sudo usermod -aG wheel rumi
# ...update the sudo group to enable nopasswd login
sudo sed -i 's/%wheel\tALL=(ALL)\tALL/# %wheel\tALL=(ALL)\tALL/g' /etc/sudoers
sudo sed -i 's/# %wheel\tALL=(ALL)\tNOPASSWD: ALL/%wheel\tALL=(ALL)\tNOPASSWD: ALL/g' /etc/sudoers
# ...create the user's key pair and authorized keys
sudo mkdir ~rumi/.ssh
sudo ssh-keygen -t rsa -N '' -f ~rumi/.ssh/id_rsa <<< y
sudo cp /root/.ssh/authorized_keys ~rumi/.ssh
sudo chown -R rumi ~rumi/.ssh
sudo chgrp -R rumi ~rumi/.ssh
sudo chmod 700 ~rumi/.ssh

# Work around for "authenticity of host ... can't be established"
sudo echo "UserKnownHostsFile /dev/null" >> ~rumi/.ssh/config
sudo echo "StrictHostKeyChecking no" >> ~rumi/.ssh/config
sudo chmod 644 ~rumi/.ssh/config

# Create the various directories
sudo mkdir ~rumi/scripts
sudo chown -R rumi ~rumi/scripts
sudo chgrp -R rumi ~rumi/scripts

# Install Java
sudo dnf -y install java-1.8.0-openjdk-devel
sudo dnf -y install java-11-openjdk-devel
sudo dnf -y install java-17-openjdk-devel

# Set up rumi user's .bash_profile
sudo echo "export JAVA_HOME_OPENJDK_8=/usr/lib/jvm/java-1.8.0-openjdk" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_OPENJDK_11=/usr/lib/jvm/java-11-openjdk" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_OPENJDK_17=/usr/lib/jvm/java-17-openjdk" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_8=\$JAVA_HOME_OPENJDK_8" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_11=\$JAVA_HOME_OPENJDK_11" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_17=\$JAVA_HOME_OPENJDK_17" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME=\$JAVA_HOME_8" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_11_OPTS=\"--add-opens=java.base/jdk.internal.ref=ALL-UNNAMED --add-opens=java.base/sun.nio.ch=ALL-UNNAMED --add-opens=java.base/java.lang=ALL-UNNAMED --add-opens=java.base/java.nio=ALL-UNNAMED --add-opens=java.base/java.io=ALL-UNNAMED --add-opens=java.management/sun.management=ALL-UNNAMED --illegal-access=warn\"" >> ~rumi/.setup_java.sh
sudo echo "export PATH=\$JAVA_HOME/bin:\$PATH" >> ~rumi/.setup_java.sh
sudo chown rumi ~rumi/.setup_java.sh
sudo chgrp rumi ~rumi/.setup_java.sh
sudo chmod +x ~rumi/.setup_java.sh
sudo echo ". ./.setup_java.sh" >> ~rumi/.bash_profile

# Disable remote login as root
sudo truncate --size=0 /root/.ssh/authorized_keys
