#!/bin/bash

print_usage() {
    echo "usage: $0 [--help] [--name <name>] " >&2
    exit 1
}

# Parse input parameters
NAME=""
while [[ "$1" == -* ]]; do
    case "$1" in
    --help|-h)
        print_usage
    ;;
    --name)
        shift
        NAME=$1
        shift
    ;;
    *)
        echo "error: unknown option: $1" >&2
        exit 1
    ;;
    esac
done

if [[ -z "$NAME" ]]; then
   print_usage
fi

sudo sed -i "/$NAME/d" /etc/named/zones/db.rumi.local
sudo systemctl restart named
