#!/bin/bash

# Create the Rumi user
sudo adduser rumi
# ...add it to the sudo group 
sudo usermod -aG wheel rumi
# ...update the sudo group to enable nopasswd login
sudo sed -i 's/%wheel\tALL=(ALL)\tALL/# %wheel\tALL=(ALL)\tALL/g' /etc/sudoers
sudo sed -i 's/# %wheel\tALL=(ALL)\tNOPASSWD: ALL/%wheel\tALL=(ALL)\tNOPASSWD: ALL/g' /etc/sudoers
# ...create the user's key pair and authorized keys
sudo mkdir ~rumi/.ssh
sudo ssh-keygen -t rsa -N '' -f ~rumi/.ssh/id_rsa <<< y
sudo cp /root/.ssh/authorized_keys ~rumi/.ssh
sudo chown -R rumi ~rumi/.ssh
sudo chgrp -R rumi ~rumi/.ssh
sudo chmod 700 ~rumi/.ssh

# Work around for "authenticity of host ... can't be established"
sudo echo "UserKnownHostsFile /dev/null" >> ~rumi/.ssh/config
sudo echo "StrictHostKeyChecking no" >> ~rumi/.ssh/config
sudo chmod 644 ~rumi/.ssh/config

# Create the various directories
sudo mkdir ~rumi/scripts
sudo chown -R rumi ~rumi/scripts
sudo chgrp -R rumi ~rumi/scripts
sudo mkdir ~rumi/staging
sudo chown -R rumi ~rumi/staging
sudo chgrp -R rumi ~rumi/staging

# Install epel (extra packages for enterprise linux)
# ...some packages installed below, such as nginx, need this
sudo yum -y install epel-release

# Install Java
sudo dnf -y install java-1.8.0-openjdk-devel
sudo dnf -y install java-11-openjdk-devel
sudo dnf -y install java-17-openjdk-devel

# Set up rumi user's .bash_profile
sudo echo "export JAVA_HOME_OPENJDK_8=/usr/lib/jvm/java-1.8.0-openjdk" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_OPENJDK_11=/usr/lib/jvm/java-11-openjdk" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_OPENJDK_17=/usr/lib/jvm/java-17-openjdk" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_8=\$JAVA_HOME_OPENJDK_8" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_11=\$JAVA_HOME_OPENJDK_11" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME_17=\$JAVA_HOME_OPENJDK_17" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_HOME=\$JAVA_HOME_8" >> ~rumi/.setup_java.sh
sudo echo "export JAVA_11_OPTS=\"--add-opens=java.base/jdk.internal.ref=ALL-UNNAMED --add-opens=java.base/sun.nio.ch=ALL-UNNAMED --add-opens=java.base/java.lang=ALL-UNNAMED --add-opens=java.base/java.nio=ALL-UNNAMED --add-opens=java.base/java.io=ALL-UNNAMED --add-opens=java.management/sun.management=ALL-UNNAMED --illegal-access=warn\"" >> ~rumi/.setup_java.sh
sudo echo "export PATH=\$JAVA_HOME/bin:\$PATH" >> ~rumi/.setup_java.sh
sudo chown rumi ~rumi/.setup_java.sh
sudo chgrp rumi ~rumi/.setup_java.sh
sudo chmod +x ~rumi/.setup_java.sh
sudo echo ". ./.setup_java.sh" >> ~rumi/.bash_profile

# Install and configure the BIND server
sudo yum -y install bind bind-utils
# ...back up and update /etc/named.conf
sudo cp /etc/named.conf /etc/named.conf.orig
# ...get local IP addr
IP=`hostname -I`
# ...update /etc/named.conf
#sudo sed -i '10i acl "trusted" {' /etc/named.conf
#sudo sed -i "11i \ \ \ \ \ \ \ \ $IP;" /etc/named.conf
#sudo sed -i "12i };" /etc/named.conf
#sudo sed -i "13i \ " /etc/named.conf
sudo sed -i "s/listen-on port 53 { 127.0.0.1; };/listen-on port 53 { 127.0.0.1; $IP;};/g" /etc/named.conf
sudo sed -i "s/allow-query     { localhost; };/allow-query     { any; };/g" /etc/named.conf
sudo sed -i '/recursion yes;/a\
        forwarders {\
            8.8.8.8;\
            1.1.1.1;\
        };' /etc/named.conf
sudo echo "include \"/etc/named/named.conf.local\";" >> /etc/named.conf
# ...create /etc/named/named.conf.local
sudo echo "zone \"rumi.local\" {" >> /etc/named/named.conf.local
sudo echo "    type master;" >> /etc/named/named.conf.local
sudo echo "    file \"/etc/named/zones/db.rumi.local\"; # zone file path" >> /etc/named/named.conf.local
sudo echo "};" >> /etc/named/named.conf.local
# ...create /etc/named/zones/db.rumi.local
sudo mkdir /etc/named/zones
sudo echo "\$TTL    604800" >> /etc/named/zones/db.rumi.local
sudo echo "@       IN      SOA     ns1.rumi.local. webmaster.rumi.local. (" >> /etc/named/zones/db.rumi.local
sudo echo "                              3         ; Serial" >> /etc/named/zones/db.rumi.local
sudo echo "                         604800         ; Refresh" >> /etc/named/zones/db.rumi.local
sudo echo "                          86400         ; Retry" >> /etc/named/zones/db.rumi.local
sudo echo "                        2419200         ; Expire" >> /etc/named/zones/db.rumi.local
sudo echo "                         604800 )       ; Negative Cache TTL" >> /etc/named/zones/db.rumi.local
sudo echo ";" >> /etc/named/zones/db.rumi.local
sudo echo "; name servers - NS records" >> /etc/named/zones/db.rumi.local
sudo echo "    IN      NS      ns1.rumi.local." >> /etc/named/zones/db.rumi.local
sudo echo "" >> /etc/named/zones/db.rumi.local
sudo echo "; name servers - A records" >> /etc/named/zones/db.rumi.local
sudo echo "ns1.rumi.local.          IN      A       $IP" >> /etc/named/zones/db.rumi.local
sudo echo "" >> /etc/named/zones/db.rumi.local
sudo echo "; A records" >> /etc/named/zones/db.rumi.local
sudo echo "; Rumi Platform" >> /etc/named/zones/db.rumi.local
# ...update /etc/resolver.conf
sudo mv /etc/resolv.conf /etc/resolv.conf.orig
sudo echo "# Generated by Rumi" > /etc/resolv.conf
sudo echo "search rumi.local" >> /etc/resolv.conf
sudo echo "nameserver 127.0.0.1" >> /etc/resolv.conf
sudo chattr +i /etc/resolv.conf

# Start the bind service
sudo systemctl start named
sudo systemctl enable named

# Install the NGINX server
sudo yum -y install nginx

# Backup the NGINX server config
sudo cp /etc/nginx/nginx.conf /etc/nginx/nginx.conf.orig

# Start the NGINX server
# ...note: we do this last since the readiness check for the jump server is port 80 reachability which will only happen when nginx is successfully launched
sudo systemctl start nginx
sudo systemctl enable nginx

# Disable remote login as root
sudo truncate --size=0 /root/.ssh/authorized_keys
