#!/bin/bash

# Usage help
print_usage() {
    echo "Usage: $0 --system <system_name> --script <script_name> --param <script_param>"
    exit 1
}

# Parse input arguments
SYSTEM=""
SCRIPT=""
PARAM=""

while [[ "$1" == -* ]]; do
    case "$1" in
    --system)
        shift
        SYSTEM=$1
        shift
        ;;
    --script)
        shift
        SCRIPT=$1
        shift
        ;;
    --param)
        shift
        PARAM=$1
        shift
        ;;
    *)
        echo "Unknown option: $1" >&2
        print_usage
        ;;
    esac
done

# Validate required parameters
if [[ -z "$SYSTEM" || -z "$SCRIPT" || -z "$PARAM" ]]; then
    print_usage
fi

# Execute the command locally within the container
source rumi-admin/current/setenv.sh && rumi-admin/current/controller/bin/ruc $SYSTEM $SCRIPT $PARAM
