/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ValueNode;
import com.akiban.sql.parser.Visitor;
import com.akiban.sql.types.DataTypeDescriptor;

public class CastNode
extends ValueNode {
    private ValueNode castOperand;
    private int targetCharType;
    private boolean forDataTypeFunction = false;
    private boolean externallyGeneratedCastNode = false;

    @Override
    public void init(Object castOperand, Object castTarget) throws StandardException {
        this.castOperand = (ValueNode)castOperand;
        this.setType((DataTypeDescriptor)castTarget);
    }

    @Override
    public void init(Object castOperand, Object charType, Object charLength) throws StandardException {
        this.castOperand = (ValueNode)castOperand;
        int charLen = (Integer)charLength;
        this.targetCharType = (Integer)charType;
        if (charLen < 0) {
            return;
        }
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.targetCharType, charLen));
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        CastNode other = (CastNode)node;
        this.castOperand = (ValueNode)this.getNodeFactory().copyNode(other.castOperand, this.getParserContext());
        this.targetCharType = other.targetCharType;
        this.forDataTypeFunction = other.forDataTypeFunction;
        this.externallyGeneratedCastNode = other.externallyGeneratedCastNode;
    }

    public ValueNode getCastOperand() {
        return this.castOperand;
    }

    @Override
    public String toString() {
        return "castTarget: " + this.getType() + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.castOperand != null) {
            this.printLabel(depth, "castOperand: ");
            this.castOperand.treePrint(depth + 1);
        }
    }

    @Override
    public boolean isConstantExpression() {
        return this.castOperand.isConstantExpression();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.castOperand != null) {
            this.castOperand = (ValueNode)this.castOperand.accept(v);
        }
    }

    void setForExternallyGeneratedCASTnode() {
        this.externallyGeneratedCastNode = true;
    }

    void setForDataTypeFunction(boolean b) {
        this.forDataTypeFunction = b;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            CastNode other = (CastNode)o;
            return this.getType().equals(other.getType()) && this.castOperand.isEquivalent(other.castOperand);
        }
        return false;
    }
}

