/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.client.link.ClientLinkManager;
import com.neeve.client.link.EClientLinkNotManagedException;
import com.neeve.tools.interactive.commands.Command;

public final class Dependees
extends Command {
    private final ClientLinkManager linkManager;

    public Dependees(ClientLinkManager linkManager) {
        this.linkManager = linkManager;
    }

    private void processDependees(String name) {
        try {
            String dependee;
            int numDependees = 0;
            while ((dependee = this.linkManager.getDependee(name)) != null) {
                System.out.print("->" + dependee);
                name = dependee;
                ++numDependees;
            }
            if (numDependees == 0) {
                System.out.println("<Root link>");
            } else {
                System.out.printf("\n", new Object[0]);
            }
        }
        catch (EClientLinkNotManagedException e) {
            System.out.println("Invalid link ['" + name + "'].");
        }
    }

    public final void run(String[] args) {
        if (args.length != 1) {
            System.out.println("Syntax error: dependees <name>");
        } else {
            this.processDependees(args[0]);
        }
    }

    public final void help() {
        System.out.println("dependees <name>");
        System.out.println("  List dependees of a link maintained by the link manager.");
    }

    public final String[] keywords() {
        return new String[]{"dependees"};
    }
}

