/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.mon;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.config.Config;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIndexedList;
import com.neeve.lang.XIterator;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.protobuf.ProtobufUtil;
import com.neeve.query.impl.index.IdxMappable;
import com.neeve.rog.IRogFieldReflector;
import com.neeve.server.mon.ISrvMonSysGCStats;
import com.neeve.server.mon.SrvMonHeartbeatFactory;
import com.neeve.server.mon.SrvMonSysGCCollectorStats;
import com.neeve.sma.MessageReflector;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReflection;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="xbuf", compatLevel="5.0.0", admVersion="nvx-rumi-adm v4.0 (build 590)", date="6/30/25 9:20 PM", buildInfo="nvx-rumi-server 4.0 (raven)")
@AdmFactoryInfo(factoryClass=SrvMonHeartbeatFactory.class, vfid=32, ofid=32, typeId=214)
@JsonPropertyOrder(value={"collectorsStats"})
public final class SrvMonSysGCStats
implements ISrvMonSysGCStats,
MessageReflector,
IdxMappable,
UtlPool.Item<SrvMonSysGCStats>,
AdmRuntime.BufferSizer {
    private static final HashMap<String, IRogFieldReflector<SrvMonSysGCStats, ?>> _fieldReflectors = new HashMap(0);
    private static final boolean _conserveMemory = Config.conserveMemory();
    private static final MemoryStats _memstats = MemoryStats.getInstance();
    private static final SrvMonSysGCStatsPoolFactory _srvMonSysGCStatsFactory = new SrvMonSysGCStatsPoolFactory();
    private static final SrvMonSysGCStatsPojoPoolFactory _srvMonSysGCStatsPojoFactory = new SrvMonSysGCStatsPojoPoolFactory();
    private static final SrvMonSysGCStatsSerializerPoolFactory _srvMonSysGCStatsSerializerFactory = new SrvMonSysGCStatsSerializerPoolFactory();
    private static final SrvMonSysGCStatsDeserializerPoolFactory _srvMonSysGCStatsDeserializerFactory = new SrvMonSysGCStatsDeserializerPoolFactory();
    static final UtlPool<SrvMonSysGCStats> _entityPool = UtlPool.create((String)"protobuf.entity", (String)"SrvMonSysGCStatsProtobufEntity.0.214", (UtlPool.Factory)_srvMonSysGCStatsFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(SrvMonSysGCStats.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new SrvMonSysGCStatsPoolEvictedItemReceiver());
    static final UtlPool<Pojo> _entityPojoPool = UtlPool.create((String)"protobuf.entity.pojo", (String)"SrvMonSysGCStatsProtobufEntityPojo.0.214", (UtlPool.Factory)_srvMonSysGCStatsPojoFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new SrvMonSysGCStatsPojoPoolEvictedItemReceiver());
    static final UtlPool<Serializer> _entitySerializerPool = UtlPool.create((String)"protobuf.entity.serializer", (String)"SrvMonSysGCStatsProtobufEntitySerializer.0.214", (UtlPool.Factory)_srvMonSysGCStatsSerializerFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new SrvMonSysGCStatsSerializerPoolEvictedItemReceiver());
    static final UtlPool<Deserializer> _entityDeserializerPool = UtlPool.create((String)"protobuf.entity.deserializer", (String)"SrvMonSysGCStatsProtobufEntityDeserializer.0.214", (UtlPool.Factory)_srvMonSysGCStatsDeserializerFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new SrvMonSysGCStatsDeserializerPoolEvictedItemReceiver());
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<SrvMonSysGCStats> _pool;
    private long _serializedBuffer;
    private int _serializedBufferLength;
    private int _serializedBufferCapacity;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final SrvMonSysGCStats[] EMPTY_ARRAY = new SrvMonSysGCStats[0];

    SrvMonSysGCStats() {
    }

    public static SrvMonSysGCStats create() {
        SrvMonSysGCStats entity = (SrvMonSysGCStats)_entityPool.get(null);
        _memstats.onEntityAllocated(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final long serializedBuffer(int len) {
        long oldBuffer = this._serializedBuffer;
        int oldCapacity = this._serializedBufferCapacity;
        int newCapacity = Math.max(len, 4);
        this._serializedBuffer = IOBuffer.ensureMemoryBlockCapacity((long)this._serializedBuffer, (long)this._serializedBufferCapacity, (int)newCapacity, (boolean)false);
        if (newCapacity > oldCapacity) {
            if (oldBuffer != 0L) {
                _memstats.onEntityDataDisposed(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memstats.onEntityDataAllocated(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
            this._serializedBufferCapacity = newCapacity;
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != 0L;
    }

    @JsonIgnore
    public final long getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @JsonIgnore
    public final int getSerializedBufferCapacity() {
        return this._serializedBufferCapacity;
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    @Deprecated
    @JsonIgnore
    public final int getSerializeToNativeLength() {
        return this.getSerializedBufferLength();
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferCapacity) {
            return addr;
        }
        int newLength = capacity <= this._serializedBufferCapacity ? capacity : Math.max(capacity, this._serializedBufferCapacity * 2);
        this._serializedBuffer = IOBuffer.ensureMemoryBlockCapacity((long)this._serializedBuffer, (long)this._serializedBufferCapacity, (int)newLength, (boolean)false);
        this._serializedBufferCapacity = newLength;
        return this._serializedBuffer;
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo(boolean onlyPojos) {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (onlyPojos) {
            this._pojo.setOnlyPojos();
        } else {
            this._pojo.clearOnlyPojos();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        if (onlyPojos) {
            this.conserveMemory(AdmRuntime.DataStoragePolicy.OnlyPojo);
        }
        return this._pojo;
    }

    public final Pojo pojo() {
        return this.pojo(false);
    }

    public final void disposeSerializedBuffer(boolean gcDisposed) {
        if (this.hasSerializedBuffer()) {
            IOBuffer.freeMemoryBlock((long)this._serializedBuffer, (int)this._serializedBufferCapacity);
            _memstats.onEntityDataDisposed(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity, this._serializedBufferCapacity, !gcDisposed);
            this._serializedBuffer = 0L;
            this._serializedBufferLength = 0;
            this._serializedBufferCapacity = 0;
        }
    }

    public final void disposeSerializedBuffer() {
        this.disposeSerializedBuffer(false);
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory(AdmRuntime.DataStoragePolicy policy) {
        switch (policy) {
            case OnlySerialized: {
                this.sync();
                this.disposeSerializer();
                this.disposeDeserializer();
                this.disposePojo(false);
                break;
            }
            case OnlyPojo: {
                this.disposeSerializer();
                this.disposeDeserializer();
                if (this._pojo == null || !this._pojo.isInitialized()) {
                    this.pojo(false);
                }
                this.disposeSerializedBuffer();
                this._pojo.forceDirty();
                break;
            }
            case SerializedOrPojo: {
                this.disposeSerializer();
                this.disposeDeserializer();
                if (this._pojo == null || !this._pojo.isInitialized()) break;
                this.disposeSerializedBuffer();
                this._pojo.forceDirty();
                break;
            }
        }
    }

    public final void clear(boolean disposeMembers) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this.disposePojo(false);
            } else {
                this._pojo.reset();
            }
        }
        if (disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear() {
        this.clear(false);
    }

    @Deprecated
    public final void clearContent() {
        this.clear();
    }

    public final void reset(boolean disposeMembers) {
        this.clear(disposeMembers);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset() {
        this.reset(_conserveMemory);
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SrvMonHeartbeatFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (this.hasDirtyPojo()) {
            this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
            this._pojo.clearDirty();
        } else if (!this.hasSerializedBuffer()) {
            this.serializedBuffer(0);
        }
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            IOBuffer.getTo((long)this._serializedBuffer, (int)0, (byte[])array, (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            IOBuffer.getTo((long)this._serializedBuffer, (int)0, (ByteBuffer)buffer, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            IOBuffer.copy((long)this._serializedBuffer, (int)0, (long)buffer.getNativeAddress(), (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(1052854);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            IOBuffer.copy((long)this._serializedBuffer, (int)0, (long)addr, (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    @Deprecated
    public final int serializeToNative(long addr, int offset) {
        return this.serializeTo(addr, offset);
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final SrvMonSysGCStats deserializeFromRawJson(String json) {
        try {
            SrvMonHeartbeatFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final SrvMonSysGCStats deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final SrvMonSysGCStats deserializeFrom(SrvMonSysGCStats val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final SrvMonSysGCStats wrap(IOBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer.getNativeAddress();
        this._serializedBufferLength = len;
        return this;
    }

    public final SrvMonSysGCStats deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final SrvMonSysGCStats deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            IOBuffer.putFrom((long)this.serializedBuffer(len), (int)0, (byte[])array, (int)offset, (int)len);
        }
        return this;
    }

    public final SrvMonSysGCStats deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final SrvMonSysGCStats deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            IOBuffer.putFrom((long)this.serializedBuffer(this._serializedBufferLength), (int)0, (ByteBuffer)buffer, (int)buffer.position(), (int)this._serializedBufferLength);
        }
        return this;
    }

    public final SrvMonSysGCStats deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            IOBuffer.copy((long)buffer.getNativeAddress(), (int)offset, (long)this.serializedBuffer(len), (int)0, (int)len);
        }
        return this;
    }

    public final SrvMonSysGCStats deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset, len);
    }

    public final SrvMonSysGCStats deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final SrvMonSysGCStats deserializeFrom(PktPacket packet) {
        try {
            IOElasticBuffer buffer = packet.getBody().getBuffer();
            SrvMonSysGCStats srvMonSysGCStats = this.deserializeFrom(buffer, 0, buffer.getLength());
            return srvMonSysGCStats;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final SrvMonSysGCStats deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        IOBuffer.copy((long)addr, (int)offset, (long)this.serializedBuffer(len), (int)0, (int)len);
        return this;
    }

    @Deprecated
    public final SrvMonSysGCStats deserializeFromNative(long addr, int offset, int len) {
        return this.deserializeFrom(addr, offset, len);
    }

    public final SrvMonSysGCStats deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(SrvMonSysGCStats copy) {
        copy.clear();
        this.sync();
        if (this.hasSerializedBuffer()) {
            copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
    }

    public final SrvMonSysGCStats copy() {
        SrvMonSysGCStats copy = SrvMonSysGCStats.create();
        this.copyInto(copy);
        return copy;
    }

    public boolean needsSync() {
        return false;
    }

    public final boolean fieldExists(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return _fieldReflectors.containsKey(name) || UtlReflection.hasPath((Object)message, (String)name);
    }

    public final boolean isFieldReflectable(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (_fieldReflectors.containsKey(name)) {
            return true;
        }
        Class c = UtlReflection.getUnwrappedReturnType(message.getClass(), (String)name);
        if (c == null || c.isArray()) {
            return false;
        }
        if (c.isEnum() || c.isPrimitive()) {
            return true;
        }
        return c == Date.class || c == Currency.class || c == String.class || XString.class.isAssignableFrom(c);
    }

    public final String getFieldValueAsString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.getFieldValueAsString(message, name.split("\\."));
    }

    public final String getFieldValueAsString(Object message, String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            return object == null ? null : String.valueOf(object);
        }
        IRogFieldReflector<SrvMonSysGCStats, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            Object val = reflector.getValue((Object)this);
            if (val != null) {
                return val.toString();
            }
            return null;
        }
        return null;
    }

    public final XString getFieldValueAsRawString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.getFieldValueAsRawString(message, name.split("\\."));
    }

    public final XString getFieldValueAsRawString(Object message, String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            return object == null ? null : XString.create((String)object.toString());
        }
        IRogFieldReflector<SrvMonSysGCStats, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            Object val = reflector.getValue((Object)this);
            if (val != null) {
                return XString.create((String)val.toString());
            }
            return null;
        }
        return null;
    }

    public final boolean appendFieldValueTo(Object message, String name, XString target) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.appendFieldValueTo(message, name.split("\\."), target);
    }

    public final boolean appendFieldValueTo(Object node, String[] pathComponents, XString target) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            if (object == null) {
                return false;
            }
            target.append((CharSequence)object.toString());
            return true;
        }
        IRogFieldReflector<SrvMonSysGCStats, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            return reflector.appendValueTo((Object)this, target);
        }
        return false;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    public static final int getCollectorsStatsFieldId() {
        return 19;
    }

    @Override
    @JsonProperty(value="collectorsStats")
    public final void setCollectorsStats(SrvMonSysGCCollectorStats[] val) {
        this.pojo().clearCollectorsStats();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().addToCollectorsStats(val[i]);
            }
        }
    }

    @Override
    public final void lendCollectorsStats(SrvMonSysGCCollectorStats[] val) {
        this.pojo().clearCollectorsStats();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().lendToCollectorsStats(val[i]);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void setCollectorsStatsFrom(XIterator<SrvMonSysGCCollectorStats> val) {
        this.pojo().clearCollectorsStats();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                SrvMonSysGCCollectorStats v = (SrvMonSysGCCollectorStats)val.next();
                if (v == null) continue;
                this.pojo().addToCollectorsStats(v);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void lendCollectorsStatsFrom(XIterator<SrvMonSysGCCollectorStats> val) {
        this.pojo().clearCollectorsStats();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                SrvMonSysGCCollectorStats v = (SrvMonSysGCCollectorStats)val.next();
                if (v == null) continue;
                this.pojo().lendToCollectorsStats(v);
            }
        }
    }

    @Override
    @JsonProperty(value="collectorsStats")
    public final void addCollectorsStats(SrvMonSysGCCollectorStats val) {
        this.pojo().addToCollectorsStats(val);
    }

    @Override
    @JsonProperty(value="collectorsStats")
    public final void lendCollectorsStats(SrvMonSysGCCollectorStats val) {
        this.pojo().lendToCollectorsStats(val);
    }

    @Override
    @JsonProperty(value="collectorsStats")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final SrvMonSysGCCollectorStats[] getCollectorsStats() {
        int count = this.pojo().getCollectorsStatsCount();
        if (count > 0) {
            SrvMonSysGCCollectorStats[] val = new SrvMonSysGCCollectorStats[count];
            XIterator<SrvMonSysGCCollectorStats> iterator = this.pojo().getCollectorsStatsIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (SrvMonSysGCCollectorStats)iterator.next();
            }
            return val;
        }
        return null;
    }

    @Override
    public final SrvMonSysGCCollectorStats[] getCollectorsStatsEmptyIfNull() {
        SrvMonSysGCCollectorStats[] val = this.getCollectorsStats();
        return val != null ? val : SrvMonSysGCCollectorStats.EMPTY_ARRAY;
    }

    @Override
    public final int getCollectorsStatsCount() {
        return this.pojo().getCollectorsStatsCount();
    }

    @Override
    public final SrvMonSysGCCollectorStats getCollectorsStatsAt(int index) {
        return this.pojo().getCollectorsStatsAt(index);
    }

    @Override
    public final XIterator<SrvMonSysGCCollectorStats> getCollectorsStatsIterator() {
        return this.pojo().getCollectorsStatsIterator();
    }

    @Override
    public final SrvMonSysGCCollectorStats[] takeCollectorsStats() {
        int count = this.pojo().getCollectorsStatsCount();
        if (count > 0) {
            SrvMonSysGCCollectorStats[] val = new SrvMonSysGCCollectorStats[count];
            XIterator<SrvMonSysGCCollectorStats> iterator = this.pojo().getCollectorsStatsIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (SrvMonSysGCCollectorStats)iterator.next();
                val[i].acquire();
            }
            return val;
        }
        return null;
    }

    @Override
    public final void clearCollectorsStats() {
        this.pojo().clearCollectorsStats();
    }

    public static final <T> IRogFieldReflector<SrvMonSysGCStats, T> getFieldReflector(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return SrvMonSysGCStats.getFieldReflector(name.split("\\."));
    }

    public static final <T> IRogFieldReflector<SrvMonSysGCStats, T> getFieldReflector(String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            throw new IllegalArgumentException("fetching of reflectable field accessors for nested fields is currently not supported");
        }
        return _fieldReflectors.get(pathComponents[0]);
    }

    public final Object getQueryFieldValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IRogFieldReflector<SrvMonSysGCStats, ?> reflector = _fieldReflectors.get(name);
        if (reflector != null) {
            return reflector.getValue((Object)this);
        }
        return null;
    }

    public final SrvMonSysGCStats init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final SrvMonSysGCStats setPool(UtlPool<SrvMonSysGCStats> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<SrvMonSysGCStats> getPool() {
        return this._pool;
    }

    public final SrvMonSysGCStats acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose() {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            this._pool.put((UtlPool.Item)this);
            _memstats.onEntityDisposed(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final Object clone() {
        SrvMonSysGCStats clonee = SrvMonSysGCStats.create();
        SrvMonSysGCCollectorStats[] cloner_collectorsStats = this.getCollectorsStats();
        if (cloner_collectorsStats != null) {
            SrvMonSysGCCollectorStats[] clonee_collectorsStats = new SrvMonSysGCCollectorStats[cloner_collectorsStats.length];
            for (int i = 0; i < cloner_collectorsStats.length; ++i) {
                clonee_collectorsStats[i] = (SrvMonSysGCCollectorStats)cloner_collectorsStats[i].clone();
            }
            clonee.setCollectorsStats(clonee_collectorsStats);
        } else {
            clonee.setCollectorsStats(null);
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        builder.append(0 == c++ ? "" : ",").append("CollectorsStats=").append(Arrays.toString(this.getCollectorsStats()));
        builder.append("}");
        return builder.toString();
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final byte FLG_ONLY_POJOS = 8;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private final XIndexedList<SrvMonSysGCCollectorStats> _usrCollectorsStats = new XIndexedList(256);

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memstats.onEntityPojoAllocated(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final int getCollectorsStatsCount() {
            return this._usrCollectorsStats.size();
        }

        public final SrvMonSysGCCollectorStats getCollectorsStatsAt(int index) {
            if (index < 0 || index >= this.getCollectorsStatsCount()) {
                throw new IllegalArgumentException("index out of range");
            }
            return (SrvMonSysGCCollectorStats)this._usrCollectorsStats.get(index);
        }

        public final XIterator<SrvMonSysGCCollectorStats> getCollectorsStatsIterator() {
            return this._usrCollectorsStats.reusableIterator();
        }

        public final void addToCollectorsStats(SrvMonSysGCCollectorStats val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrCollectorsStats.add((Object)val);
            this._dirty = true;
        }

        public final void addToCollectorsStatsFrom(SrvMonSysGCCollectorStats.Deserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                return;
            }
            SrvMonSysGCCollectorStats val = SrvMonSysGCCollectorStats.create();
            if (deserializer.getSerializedLength() > 0) {
                val.deserializeFrom(deserializer);
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrCollectorsStats.add((Object)val);
            this._dirty = true;
        }

        public final void lendToCollectorsStats(SrvMonSysGCCollectorStats val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            val.acquire();
            this._usrCollectorsStats.add((Object)val);
            this._dirty = true;
        }

        public final void clearCollectorsStats() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int size = this._usrCollectorsStats.size();
            if (size == 0) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                ((SrvMonSysGCCollectorStats)this._usrCollectorsStats.get(i)).dispose();
            }
            this._usrCollectorsStats.clear();
            this._dirty = true;
        }

        public final void clear() {
            this._readonly = false;
            this.clearCollectorsStats();
            this._fieldBitmask[0] = 0L;
            this._dirty = true;
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final Pojo setOnlyPojos() {
            this._flags = (byte)(this._flags | 8);
            return this;
        }

        private final boolean isOnlyPojos() {
            return (this._flags & 8) != 0;
        }

        private final Pojo clearOnlyPojos() {
            this._flags = (byte)(this._flags & 0xFFFFFFF7);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = 0;
            XIterator<SrvMonSysGCCollectorStats> collectorsStatsIterator = this.getCollectorsStatsIterator();
            while (collectorsStatsIterator.hasNext()) {
                SrvMonSysGCCollectorStats val = (SrvMonSysGCCollectorStats)collectorsStatsIterator.next();
                len += val.hasDirtyPojo() ? ProtobufUtil.varlenFieldSerializedLength((int)19, (int)val.pojo().getSerializedLength()) : ProtobufUtil.varlenFieldSerializedLength((int)19, (int)val.getSerializedBufferLength());
            }
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            XIterator<SrvMonSysGCCollectorStats> collectorsStatsIterator = this.getCollectorsStatsIterator();
            while (collectorsStatsIterator.hasNext()) {
                SrvMonSysGCCollectorStats val = (SrvMonSysGCCollectorStats)collectorsStatsIterator.next();
                serializer.collectorsStats(val);
                if (!this.isOnlyPojos()) continue;
                val.pojo(true);
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset() {
            this.clear();
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntityPojoDisposed(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handleCollectorsStats(SrvMonSysGCCollectorStats.Deserializer val) {
                Pojo.this.addToCollectorsStatsFrom(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private final SrvMonSysGCCollectorStats.Deserializer _collectorsStatsDeserializer = SrvMonSysGCCollectorStats.Deserializer.create(true);
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private final IOBuffer.VarintDeserializeLength _varintDeserializeLength = new IOBuffer.VarintDeserializeLength();
        private long _addr;
        private int _offset;
        private int _len;
        private boolean _stopped;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memstats.onEntityDeserializerAllocated(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(IOBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getLength() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            int tlen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            this._stopped = false;
            block9: for (int pos = this._offset; !this._stopped && pos < lim; pos += tlen + flen) {
                int ftag = IOBuffer.getVarint32((long)addr, (int)pos, (IOBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                int ftype = ftag & 7;
                switch (ftag >>> 3) {
                    case 19: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 19");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = IOBuffer.getVarint32((long)addr, (int)(pos + tlen), (IOBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleCollectorsStats(this._collectorsStatsDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block9;
                    }
                    default: {
                        switch (ftype) {
                            case 0: {
                                tlen = this._varintDeserializeLength.value;
                                IOBuffer.getVarint32((long)addr, (int)(pos + tlen), (IOBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen = this._varintDeserializeLength.value;
                                continue block9;
                            }
                            case 1: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 8;
                                continue block9;
                            }
                            case 2: {
                                tlen = this._varintDeserializeLength.value;
                                flen = IOBuffer.getVarint32((long)addr, (int)(pos + tlen), (IOBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen += this._varintDeserializeLength.value;
                                continue block9;
                            }
                            case 5: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 4;
                                continue block9;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + (IOBuffer.getVarint32((long)addr, (int)pos, (IOBuffer.VarintDeserializeLength)this._varintDeserializeLength) >>> 3));
                    }
                }
            }
        }

        public final void stop() {
            this._stopped = true;
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntityDeserializerDisposed(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static abstract class AbstractCallbackImpl
        implements Callback {
            @Override
            public void handleCollectorsStats(SrvMonSysGCCollectorStats.Deserializer val) {
            }
        }

        public static interface Callback {
            public void handleCollectorsStats(SrvMonSysGCCollectorStats.Deserializer var1);
        }
    }

    public static final class Serializer
    implements UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private final SrvMonSysGCCollectorStats.Serializer _collectorsStatsSerializer = SrvMonSysGCCollectorStats.Serializer.create(true);
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private SrvMonSysGCStats _entity;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memstats.onEntitySerializerAllocated(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        final Serializer init(SrvMonSysGCStats entity) {
            this.init(entity.getSerializedBuffer(), 0);
            this._entity = entity;
            return this;
        }

        public final Serializer init(long addr, int len) {
            this._entity = null;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(IOBuffer buffer, int len) {
            return this.init(buffer.getNativeAddress(), len);
        }

        public final Serializer init(IOBuffer buffer) {
            return this.init(buffer.getNativeAddress(), 0);
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getLength() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(IOBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Serializer collectorsStats(SrvMonSysGCCollectorStats val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            val.sync();
            int serializedEntityLength = val.getSerializedBufferLength();
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)19, (int)serializedEntityLength));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)154);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)serializedEntityLength);
            val.serializeTo(this._addr, this._len);
            this._len += serializedEntityLength;
            return this;
        }

        public final Serializer collectorsStats(SrvMonSysGCCollectorStats.Serializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)19, (int)val.getSerializedLength()));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)154);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer collectorsStats(SrvMonSysGCCollectorStats.Deserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)19, (int)val.getSerializedLength()));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)154);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer collectorsStats(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)19, (int)len));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)154);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            if (val != null) {
                val.getTo(offset, this._addr, this._len, len);
            }
            this._len += len;
            return this;
        }

        public final Serializer collectorsStats(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (addr == 0L && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)19, (int)len));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)154);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            if (addr != 0L) {
                IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            }
            this._len += len;
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntitySerializerDisposed(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    private static final class SrvMonSysGCStatsDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private SrvMonSysGCStatsDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memstats.onEntityDeserializerLeaked(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class SrvMonSysGCStatsDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private SrvMonSysGCStatsDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class SrvMonSysGCStatsSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private SrvMonSysGCStatsSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memstats.onEntitySerializerLeaked(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class SrvMonSysGCStatsSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private SrvMonSysGCStatsSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class SrvMonSysGCStatsPojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private SrvMonSysGCStatsPojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            _memstats.onEntityPojoLeaked(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class SrvMonSysGCStatsPojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private SrvMonSysGCStatsPojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class SrvMonSysGCStatsPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<SrvMonSysGCStats> {
        private SrvMonSysGCStatsPoolEvictedItemReceiver() {
        }

        public final void process(SrvMonSysGCStats evictedItem) {
            _memstats.onEntityLeaked(SrvMonSysGCStats.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class SrvMonSysGCStatsPoolFactory
    implements UtlPool.Factory<SrvMonSysGCStats> {
        private SrvMonSysGCStatsPoolFactory() {
        }

        public final SrvMonSysGCStats createItem(Object object) {
            return new SrvMonSysGCStats();
        }

        public final SrvMonSysGCStats[] createItemArray(int size) {
            return new SrvMonSysGCStats[size];
        }
    }

    static final class SrvMonSysGCStatsPoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        SrvMonSysGCStatsPoolFactoryItemCreateArgument() {
        }

        SrvMonSysGCStatsPoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }

    public static final class PacketBody
    extends PktBodyData {
        private PacketBody(Properties props) {
            super(1052854, props);
        }

        public static PktBody create(Properties props) {
            return new PacketBody(props);
        }

        public static PktBody create() {
            return PacketBody.create(null);
        }
    }
}

