/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.link;

import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.LnkHandshaker;
import com.neeve.link.LnkLTPAuthority;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyServerClientConnectReply;
import com.neeve.pkt.types.PktBodyServerClientConnectRequest;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.app.SrvAppManager;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.link.ESrvLinkHandshakeFailureException;
import com.neeve.server.link.ISrvLinkHandshakeCompletionHandler;
import com.neeve.server.link.SrvLink;
import com.neeve.server.link.SrvLinkClient;
import com.neeve.server.link.SrvLinkClientCollection;
import com.neeve.server.link.SrvLinkConfig;
import com.neeve.server.link.SrvLinkHandshakeFailureCompletionData;
import com.neeve.server.link.SrvLinkHandshakeSuccessCompletionData;
import com.neeve.trace.Tracer;

final class SrvLinkHandshaker
extends LnkHandshaker {
    private final SrvConfigDescriptor configDescriptor;
    private final SrvAppManager appManager;
    private final SrvLink link;
    private final SrvLinkClientCollection clients;
    private final IEmxDispatcher dispatcher;
    private final ISrvLinkHandshakeCompletionHandler completionHandler;

    SrvLinkHandshaker(SrvConfigDescriptor configDescriptor, SrvAppManager appManager, SrvLink link, IEmxDispatcher dispatcher, SrvLinkClientCollection clients, int timeout, ISrvLinkHandshakeCompletionHandler completionHandler) {
        super(SrvLinkConfig.getConfig(), link.getCommLink(), timeout, (short)-1, link.wasAccepted() ? LnkHandshaker.State.ACCEPTED : LnkHandshaker.State.CONNECTED);
        this.configDescriptor = configDescriptor;
        this.appManager = appManager;
        this.link = link;
        this.dispatcher = dispatcher;
        this.clients = clients;
        this.completionHandler = completionHandler;
        if (link.getCommLink().isReadOperational()) {
            throw new InternalError("Read cannot be operational on link when handshake is kicked off");
        }
        this.start(dispatcher);
    }

    private final void validateAppVersion(SrvAppLoader appLoader, short appVersion) throws Exception {
        if (appVersion != 0 && appLoader.getAppVersion() != 0 && appVersion > appLoader.getAppVersion()) {
            throw new Exception("Incompatible application version [req=" + appVersion + " actual=" + appLoader.getAppVersion() + "]");
        }
    }

    private final void validateClientConnectRequest(PktPacket packet) throws Exception {
        PktBodyServerClientConnectRequest pktBody = (PktBodyServerClientConnectRequest)packet.getBody();
        String clientName = pktBody.getClientName();
        if (clientName == null) {
            throw new ESrvLinkHandshakeFailureException("Invalid client name [null]");
        }
        if (this.clients.getClient(clientName) != null) {
            throw new ESrvLinkHandshakeFailureException("Client with name '" + clientName + "' already exists.");
        }
        String group = pktBody.getClientGroup();
        if (group == null || this.configDescriptor.getGroup().compareToIgnoreCase(group) != 0) {
            throw new ESrvLinkHandshakeFailureException("Group mismatch [this='" + this.configDescriptor.getGroup() + "' client='" + group + "']");
        }
        String appName = pktBody.getAppName();
        if (appName == null) {
            throw new ESrvLinkHandshakeFailureException("invalid application name [null]");
        }
        SrvAppLoader appLoader = this.appManager.getAppLoader(appName);
        if (appLoader == null) {
            throw new Exception("application [" + appName + "] is not loaded");
        }
        this.validateAppVersion(appLoader, pktBody.getAppVersion());
    }

    private final PktPacket prepareClientConnectReply(PktPacket request) throws Exception {
        PktPacket reply = PktFactory.getInstance().createPacket(557);
        PktHeader pktHeader = reply.getHeader();
        PktBodyServerClientConnectReply pktBody = (PktBodyServerClientConnectReply)reply.getBody();
        pktHeader.setDestPort(request.getHeader().getSrcPort());
        pktBody.setServerVersion(this.configDescriptor.getVersion());
        pktBody.setServerLtp(LnkLTPAuthority.getInstance().alloc());
        pktBody.setServerName(this.configDescriptor.getName());
        return reply;
    }

    private final SrvLinkClient createClient(PktPacket request, PktPacket reply) throws Exception {
        PktHeader requestHeader = request.getHeader();
        PktBodyServerClientConnectRequest requestBody = (PktBodyServerClientConnectRequest)request.getBody();
        PktBodyServerClientConnectReply replyBody = (PktBodyServerClientConnectReply)reply.getBody();
        int addr = requestHeader.getSrc();
        short clientLtp = requestHeader.getSrcPort();
        String name = requestBody.getClientName();
        short srvLtp = replyBody.getServerLtp();
        SrvLinkClient.AppInfo appInfo = null;
        if (requestBody.getAppName() != null) {
            appInfo = new SrvLinkClient.AppInfo(requestBody.getAppName(), requestBody.getAppVersion());
        }
        this.link.setThreadAffinity(requestBody.getThreadAffinity());
        return new SrvLinkClient(name, addr, this.link, srvLtp, clientLtp, appInfo);
    }

    protected final PktPacket prepareRequest() throws Exception {
        throw new InternalError("Received request to prepare a request packet for client handshake!");
    }

    protected final void validateRequest(PktPacket request) throws Exception {
        switch (request.getBody().getType()) {
            case 556: {
                this.validateClientConnectRequest(request);
                break;
            }
            default: {
                throw new ESrvLinkHandshakeFailureException("Invalid connect request packet received [" + request.getBody().getType() + "]");
            }
        }
    }

    protected final PktPacket prepareReply(PktPacket request) throws Exception {
        PktPacket reply = null;
        switch (request.getBody().getType()) {
            case 556: {
                reply = this.prepareClientConnectReply(request);
                break;
            }
            default: {
                throw new ESrvLinkHandshakeFailureException("Invalid connect request packet received [" + request.getBody().getType() + "]");
            }
        }
        return reply;
    }

    protected final void validateReply(PktPacket reply) throws Exception {
        throw new InternalError("Received request to validate a reply packet for a client handshake!");
    }

    protected final void onComplete(LnkHandshaker.CompletionData completionData) {
        if (this.link.getCommLink().isReadOperational()) {
            throw new InternalError("Read is operational on handshake completion");
        }
        SrvLinkClient client = null;
        if (completionData.status == null) {
            try {
                client = this.createClient(completionData.request, completionData.reply);
            }
            catch (Exception e) {
                if (this.tracer.debug) {
                    this.tracer.log("Failed to create client after successful handshake completion [" + e.toString() + "]", Tracer.Level.DEBUG);
                }
                completionData.status = e;
            }
        }
        try {
            if (completionData.status != null) {
                this.completionHandler.onHandshakeComplete(this.link, false, new SrvLinkHandshakeFailureCompletionData(completionData.status));
            } else {
                this.completionHandler.onHandshakeComplete(this.link, true, new SrvLinkHandshakeSuccessCompletionData(client, completionData.overflowPacketList));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final String toString() {
        return this.link.toString();
    }
}

