/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.admin.impl.direct;

import com.neeve.client.Client;
import com.neeve.client.ClientEvents;
import com.neeve.client.EClientOpFailedException;
import com.neeve.client.EClientOpTimeoutException;
import com.neeve.client.EClientRootException;
import com.neeve.client.IClientEventHandler;
import com.neeve.client.link.EClientLinkException;
import com.neeve.link.ELnkException;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogMessage;
import com.neeve.server.admin.AdminSession;
import com.neeve.server.admin.EAdminException;
import com.neeve.server.admin.EAdminOpFailedException;
import com.neeve.server.admin.EAdminOpServerErrorException;
import com.neeve.server.admin.EAdminOpTimeoutException;
import com.neeve.server.admin.impl.AdminSessionBase;
import com.neeve.server.admin.impl.direct.AdminClient;
import com.neeve.server.admin.impl.direct.AdminClientConnection;
import com.neeve.server.admin.impl.direct.EAdminClientServerError;
import com.neeve.server.mon.cnc.ISrvMonXvmRequest;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.server.mon.cnc.SrvMonXvmInfoRequest;
import com.neeve.server.mon.cnc.SrvMonXvmInfoResponse;
import com.neeve.sma.MessageView;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlProps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class AdminClientSession
extends AdminSessionBase
implements AdminSession {
    private static final String tracePrefix = "[AdminClientSession] ";
    private final UtlAddressDescriptor descriptor;
    private final AdminClient client;
    private final AdminClientConnection clientConnection;
    public static final String TYPE = "direct";

    private AdminClientSession(String adminClientId, String xvmName, UtlAddressDescriptor descriptor, AdminSession.EventHandler eventHandler, Properties sessionProps, Tracer tracer) {
        super(adminClientId, xvmName, eventHandler, sessionProps, tracer);
        this.descriptor = descriptor;
        this.client = AdminClient.create(adminClientId, new AdminClientEventHandler());
        this.clientConnection = (AdminClientConnection)((Object)this.client.createConnection());
        this.clientConnection.setConnectHandshakeTimeout(this.connectHandshakeTimeout);
        this.clientConnection.setApp("admin");
        if (tracer.isEnabled(Tracer.Level.CONFIG)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Direct Admin Session created for xvm '" + xvmName + "' {\n");
            sb.append("...connectionDescriptor=" + this.getConnectionDescriptor()).append("\n");
            sb.append("...sessionUseName=" + adminClientId).append("\n");
            sb.append("...passiveMonitoringOnly=" + this.isPassiveMonitoringOnly()).append("\n");
            sb.append("...sessionProps {\n");
            HashMap filteredProps = (HashMap)UtlProps.getSubProps((Properties)sessionProps, (String)"nv.server.admin", (boolean)true, new HashMap());
            for (Map.Entry prop : filteredProps.entrySet()) {
                sb.append("......").append(String.valueOf(prop.getKey())).append("=").append(String.valueOf(prop.getValue())).append("\n");
            }
            sb.append("}");
            this.tracer.log(tracePrefix + sb.toString(), Tracer.Level.CONFIG);
        }
    }

    public static final AdminClientSession create(String adminClientId, String xvmName, UtlAddressDescriptor descriptor, AdminSession.EventHandler eventHandler, Properties sessionProps, Tracer tracer) {
        return new AdminClientSession(adminClientId, xvmName, descriptor, eventHandler, sessionProps, tracer);
    }

    private final void connect() throws EAdminException {
        Properties linkManagerProps = new Properties();
        linkManagerProps.setProperty("ThreadingModel", "strmtw");
        linkManagerProps.setProperty("Detached", "true");
        try {
            this.clientConnection.setLinkContext(this.descriptor.toShortString(), linkManagerProps);
            this.client.setConnectionPool(this.clientConnection);
            this.client.open();
        }
        catch (EClientRootException e) {
            throw new EAdminException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private final void pingAdminApp() throws EAdminException {
        Boolean pingResponse = Boolean.FALSE;
        for (int i = 0; i < 5; ++i) {
            try {
                pingResponse = Boolean.valueOf(String.valueOf(this.client.invokeCommand(100 + i * 500, "server", "app_ping", "admin")));
                if (!pingResponse.booleanValue()) continue;
            }
            catch (EClientOpFailedException e) {
                if (i != 4) continue;
                this.tracer.log("Failed to ping admin app: " + e.getMessage(), Tracer.Level.SEVERE);
            }
            break;
        }
        if (!pingResponse.booleanValue()) {
            throw new EAdminOpTimeoutException("Timed out waiting for admin app to come up");
        }
    }

    @Override
    protected final void doConnect() throws EAdminException {
        this.connect();
        this.pingAdminApp();
        this.setAdminCompatVersion(String.valueOf(this.doGetAdminCompatLevel()));
        if (!this.isPassiveMonitoringOnly() && this.adminCompatVersion >= 2) {
            SrvMonXvmInfoResponse xvmInfo = (SrvMonXvmInfoResponse)this.sendRequest(SrvMonXvmInfoRequest.create(), this.defaultCommandTimeout);
            this.systemName = xvmInfo.getSystemName();
            this.systemVersion = xvmInfo.getSystemVersion();
        }
    }

    @Override
    protected final int doGetAdminCompatLevel() throws EAdminOpFailedException {
        try {
            return this.client.getAdminCompatLevel();
        }
        catch (EAdminClientServerError e) {
            throw new EAdminOpServerErrorException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (EClientOpTimeoutException e) {
            throw new EAdminOpServerErrorException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (EClientOpFailedException e) {
            throw new EAdminOpFailedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    protected final void doClose() {
        if (this.client != null) {
            this.client.close();
            try {
                this.clientConnection.getLinkManager().close(null);
                try {
                    this.clientConnection.getLinkManager().run(100, null);
                }
                catch (ELnkException eLnkException) {
                    // empty catch block
                }
                this.clientConnection.getLinkManager().shutdown();
            }
            catch (EClientLinkException e) {
                this.tracer.log("[AdminClientSession] Failed to shut down admin client's link manager [" + e.toString() + "].", Tracer.Level.WARNING);
            }
        }
    }

    @Override
    protected final <RequestType extends IRogMessage & ISrvMonXvmRequest, ResponseType extends IRogMessage> ResponseType sendRequest(RequestType request, int timeoutInMillis) throws EAdminOpFailedException, EAdminOpServerErrorException, EAdminOpTimeoutException {
        if (this.isPassiveMonitoringOnly()) {
            throw new EAdminOpFailedException("Cannot send requests when session is configured for passive monitoring only.");
        }
        try {
            PktPacket packet = this.client.sendRequest(request, timeoutInMillis);
            if (packet != null) {
                return (ResponseType)((IRogMessage)this.client.packetToMessage(packet));
            }
            return null;
        }
        catch (EAdminClientServerError e) {
            throw new EAdminOpServerErrorException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (EClientOpTimeoutException e) {
            throw new EAdminOpServerErrorException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (EClientOpFailedException e) {
            throw new EAdminOpFailedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    protected Object doInvokeCommand(int timeout, String target, String command, Object ... params) throws EAdminOpFailedException, EAdminOpServerErrorException, EAdminOpTimeoutException {
        if (this.isPassiveMonitoringOnly()) {
            throw new EAdminOpFailedException("Cannot invoke '" + command + "'. Session is configured for passive monitoring only.");
        }
        try {
            return this.client.invokeCommand(timeout, target, command, params);
        }
        catch (EAdminClientServerError e) {
            throw new EAdminOpServerErrorException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (EClientOpTimeoutException e) {
            throw new EAdminOpServerErrorException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (EClientOpFailedException e) {
            throw new EAdminOpFailedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    protected void doStartAppWatch() throws EAdminOpFailedException {
        try {
            this.client.startAppWatch();
        }
        catch (EAdminClientServerError e) {
            throw new EAdminOpServerErrorException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (EClientOpFailedException e) {
            throw new EAdminOpFailedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    protected void doStopAppWatch() throws EAdminOpFailedException {
        try {
            this.client.stopAppWatch();
        }
        catch (EAdminClientServerError e) {
            throw new EAdminOpServerErrorException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (EClientOpFailedException e) {
            throw new EAdminOpFailedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    protected final void doStartTraceWatch() throws EAdminOpFailedException {
        try {
            this.client.startTraceWatch();
        }
        catch (EAdminClientServerError e) {
            throw new EAdminOpServerErrorException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (EClientOpFailedException e) {
            throw new EAdminOpFailedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    protected final void doStopTraceWatch() throws EAdminOpFailedException {
        try {
            this.client.stopTraceWatch();
        }
        catch (EAdminClientServerError e) {
            throw new EAdminOpServerErrorException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (EClientOpFailedException e) {
            throw new EAdminOpFailedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public final void waitForAppWatchJoin(int timeoutMillis) throws IllegalStateException, EAdminException, EAdminOpTimeoutException, InterruptedException {
        try {
            this.client.waitForAppWatchJoin(timeoutMillis);
        }
        catch (EAdminClientServerError e) {
            throw new EAdminOpServerErrorException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (EClientOpTimeoutException e) {
            throw new EAdminOpServerErrorException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (EClientOpFailedException e) {
            throw new EAdminOpFailedException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Override
    public final String getConnectionDescriptor() {
        return this.descriptor.toFullString();
    }

    @Override
    public final String getTransportType() {
        return TYPE;
    }

    private final class AdminClientEventHandler
    implements IClientEventHandler {
        private AdminClientEventHandler() {
        }

        public final void onEvent(Client<?> client, int type, Object data) {
            switch (type) {
                case 2: {
                    AdminClientSession.this.onAdminSessionFailure(((ClientEvents.FailEventData)data).e);
                    break;
                }
                case 451: {
                    SrvMonTraceRecord message = SrvMonTraceRecord.create();
                    message.setTrace((String)data);
                    AdminClientSession.this.onMessageReceived((MessageView)message);
                    message.dispose();
                    break;
                }
                case 452: {
                    AdminClientSession.this.onMessageReceived((MessageView)data);
                    break;
                }
                default: {
                    AdminClientSession.this.tracer.log("[AdminClientSession] Received unknown event '" + type + "' from admin client. Ignoring...", Tracer.Level.WARNING);
                }
            }
        }
    }
}

