/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.server;

import com.neeve.config.Config;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkAlreadyJoinedException;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkFlushInProgressException;
import com.neeve.link.ELnkMaxUsersReachedException;
import com.neeve.link.ELnkNotJoinedException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkEventHandlerCore;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.ILnkPeerEndpointCore;
import com.neeve.link.ILnkRootEndpoint;
import com.neeve.link.LnkLTPAuthority;
import com.neeve.link.LnkPeerEndpoint;
import com.neeve.link.server.LnkSrvObject;
import com.neeve.pkt.PktPacket;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlList;
import java.util.HashMap;

final class LnkSrvPeerEndpoint
extends LnkSrvObject
implements ILnkPeerEndpointCore {
    private final String myName;
    private final short myLtp;
    private final ILnkPeerEndpoint pep;
    private final String peerName;
    private final short peerLtp;
    private final UtlList overflowPacketList;
    private final UtlAddressDescriptor descriptor;
    private final String name;
    private final LinkEventHandler myEventHandler;
    private volatile ILnkEventHandlerCore userEventHandler;

    private LnkSrvPeerEndpoint(RootConfig.ObjectConfig config, ILnkPeerEndpoint pep, String myName, short myLtp, String peerName, short peerLtp, UtlList overflowPacketList, UtlAddressDescriptor descriptor) throws ELnkException {
        super(config);
        this.pep = pep;
        this.myName = myName;
        this.myLtp = myLtp;
        this.peerName = peerName;
        this.peerLtp = peerLtp;
        this.overflowPacketList = overflowPacketList;
        this.descriptor = descriptor;
        Config.setTraceLevel((Tracer)this.tracer, (String)("nv.link." + descriptor.type + ".pep.trace"));
        this.name = myName + ":" + myLtp + "->" + peerName + ":" + peerLtp;
        try {
            this.myEventHandler = new LinkEventHandler();
            this.pep.join(myLtp, (ILnkEventHandler)this.myEventHandler);
        }
        catch (ELnkAlreadyJoinedException e) {
            throw new InternalError("LTP handed to server link peer endpoint is already taken!!");
        }
        if (this.tracer.debug) {
            this.tracer.log("Created server link endpoint [name=" + this.getName() + " numOverflowPackets=" + overflowPacketList.count() + "]", Tracer.Level.DEBUG);
        }
    }

    static ILnkPeerEndpoint create(RootConfig.ObjectConfig config, ILnkPeerEndpoint underlyingPep, String myName, short myLtp, String peerName, short peerLtp, UtlList overflowPacketList, UtlAddressDescriptor descriptor) throws ELnkException {
        LnkSrvPeerEndpoint pep = new LnkSrvPeerEndpoint(config, underlyingPep, myName, myLtp, peerName, peerLtp, overflowPacketList, descriptor);
        try {
            return LnkPeerEndpoint.create((RootConfig.ObjectConfig)config, (ILnkPeerEndpointCore)pep, (HashMap)pep.descriptor.props, (String)pep.descriptor.type);
        }
        catch (ELnkException e) {
            try {
                pep.closeFinal(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private final void closeFinal(boolean dispatchClosure) {
        LnkLTPAuthority.getInstance().release(this.myLtp);
        try {
            this.pep.leave(this.myLtp, 1);
        }
        catch (ELnkNotJoinedException e) {
            throw new InternalError("Received 'not joined' exception when leaving (on close) after a successful join (ltp=" + this.myLtp + "]!");
        }
        catch (ELnkFlushInProgressException e) {
            throw new InternalError("Received 'flush in progress' exception when leaving (on close) with expliclt pending flush allowance (ltp=" + this.myLtp + "]!");
        }
        catch (ELnkOpFailedException e) {
            throw new InternalError("Received 'op failed' exception when leaving (on close) with explicitly suppressed implicit close (ltp=" + this.myLtp + "]!");
        }
        if (dispatchClosure) {
            this.userEventHandler.onEvent(null, 9, null);
        }
    }

    public final String getName() {
        return this.name;
    }

    public short getLtp() {
        return this.myLtp;
    }

    public short getPeerLtp() {
        return this.peerLtp;
    }

    public final boolean isGroupEndpoint() {
        return false;
    }

    public final boolean isRootEndpoint() {
        return false;
    }

    public final ILnkRootEndpoint getRootEndpoint() {
        return this.pep.getRootEndpoint();
    }

    public final int getEnqueuedSize() {
        return this.pep.getEnqueuedSize();
    }

    public final void setEventHandler(ILnkEventHandlerCore handler) {
        if (this.tracer.debug) {
            this.tracer.log("Setting event handler in server endpoint...", Tracer.Level.DEBUG);
        }
        this.userEventHandler = handler;
    }

    public final void join(short ltp) throws ELnkAlreadyJoinedException, ELnkMaxUsersReachedException {
        this.pep.join(ltp, (ILnkEventHandler)this.myEventHandler);
    }

    public final void leave(short ltp) {
        try {
            this.pep.leave(ltp, 1);
        }
        catch (ELnkNotJoinedException e) {
            throw new InternalError("Received 'not joined' exception from underlying endpoint for leave with ltp=" + ltp);
        }
        catch (ELnkFlushInProgressException e) {
            throw new InternalError("Received 'flush in progress' exception from underlying endpoint for leave with ltp=" + ltp + " when expliclty allowed flush to be pending");
        }
        catch (ELnkOpFailedException e) {
            throw new InternalError("Received 'op failed' exception from underlying endpoint for leave with ltp=" + ltp + " when a join is still pending!");
        }
    }

    public final boolean enque(PktPacket packet, ILnkPeerEndpoint.FlushContext flushContext, int flags) throws ELnkOpFailedException {
        try {
            return this.pep.enque(this.myLtp, packet, flushContext, flags);
        }
        catch (ELnkNotJoinedException e) {
            throw new InternalError("Received 'not joined' exception on enque from a core endpoint!!");
        }
        catch (ELnkFlushInProgressException e) {
            throw new InternalError("Received 'flush in progress' exception on enque from a core endpoint!!");
        }
    }

    public final void flush(ILnkPeerEndpoint.FlushContext flushContext) throws ELnkOpFailedException {
        try {
            this.pep.flush(this.myLtp, flushContext);
        }
        catch (ELnkNotJoinedException e) {
            throw new InternalError("Received 'not joined' exception on flush from a core endpoint!!");
        }
        catch (ELnkFlushInProgressException e) {
            throw new InternalError("Received 'flush in progress' exception on flush from a core endpoint!!");
        }
    }

    public final void close() throws ELnkOpFailedException {
        this.closeFinal(true);
    }

    private final class LinkEventHandler
    implements ILnkEventHandler {
        private LinkEventHandler() {
        }

        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
            switch (type) {
                default: 
            }
            LnkSrvPeerEndpoint.this.userEventHandler.onEvent(dispatcher, type, data);
        }
    }
}

