/*
 * Decompiled with CFR 0.152.
 */
package vanilla.java.affinity.impl;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.PointerType;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.LongByReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import vanilla.java.affinity.IAffinity;

public enum WindowsJNAAffinity implements IAffinity
{
    INSTANCE;

    private static final Logger LOGGER;
    public static final boolean LOADED;

    @Override
    public long getAffinity() {
        CLibrary lib = CLibrary.INSTANCE;
        LongByReference cpuset1 = new LongByReference(0L);
        LongByReference cpuset2 = new LongByReference(0L);
        try {
            int ret = lib.GetProcessAffinityMask(-1, (PointerType)cpuset1, (PointerType)cpuset2);
            if (ret < 0) {
                throw new IllegalStateException("sched_getaffinity((8) , &(" + cpuset1 + ") ) return " + ret);
            }
            return cpuset1.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @Override
    public void setAffinity(long affinity) {
        CLibrary lib = CLibrary.INSTANCE;
        WinDef.DWORD aff = new WinDef.DWORD(affinity);
        try {
            lib.SetThreadAffinityMask(lib.GetCurrentThread(), aff);
        }
        catch (LastErrorException e) {
            throw new IllegalStateException("sched_getaffinity((8) , &(" + affinity + ") ) errorNo=" + e.getErrorCode(), e);
        }
    }

    static {
        LOGGER = Logger.getLogger(WindowsJNAAffinity.class.getName());
        boolean loaded = false;
        try {
            INSTANCE.getAffinity();
            loaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.log(Level.WARNING, "Unable to load jna library " + e);
        }
        LOADED = loaded;
    }

    private static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"kernel32", CLibrary.class);

        public int GetProcessAffinityMask(int var1, PointerType var2, PointerType var3) throws LastErrorException;

        public void SetThreadAffinityMask(int var1, WinDef.DWORD var2) throws LastErrorException;

        public int GetCurrentThread() throws LastErrorException;
    }
}

