/*
 * Decompiled with CFR 0.152.
 */
package vanilla.java.affinity;

import java.util.concurrent.ThreadFactory;
import vanilla.java.affinity.AffinityLock;
import vanilla.java.affinity.AffinityStrategies;
import vanilla.java.affinity.AffinityStrategy;

public class AffinityThreadFactory
implements ThreadFactory {
    private final String name;
    private final boolean daemon;
    private final AffinityStrategy[] strategies;
    private AffinityLock lastAffinityLock = null;
    private int id = 1;

    public AffinityThreadFactory(String name, AffinityStrategy ... strategies) {
        this(name, true, strategies);
    }

    public AffinityThreadFactory(String name, boolean daemon, AffinityStrategy ... strategies) {
        AffinityStrategy[] affinityStrategyArray;
        this.name = name;
        this.daemon = daemon;
        if (strategies.length == 0) {
            AffinityStrategy[] affinityStrategyArray2 = new AffinityStrategy[1];
            affinityStrategyArray = affinityStrategyArray2;
            affinityStrategyArray2[0] = AffinityStrategies.ANY;
        } else {
            affinityStrategyArray = strategies;
        }
        this.strategies = affinityStrategyArray;
    }

    @Override
    public synchronized Thread newThread(final Runnable r) {
        String name2 = this.id <= 1 ? this.name : this.name + '-' + this.id;
        ++this.id;
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AffinityLock al = AffinityThreadFactory.this.lastAffinityLock == null ? AffinityLock.acquireLock() : AffinityThreadFactory.this.lastAffinityLock.acquireLock(AffinityThreadFactory.this.strategies);
                try {
                    if (al.cpuId() >= 0) {
                        AffinityThreadFactory.this.lastAffinityLock = al;
                    }
                    r.run();
                }
                finally {
                    al.release();
                }
            }
        }, name2);
        t.setDaemon(this.daemon);
        return t;
    }
}

